/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.objects.delegate;

import com.netflix.hollow.api.custom.HollowListTypeAPI;
import com.netflix.hollow.api.custom.HollowTypeAPI;
import com.netflix.hollow.api.objects.HollowList;
import com.netflix.hollow.api.objects.delegate.HollowCachedDelegate;
import com.netflix.hollow.api.objects.delegate.HollowListDelegate;
import com.netflix.hollow.core.read.dataaccess.HollowListTypeDataAccess;
import com.netflix.hollow.core.schema.HollowListSchema;

public class HollowListCachedDelegate<T>
implements HollowListDelegate<T>,
HollowCachedDelegate {
    private final int[] ordinals;
    protected HollowListTypeAPI typeAPI;
    private HollowListTypeDataAccess dataAccess;

    public HollowListCachedDelegate(HollowListTypeDataAccess dataAccess, int ordinal) {
        this(dataAccess, null, ordinal);
    }

    public HollowListCachedDelegate(HollowListTypeAPI typeAPI, int ordinal) {
        this(typeAPI.getTypeDataAccess(), typeAPI, ordinal);
    }

    private HollowListCachedDelegate(HollowListTypeDataAccess dataAccess, HollowListTypeAPI typeAPI, int ordinal) {
        int[] ordinals = new int[dataAccess.size(ordinal)];
        for (int i = 0; i < ordinals.length; ++i) {
            ordinals[i] = dataAccess.getElementOrdinal(ordinal, i);
        }
        this.ordinals = ordinals;
        this.dataAccess = dataAccess;
        this.typeAPI = typeAPI;
    }

    @Override
    public int size(int ordinal) {
        return this.ordinals.length;
    }

    @Override
    public T get(HollowList<T> list, int ordinal, int idx) {
        return list.instantiateElement(this.ordinals[idx]);
    }

    @Override
    public final boolean contains(HollowList<T> list, int ordinal, Object o) {
        return this.indexOf(list, ordinal, o) != -1;
    }

    @Override
    public final int indexOf(HollowList<T> list, int ordinal, Object o) {
        for (int i = 0; i < this.ordinals.length; ++i) {
            if (!list.equalsElement(this.ordinals[i], o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(HollowList<T> list, int ordinal, Object o) {
        for (int i = this.ordinals.length - 1; i >= 0; --i) {
            if (!list.equalsElement(this.ordinals[i], o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public HollowListSchema getSchema() {
        return this.dataAccess.getSchema();
    }

    @Override
    public HollowListTypeDataAccess getTypeDataAccess() {
        return this.dataAccess;
    }

    @Override
    public HollowListTypeAPI getTypeAPI() {
        return this.typeAPI;
    }

    @Override
    public void updateTypeAPI(HollowTypeAPI typeAPI) {
        this.typeAPI = (HollowListTypeAPI)typeAPI;
        this.dataAccess = this.typeAPI.getTypeDataAccess();
    }
}

