/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.objects;

import com.netflix.hollow.api.objects.HollowRecord;
import com.netflix.hollow.api.objects.delegate.HollowRecordDelegate;
import com.netflix.hollow.api.objects.delegate.HollowSetDelegate;
import com.netflix.hollow.core.read.dataaccess.HollowSetTypeDataAccess;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.schema.HollowSetSchema;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class HollowSet<T>
extends AbstractSet<T>
implements HollowRecord {
    protected final int ordinal;
    protected final HollowSetDelegate<T> delegate;

    public HollowSet(HollowSetDelegate<T> delegate, int ordinal) {
        this.ordinal = ordinal;
        this.delegate = delegate;
    }

    @Override
    public final int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public final int size() {
        return this.delegate.size(this.ordinal);
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(this, this.ordinal, o);
    }

    public T findElement(Object ... hashKey) {
        return this.delegate.findElement(this, this.ordinal, hashKey);
    }

    public abstract T instantiateElement(int var1);

    public abstract boolean equalsElement(int var1, Object var2);

    @Override
    public HollowSetSchema getSchema() {
        return this.delegate.getSchema();
    }

    @Override
    public HollowSetTypeDataAccess getTypeDataAccess() {
        return this.delegate.getTypeDataAccess();
    }

    @Override
    public final Iterator<T> iterator() {
        return new Itr();
    }

    @Override
    public HollowRecordDelegate getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HollowSet) {
            HollowSet that = (HollowSet)o;
            if (this.delegate.getTypeDataAccess() == that.delegate.getTypeDataAccess()) {
                return this.ordinal == that.ordinal;
            }
        }
        return super.equals(o);
    }

    private final class Itr
    implements Iterator<T> {
        private final HollowOrdinalIterator ordinalIterator;
        private T next;

        Itr() {
            this.ordinalIterator = HollowSet.this.delegate.iterator(HollowSet.this.ordinal);
            this.positionNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object current = this.next;
            this.positionNext();
            return current;
        }

        private void positionNext() {
            int currentOrdinal = this.ordinalIterator.next();
            this.next = currentOrdinal != Integer.MAX_VALUE ? HollowSet.this.instantiateElement(currentOrdinal) : null;
        }
    }
}

