/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.objects;

import com.netflix.hollow.api.objects.HollowRecord;
import com.netflix.hollow.api.objects.delegate.HollowMapDelegate;
import com.netflix.hollow.api.objects.delegate.HollowRecordDelegate;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import com.netflix.hollow.core.schema.HollowMapSchema;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public abstract class HollowMap<K, V>
extends AbstractMap<K, V>
implements HollowRecord {
    protected final int ordinal;
    protected final HollowMapDelegate<K, V> delegate;

    public HollowMap(HollowMapDelegate<K, V> delegate, int ordinal) {
        this.ordinal = ordinal;
        this.delegate = delegate;
    }

    @Override
    public final int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public final int size() {
        return this.delegate.size(this.ordinal);
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public final V get(Object key) {
        return this.delegate.get(this, this.ordinal, key);
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.delegate.containsKey(this, this.ordinal, key);
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.delegate.containsValue(this, this.ordinal, value);
    }

    public final K findKey(Object ... hashKey) {
        return this.delegate.findKey(this, this.ordinal, hashKey);
    }

    public final V findValue(Object ... hashKey) {
        return this.delegate.findValue(this, this.ordinal, hashKey);
    }

    public final Map.Entry<K, V> findEntry(Object ... hashKey) {
        return this.delegate.findEntry(this, this.ordinal, hashKey);
    }

    public abstract K instantiateKey(int var1);

    public abstract V instantiateValue(int var1);

    public abstract boolean equalsKey(int var1, Object var2);

    public abstract boolean equalsValue(int var1, Object var2);

    @Override
    public HollowMapSchema getSchema() {
        return this.delegate.getSchema();
    }

    @Override
    public HollowMapTypeDataAccess getTypeDataAccess() {
        return this.delegate.getTypeDataAccess();
    }

    @Override
    public HollowRecordDelegate getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HollowMap) {
            HollowMap that = (HollowMap)o;
            if (this.delegate.getTypeDataAccess() == that.delegate.getTypeDataAccess()) {
                return this.ordinal == that.ordinal;
            }
        }
        return super.equals(o);
    }

    private static final class OrdinalEntry<K, V>
    implements Map.Entry<K, V> {
        private final HollowMap<K, V> map;
        private final int keyOrdinal;
        private final int valueOrdinal;

        OrdinalEntry(HollowMap<K, V> map, int keyOrdinal, int valueOrdinal) {
            this.map = map;
            this.keyOrdinal = keyOrdinal;
            this.valueOrdinal = valueOrdinal;
        }

        @Override
        public K getKey() {
            return this.map.instantiateKey(this.keyOrdinal);
        }

        @Override
        public V getValue() {
            return this.map.instantiateValue(this.valueOrdinal);
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.getValue());
        }

        @Override
        public boolean equals(Object o) {
            Map.Entry<K, V> that;
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof OrdinalEntry) {
                that = (OrdinalEntry)o;
                if (this.map.delegate.getTypeDataAccess() == ((OrdinalEntry)that).map.delegate.getTypeDataAccess()) {
                    return this.keyOrdinal == ((OrdinalEntry)that).keyOrdinal && this.valueOrdinal == ((OrdinalEntry)that).valueOrdinal;
                }
            }
            that = (Map.Entry)o;
            return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getValue(), that.getValue());
        }
    }

    private final class EntryItr
    implements Iterator<Map.Entry<K, V>> {
        private final HollowMapEntryOrdinalIterator ordinalIterator;
        private Map.Entry<K, V> next;

        EntryItr() {
            this.ordinalIterator = HollowMap.this.delegate.iterator(HollowMap.this.ordinal);
            this.positionNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry current = this.next;
            this.positionNext();
            return current;
        }

        private void positionNext() {
            this.next = this.ordinalIterator.next() ? new OrdinalEntry(HollowMap.this, this.ordinalIterator.getKey(), this.ordinalIterator.getValue()) : null;
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryItr();
        }

        @Override
        public int size() {
            return HollowMap.this.delegate.size(HollowMap.this.ordinal);
        }
    }
}

