/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.metrics;

import com.netflix.hollow.api.metrics.HollowMetrics;
import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.api.producer.HollowProducerListener;
import com.netflix.hollow.api.producer.Status;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import java.util.concurrent.atomic.AtomicInteger;

public class HollowProducerMetrics
extends HollowMetrics {
    private int cyclesCompleted = 0;
    private int cyclesSucceeded = 0;
    private int cycleFailed = 0;
    private AtomicInteger snapshotsCompleted = new AtomicInteger();
    private AtomicInteger snapshotsFailed = new AtomicInteger();
    private int deltasCompleted = 0;
    private int deltasFailed = 0;
    private int reverseDeltasCompleted = 0;
    private int reverseDeltasFailed = 0;

    public void updateCycleMetrics(HollowProducerListener.ProducerStatus producerStatus) {
        Status.StatusType st = producerStatus.getStatus() == HollowProducerListener.Status.SUCCESS ? Status.StatusType.SUCCESS : Status.StatusType.FAIL;
        this.updateCycleMetrics(new Status(st, producerStatus.getCause()), producerStatus.getReadState(), producerStatus.getVersion());
    }

    public void updateCycleMetrics(Status status, HollowProducer.ReadState readState, long version) {
        ++this.cyclesCompleted;
        if (status.getType() == Status.StatusType.FAIL) {
            ++this.cycleFailed;
            return;
        }
        ++this.cyclesSucceeded;
        if (readState != null) {
            HollowReadStateEngine hollowReadStateEngine = readState.getStateEngine();
            super.update(hollowReadStateEngine, version);
        } else {
            super.update(version);
        }
    }

    public void updateBlobTypeMetrics(HollowProducerListener.PublishStatus publishStatus) {
        Status.StatusType st = publishStatus.getStatus() == HollowProducerListener.Status.SUCCESS ? Status.StatusType.SUCCESS : Status.StatusType.FAIL;
        this.updateBlobTypeMetrics(new Status(st, publishStatus.getCause()), publishStatus.getBlob());
    }

    public void updateBlobTypeMetrics(Status status, HollowProducer.Blob blob) {
        HollowProducer.Blob.Type blobType = blob.getType();
        switch (blobType) {
            case SNAPSHOT: {
                if (status.getType() == Status.StatusType.SUCCESS) {
                    this.snapshotsCompleted.incrementAndGet();
                    break;
                }
                this.snapshotsFailed.incrementAndGet();
                break;
            }
            case DELTA: {
                if (status.getType() == Status.StatusType.SUCCESS) {
                    ++this.deltasCompleted;
                    break;
                }
                ++this.deltasFailed;
                break;
            }
            case REVERSE_DELTA: {
                if (status.getType() == Status.StatusType.SUCCESS) {
                    ++this.reverseDeltasCompleted;
                    break;
                }
                ++this.reverseDeltasFailed;
            }
        }
    }

    public int getCyclesCompleted() {
        return this.cyclesCompleted;
    }

    public int getCyclesSucceeded() {
        return this.cyclesSucceeded;
    }

    public int getCycleFailed() {
        return this.cycleFailed;
    }

    public int getSnapshotsCompleted() {
        return this.snapshotsCompleted.get();
    }

    public int getSnapshotsFailed() {
        return this.snapshotsFailed.get();
    }

    public int getDeltasCompleted() {
        return this.deltasCompleted;
    }

    public int getDeltasFailed() {
        return this.deltasFailed;
    }

    public int getReverseDeltasCompleted() {
        return this.reverseDeltasCompleted;
    }

    public int getReverseDeltasFailed() {
        return this.reverseDeltasFailed;
    }
}

