/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.error;

import com.netflix.hollow.api.error.HollowException;
import java.util.Collection;

public class SchemaNotFoundException
extends HollowException {
    private final String typeName;
    private final Collection<String> availableTypes;

    public SchemaNotFoundException(String typeName, Collection<String> availableTypes) {
        super("Could not find schema for " + typeName + " - " + SchemaNotFoundException.getMessageSuffix(availableTypes));
        this.typeName = typeName;
        this.availableTypes = availableTypes;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Collection<String> getAvailableTypes() {
        return this.availableTypes;
    }

    private static String getMessageSuffix(Collection<String> availableTypes) {
        if (availableTypes.isEmpty()) {
            return "empty type state, make sure your namespace has published versions";
        }
        return "available schemas: " + availableTypes;
    }
}

