/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.custom;

import com.netflix.hollow.api.custom.HollowAPI;
import com.netflix.hollow.api.custom.HollowTypeAPI;
import com.netflix.hollow.api.sampling.DisabledSamplingDirector;
import com.netflix.hollow.api.sampling.HollowObjectSampler;
import com.netflix.hollow.api.sampling.HollowSampler;
import com.netflix.hollow.api.sampling.HollowSamplingDirector;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.missing.HollowObjectMissingDataAccess;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.read.missing.MissingDataHandler;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import java.util.Arrays;

public abstract class HollowObjectTypeAPI
extends HollowTypeAPI {
    protected final String[] fieldNames;
    protected final int[] fieldIndex;
    protected final HollowObjectSampler boxedFieldAccessSampler;

    protected HollowObjectTypeAPI(HollowAPI api, HollowObjectTypeDataAccess typeDataAccess, String[] fieldNames) {
        super(api, typeDataAccess);
        this.fieldNames = fieldNames;
        this.fieldIndex = new int[fieldNames.length];
        HollowObjectSampler boxedFieldAccessSampler = HollowObjectSampler.NULL_SAMPLER;
        if (!(typeDataAccess instanceof HollowObjectMissingDataAccess)) {
            HollowObjectSchema schema = typeDataAccess.getSchema();
            for (int i = 0; i < fieldNames.length; ++i) {
                int fieldPosition;
                this.fieldIndex[i] = fieldPosition = schema.getPosition(fieldNames[i]);
            }
            boxedFieldAccessSampler = new HollowObjectSampler(schema, DisabledSamplingDirector.INSTANCE);
        } else {
            Arrays.fill(this.fieldIndex, -1);
        }
        this.boxedFieldAccessSampler = boxedFieldAccessSampler;
    }

    @Override
    public HollowObjectTypeDataAccess getTypeDataAccess() {
        return (HollowObjectTypeDataAccess)this.typeDataAccess;
    }

    public HollowDataAccess getDataAccess() {
        return this.typeDataAccess.getDataAccess();
    }

    public HollowSampler getBoxedFieldAccessSampler() {
        return this.boxedFieldAccessSampler;
    }

    @Override
    public void setSamplingDirector(HollowSamplingDirector samplingDirector) {
        super.setSamplingDirector(samplingDirector);
        this.boxedFieldAccessSampler.setSamplingDirector(samplingDirector);
    }

    @Override
    public void setFieldSpecificSamplingDirector(HollowFilterConfig fieldSpec, HollowSamplingDirector director) {
        super.setFieldSpecificSamplingDirector(fieldSpec, director);
        this.boxedFieldAccessSampler.setFieldSpecificSamplingDirector(fieldSpec, director);
    }

    @Override
    public void ignoreUpdateThreadForSampling(Thread t) {
        super.ignoreUpdateThreadForSampling(t);
        this.boxedFieldAccessSampler.setUpdateThread(t);
    }

    protected MissingDataHandler missingDataHandler() {
        return this.api.getDataAccess().getMissingDataHandler();
    }
}

