/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.custom;

import com.netflix.hollow.api.custom.HollowObjectTypeAPI;
import com.netflix.hollow.api.custom.HollowTypeAPI;
import com.netflix.hollow.api.sampling.HollowSamplingDirector;
import com.netflix.hollow.api.sampling.SampleResult;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HollowAPI {
    private final HollowDataAccess dataAccess;
    private final List<HollowTypeAPI> typeAPIs;
    protected HollowSamplingDirector samplingDirector;

    public HollowAPI(HollowDataAccess dataAccess) {
        this.dataAccess = dataAccess;
        this.typeAPIs = new ArrayList<HollowTypeAPI>();
    }

    public HollowDataAccess getDataAccess() {
        return this.dataAccess;
    }

    public HollowSamplingDirector getSamplingDirector() {
        return this.samplingDirector;
    }

    public void setSamplingDirector(HollowSamplingDirector samplingDirector) {
        this.samplingDirector = samplingDirector;
        for (HollowTypeAPI typeAPI : this.typeAPIs) {
            typeAPI.setSamplingDirector(samplingDirector);
        }
    }

    public void setFieldSpecificSamplingDirector(HollowFilterConfig fieldSpec, HollowSamplingDirector director) {
        for (HollowTypeAPI typeAPI : this.typeAPIs) {
            typeAPI.setFieldSpecificSamplingDirector(fieldSpec, director);
        }
    }

    public void ignoreUpdateThreadForSampling(Thread t) {
        for (HollowTypeAPI typeAPI : this.typeAPIs) {
            typeAPI.ignoreUpdateThreadForSampling(t);
        }
    }

    public List<SampleResult> getAccessSampleResults() {
        ArrayList<SampleResult> sampleResults = new ArrayList<SampleResult>();
        for (HollowTypeAPI typeAPI : this.typeAPIs) {
            sampleResults.addAll(typeAPI.getAccessSampleResults());
        }
        Collections.sort(sampleResults);
        return sampleResults;
    }

    public List<SampleResult> getBoxedSampleResults() {
        ArrayList<SampleResult> sampleResults = new ArrayList<SampleResult>();
        for (HollowTypeAPI typeAPI : this.typeAPIs) {
            if (!(typeAPI instanceof HollowObjectTypeAPI)) continue;
            sampleResults.addAll(((HollowObjectTypeAPI)typeAPI).getBoxedFieldAccessSampler().getSampleResults());
        }
        Collections.sort(sampleResults);
        return sampleResults;
    }

    public void detachCaches() {
    }

    protected void addTypeAPI(HollowTypeAPI typeAPI) {
        this.typeAPIs.add(typeAPI);
    }
}

