/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.consumer.index;

import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.api.custom.HollowAPI;
import com.netflix.hollow.core.index.HollowPrimaryKeyIndex;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;

public abstract class AbstractHollowUniqueKeyIndex<API, T> {
    protected final HollowConsumer consumer;
    protected HollowPrimaryKeyIndex idx;
    protected API api;
    protected boolean isListenToDataRefresh;
    protected RefreshListener refreshListener;

    public AbstractHollowUniqueKeyIndex(HollowConsumer consumer, String type, boolean isListenToDataRefresh, String ... fieldPaths) {
        consumer.getRefreshLock().lock();
        try {
            this.consumer = consumer;
            this.api = this.castAPI(consumer.getAPI());
            this.idx = new HollowPrimaryKeyIndex(consumer.getStateEngine(), type, fieldPaths);
            this.refreshListener = new RefreshListener();
            if (isListenToDataRefresh) {
                this.listenToDataRefresh();
            }
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("The HollowConsumer provided was not created with the PackageErgoTestAPI generated API class.");
        }
        finally {
            consumer.getRefreshLock().unlock();
        }
    }

    private API castAPI(HollowAPI api) {
        return (API)api;
    }

    @Deprecated
    public boolean isListenToDataRefreah() {
        return this.isListenToDataRefresh;
    }

    @Deprecated
    public void listenToDataRefreah() {
        this.listenToDataRefresh();
    }

    public boolean isListenToDataRefresh() {
        return this.isListenToDataRefresh;
    }

    public void listenToDataRefresh() {
        if (this.isListenToDataRefresh) {
            return;
        }
        this.isListenToDataRefresh = true;
        this.idx.listenForDeltaUpdates();
        this.consumer.addRefreshListener(this.refreshListener);
    }

    public void detachFromDataRefresh() {
        this.isListenToDataRefresh = false;
        this.idx.detachFromDeltaUpdates();
        this.consumer.removeRefreshListener(this.refreshListener);
    }

    private class RefreshListener
    implements HollowConsumer.RefreshListener {
        private RefreshListener() {
        }

        @Override
        public void snapshotUpdateOccurred(HollowAPI refreshAPI, HollowReadStateEngine stateEngine, long version) {
            AbstractHollowUniqueKeyIndex.this.idx.detachFromDeltaUpdates();
            AbstractHollowUniqueKeyIndex.this.idx = new HollowPrimaryKeyIndex(stateEngine, AbstractHollowUniqueKeyIndex.this.idx.getPrimaryKey());
            AbstractHollowUniqueKeyIndex.this.idx.listenForDeltaUpdates();
            AbstractHollowUniqueKeyIndex.this.api = AbstractHollowUniqueKeyIndex.this.castAPI(refreshAPI);
        }

        @Override
        public void deltaUpdateOccurred(HollowAPI refreshAPI, HollowReadStateEngine stateEngine, long version) {
            AbstractHollowUniqueKeyIndex.this.api = AbstractHollowUniqueKeyIndex.this.castAPI(refreshAPI);
        }

        @Override
        public void refreshStarted(long currentVersion, long requestedVersion) {
        }

        @Override
        public void blobLoaded(HollowConsumer.Blob transition) {
        }

        @Override
        public void refreshSuccessful(long beforeVersion, long afterVersion, long requestedVersion) {
        }

        @Override
        public void refreshFailed(long beforeVersion, long afterVersion, long requestedVersion, Throwable failureCause) {
        }
    }
}

