/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.objects;

import com.netflix.hollow.api.codegen.CodeGeneratorConfig;
import com.netflix.hollow.api.codegen.HollowCodeGenerationUtils;
import com.netflix.hollow.api.codegen.objects.HollowCollectionsGenerator;
import com.netflix.hollow.api.objects.HollowSet;
import com.netflix.hollow.api.objects.delegate.HollowSetDelegate;
import com.netflix.hollow.api.objects.generic.GenericHollowRecordHelper;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.schema.HollowSetSchema;
import java.util.Arrays;
import java.util.Set;

public class HollowSetJavaGenerator
extends HollowCollectionsGenerator {
    private final HollowSetSchema schema;
    private final String elementClassName;
    private final boolean parameterize;

    public HollowSetJavaGenerator(String packageName, String apiClassname, HollowSetSchema schema, Set<String> parameterizedTypes, boolean parameterizeClassNames, HollowDataset dataset, CodeGeneratorConfig config) {
        super(packageName, apiClassname, schema, dataset, config);
        this.schema = schema;
        this.elementClassName = this.hollowImplClassname(schema.getElementType());
        this.parameterize = parameterizeClassNames || parameterizedTypes.contains(schema.getElementType());
    }

    @Override
    public String generate() {
        StringBuilder builder = new StringBuilder();
        this.appendPackageAndCommonImports(builder, this.apiClassname, Arrays.asList(this.schema));
        builder.append("import " + HollowSet.class.getName() + ";\n");
        builder.append("import " + HollowSetSchema.class.getName() + ";\n");
        builder.append("import " + HollowSetDelegate.class.getName() + ";\n");
        builder.append("import " + GenericHollowRecordHelper.class.getName() + ";\n\n");
        this.appendGeneratedAnnotation(builder);
        builder.append("\n@SuppressWarnings(\"all\")\n");
        if (this.parameterize) {
            builder.append("public class " + this.className + "<T> extends HollowSet<T> {\n\n");
        } else {
            builder.append("public class " + this.className + " extends HollowSet<" + this.elementClassName + "> {\n\n");
        }
        this.appendConstructor(builder);
        this.appendInstantiateMethod(builder);
        this.appendEqualityMethod(builder);
        this.appendAPIAccessor(builder);
        this.appendTypeAPIAccessor(builder);
        builder.append("}");
        return builder.toString();
    }

    private void appendConstructor(StringBuilder classBuilder) {
        classBuilder.append("    public " + this.className + "(HollowSetDelegate delegate, int ordinal) {\n");
        classBuilder.append("        super(delegate, ordinal);\n");
        classBuilder.append("    }\n\n");
    }

    private void appendInstantiateMethod(StringBuilder classBuilder) {
        String returnType = this.parameterize ? "T" : this.elementClassName;
        classBuilder.append("    @Override\n");
        classBuilder.append("    public ").append(returnType).append(" instantiateElement(int ordinal) {\n");
        classBuilder.append("        return (").append(returnType).append(") api().get").append(this.elementClassName).append("(ordinal);\n");
        classBuilder.append("    }\n\n");
    }

    private void appendEqualityMethod(StringBuilder classBuilder) {
        classBuilder.append("    @Override\n");
        classBuilder.append("    public boolean equalsElement(int elementOrdinal, Object testObject) {\n");
        classBuilder.append("        return GenericHollowRecordHelper.equalObject(getSchema().getElementType(), elementOrdinal, testObject);\n");
        classBuilder.append("    }\n\n");
    }

    private void appendAPIAccessor(StringBuilder classBuilder) {
        classBuilder.append("    public " + this.apiClassname + " api() {\n");
        classBuilder.append("        return typeApi().getAPI();\n");
        classBuilder.append("    }\n\n");
    }

    private void appendTypeAPIAccessor(StringBuilder classBuilder) {
        String typeAPIClassname = HollowCodeGenerationUtils.typeAPIClassname(this.schema.getName());
        classBuilder.append("    public " + typeAPIClassname + " typeApi() {\n");
        classBuilder.append("        return (").append(typeAPIClassname).append(") delegate.getTypeAPI();\n");
        classBuilder.append("    }\n\n");
    }
}

