/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.api;

import com.netflix.hollow.api.codegen.CodeGeneratorConfig;
import com.netflix.hollow.api.codegen.HollowCodeGenerationUtils;
import com.netflix.hollow.api.codegen.api.HollowTypeAPIGenerator;
import com.netflix.hollow.api.custom.HollowSetTypeAPI;
import com.netflix.hollow.api.objects.delegate.HollowSetLookupDelegate;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.read.dataaccess.HollowSetTypeDataAccess;
import com.netflix.hollow.core.schema.HollowSetSchema;

public class TypeAPISetJavaGenerator
extends HollowTypeAPIGenerator {
    private final HollowSetSchema schema;

    public TypeAPISetJavaGenerator(String apiClassname, String packageName, HollowSetSchema schema, HollowDataset dataset, CodeGeneratorConfig config) {
        super(apiClassname, packageName, schema, dataset, config);
        this.schema = schema;
    }

    @Override
    public String generate() {
        StringBuilder builder = new StringBuilder();
        this.appendPackageAndCommonImports(builder, this.apiClassname);
        builder.append("import " + HollowSetTypeAPI.class.getName() + ";\n\n");
        builder.append("import " + HollowSetTypeDataAccess.class.getName() + ";\n");
        builder.append("import " + HollowSetLookupDelegate.class.getName() + ";\n");
        this.appendGeneratedAnnotation(builder);
        builder.append("\n@SuppressWarnings(\"all\")\n");
        builder.append("public class ").append(this.className).append(" extends HollowSetTypeAPI {\n\n");
        builder.append("    private final ").append(HollowCodeGenerationUtils.delegateLookupClassname(this.schema)).append(" delegateLookupImpl;\n\n");
        builder.append("    public ").append(this.className).append("(").append(this.apiClassname).append(" api, HollowSetTypeDataAccess dataAccess) {\n");
        builder.append("        super(api, dataAccess);\n");
        builder.append("        this.delegateLookupImpl = new ").append(HollowCodeGenerationUtils.delegateLookupClassname(this.schema)).append("(this);\n");
        builder.append("    }\n\n");
        builder.append("    public ").append(HollowCodeGenerationUtils.typeAPIClassname(this.schema.getElementType())).append(" getElementAPI() {\n");
        builder.append("        return getAPI().get").append(HollowCodeGenerationUtils.typeAPIClassname(this.schema.getElementType())).append("();\n");
        builder.append("    }\n\n");
        builder.append("    public ").append(this.apiClassname).append(" getAPI() {\n");
        builder.append("        return (").append(this.apiClassname).append(")api;\n");
        builder.append("    }\n\n");
        builder.append("    public ").append(HollowCodeGenerationUtils.delegateLookupClassname(this.schema)).append(" getDelegateLookupImpl() {\n");
        builder.append("        return delegateLookupImpl;\n");
        builder.append("    }\n\n");
        builder.append("}");
        return builder.toString();
    }
}

