/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen;

import com.netflix.hollow.api.objects.delegate.HollowListCachedDelegate;
import com.netflix.hollow.api.objects.delegate.HollowListDelegate;
import com.netflix.hollow.api.objects.delegate.HollowListLookupDelegate;
import com.netflix.hollow.api.objects.delegate.HollowMapCachedDelegate;
import com.netflix.hollow.api.objects.delegate.HollowMapDelegate;
import com.netflix.hollow.api.objects.delegate.HollowMapLookupDelegate;
import com.netflix.hollow.api.objects.delegate.HollowSetCachedDelegate;
import com.netflix.hollow.api.objects.delegate.HollowSetDelegate;
import com.netflix.hollow.api.objects.delegate.HollowSetLookupDelegate;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HollowCodeGenerationUtils {
    private static final Set<String> PRIMITIVE_TYPES = new HashSet<String>();
    private static final Map<String, String> DEFAULT_CLASS_NAME_SUBSTITUTIONS = new HashMap<String, String>();
    private static final Map<String, String> AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS = new HashMap<String, String>();
    private static final Set<String> booleanMethodPrefixes;

    public static String typeAPIClassname(String typeName) {
        return HollowCodeGenerationUtils.uppercase(typeName) + "TypeAPI";
    }

    public static String hollowFactoryClassname(String typeName) {
        return HollowCodeGenerationUtils.substituteInvalidChars(HollowCodeGenerationUtils.uppercase(typeName)) + "HollowFactory";
    }

    public static String hollowObjectProviderName(String typeName) {
        return HollowCodeGenerationUtils.substituteInvalidChars(HollowCodeGenerationUtils.lowercase(typeName)) + "Provider";
    }

    public static String hollowImplClassname(String typeName, String classPostfix, boolean useAggressiveSubstitutions, boolean useHollowPrimitives) {
        String classname = HollowCodeGenerationUtils.substituteInvalidChars(HollowCodeGenerationUtils.uppercase(typeName));
        if (!useHollowPrimitives && !"".equals(classPostfix)) {
            return classname + classPostfix;
        }
        String sub = useAggressiveSubstitutions ? AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.get(classname) : DEFAULT_CLASS_NAME_SUBSTITUTIONS.get(classname);
        return sub == null ? classname + classPostfix : sub;
    }

    public static String delegateInterfaceName(String typeName) {
        return HollowCodeGenerationUtils.substituteInvalidChars(HollowCodeGenerationUtils.uppercase(typeName)) + "Delegate";
    }

    public static String delegateInterfaceName(HollowSchema schema) {
        if (schema instanceof HollowObjectSchema) {
            return HollowCodeGenerationUtils.delegateInterfaceName(schema.getName());
        }
        if (schema instanceof HollowListSchema) {
            return HollowListDelegate.class.getSimpleName();
        }
        if (schema instanceof HollowSetSchema) {
            return HollowSetDelegate.class.getSimpleName();
        }
        if (schema instanceof HollowMapSchema) {
            return HollowMapDelegate.class.getSimpleName();
        }
        throw new UnsupportedOperationException("What kind of schema is a " + schema.getClass().getSimpleName() + "?");
    }

    public static String delegateCachedImplName(String typeName) {
        return HollowCodeGenerationUtils.substituteInvalidChars(HollowCodeGenerationUtils.uppercase(typeName)) + "DelegateCachedImpl";
    }

    public static String delegateCachedClassname(HollowSchema schema) {
        if (schema instanceof HollowObjectSchema) {
            return HollowCodeGenerationUtils.delegateCachedImplName(schema.getName());
        }
        if (schema instanceof HollowListSchema) {
            return HollowListCachedDelegate.class.getSimpleName();
        }
        if (schema instanceof HollowSetSchema) {
            return HollowSetCachedDelegate.class.getSimpleName();
        }
        if (schema instanceof HollowMapSchema) {
            return HollowMapCachedDelegate.class.getSimpleName();
        }
        throw new UnsupportedOperationException("What kind of schema is a " + schema.getClass().getSimpleName() + "?");
    }

    public static String delegateLookupImplName(String typeName) {
        return HollowCodeGenerationUtils.substituteInvalidChars(HollowCodeGenerationUtils.uppercase(typeName)) + "DelegateLookupImpl";
    }

    public static String delegateLookupClassname(HollowSchema schema) {
        if (schema instanceof HollowObjectSchema) {
            return HollowCodeGenerationUtils.delegateLookupImplName(schema.getName());
        }
        if (schema instanceof HollowListSchema) {
            return HollowListLookupDelegate.class.getSimpleName();
        }
        if (schema instanceof HollowSetSchema) {
            return HollowSetLookupDelegate.class.getSimpleName();
        }
        if (schema instanceof HollowMapSchema) {
            return HollowMapLookupDelegate.class.getSimpleName();
        }
        throw new UnsupportedOperationException("What kind of schema is a " + schema.getClass().getSimpleName() + "?");
    }

    public static String lowercase(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(str.substring(0, 1).toLowerCase());
        builder.append(str.substring(1));
        return builder.toString();
    }

    public static String uppercase(String str) {
        return HollowCodeGenerationUtils.upperFirstChar(str);
    }

    public static String upperFirstChar(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(str.substring(0, 1).toUpperCase());
        builder.append(str.substring(1));
        return builder.toString();
    }

    public static String substituteInvalidChars(String str) {
        str = str.replace(' ', '_');
        str = str.replace('.', '_');
        return str;
    }

    public static String getJavaBoxedType(HollowObjectSchema.FieldType fieldType) {
        switch (fieldType) {
            case BOOLEAN: {
                return "Boolean";
            }
            case BYTES: {
                return "byte[]";
            }
            case DOUBLE: {
                return "Double";
            }
            case FLOAT: {
                return "Float";
            }
            case LONG: {
                return "Long";
            }
            case INT: 
            case REFERENCE: {
                return "Integer";
            }
            case STRING: {
                return "String";
            }
        }
        throw new IllegalArgumentException("Java boxed type is not known for FieldType." + fieldType.toString());
    }

    public static String getJavaScalarType(HollowObjectSchema.FieldType fieldType) {
        switch (fieldType) {
            case BOOLEAN: {
                return "boolean";
            }
            case BYTES: {
                return "byte[]";
            }
            case DOUBLE: {
                return "double";
            }
            case FLOAT: {
                return "float";
            }
            case LONG: {
                return "long";
            }
            case INT: 
            case REFERENCE: {
                return "int";
            }
            case STRING: {
                return "String";
            }
        }
        throw new IllegalArgumentException("Java scalar type is not known for FieldType." + fieldType.toString());
    }

    public static Set<String> getBooleanMethodPrefixes() {
        return booleanMethodPrefixes;
    }

    public static String generateAccessortMethodName(String fieldName, Class<?> clazz) {
        String prefix = "get";
        if (Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz)) {
            for (String booleanPrefix : booleanMethodPrefixes) {
                char firstCharAfterBooleanPrefix;
                if (!fieldName.startsWith(booleanPrefix) || fieldName.length() <= booleanPrefix.length() || !Character.isUpperCase(firstCharAfterBooleanPrefix = fieldName.charAt(booleanPrefix.length()))) continue;
                return fieldName;
            }
        }
        return HollowCodeGenerationUtils.substituteInvalidChars(prefix + HollowCodeGenerationUtils.uppercase(fieldName));
    }

    public static String generateBooleanAccessorMethodName(String fieldName, boolean useBooleanFieldErgonomics) {
        return useBooleanFieldErgonomics ? HollowCodeGenerationUtils.generateAccessortMethodName(fieldName, Boolean.TYPE) : "get" + HollowCodeGenerationUtils.uppercase(fieldName);
    }

    public static String normalizeFieldPathToParamName(String fieldPath) {
        String result = null;
        if (fieldPath.contains(".")) {
            String[] parts = fieldPath.split("\\.");
            StringBuilder sb = new StringBuilder();
            sb.append(HollowCodeGenerationUtils.lowercase(parts[0]));
            for (int i = 1; i < parts.length; ++i) {
                sb.append(HollowCodeGenerationUtils.uppercase(parts[i]));
            }
            result = sb.toString();
        } else {
            result = HollowCodeGenerationUtils.lowercase(fieldPath);
        }
        if (result.endsWith("!")) {
            return result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static boolean isPrimitiveType(String type) {
        return PRIMITIVE_TYPES.contains(type);
    }

    public static Set<String> getPrimitiveTypes(Collection<HollowSchema> schemaList) {
        HashSet<String> primitiveTypes = new HashSet<String>();
        for (HollowSchema schema : schemaList) {
            String type = schema.getName();
            if (!HollowCodeGenerationUtils.isPrimitiveType(type)) continue;
            primitiveTypes.add(type);
        }
        return primitiveTypes;
    }

    public static boolean isCollectionType(String schemaName, HollowDataset dataset) {
        return dataset.getSchema(schemaName).getSchemaType() != HollowSchema.SchemaType.OBJECT;
    }

    static {
        for (Class clzz : Arrays.asList(Boolean.class, Integer.class, Long.class, Float.class, Double.class, String.class)) {
            PRIMITIVE_TYPES.add(clzz.getSimpleName());
        }
        DEFAULT_CLASS_NAME_SUBSTITUTIONS.put("String", "HString");
        DEFAULT_CLASS_NAME_SUBSTITUTIONS.put("Integer", "HInteger");
        DEFAULT_CLASS_NAME_SUBSTITUTIONS.put("Long", "HLong");
        DEFAULT_CLASS_NAME_SUBSTITUTIONS.put("Float", "HFloat");
        DEFAULT_CLASS_NAME_SUBSTITUTIONS.put("Double", "HDouble");
        DEFAULT_CLASS_NAME_SUBSTITUTIONS.put("Boolean", "HBoolean");
        DEFAULT_CLASS_NAME_SUBSTITUTIONS.put("Object", "HObject");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("AbstractMethodError", "HAbstractMethodError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Appendable", "HAppendable");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("ArithmeticException", "HArithmeticException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("ArrayIndexOutOfBoundsException", "HArrayIndexOutOfBoundsException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("ArrayStoreException", "HArrayStoreException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("AssertionError", "HAssertionError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("AutoCloseable", "HAutoCloseable");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Boolean", "HBoolean");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("BootstrapMethodError", "HBootstrapMethodError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Byte", "HByte");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("CharSequence", "HCharSequence");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Character", "HCharacter");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Class", "HClass");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("ClassCastException", "HClassCastException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("ClassCircularityError", "HClassCircularityError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("ClassFormatError", "HClassFormatError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("ClassLoader", "HClassLoader");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("ClassNotFoundException", "HClassNotFoundException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("ClassValue", "HClassValue");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("CloneNotSupportedException", "HCloneNotSupportedException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Cloneable", "HCloneable");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Comparable", "HComparable");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Compiler", "HCompiler");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Deprecated", "HDeprecated");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Double", "HDouble");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Enum", "HEnum");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("EnumConstantNotPresentException", "HEnumConstantNotPresentException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Error", "HError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Exception", "HException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("ExceptionInInitializerError", "HExceptionInInitializerError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Float", "HFloat");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("IllegalAccessError", "HIllegalAccessError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("IllegalAccessException", "HIllegalAccessException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("IllegalArgumentException", "HIllegalArgumentException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("IllegalMonitorStateException", "HIllegalMonitorStateException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("IllegalStateException", "HIllegalStateException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("IllegalThreadStateException", "HIllegalThreadStateException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("IncompatibleClassChangeError", "HIncompatibleClassChangeError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("IndexOutOfBoundsException", "HIndexOutOfBoundsException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("InheritableThreadLocal", "HInheritableThreadLocal");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("InstantiationError", "HInstantiationError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("InstantiationException", "HInstantiationException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Integer", "HInteger");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("InternalError", "HInternalError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("InterruptedException", "HInterruptedException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Iterable", "HIterable");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("LinkageError", "HLinkageError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Long", "HLong");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Math", "HMath");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("NegativeArraySizeException", "HNegativeArraySizeException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("NoClassDefFoundError", "HNoClassDefFoundError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("NoSuchFieldError", "HNoSuchFieldError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("NoSuchFieldException", "HNoSuchFieldException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("NoSuchMethodError", "HNoSuchMethodError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("NoSuchMethodException", "HNoSuchMethodException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("NullPointerException", "HNullPointerException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Number", "HNumber");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("NumberFormatException", "HNumberFormatException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Object", "HObject");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("OutOfMemoryError", "HOutOfMemoryError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Override", "HOverride");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Package", "HPackage");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Process", "HProcess");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("ProcessBuilder", "HProcessBuilder");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Readable", "HReadable");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("ReflectiveOperationException", "HReflectiveOperationException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Runnable", "HRunnable");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Runtime", "HRuntime");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("RuntimeException", "HRuntimeException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("RuntimePermission", "HRuntimePermission");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("SafeVarargs", "HSafeVarargs");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("SecurityException", "HSecurityException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("SecurityManager", "HSecurityManager");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Short", "HShort");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("StackOverflowError", "HStackOverflowError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("StackTraceElement", "HStackTraceElement");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("StrictMath", "HStrictMath");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("String", "HString");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("StringBuffer", "HStringBuffer");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("StringBuilder", "HStringBuilder");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("StringIndexOutOfBoundsException", "HStringIndexOutOfBoundsException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("SuppressWarnings", "HSuppressWarnings");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("System", "HSystem");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Thread", "HThread");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("ThreadDeath", "HThreadDeath");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("ThreadGroup", "HThreadGroup");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("ThreadLocal", "HThreadLocal");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Throwable", "HThrowable");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("TypeNotPresentException", "HTypeNotPresentException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("UnknownError", "HUnknownError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("UnsatisfiedLinkError", "HUnsatisfiedLinkError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("UnsupportedClassVersionError", "HUnsupportedClassVersionError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("UnsupportedOperationException", "HUnsupportedOperationException");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("VerifyError", "HVerifyError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("VirtualMachineError", "HVirtualMachineError");
        AGGRESSIVE_CLASS_NAME_SUBSTITUTIONS.put("Void", "HVoid");
        booleanMethodPrefixes = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("is", "has", "do", "should", "was", "contains", "enable", "disable", "get")));
    }
}

