/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArgumentParser<T extends Enum> {
    private static final Pattern COMMAND_LINE_ARG_PATTERN = Pattern.compile("--(\\w+)=([\\w, ./-]+)");
    private final List<ParsedArgument> parsedArguments = new ArrayList<ParsedArgument>();

    public ArgumentParser(Class<T> validArguments, String[] args) {
        for (String arg : args) {
            Matcher matcher = COMMAND_LINE_ARG_PATTERN.matcher(arg);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid argument " + arg);
            }
            String argK = matcher.group(1);
            String argV = matcher.group(2);
            try {
                T key = Enum.valueOf(validArguments, argK);
                this.parsedArguments.add(new ParsedArgument(this, key, argV));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid argument " + arg);
            }
        }
    }

    public List<ParsedArgument> getParsedArguments() {
        return this.parsedArguments;
    }

    public static class ParsedArgument {
        private final T key;
        private final String value;
        final /* synthetic */ ArgumentParser this$0;

        public ParsedArgument(T key, String value) {
            this.this$0 = this$0;
            this.key = key;
            this.value = value;
        }

        public T getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

