/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.client;

import com.netflix.hollow.api.client.StackTraceRecorder;
import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.api.custom.HollowAPI;
import com.netflix.hollow.api.sampling.EnabledSamplingDirector;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.proxy.HollowProxyDataAccess;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.util.Threads;
import com.netflix.hollow.tools.history.HollowHistoricalStateDataAccess;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StaleHollowReferenceDetector {
    private static final long HOUSEKEEPING_INTERVAL = 30000L;
    private static final EnabledSamplingDirector ENABLED_SAMPLING_DIRECTOR = new EnabledSamplingDirector();
    private final List<HollowWeakReferenceHandle> handles = new ArrayList<HollowWeakReferenceHandle>();
    private final HollowConsumer.ObjectLongevityConfig config;
    private final HollowConsumer.ObjectLongevityDetector detector;
    private final StackTraceRecorder stackTraceRecorder;
    private Thread monitor;

    public StaleHollowReferenceDetector(HollowConsumer.ObjectLongevityConfig config, HollowConsumer.ObjectLongevityDetector detector) {
        this.config = config;
        this.detector = detector;
        this.stackTraceRecorder = new StackTraceRecorder(25);
    }

    synchronized boolean isKnownAPIHandle(HollowAPI api) {
        for (HollowWeakReferenceHandle handle : this.handles) {
            if (!handle.isAPIHandled(api)) continue;
            return true;
        }
        return false;
    }

    synchronized void newAPIHandle(HollowAPI api) {
        for (HollowWeakReferenceHandle handle : this.handles) {
            handle.newAPIAvailable(api);
        }
        this.handles.add(new HollowWeakReferenceHandle(api));
    }

    private synchronized int countStaleReferenceExistenceSignals() {
        int signals = 0;
        for (HollowWeakReferenceHandle handle : this.handles) {
            if (!handle.isExistingStaleReferenceHint()) continue;
            ++signals;
        }
        return signals;
    }

    private synchronized int countStaleReferenceUsageSignals() {
        int signals = 0;
        for (HollowWeakReferenceHandle handle : this.handles) {
            if (!handle.hasBeenUsedSinceReset()) continue;
            ++signals;
        }
        return signals;
    }

    private synchronized void housekeeping() {
        Iterator<HollowWeakReferenceHandle> iter = this.handles.iterator();
        while (iter.hasNext()) {
            HollowWeakReferenceHandle handle = iter.next();
            handle.housekeeping();
            if (!handle.isFinished()) continue;
            iter.remove();
        }
    }

    public void startMonitoring() {
        if (this.monitor == null) {
            Threads.daemonThread(new Monitor(this), this.getClass(), "monitor").start();
        }
    }

    public StackTraceRecorder getStaleReferenceStackTraceRecorder() {
        return this.stackTraceRecorder;
    }

    private class HollowWeakReferenceHandle {
        private final WeakReference<HollowAPI> apiHandle;
        private final WeakReference<Object> siblingHandle;
        private long gracePeriodBeginTimestamp = Long.MAX_VALUE;
        private Object sibling;
        private boolean usageDetected;
        private boolean detached;

        private HollowWeakReferenceHandle(HollowAPI stateEngine) {
            this.apiHandle = new WeakReference<HollowAPI>(stateEngine);
            this.sibling = new Object();
            this.siblingHandle = new WeakReference<Object>(this.sibling);
        }

        private boolean isFinished() {
            return !this.stateEngineIsReachable();
        }

        private boolean isExistingStaleReferenceHint() {
            return this.stateEngineIsReachable() && !this.siblingIsReachable();
        }

        private boolean hasBeenUsedSinceReset() {
            HollowAPI myAPI;
            if (this.sibling == null && (myAPI = (HollowAPI)this.apiHandle.get()) != null) {
                return myAPI.getDataAccess().hasSampleResults();
            }
            return false;
        }

        private void housekeeping() {
            if (this.gracePeriodBeginTimestamp != Long.MAX_VALUE) {
                if (this.shouldBeginUsageDetectionPeriod()) {
                    this.beginUsageDetectionPeriod();
                }
                if (this.shouldDetach()) {
                    this.detach();
                }
                this.setUpStackTraceRecording();
            }
        }

        private boolean shouldDetach() {
            if (!this.detached && System.currentTimeMillis() > this.gracePeriodBeginTimestamp + StaleHollowReferenceDetector.this.config.gracePeriodMillis() + StaleHollowReferenceDetector.this.config.usageDetectionPeriodMillis()) {
                if (StaleHollowReferenceDetector.this.config.forceDropData()) {
                    return true;
                }
                if (StaleHollowReferenceDetector.this.config.dropDataAutomatically()) {
                    if (this.usageDetected) {
                        return false;
                    }
                    HollowAPI api = (HollowAPI)this.apiHandle.get();
                    if (api != null) {
                        HollowDataAccess dataAccess = api.getDataAccess();
                        if (dataAccess.hasSampleResults()) {
                            this.usageDetected = true;
                            return false;
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        private void detach() {
            HollowAPI api = (HollowAPI)this.apiHandle.get();
            if (api != null) {
                HollowDataAccess dataAccess = api.getDataAccess();
                if (dataAccess instanceof HollowProxyDataAccess) {
                    ((HollowProxyDataAccess)dataAccess).disableDataAccess();
                } else if (dataAccess instanceof HollowReadStateEngine) {
                    ((HollowReadStateEngine)dataAccess).invalidate();
                }
                api.detachCaches();
            }
            this.detached = true;
        }

        private boolean shouldBeginUsageDetectionPeriod() {
            return this.sibling != null && System.currentTimeMillis() > this.gracePeriodBeginTimestamp + StaleHollowReferenceDetector.this.config.gracePeriodMillis();
        }

        private void beginUsageDetectionPeriod() {
            this.sibling = null;
            HollowAPI hollowAPI = (HollowAPI)this.apiHandle.get();
            if (hollowAPI != null) {
                hollowAPI.getDataAccess().resetSampling();
                hollowAPI.setSamplingDirector(ENABLED_SAMPLING_DIRECTOR);
            }
        }

        private void setUpStackTraceRecording() {
            HollowDataAccess proxiedDataAccess;
            HollowDataAccess dataAccess;
            HollowAPI api = (HollowAPI)this.apiHandle.get();
            if (api != null && (dataAccess = api.getDataAccess()) instanceof HollowProxyDataAccess && (proxiedDataAccess = ((HollowProxyDataAccess)dataAccess).getProxiedDataAccess()) instanceof HollowHistoricalStateDataAccess) {
                ((HollowHistoricalStateDataAccess)proxiedDataAccess).setStackTraceRecorder(StaleHollowReferenceDetector.this.config.enableExpiredUsageStackTraces() ? StaleHollowReferenceDetector.this.stackTraceRecorder : null);
            }
        }

        private boolean stateEngineIsReachable() {
            return this.apiHandle.get() != null;
        }

        private boolean siblingIsReachable() {
            return this.siblingHandle.get() != null;
        }

        private boolean isAPIHandled(HollowAPI api) {
            return this.apiHandle.get() == api;
        }

        private void newAPIAvailable(HollowAPI api) {
            if (this.shouldBeginGracePeriod(api)) {
                this.gracePeriodBeginTimestamp = System.currentTimeMillis();
            }
        }

        private boolean shouldBeginGracePeriod(HollowAPI newAPI) {
            if (this.gracePeriodBeginTimestamp != Long.MAX_VALUE) {
                return false;
            }
            HollowAPI myAPI = (HollowAPI)this.apiHandle.get();
            if (myAPI == null) {
                return false;
            }
            if (myAPI == newAPI) {
                return false;
            }
            if (myAPI.getDataAccess() == newAPI.getDataAccess()) {
                return false;
            }
            if (newAPI.getDataAccess() instanceof HollowProxyDataAccess && ((HollowProxyDataAccess)newAPI.getDataAccess()).getProxiedDataAccess() == myAPI.getDataAccess()) {
                return false;
            }
            if (myAPI.getDataAccess() instanceof HollowProxyDataAccess && ((HollowProxyDataAccess)myAPI.getDataAccess()).getProxiedDataAccess() == newAPI.getDataAccess()) {
                return false;
            }
            return !(myAPI.getDataAccess() instanceof HollowProxyDataAccess) || !(newAPI.getDataAccess() instanceof HollowProxyDataAccess) || ((HollowProxyDataAccess)myAPI.getDataAccess()).getProxiedDataAccess() != ((HollowProxyDataAccess)newAPI.getDataAccess()).getProxiedDataAccess();
        }
    }

    private static class Monitor
    implements Runnable {
        private final WeakReference<StaleHollowReferenceDetector> ref;

        Monitor(StaleHollowReferenceDetector parent) {
            this.ref = new WeakReference<StaleHollowReferenceDetector>(parent);
        }

        @Override
        public void run() {
            while (this.ref.get() != null) {
                StaleHollowReferenceDetector parent;
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if ((parent = (StaleHollowReferenceDetector)this.ref.get()) == null) continue;
                parent.housekeeping();
                parent.detector.staleReferenceExistenceDetected(parent.countStaleReferenceExistenceSignals());
                parent.detector.staleReferenceUsageDetected(parent.countStaleReferenceUsageSignals());
            }
        }
    }
}

