/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.client;

import com.netflix.hollow.api.client.HollowBlobRetriever;
import com.netflix.hollow.api.client.HollowClientConsumerBridge;
import com.netflix.hollow.api.client.HollowUpdatePlan;
import com.netflix.hollow.api.consumer.HollowConsumer;
import java.util.logging.Logger;

public class HollowUpdatePlanner {
    private static final Logger LOG = Logger.getLogger(HollowUpdatePlanner.class.getName());
    private final HollowConsumer.BlobRetriever transitionCreator;
    private final HollowConsumer.DoubleSnapshotConfig doubleSnapshotConfig;
    private final HollowConsumer.UpdatePlanBlobVerifier updatePlanBlobVerifier;

    @Deprecated
    public HollowUpdatePlanner(HollowBlobRetriever blobRetriever) {
        this(HollowClientConsumerBridge.consumerBlobRetrieverFor(blobRetriever));
    }

    public HollowUpdatePlanner(HollowConsumer.BlobRetriever blobRetriever) {
        this(blobRetriever, HollowConsumer.DoubleSnapshotConfig.DEFAULT_CONFIG);
    }

    public HollowUpdatePlanner(HollowConsumer.BlobRetriever transitionCreator, HollowConsumer.DoubleSnapshotConfig doubleSnapshotConfig) {
        this(transitionCreator, doubleSnapshotConfig, HollowConsumer.UpdatePlanBlobVerifier.DEFAULT_INSTANCE);
    }

    public HollowUpdatePlanner(HollowConsumer.BlobRetriever transitionCreator, HollowConsumer.DoubleSnapshotConfig doubleSnapshotConfig, HollowConsumer.UpdatePlanBlobVerifier updatePlanBlobVerifier) {
        this.transitionCreator = transitionCreator;
        this.doubleSnapshotConfig = doubleSnapshotConfig;
        this.updatePlanBlobVerifier = updatePlanBlobVerifier;
    }

    @Deprecated
    public HollowUpdatePlan planInitializingUpdate(long desiredVersion) throws Exception {
        return this.planInitializingUpdate(new HollowConsumer.VersionInfo(desiredVersion));
    }

    public HollowUpdatePlan planInitializingUpdate(HollowConsumer.VersionInfo desiredVersionInfo) throws Exception {
        return this.planUpdate(Long.MIN_VALUE, desiredVersionInfo, true);
    }

    @Deprecated
    public HollowUpdatePlan planUpdate(long currentVersion, long desiredVersion, boolean allowSnapshot) throws Exception {
        return this.planUpdate(currentVersion, new HollowConsumer.VersionInfo(desiredVersion), allowSnapshot);
    }

    public HollowUpdatePlan planUpdate(long currentVersion, HollowConsumer.VersionInfo desiredVersionInfo, boolean allowSnapshot) throws Exception {
        HollowUpdatePlan snapshotPlan;
        long snapshotDestinationVersion;
        long desiredVersion = desiredVersionInfo.getVersion();
        if (desiredVersion == currentVersion) {
            return HollowUpdatePlan.DO_NOTHING;
        }
        if (currentVersion == Long.MIN_VALUE) {
            return this.snapshotPlan(desiredVersionInfo);
        }
        HollowUpdatePlan deltaPlan = this.deltaPlan(currentVersion, desiredVersion, this.doubleSnapshotConfig.maxDeltasBeforeDoubleSnapshot());
        long deltaDestinationVersion = deltaPlan.destinationVersion(currentVersion);
        if (deltaDestinationVersion != desiredVersion && allowSnapshot && ((snapshotDestinationVersion = (snapshotPlan = this.snapshotPlan(desiredVersionInfo)).destinationVersion(currentVersion)) == desiredVersion || deltaDestinationVersion > desiredVersion && snapshotDestinationVersion < desiredVersion || snapshotDestinationVersion < desiredVersion && snapshotDestinationVersion > deltaDestinationVersion)) {
            return snapshotPlan;
        }
        return deltaPlan;
    }

    private HollowUpdatePlan snapshotPlan(HollowConsumer.VersionInfo desiredVersionInfo) {
        HollowUpdatePlan plan = new HollowUpdatePlan();
        long desiredVersion = desiredVersionInfo.getVersion();
        long nearestPreviousSnapshotVersion = this.includeNearestSnapshot(plan, desiredVersionInfo);
        if (nearestPreviousSnapshotVersion > desiredVersion) {
            return HollowUpdatePlan.DO_NOTHING;
        }
        if (nearestPreviousSnapshotVersion == Long.MAX_VALUE) {
            return HollowUpdatePlan.DO_NOTHING;
        }
        plan.appendPlan(this.deltaPlan(nearestPreviousSnapshotVersion, desiredVersion, Integer.MAX_VALUE));
        return plan;
    }

    private HollowUpdatePlan deltaPlan(long currentVersion, long desiredVersion, int maxDeltas) {
        HollowUpdatePlan plan = new HollowUpdatePlan();
        if (currentVersion < desiredVersion) {
            this.applyForwardDeltasToPlan(currentVersion, desiredVersion, plan, maxDeltas);
        } else if (currentVersion > desiredVersion) {
            this.applyReverseDeltasToPlan(currentVersion, desiredVersion, plan, maxDeltas);
        }
        return plan;
    }

    private long applyForwardDeltasToPlan(long currentVersion, long desiredVersion, HollowUpdatePlan plan, int maxDeltas) {
        for (int transitionCounter = 0; currentVersion < desiredVersion && transitionCounter < maxDeltas; ++transitionCounter) {
            currentVersion = this.includeNextDelta(plan, currentVersion, desiredVersion);
        }
        return currentVersion;
    }

    private long applyReverseDeltasToPlan(long currentVersion, long desiredVersion, HollowUpdatePlan plan, int maxDeltas) {
        long achievedVersion = currentVersion;
        for (int transitionCounter = 0; currentVersion > desiredVersion && transitionCounter < maxDeltas; ++transitionCounter) {
            if ((currentVersion = this.includeNextReverseDelta(plan, currentVersion)) == Long.MIN_VALUE) continue;
            achievedVersion = currentVersion;
        }
        return achievedVersion;
    }

    private long includeNextDelta(HollowUpdatePlan plan, long currentVersion, long desiredVersion) {
        HollowConsumer.Blob transition = this.transitionCreator.retrieveDeltaBlob(currentVersion);
        if (transition != null) {
            if (transition.getToVersion() <= desiredVersion) {
                plan.add(transition);
            }
            return transition.getToVersion();
        }
        return Long.MAX_VALUE;
    }

    private long includeNextReverseDelta(HollowUpdatePlan plan, long currentVersion) {
        HollowConsumer.Blob transition = this.transitionCreator.retrieveReverseDeltaBlob(currentVersion);
        if (transition != null) {
            plan.add(transition);
            return transition.getToVersion();
        }
        return Long.MIN_VALUE;
    }

    private long includeNearestSnapshot(HollowUpdatePlan plan, HollowConsumer.VersionInfo desiredVersionInfo) {
        long desiredVersion = desiredVersionInfo.getVersion();
        HollowConsumer.Blob transition = this.transitionCreator.retrieveSnapshotBlob(desiredVersion);
        if (transition != null) {
            if (transition.getToVersion() == desiredVersion) {
                plan.add(transition);
                return transition.getToVersion();
            }
            if (this.updatePlanBlobVerifier != null && this.updatePlanBlobVerifier.announcementVerificationEnabled() && desiredVersionInfo.wasAnnounced() != null && desiredVersionInfo.wasAnnounced().isPresent() && desiredVersionInfo.wasAnnounced().get().booleanValue()) {
                int maxLookback = this.updatePlanBlobVerifier.announcementVerificationMaxLookback();
                HollowConsumer.AnnouncementWatcher announcementWatcher = this.updatePlanBlobVerifier.announcementWatcher();
                for (int lookback = 1; lookback <= maxLookback; ++lookback) {
                    HollowConsumer.AnnouncementStatus announcementStatus;
                    HollowConsumer.AnnouncementStatus announcementStatus2 = announcementStatus = announcementWatcher == null ? HollowConsumer.AnnouncementStatus.UNKNOWN : announcementWatcher.getVersionAnnouncementStatus(transition.getToVersion());
                    if (announcementStatus != null && !announcementStatus.equals((Object)HollowConsumer.AnnouncementStatus.UNKNOWN) && !announcementStatus.equals((Object)HollowConsumer.AnnouncementStatus.ANNOUNCED)) continue;
                    if (announcementStatus == HollowConsumer.AnnouncementStatus.UNKNOWN) {
                        if (announcementWatcher == null) {
                            LOG.warning("HollowUpdatePlanner was not initialized with an announcement watcher so it does not support getVersionAnnouncementStatus. Consumer will continue with the update but runs the risk of consuming a snapshot version that was not announced");
                        } else {
                            LOG.warning(String.format("Announcement watcher impl bound (%s) to HollowUpdatePlanner does not support getVersionAnnouncementStatus. Consumer will continue with the update but runs the risk of consuming a snapshot version that was not announced", announcementWatcher.getClass().getName()));
                        }
                    } else if (announcementStatus == null) {
                        LOG.warning(String.format("Expecting a valid announcement stats for version(%s), but Announcement watcher impl (%s) returned null", transition.getToVersion(), announcementWatcher.getClass().getName()));
                    }
                    plan.add(transition);
                    return transition.getToVersion();
                }
                LOG.warning("No past snapshot found within lookback period that corresponded to an announced version, maxLookback configured to " + maxLookback);
            } else {
                plan.add(transition);
                return transition.getToVersion();
            }
        }
        return Long.MAX_VALUE;
    }
}

