/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.client;

import com.netflix.hollow.api.consumer.HollowConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class HollowUpdatePlan
implements Iterable<HollowConsumer.Blob> {
    public static HollowUpdatePlan DO_NOTHING = new HollowUpdatePlan(Collections.emptyList());
    private final List<HollowConsumer.Blob> transitions;

    private HollowUpdatePlan(List<HollowConsumer.Blob> transitions) {
        this.transitions = transitions;
    }

    public HollowUpdatePlan() {
        this.transitions = new ArrayList<HollowConsumer.Blob>();
    }

    public boolean isSnapshotPlan() {
        return !this.transitions.isEmpty() && this.transitions.get(0).isSnapshot();
    }

    public HollowConsumer.Blob getSnapshotTransition() {
        if (!this.isSnapshotPlan()) {
            return null;
        }
        return this.transitions.get(0);
    }

    public List<HollowConsumer.Blob> getDeltaTransitions() {
        if (!this.isSnapshotPlan()) {
            return this.transitions;
        }
        return this.transitions.subList(1, this.transitions.size());
    }

    public HollowConsumer.Blob getTransition(int index) {
        return this.transitions.get(index);
    }

    public List<HollowConsumer.Blob> getTransitions() {
        return this.transitions;
    }

    public List<HollowConsumer.Blob.BlobType> getTransitionSequence() {
        return this.transitions.stream().map(t -> t.getBlobType()).collect(Collectors.toList());
    }

    public long destinationVersion(long currentVersion) {
        long dest = this.destinationVersion();
        return dest == Long.MIN_VALUE ? currentVersion : dest;
    }

    public long destinationVersion() {
        return this.transitions.isEmpty() ? Long.MIN_VALUE : this.transitions.get(this.transitions.size() - 1).getToVersion();
    }

    public int numTransitions() {
        return this.transitions.size();
    }

    public void add(HollowConsumer.Blob transition) {
        this.transitions.add(transition);
    }

    public void appendPlan(HollowUpdatePlan plan) {
        this.transitions.addAll(plan.transitions);
    }

    @Override
    public Iterator<HollowConsumer.Blob> iterator() {
        return this.transitions.iterator();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.transitions != null) {
            for (int i = 0; i < this.transitions.size(); ++i) {
                HollowConsumer.Blob blob = this.transitions.get(i);
                result.append((Object)blob.getBlobType()).append(" to ").append(blob.getToVersion());
                if (i >= this.transitions.size() - 1) continue;
                result.append(", ");
            }
        }
        return result.toString();
    }
}

