/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.client;

import com.netflix.hollow.api.client.HollowClient;
import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.core.util.Threads;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public abstract class HollowAnnouncementWatcher {
    private static final Logger log = Logger.getLogger(HollowAnnouncementWatcher.class.getName());
    private final ExecutorService refreshExecutor;
    private HollowClient client;

    public HollowAnnouncementWatcher() {
        this.refreshExecutor = Executors.newFixedThreadPool(1, r -> Threads.daemonThread(r, this.getClass(), "watch"));
    }

    public HollowAnnouncementWatcher(ExecutorService refreshExecutor) {
        this.refreshExecutor = refreshExecutor;
    }

    public HollowConsumer.VersionInfo getLatestVersionInfo() {
        return new HollowConsumer.VersionInfo(this.getLatestVersion());
    }

    public abstract long getLatestVersion();

    public abstract void subscribeToEvents();

    public void setLatestVersion(long latestVersion) {
        throw new UnsupportedOperationException("Cannot explicitly set latest version on a " + this.getClass());
    }

    protected void forceDoubleSnapshotNextUpdate() {
        this.client.forceDoubleSnapshotNextUpdate();
    }

    public void triggerAsyncRefresh() {
        this.triggerAsyncRefreshWithDelay(0);
    }

    public void triggerAsyncRefreshWithRandomDelay(int maxDelayMillis) {
        Random rand = new Random();
        int delayMillis = maxDelayMillis > 0 ? rand.nextInt(maxDelayMillis) : 0;
        this.triggerAsyncRefreshWithDelay(delayMillis);
    }

    public void triggerAsyncRefreshWithDelay(int delayMillis) {
        final HollowClient client = this.client;
        final long targetBeginTime = System.currentTimeMillis() + (long)delayMillis;
        this.refreshExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    long delay = targetBeginTime - System.currentTimeMillis();
                    if (delay > 0L) {
                        Thread.sleep(delay);
                    }
                    client.triggerRefresh();
                }
                catch (Throwable th) {
                    log.log(Level.SEVERE, "Async refresh failed", th);
                }
            }
        });
    }

    protected HollowClient getClientToNotify() {
        return this.client;
    }

    void setClientToNotify(HollowClient client) {
        this.client = client;
        this.subscribeToEvents();
    }

    public static class DefaultWatcher
    extends HollowAnnouncementWatcher {
        private long latestVersion = Long.MAX_VALUE;

        public DefaultWatcher() {
        }

        public DefaultWatcher(ExecutorService refreshExecutor) {
            super(refreshExecutor);
        }

        @Override
        public long getLatestVersion() {
            return this.latestVersion;
        }

        @Override
        public void subscribeToEvents() {
        }

        @Override
        public void setLatestVersion(long latestVersion) {
            this.latestVersion = latestVersion;
        }
    }
}

