/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.utils;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.commons.utils.StringNormalizer;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SvgCssUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SvgCssUtils.class);

    private SvgCssUtils() {
    }

    public static List<String> splitValueList(String value) {
        ArrayList<String> result = new ArrayList<String>();
        if (value != null && value.length() > 0) {
            String[] list;
            value = value.trim();
            for (String element : list = value.split("[,|\\s]")) {
                if (element.isEmpty()) continue;
                result.add(element);
            }
        }
        return result;
    }

    @Deprecated
    public static String convertFloatToString(float value) {
        return String.valueOf(value);
    }

    @Deprecated
    public static String convertDoubleToString(double value) {
        return String.valueOf(value);
    }

    public static float parseAbsoluteLength(AbstractSvgNodeRenderer svgNodeRenderer, String length, float percentBaseValue, float defaultValue, SvgDrawContext context) {
        float em = svgNodeRenderer.getCurrentFontSize(context);
        float rem = context.getCssContext().getRootFontSize();
        return CssDimensionParsingUtils.parseLength(length, percentBaseValue, defaultValue, em, rem);
    }

    public static float parseAbsoluteVerticalLength(AbstractSvgNodeRenderer svgNodeRenderer, String length, float defaultValue, SvgDrawContext context) {
        float percentBaseValue = SvgCssUtils.calculatePercentBaseValueIfNeeded(svgNodeRenderer, context, length, false);
        return SvgCssUtils.parseAbsoluteLength(svgNodeRenderer, length, percentBaseValue, defaultValue, context);
    }

    public static float parseAbsoluteHorizontalLength(AbstractSvgNodeRenderer svgNodeRenderer, String length, float defaultValue, SvgDrawContext context) {
        float percentBaseValue = SvgCssUtils.calculatePercentBaseValueIfNeeded(svgNodeRenderer, context, length, true);
        return SvgCssUtils.parseAbsoluteLength(svgNodeRenderer, length, percentBaseValue, defaultValue, context);
    }

    public static float[] parseViewBox(ISvgNodeRenderer svgRenderer) {
        String vbString = svgRenderer.getAttribute("viewBox");
        if (vbString == null) {
            vbString = svgRenderer.getAttribute(StringNormalizer.toLowerCase("viewBox"));
        }
        float[] values = null;
        if (vbString != null) {
            List<String> valueStrings = SvgCssUtils.splitValueList(vbString);
            values = new float[valueStrings.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = CssDimensionParsingUtils.parseAbsoluteLength(valueStrings.get(i));
            }
        }
        if (values != null) {
            if (values.length != 4) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn(MessageFormatUtil.format("The viewBox value must be 4 numbers. This viewBox=\"{0}\" will not be processed.", vbString));
                }
                return null;
            }
            if (values[2] < 0.0f || values[3] < 0.0f) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn(MessageFormatUtil.format("The viewBox width and height cannot be negative. This viewBox=\"{0}\" will not be processed.", vbString));
                }
                return null;
            }
        }
        return values;
    }

    public static Rectangle extractWidthAndHeight(ISvgNodeRenderer svgRenderer, float em, SvgDrawContext context) {
        float percentVerticalBase;
        float percentHorizontalBase;
        float finalWidth = 0.0f;
        float finalHeight = 0.0f;
        if (context.getCustomViewport() == null) {
            float[] viewBox = SvgCssUtils.parseViewBox(svgRenderer);
            if (viewBox == null) {
                percentHorizontalBase = 225.0f;
                percentVerticalBase = 112.5f;
            } else {
                percentHorizontalBase = viewBox[2];
                percentVerticalBase = viewBox[3];
            }
        } else {
            percentHorizontalBase = context.getCustomViewport().getWidth();
            percentVerticalBase = context.getCustomViewport().getHeight();
        }
        float rem = context.getCssContext().getRootFontSize();
        String width = svgRenderer.getAttribute("width");
        finalWidth = SvgCssUtils.calculateFinalSvgRendererLength(width, em, rem, percentHorizontalBase);
        String height = svgRenderer.getAttribute("height");
        finalHeight = SvgCssUtils.calculateFinalSvgRendererLength(height, em, rem, percentVerticalBase);
        return new Rectangle(finalWidth, finalHeight);
    }

    private static float calculateFinalSvgRendererLength(String length, float em, float rem, float percentBase) {
        if (length == null) {
            length = "100%";
        }
        if (CssTypesValidationUtils.isRemValue(length)) {
            return CssDimensionParsingUtils.parseRelativeValue(length, rem);
        }
        if (CssTypesValidationUtils.isEmValue(length)) {
            return CssDimensionParsingUtils.parseRelativeValue(length, em);
        }
        if (CssTypesValidationUtils.isPercentageValue(length)) {
            return CssDimensionParsingUtils.parseRelativeValue(length, percentBase);
        }
        return CssDimensionParsingUtils.parseAbsoluteLength(length);
    }

    private static float calculatePercentBaseValueIfNeeded(AbstractSvgNodeRenderer svgNodeRenderer, SvgDrawContext context, String length, boolean isXAxis) {
        float percentBaseValue = 0.0f;
        if (CssTypesValidationUtils.isPercentageValue(length)) {
            Rectangle viewBox = svgNodeRenderer.getCurrentViewBox(context);
            if (viewBox == null) {
                throw new SvgProcessingException("Relative value can't be resolved, no viewport is set.");
            }
            percentBaseValue = isXAxis ? viewBox.getWidth() : viewBox.getHeight();
        }
        return percentBaseValue;
    }
}

