/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.path.impl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.path.impl.AbstractPathShape;
import com.itextpdf.svg.renderers.path.impl.DefaultOperatorConverter;
import com.itextpdf.svg.renderers.path.impl.IControlPointCurve;
import com.itextpdf.svg.renderers.path.impl.IOperatorConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class QuadraticCurveTo
extends AbstractPathShape
implements IControlPointCurve {
    static final int ARGUMENT_SIZE = 4;

    public QuadraticCurveTo() {
        this(false);
    }

    public QuadraticCurveTo(boolean relative) {
        this(relative, new DefaultOperatorConverter());
    }

    public QuadraticCurveTo(boolean relative, IOperatorConverter copier) {
        super(relative, copier);
    }

    @Override
    public void draw() {
        double x1 = this.parseHorizontalLength(this.coordinates[0]);
        double y1 = this.parseVerticalLength(this.coordinates[1]);
        double x = this.parseHorizontalLength(this.coordinates[2]);
        double y = this.parseVerticalLength(this.coordinates[3]);
        double[] points = new double[]{x1, y1, x, y};
        this.applyTransform(points);
        int i = 0;
        this.context.getCurrentCanvas().curveTo(points[i++], points[i++], points[i++], points[i]);
    }

    @Override
    public void setCoordinates(String[] inputCoordinates, Point startPoint) {
        if (inputCoordinates.length < 4) {
            throw new IllegalArgumentException(MessageFormatUtil.format("(x1 y1 x y)+ parameters are expected for quadratic curves. Got: {0}", Arrays.toString(this.coordinates)));
        }
        this.coordinates = new String[4];
        System.arraycopy(inputCoordinates, 0, this.coordinates, 0, 4);
        double[] initialPoint = new double[]{startPoint.getX(), startPoint.getY()};
        if (this.isRelative()) {
            this.coordinates = this.copier.makeCoordinatesAbsolute(this.coordinates, initialPoint);
        }
    }

    @Override
    public Point getLastControlPoint() {
        return this.createPoint(this.coordinates[0], this.coordinates[1]);
    }

    @Override
    public Rectangle getPathShapeRectangle(Point lastPoint) {
        Point controlPoint = this.getLastControlPoint();
        Point endingPoint = this.getEndingPoint();
        double[] points = QuadraticCurveTo.getBezierMinMaxPoints(lastPoint.getX(), lastPoint.getY(), controlPoint.getX(), controlPoint.getY(), endingPoint.getX(), endingPoint.getY());
        return new Rectangle((float)CssUtils.convertPxToPts(points[0]), (float)CssUtils.convertPxToPts(points[1]), (float)CssUtils.convertPxToPts(points[2] - points[0]), (float)CssUtils.convertPxToPts(points[3] - points[1]));
    }

    private static double[] getBezierMinMaxPoints(double x0, double y0, double x1, double y1, double x2, double y2) {
        double[] extremeTValues;
        double xMin = Math.min(x0, x2);
        double yMin = Math.min(y0, y2);
        double xMax = Math.max(x0, x2);
        double yMax = Math.max(y0, y2);
        for (double t : extremeTValues = QuadraticCurveTo.getExtremeTValues(x0, y0, x1, y1, x2, y2)) {
            double xValue = QuadraticCurveTo.calculateExtremeCoordinate(t, x0, x1, x2);
            double yValue = QuadraticCurveTo.calculateExtremeCoordinate(t, y0, y1, y2);
            xMin = Math.min(xValue, xMin);
            yMin = Math.min(yValue, yMin);
            xMax = Math.max(xValue, xMax);
            yMax = Math.max(yValue, yMax);
        }
        return new double[]{xMin, yMin, xMax, yMax};
    }

    private static double[] getExtremeTValues(double x0, double y0, double x1, double y1, double x2, double y2) {
        ArrayList<Double> tValuesList = new ArrayList<Double>();
        QuadraticCurveTo.addTValueToList(QuadraticCurveTo.getTValue(x0, x1, x2), tValuesList);
        QuadraticCurveTo.addTValueToList(QuadraticCurveTo.getTValue(y0, y1, y2), tValuesList);
        double[] tValuesArray = new double[tValuesList.size()];
        for (int i = 0; i < tValuesList.size(); ++i) {
            tValuesArray[i] = (Double)tValuesList.get(i);
        }
        return tValuesArray;
    }

    private static void addTValueToList(double t, List<Double> tValuesList) {
        if (0.0 <= t && t <= 1.0) {
            tValuesList.add(t);
        }
    }

    private static double getTValue(double p0, double p1, double p2) {
        double b = 2.0 * p1 - 2.0 * p0;
        double a = p0 - 2.0 * p1 + p2;
        return -b / (2.0 * a);
    }

    private static double calculateExtremeCoordinate(double t, double p0, double p1, double p2) {
        double minusT = 1.0 - t;
        return minusT * minusT * p0 + 2.0 * minusT * t * p1 + t * t * p2;
    }
}

