/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.NoninvertibleTransformException;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.svg.renderers.IBranchSvgNodeRenderer;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.MarkerSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCoordinateUtils;
import com.itextpdf.svg.utils.SvgCssUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBranchSvgNodeRenderer
extends AbstractSvgNodeRenderer
implements IBranchSvgNodeRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBranchSvgNodeRenderer.class);
    @Deprecated
    protected static final int VIEWBOX_VALUES_NUMBER = 4;
    private static final float EPS = 1.0E-6f;
    private final List<ISvgNodeRenderer> children = new ArrayList<ISvgNodeRenderer>();

    @Override
    protected void doDraw(SvgDrawContext context) {
        if (!this.getChildren().isEmpty()) {
            PdfStream stream = new PdfStream();
            stream.put(PdfName.Type, PdfName.XObject);
            stream.put(PdfName.Subtype, PdfName.Form);
            PdfFormXObject xObject = (PdfFormXObject)PdfXObject.makeXObject(stream);
            PdfCanvas newCanvas = new PdfCanvas(xObject, context.getCurrentCanvas().getDocument());
            this.applyViewBox(context);
            boolean overflowVisible = AbstractBranchSvgNodeRenderer.isOverflowVisible(this);
            Rectangle bbBox = this instanceof MarkerSvgNodeRenderer && overflowVisible ? AbstractBranchSvgNodeRenderer.getBBoxAccordingToVisibleOverflow(context) : context.getCurrentViewPort().clone();
            stream.put(PdfName.BBox, new PdfArray(bbBox));
            context.pushCanvas(newCanvas);
            if (!(this instanceof MarkerSvgNodeRenderer) || !overflowVisible) {
                this.applyViewportClip(context);
            }
            for (ISvgNodeRenderer child : this.getChildren()) {
                if (child instanceof MarkerSvgNodeRenderer) continue;
                newCanvas.saveState();
                child.draw(context);
                newCanvas.restoreState();
            }
            this.cleanUp(context);
            context.getCurrentCanvas().addXObjectAt(xObject, bbBox.getX(), bbBox.getY());
        }
    }

    void applyViewBox(SvgDrawContext context) {
        Rectangle currentViewPort = context.getCurrentViewPort();
        float[] viewBoxValues = SvgCssUtils.parseViewBox(this);
        if (viewBoxValues == null || viewBoxValues.length < 4) {
            viewBoxValues = new float[]{0.0f, 0.0f, currentViewPort.getWidth(), currentViewPort.getHeight()};
        }
        this.calculateAndApplyViewBox(context, viewBoxValues, currentViewPort);
    }

    private void applyViewportClip(SvgDrawContext context) {
        PdfCanvas currentCanvas = context.getCurrentCanvas();
        currentCanvas.rectangle(context.getCurrentViewPort());
        currentCanvas.clip();
        currentCanvas.endPath();
    }

    private void cleanUp(SvgDrawContext context) {
        if (this.getParent() != null) {
            context.removeCurrentViewPort();
        }
        context.popCanvas();
    }

    @Override
    public final void addChild(ISvgNodeRenderer child) {
        if (child != null) {
            this.children.add(child);
        }
    }

    @Override
    public final List<ISvgNodeRenderer> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    protected final void deepCopyChildren(AbstractBranchSvgNodeRenderer deepCopy) {
        for (ISvgNodeRenderer child : this.children) {
            ISvgNodeRenderer newChild = child.createDeepCopy();
            child.setParent(deepCopy);
            deepCopy.addChild(newChild);
        }
    }

    @Override
    void postDraw(SvgDrawContext context) {
    }

    @Override
    public abstract ISvgNodeRenderer createDeepCopy();

    void calculateAndApplyViewBox(SvgDrawContext context, float[] values, Rectangle currentViewPort) {
        if (Math.abs(values[2]) < 1.0E-6f || Math.abs(values[3]) < 1.0E-6f) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("The viewBox width or height is zero. The element with this viewBox will not be rendered.");
            }
            context.getCurrentCanvas().concatMatrix(AffineTransform.getScaleInstance(0.0, 0.0));
            return;
        }
        String[] alignAndMeet = this.retrieveAlignAndMeet();
        String align = alignAndMeet[0];
        String meetOrSlice = alignAndMeet[1];
        Rectangle viewBox = new Rectangle(values[0], values[1], values[2], values[3]);
        Rectangle appliedViewBox = SvgCoordinateUtils.applyViewBox(viewBox, currentViewPort, align, meetOrSlice);
        float scaleWidth = appliedViewBox.getWidth() / viewBox.getWidth();
        float scaleHeight = appliedViewBox.getHeight() / viewBox.getHeight();
        AffineTransform scale = AffineTransform.getScaleInstance(scaleWidth, scaleHeight);
        float xOffset = appliedViewBox.getX() / scaleWidth - viewBox.getX();
        float yOffset = appliedViewBox.getY() / scaleHeight - viewBox.getY();
        AffineTransform transform = new AffineTransform();
        transform.translate(xOffset, yOffset);
        if (!transform.isIdentity()) {
            context.getCurrentCanvas().concatMatrix(transform);
            context.getCurrentViewPort().setX(currentViewPort.getX() - (float)transform.getTranslateX()).setY(currentViewPort.getY() - (float)transform.getTranslateY());
        }
        if (this instanceof MarkerSvgNodeRenderer) {
            ((MarkerSvgNodeRenderer)this).applyMarkerAttributes(context);
        }
        if (!scale.isIdentity()) {
            context.getCurrentCanvas().concatMatrix(scale);
            context.getCurrentViewPort().setWidth(currentViewPort.getWidth() / scaleWidth).setX(currentViewPort.getX() / scaleWidth).setHeight(currentViewPort.getHeight() / scaleHeight).setY(currentViewPort.getY() / scaleHeight);
        }
    }

    private static boolean isOverflowVisible(AbstractSvgNodeRenderer currentElement) {
        return "visible".equals(currentElement.attributesAndStyles.get("overflow")) || "auto".equals(currentElement.attributesAndStyles.get("overflow"));
    }

    private static Rectangle getBBoxAccordingToVisibleOverflow(SvgDrawContext context) {
        AffineTransform transform = context.getConcatenatedTransform();
        try {
            transform = transform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            Logger logger = LoggerFactory.getLogger(AbstractBranchSvgNodeRenderer.class);
            logger.warn("Unable to get inverse transformation matrix and thus calculate a viewport for the element because some of the transformation matrices, which are written to document, have a determinant of zero value. A bbox of zero values will be used as a viewport for this element.");
            return new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
        }
        Point[] points = context.getRootViewPort().toPointsArray();
        transform.transform(points, 0, points, 0, points.length);
        return Rectangle.calculateBBox(Arrays.asList(points));
    }
}

