/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.factories;

import com.itextpdf.commons.utils.StringNormalizer;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.CircleSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.ClipPathSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.DefsSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.EllipseSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.GroupSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.ImageSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.LineSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.LinearGradientSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.MarkerSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.PathSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.PatternSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.PolygonSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.PolylineSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.RectangleSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.StopSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.SvgTagSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.SymbolSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.TextLeafSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.TextSvgBranchRenderer;
import com.itextpdf.svg.renderers.impl.TextSvgTSpanBranchRenderer;
import com.itextpdf.svg.renderers.impl.UseSvgNodeRenderer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

class DefaultSvgNodeRendererMapper {
    private static final String CLIP_PATH_LC = StringNormalizer.toLowerCase("clipPath");
    private static final String LINEAR_GRADIENT_LC = StringNormalizer.toLowerCase("linearGradient");
    private static final String TEXT_LEAF_LC = StringNormalizer.toLowerCase(":text-leaf");
    private static final Map<String, ISvgNodeRendererCreator> mapping;
    private static final Collection<String> ignored;

    DefaultSvgNodeRendererMapper() {
    }

    Map<String, ISvgNodeRendererCreator> getMapping() {
        return mapping;
    }

    Collection<String> getIgnoredTags() {
        return ignored;
    }

    static {
        HashMap<String, ISvgNodeRendererCreator> result = new HashMap<String, ISvgNodeRendererCreator>();
        result.put("circle", () -> new CircleSvgNodeRenderer());
        result.put("clipPath", () -> new ClipPathSvgNodeRenderer());
        result.put("defs", () -> new DefsSvgNodeRenderer());
        result.put("ellipse", () -> new EllipseSvgNodeRenderer());
        result.put("g", () -> new GroupSvgNodeRenderer());
        result.put("image", () -> new ImageSvgNodeRenderer());
        result.put("line", () -> new LineSvgNodeRenderer());
        result.put("linearGradient", () -> new LinearGradientSvgNodeRenderer());
        result.put("marker", () -> new MarkerSvgNodeRenderer());
        result.put("pattern", () -> new PatternSvgNodeRenderer());
        result.put("path", () -> new PathSvgNodeRenderer());
        result.put("polygon", () -> new PolygonSvgNodeRenderer());
        result.put("polyline", () -> new PolylineSvgNodeRenderer());
        result.put("rect", () -> new RectangleSvgNodeRenderer());
        result.put("stop", () -> new StopSvgNodeRenderer());
        result.put("svg", () -> new SvgTagSvgNodeRenderer());
        result.put("symbol", () -> new SymbolSvgNodeRenderer());
        result.put("text", () -> new TextSvgBranchRenderer());
        result.put("tspan", () -> new TextSvgTSpanBranchRenderer());
        result.put("use", () -> new UseSvgNodeRenderer());
        result.put(":text-leaf", () -> new TextLeafSvgNodeRenderer());
        result.put(CLIP_PATH_LC, () -> new ClipPathSvgNodeRenderer());
        result.put(LINEAR_GRADIENT_LC, () -> new LinearGradientSvgNodeRenderer());
        result.put(TEXT_LEAF_LC, () -> new TextLeafSvgNodeRenderer());
        mapping = Collections.unmodifiableMap(result);
        HashSet<String> ignoredTags = new HashSet<String>();
        ignoredTags.add("a");
        ignoredTags.add("altGlyph");
        ignoredTags.add("altGlyphDef");
        ignoredTags.add("altGlyphItem");
        ignoredTags.add("color-profile");
        ignoredTags.add("desc");
        ignoredTags.add("feBlend");
        ignoredTags.add("feColorMatrix");
        ignoredTags.add("feComponentTransfer");
        ignoredTags.add("feComposite");
        ignoredTags.add("feConvolveMatrix");
        ignoredTags.add("feDiffuseLighting");
        ignoredTags.add("feDisplacementMap");
        ignoredTags.add("feDistantLight");
        ignoredTags.add("feFlood");
        ignoredTags.add("feFuncA");
        ignoredTags.add("feFuncB");
        ignoredTags.add("feFuncG");
        ignoredTags.add("feFuncR");
        ignoredTags.add("feGaussianBlur");
        ignoredTags.add("feImage");
        ignoredTags.add("feMerge");
        ignoredTags.add("feMergeNode");
        ignoredTags.add("feMorphology");
        ignoredTags.add("feOffset");
        ignoredTags.add("fePointLight");
        ignoredTags.add("feSpecularLighting");
        ignoredTags.add("feSpotLight");
        ignoredTags.add("feTile");
        ignoredTags.add("feTurbulence");
        ignoredTags.add("filter");
        ignoredTags.add("font");
        ignoredTags.add("font-face");
        ignoredTags.add("font-face-format");
        ignoredTags.add("font-face-name");
        ignoredTags.add("font-face-src");
        ignoredTags.add("font-face-uri");
        ignoredTags.add("foreignObject");
        ignoredTags.add("glyph");
        ignoredTags.add("glyphRef");
        ignoredTags.add("hkern");
        ignoredTags.add("mask");
        ignoredTags.add("metadata");
        ignoredTags.add("missing-glyph");
        ignoredTags.add("radialGradient");
        ignoredTags.add("style");
        ignoredTags.add("title");
        ignored = Collections.unmodifiableCollection(ignoredTags);
    }

    @FunctionalInterface
    public static interface ISvgNodeRendererCreator {
        public ISvgNodeRenderer create();
    }
}

