/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.css.impl;

import com.itextpdf.commons.utils.StringNormalizer;
import com.itextpdf.io.util.DecimalFormatUtil;
import com.itextpdf.io.util.ResourceUtil;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.CssFontFaceRule;
import com.itextpdf.styledxmlparser.css.CssRuleSet;
import com.itextpdf.styledxmlparser.css.CssStatement;
import com.itextpdf.styledxmlparser.css.CssStyleSheet;
import com.itextpdf.styledxmlparser.css.ICssResolver;
import com.itextpdf.styledxmlparser.css.media.CssMediaRule;
import com.itextpdf.styledxmlparser.css.media.MediaDeviceDescription;
import com.itextpdf.styledxmlparser.css.parse.CssRuleSetParser;
import com.itextpdf.styledxmlparser.css.parse.CssStyleSheetParser;
import com.itextpdf.styledxmlparser.css.resolve.AbstractCssContext;
import com.itextpdf.styledxmlparser.css.resolve.CssDefaults;
import com.itextpdf.styledxmlparser.css.resolve.CssInheritance;
import com.itextpdf.styledxmlparser.css.resolve.IStyleInheritance;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.node.IAttribute;
import com.itextpdf.styledxmlparser.node.IAttributesContainer;
import com.itextpdf.styledxmlparser.node.IDataNode;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.styledxmlparser.node.IStylesContainer;
import com.itextpdf.styledxmlparser.node.ITextNode;
import com.itextpdf.styledxmlparser.node.IXmlDeclarationNode;
import com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import com.itextpdf.styledxmlparser.util.CssVariableUtil;
import com.itextpdf.styledxmlparser.util.FontFamilySplitterUtil;
import com.itextpdf.styledxmlparser.util.StyleUtil;
import com.itextpdf.svg.css.SvgCssContext;
import com.itextpdf.svg.css.impl.SvgAttributeInheritance;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.processors.impl.SvgProcessorContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SvgStyleResolver
implements ICssResolver {
    public static final Set<IStyleInheritance> INHERITANCE_RULES = Collections.unmodifiableSet(new HashSet<IStyleInheritance>(Arrays.asList(new CssInheritance(), new SvgAttributeInheritance())));
    public static final float DEFAULT_FONT_SIZE = CssDimensionParsingUtils.parseAbsoluteFontSize(CssDefaults.getDefaultValue("font-size"));
    private static final String[] ELEMENTS_INHERITING_PARENT_STYLES = new String[]{"marker", "linearGradient", StringNormalizer.toLowerCase("linearGradient"), "pattern"};
    private static final Logger LOGGER = LoggerFactory.getLogger(SvgStyleResolver.class);
    private CssStyleSheet css;
    private static final String DEFAULT_CSS_PATH = "com/itextpdf/svg/default.css";
    private boolean isFirstSvgElement = true;
    private MediaDeviceDescription deviceDescription;
    private final List<CssFontFaceRule> fonts = new ArrayList<CssFontFaceRule>();
    private final ResourceResolver resourceResolver;

    public SvgStyleResolver(InputStream defaultCssStream, SvgProcessorContext context) throws IOException {
        this.css = CssStyleSheetParser.parse(defaultCssStream);
        this.resourceResolver = context.getResourceResolver();
        this.css.appendCssStyleSheet(context.getCssStyleSheet());
    }

    public SvgStyleResolver(SvgProcessorContext context) {
        try (InputStream defaultCss = ResourceUtil.getResourceStream(DEFAULT_CSS_PATH);){
            this.css = CssStyleSheetParser.parse(defaultCss);
        }
        catch (IOException e) {
            LOGGER.warn("Error loading the default CSS. Initializing an empty style sheet.", e);
            this.css = new CssStyleSheet();
        }
        this.resourceResolver = context.getResourceResolver();
        this.css.appendCssStyleSheet(context.getCssStyleSheet());
    }

    public SvgStyleResolver(INode rootNode, SvgProcessorContext context) {
        this.deviceDescription = context.getDeviceDescription();
        this.resourceResolver = context.getResourceResolver();
        this.css = new CssStyleSheet();
        this.css.appendCssStyleSheet(context.getCssStyleSheet());
        this.collectCssDeclarations(rootNode, this.resourceResolver);
        this.collectFonts();
    }

    public static void resolveFontSizeStyle(Map<String, String> styles, SvgCssContext cssContext, String parentFontSizeStr) {
        String resolvedFontSize;
        String elementFontSize = styles.get("font-size");
        if (CssTypesValidationUtils.isNegativeValue(elementFontSize)) {
            elementFontSize = parentFontSizeStr;
        }
        if (CssTypesValidationUtils.isRelativeValue(elementFontSize) || "larger".equals(elementFontSize) || "smaller".equals(elementFontSize)) {
            float baseFontSize = CssTypesValidationUtils.isRemValue(elementFontSize) ? (cssContext == null ? DEFAULT_FONT_SIZE : cssContext.getRootFontSize()) : (parentFontSizeStr == null ? DEFAULT_FONT_SIZE : CssDimensionParsingUtils.parseAbsoluteLength(parentFontSizeStr));
            float absoluteFontSize = CssDimensionParsingUtils.parseRelativeFontSize(elementFontSize, baseFontSize);
            resolvedFontSize = DecimalFormatUtil.formatNumber(absoluteFontSize, "0.####");
        } else {
            resolvedFontSize = elementFontSize == null ? DecimalFormatUtil.formatNumber(DEFAULT_FONT_SIZE, "0.####") : DecimalFormatUtil.formatNumber(CssDimensionParsingUtils.parseAbsoluteFontSize(elementFontSize), "0.####");
        }
        styles.put("font-size", resolvedFontSize + "pt");
    }

    public static boolean isElementNested(IElementNode element, String parentElementNameForSearch) {
        if (!(element.parentNode() instanceof IElementNode)) {
            return false;
        }
        IElementNode parentElement = (IElementNode)element.parentNode();
        if (parentElement == null) {
            return false;
        }
        if (parentElement.name() != null && parentElement.name().equals(parentElementNameForSearch)) {
            return true;
        }
        return SvgStyleResolver.isElementNested(parentElement, parentElementNameForSearch);
    }

    @Override
    public Map<String, String> resolveStyles(INode element, AbstractCssContext context) {
        if (context instanceof SvgCssContext) {
            return this.resolveStyles(element, (SvgCssContext)context);
        }
        throw new SvgProcessingException("Custom AbstractCssContext implementations are not supported yet");
    }

    public Map<String, String> resolveNativeStyles(INode node, AbstractCssContext cssContext) {
        HashMap<String, String> styles = new HashMap<String, String>();
        IAttribute styleAttr = null;
        if (node instanceof IElementNode) {
            IElementNode eNode = (IElementNode)node;
            for (IAttribute attr : eNode.getAttributes()) {
                if ("style".equals(attr.getKey())) {
                    styleAttr = attr;
                    continue;
                }
                this.processAttribute(attr, styles);
            }
        }
        List<CssDeclaration> styleSheetDeclarations = this.css.getCssDeclarations(node, MediaDeviceDescription.createDefault());
        for (CssDeclaration ssd : styleSheetDeclarations) {
            styles.put(ssd.getProperty(), ssd.getExpression());
        }
        if (styleAttr != null) {
            this.processAttribute(styleAttr, styles);
        }
        return styles;
    }

    private static boolean onlyNativeStylesShouldBeResolved(IElementNode element) {
        for (String elementInheritingParentStyles : ELEMENTS_INHERITING_PARENT_STYLES) {
            if (!elementInheritingParentStyles.equals(element.name()) && !SvgStyleResolver.isElementNested(element, elementInheritingParentStyles)) continue;
            return false;
        }
        return SvgStyleResolver.isElementNested(element, "defs");
    }

    private static void putMissingVariables(Map<String, String> styles, Map<String, String> parentStyles) {
        if (parentStyles == null) {
            return;
        }
        for (Map.Entry<String, String> entry : parentStyles.entrySet()) {
            if (!CssVariableUtil.isCssVariable(entry.getKey()) || styles.get(entry.getKey()) != null) continue;
            styles.put(entry.getKey(), entry.getValue());
        }
    }

    private Map<String, String> resolveStyles(INode element, SvgCssContext context) {
        boolean isSvgElement;
        IStylesContainer parentNode;
        Map<String, String> styles = this.resolveNativeStyles(element, context);
        Map<String, String> parentStyles = null;
        if (element.parentNode() instanceof IStylesContainer && (parentStyles = (parentNode = (IStylesContainer)((Object)element.parentNode())).getStyles()) == null && !(parentNode instanceof IElementNode)) {
            LOGGER.error("Element parent styles are not resolved. Styles for current element might be incorrect.");
        }
        if (element instanceof IElementNode && SvgStyleResolver.onlyNativeStylesShouldBeResolved((IElementNode)element)) {
            SvgStyleResolver.putMissingVariables(styles, parentStyles);
            CssVariableUtil.resolveCssVariables(styles);
            return styles;
        }
        String parentFontSizeStr = null;
        if (parentStyles != null) {
            parentFontSizeStr = parentStyles.get("font-size");
            for (Map.Entry<String, String> entry : parentStyles.entrySet()) {
                styles = StyleUtil.mergeParentStyleDeclaration(styles, entry.getKey(), entry.getValue(), parentFontSizeStr, INHERITANCE_RULES);
            }
        }
        SvgStyleResolver.resolveFontSizeStyle(styles, context, parentFontSizeStr);
        List<String> fontFamilies = FontFamilySplitterUtil.splitFontFamily(styles.get("font-family"));
        if (fontFamilies != null && !fontFamilies.isEmpty()) {
            styles.put("font-family", fontFamilies.get(0));
        }
        CssVariableUtil.resolveCssVariables(styles);
        boolean bl = isSvgElement = element instanceof IElementNode && "svg".equals(((IElementNode)element).name());
        if (this.isFirstSvgElement && isSvgElement) {
            this.isFirstSvgElement = false;
            String rootFontSize = styles.get("font-size");
            if (rootFontSize != null) {
                context.setRootFontSize(styles.get("font-size"));
            }
        }
        return styles;
    }

    private void processXLink(IAttribute attr, Map<String, String> attributesMap) {
        String xlinkValue = attr.getValue();
        if (!this.isStartedWithHash(xlinkValue) && !ResourceResolver.isDataSrc(xlinkValue)) {
            try {
                xlinkValue = this.resourceResolver.resolveAgainstBaseUri(attr.getValue()).toExternalForm();
            }
            catch (MalformedURLException mue) {
                LOGGER.error("Unable to resolve image path with given base URI ({0}) and image source path ({1})", mue);
            }
        }
        attributesMap.put(attr.getKey(), xlinkValue);
    }

    private boolean isStartedWithHash(String s) {
        return s != null && s.startsWith("#");
    }

    private void collectCssDeclarations(INode rootNode, ResourceResolver resourceResolver) {
        LinkedList<INode> q = new LinkedList<INode>();
        if (rootNode != null) {
            q.add(rootNode);
        }
        while (!q.isEmpty()) {
            IXmlDeclarationNode declarationNode;
            INode currentNode = (INode)q.pop();
            if (currentNode instanceof IElementNode) {
                IElementNode headChildElement = (IElementNode)currentNode;
                if ("style".equals(headChildElement.name())) {
                    for (INode node : currentNode.childNodes()) {
                        if (!(node instanceof IDataNode) && !(node instanceof ITextNode)) continue;
                        String styleData = node instanceof IDataNode ? ((IDataNode)node).getWholeData() : ((ITextNode)node).wholeText();
                        CssStyleSheet styleSheet = CssStyleSheetParser.parse(styleData, resourceResolver.getBaseUri());
                        this.css.appendCssStyleSheet(styleSheet);
                    }
                } else if (CssUtils.isStyleSheetLink(headChildElement)) {
                    this.parseStylesheet(headChildElement);
                }
            } else if (currentNode instanceof IXmlDeclarationNode && "xml-stylesheet".equals((declarationNode = (IXmlDeclarationNode)currentNode).name())) {
                this.parseStylesheet(declarationNode);
            }
            for (INode child : currentNode.childNodes()) {
                if (!(child instanceof IElementNode) && !(child instanceof IXmlDeclarationNode)) continue;
                q.add(child);
            }
        }
    }

    private void parseStylesheet(IAttributesContainer attributesNode) {
        String styleSheetUri = attributesNode.getAttribute("href");
        try (InputStream stream = this.resourceResolver.retrieveResourceAsInputStream(styleSheetUri);){
            if (stream != null) {
                CssStyleSheet styleSheet = CssStyleSheetParser.parse(stream, this.resourceResolver.resolveAgainstBaseUri(styleSheetUri).toExternalForm());
                this.css.appendCssStyleSheet(styleSheet);
            }
        }
        catch (Exception exc) {
            LOGGER.error("Unable to process external css file", exc);
        }
    }

    public List<CssFontFaceRule> getFonts() {
        return new ArrayList<CssFontFaceRule>(this.fonts);
    }

    private void collectFonts() {
        for (CssStatement cssStatement : this.css.getStatements()) {
            this.collectFonts(cssStatement);
        }
    }

    private void collectFonts(CssStatement cssStatement) {
        if (cssStatement instanceof CssFontFaceRule) {
            this.fonts.add((CssFontFaceRule)cssStatement);
        } else if (cssStatement instanceof CssMediaRule && ((CssMediaRule)cssStatement).matchMediaDevice(this.deviceDescription)) {
            for (CssStatement cssSubStatement : ((CssMediaRule)cssStatement).getStatements()) {
                this.collectFonts(cssSubStatement);
            }
        }
    }

    private void processAttribute(IAttribute attr, Map<String, String> styles) {
        switch (attr.getKey()) {
            case "style": {
                Map<String, String> parsed = this.parseStylesFromStyleAttribute(attr.getValue());
                for (Map.Entry<String, String> style : parsed.entrySet()) {
                    styles.put(style.getKey(), style.getValue());
                }
                break;
            }
            case "xlink:href": {
                this.processXLink(attr, styles);
                break;
            }
            default: {
                styles.put(attr.getKey(), attr.getValue());
            }
        }
    }

    private Map<String, String> parseStylesFromStyleAttribute(String style) {
        List<CssRuleSet> ruleSets = Collections.singletonList(new CssRuleSet(null, CssRuleSetParser.parsePropertyDeclarations(style)));
        return CssStyleSheet.extractStylesFromRuleSets(ruleSets);
    }
}

