/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.util;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.parse.CssDeclarationVarParser;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.ShorthandResolverFactory;
import com.itextpdf.styledxmlparser.css.validate.CssDeclarationValidationMaster;
import com.itextpdf.styledxmlparser.exceptions.StyledXMLParserException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssVariableUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CssVariableUtil.class);
    private static final int MAX_CSS_VAR_COUNT = 30;

    private CssVariableUtil() {
    }

    public static void resolveCssVariables(Map<String, String> styles) {
        ArrayList<CssDeclaration> varExpressions = new ArrayList<CssDeclaration>();
        for (Map.Entry<String, String> entry : styles.entrySet()) {
            if (!CssVariableUtil.containsVarExpression(entry.getValue()) || CssVariableUtil.isCssVariable(entry.getKey())) continue;
            CssDeclaration result = new CssDeclaration(entry.getKey(), null);
            try {
                result = CssVariableUtil.resolveSingleVar(entry.getKey(), entry.getValue(), styles);
            }
            catch (StyledXMLParserException exception) {
                LOGGER.warn(MessageFormatUtil.format(exception.getMessage(), new CssDeclaration(entry.getKey(), entry.getValue())));
            }
            varExpressions.add(result);
        }
        for (CssDeclaration expression : varExpressions) {
            styles.remove(expression.getProperty());
            if (expression.getExpression() == null) continue;
            List<CssDeclaration> resolvedShorthandProperties = CssVariableUtil.expandShorthand(expression);
            for (CssDeclaration resolved : resolvedShorthandProperties) {
                styles.put(resolved.getProperty(), resolved.getExpression());
            }
        }
    }

    public static boolean containsVarExpression(String expression) {
        return expression != null && expression.contains("var(");
    }

    public static boolean isCssVariable(String property) {
        return property != null && property.startsWith("--");
    }

    private static List<CssDeclaration> expandShorthand(CssDeclaration declaration) {
        ArrayList<CssDeclaration> result = new ArrayList<CssDeclaration>();
        IShorthandResolver shorthandResolver = ShorthandResolverFactory.getShorthandResolver(declaration.getProperty());
        if (shorthandResolver == null) {
            result.add(declaration);
            return result;
        }
        List<CssDeclaration> resolvedShorthandProps = shorthandResolver.resolveShorthand(declaration.getExpression());
        for (CssDeclaration resolved : resolvedShorthandProps) {
            result.addAll(CssVariableUtil.expandShorthand(resolved));
        }
        return result;
    }

    private static CssDeclaration resolveSingleVar(String key, String expression, Map<String, String> styles) {
        if (!CssVariableUtil.containsVarExpression(expression)) {
            return new CssDeclaration(key, expression);
        }
        String result = CssVariableUtil.resolveVarRecursively(expression, styles, 0);
        CssDeclaration declaration = new CssDeclaration(key, result);
        if (CssDeclarationValidationMaster.checkDeclaration(declaration)) {
            return declaration;
        }
        throw new StyledXMLParserException("Invalid css property declaration: {0}");
    }

    private static String resolveVarRecursively(String expression, Map<String, String> styles, int level) {
        if (level > 30) {
            throw new StyledXMLParserException("Css var expression count too high, possible cyclic backreference at declaration: {0}");
        }
        StringBuilder expandedExpressionBuilder = new StringBuilder();
        CssDeclarationVarParser tokenizer = new CssDeclarationVarParser(expression);
        CssDeclarationVarParser.VarToken currentToken = tokenizer.getFirstValidVarToken();
        if (currentToken == null) {
            throw new StyledXMLParserException("Css var expression can't be resolved at declaration: {0}");
        }
        String resolvedVar = CssVariableUtil.resolveVarExpression(currentToken.getValue(), styles);
        expandedExpressionBuilder.append(expression, 0, currentToken.getStart()).append(resolvedVar).append(expression, currentToken.getEnd(), expression.length());
        String expandedExpression = expandedExpressionBuilder.toString();
        if (CssVariableUtil.containsVarExpression(expandedExpression)) {
            expandedExpression = CssVariableUtil.resolveVarRecursively(expandedExpression, styles, ++level);
        }
        return expandedExpression;
    }

    private static String resolveVarExpression(String varExpression, Map<String, String> styles) {
        int separatorIndex;
        int variableEndIndex;
        int variableStartIndex = varExpression.indexOf("--");
        String name = varExpression.substring(variableStartIndex, variableEndIndex = (separatorIndex = varExpression.indexOf(44)) == -1 ? varExpression.indexOf(41) : separatorIndex).trim();
        String value = styles.get(name);
        if (value != null) {
            return value;
        }
        if (separatorIndex != -1) {
            return varExpression.substring(separatorIndex + 1, varExpression.lastIndexOf(41));
        }
        return "";
    }
}

