/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.css.validate.CssDeclarationValidationMaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundPositionShorthandResolver
implements IShorthandResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackgroundPositionShorthandResolver.class);
    private static final int POSITION_VALUES_MAX_COUNT = 2;

    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        if (CssTypesValidationUtils.isInitialOrInheritOrUnset(shorthandExpression)) {
            return Arrays.asList(new CssDeclaration("background-position-x", shorthandExpression), new CssDeclaration("background-position-y", shorthandExpression));
        }
        if (shorthandExpression.trim().isEmpty()) {
            LOGGER.warn(MessageFormatUtil.format("{0} shorthand property cannot be empty.", "background-position"));
            return new ArrayList<CssDeclaration>();
        }
        List<List<String>> propsList = CssUtils.extractShorthandProperties(shorthandExpression);
        HashMap<String, String> resolvedProps = new HashMap<String, String>();
        HashMap<String, String> values = new HashMap<String, String>();
        for (List<String> props : propsList) {
            if (props.isEmpty()) {
                LOGGER.warn(MessageFormatUtil.format("{0} shorthand property cannot be empty.", "background-position"));
                return new ArrayList<CssDeclaration>();
            }
            if (!BackgroundPositionShorthandResolver.parsePositionShorthand(props, values)) {
                LOGGER.warn(MessageFormatUtil.format("Invalid css property declaration: {0}", shorthandExpression));
                return new ArrayList<CssDeclaration>();
            }
            BackgroundPositionShorthandResolver.updateValue(resolvedProps, values, "background-position-x");
            BackgroundPositionShorthandResolver.updateValue(resolvedProps, values, "background-position-y");
            values.clear();
        }
        if (!BackgroundPositionShorthandResolver.checkProperty(resolvedProps, "background-position-x") || !BackgroundPositionShorthandResolver.checkProperty(resolvedProps, "background-position-y")) {
            return new ArrayList<CssDeclaration>();
        }
        return Arrays.asList(new CssDeclaration("background-position-x", (String)resolvedProps.get("background-position-x")), new CssDeclaration("background-position-y", (String)resolvedProps.get("background-position-y")));
    }

    private static boolean checkProperty(Map<String, String> resolvedProps, String key) {
        if (!CssDeclarationValidationMaster.checkDeclaration(new CssDeclaration(key, resolvedProps.get(key)))) {
            LOGGER.warn(MessageFormatUtil.format("Invalid css property declaration: {0}", resolvedProps.get(key)));
            return false;
        }
        return true;
    }

    private static void updateValue(Map<String, String> resolvedProps, Map<String, String> values, String key) {
        if (values.get(key) == null) {
            if (resolvedProps.get(key) == null) {
                resolvedProps.put(key, "center");
            } else {
                resolvedProps.put(key, resolvedProps.get(key) + "," + "center");
            }
        } else if (resolvedProps.get(key) == null) {
            resolvedProps.put(key, values.get(key));
        } else {
            resolvedProps.put(key, resolvedProps.get(key) + "," + values.get(key));
        }
    }

    private static boolean parsePositionShorthand(List<String> valuesToParse, Map<String, String> parsedValues) {
        for (String positionValue : valuesToParse) {
            if (BackgroundPositionShorthandResolver.parseNonNumericValue(positionValue, parsedValues)) continue;
            return false;
        }
        for (int i = 0; i < valuesToParse.size(); ++i) {
            if (BackgroundPositionShorthandResolver.typeOfValue(valuesToParse.get(i)) != BackgroundPositionType.NUMERIC || BackgroundPositionShorthandResolver.parseNumericValue(i, valuesToParse, parsedValues)) continue;
            return false;
        }
        return true;
    }

    private static boolean parseNumericValue(int i, List<String> positionValues, Map<String, String> values) {
        if (values.get("background-position-x") == null || values.get("background-position-y") == null) {
            return BackgroundPositionShorthandResolver.parseShortNumericValue(i, positionValues, values, positionValues.get(i));
        }
        if (i == 0) {
            return false;
        }
        return BackgroundPositionShorthandResolver.parseLargeNumericValue(positionValues.get(i - 1), values, positionValues.get(i));
    }

    private static boolean parseShortNumericValue(int i, List<String> positionValues, Map<String, String> values, String value) {
        if (positionValues.size() > 2) {
            return false;
        }
        if (values.get("background-position-x") == null) {
            if (i != 0) {
                return false;
            }
            values.put("background-position-x", value);
            return true;
        }
        if (i == 0) {
            if (BackgroundPositionShorthandResolver.typeOfValue(positionValues.get(i + 1)) == BackgroundPositionType.CENTER) {
                values.put("background-position-x", value);
                values.put("background-position-y", "center");
                return true;
            }
            return false;
        }
        values.put("background-position-y", value);
        return true;
    }

    private static boolean parseLargeNumericValue(String prevValue, Map<String, String> values, String value) {
        if (BackgroundPositionShorthandResolver.typeOfValue(prevValue) == BackgroundPositionType.HORIZONTAL_POSITION) {
            values.put("background-position-x", values.get("background-position-x") + " " + value);
            return true;
        }
        if (BackgroundPositionShorthandResolver.typeOfValue(prevValue) == BackgroundPositionType.VERTICAL_POSITION) {
            values.put("background-position-y", values.get("background-position-y") + " " + value);
            return true;
        }
        return false;
    }

    private static boolean parseNonNumericValue(String positionValue, Map<String, String> values) {
        switch (BackgroundPositionShorthandResolver.typeOfValue(positionValue)) {
            case HORIZONTAL_POSITION: {
                return BackgroundPositionShorthandResolver.parseHorizontal(positionValue, values);
            }
            case VERTICAL_POSITION: {
                return BackgroundPositionShorthandResolver.parseVertical(positionValue, values);
            }
            case CENTER: {
                return BackgroundPositionShorthandResolver.parseCenter(positionValue, values);
            }
        }
        return true;
    }

    private static boolean parseHorizontal(String positionValue, Map<String, String> values) {
        if (values.get("background-position-x") == null) {
            values.put("background-position-x", positionValue);
            return true;
        }
        if ("center".equals(values.get("background-position-x")) && values.get("background-position-y") == null) {
            values.put("background-position-x", positionValue);
            values.put("background-position-y", "center");
            return true;
        }
        return false;
    }

    private static boolean parseVertical(String positionValue, Map<String, String> values) {
        if (values.get("background-position-y") == null) {
            values.put("background-position-y", positionValue);
            return true;
        }
        return false;
    }

    private static boolean parseCenter(String positionValue, Map<String, String> values) {
        if (values.get("background-position-x") == null) {
            values.put("background-position-x", positionValue);
            return true;
        }
        if (values.get("background-position-y") == null) {
            values.put("background-position-y", positionValue);
            return true;
        }
        return false;
    }

    private static BackgroundPositionType typeOfValue(String value) {
        if ("left".equals(value) || "right".equals(value)) {
            return BackgroundPositionType.HORIZONTAL_POSITION;
        }
        if ("top".equals(value) || "bottom".equals(value)) {
            return BackgroundPositionType.VERTICAL_POSITION;
        }
        if ("center".equals(value)) {
            return BackgroundPositionType.CENTER;
        }
        return BackgroundPositionType.NUMERIC;
    }

    private static enum BackgroundPositionType {
        NUMERIC,
        HORIZONTAL_POSITION,
        VERTICAL_POSITION,
        CENTER;

    }
}

