/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.parse.CssDeclarationValueTokenizer;
import com.itextpdf.styledxmlparser.css.resolve.AbstractCssContext;
import java.util.ArrayList;
import org.slf4j.LoggerFactory;

public class CssQuotes {
    private static final String EMPTY_QUOTE = "";
    private ArrayList<String> openQuotes;
    private ArrayList<String> closeQuotes;

    private CssQuotes(ArrayList<String> openQuotes, ArrayList<String> closeQuotes) {
        this.openQuotes = new ArrayList<String>(openQuotes);
        this.closeQuotes = new ArrayList<String>(closeQuotes);
    }

    public static CssQuotes createQuotes(String quotesString, boolean fallbackToDefault) {
        boolean error = false;
        ArrayList quotes = new ArrayList(2);
        quotes.add(new ArrayList());
        quotes.add(new ArrayList());
        if (quotesString != null) {
            CssDeclarationValueTokenizer.Token token;
            if (quotesString.equals("none")) {
                ((ArrayList)quotes.get(0)).add(EMPTY_QUOTE);
                ((ArrayList)quotes.get(1)).add(EMPTY_QUOTE);
                return new CssQuotes((ArrayList)quotes.get(0), (ArrayList)quotes.get(1));
            }
            CssDeclarationValueTokenizer tokenizer = new CssDeclarationValueTokenizer(quotesString);
            int i = 0;
            while ((token = tokenizer.getNextValidToken()) != null) {
                if (!token.isString()) {
                    error = true;
                    break;
                }
                ((ArrayList)quotes.get(i % 2)).add(token.getValue());
                ++i;
            }
            if (((ArrayList)quotes.get(0)).size() == ((ArrayList)quotes.get(1)).size() && !((ArrayList)quotes.get(0)).isEmpty() && !error) {
                return new CssQuotes((ArrayList)quotes.get(0), (ArrayList)quotes.get(1));
            }
            LoggerFactory.getLogger(CssQuotes.class).error(MessageFormatUtil.format("Quote property \"{0}\" is invalid. It should contain even number of <string> values.", quotesString));
        }
        return fallbackToDefault ? CssQuotes.createDefaultQuotes() : null;
    }

    public static CssQuotes createDefaultQuotes() {
        ArrayList<String> openQuotes = new ArrayList<String>();
        ArrayList<String> closeQuotes = new ArrayList<String>();
        openQuotes.add("\u00ab");
        closeQuotes.add("\u00bb");
        return new CssQuotes(openQuotes, closeQuotes);
    }

    public String resolveQuote(String value, AbstractCssContext context) {
        int depth = context.getQuotesDepth();
        if ("open-quote".equals(value)) {
            this.increaseDepth(context);
            return this.getQuote(depth, this.openQuotes);
        }
        if ("close-quote".equals(value)) {
            this.decreaseDepth(context);
            return this.getQuote(depth - 1, this.closeQuotes);
        }
        if ("no-open-quote".equals(value)) {
            this.increaseDepth(context);
            return EMPTY_QUOTE;
        }
        if ("no-close-quote".equals(value)) {
            this.decreaseDepth(context);
            return EMPTY_QUOTE;
        }
        return null;
    }

    private void increaseDepth(AbstractCssContext context) {
        context.setQuotesDepth(context.getQuotesDepth() + 1);
    }

    private void decreaseDepth(AbstractCssContext context) {
        if (context.getQuotesDepth() > 0) {
            context.setQuotesDepth(context.getQuotesDepth() - 1);
        }
    }

    private String getQuote(int depth, ArrayList<String> quotes) {
        if (depth >= quotes.size()) {
            return quotes.get(quotes.size() - 1);
        }
        if (depth < 0) {
            return EMPTY_QUOTE;
        }
        return quotes.get(depth);
    }
}

