/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.report.xml;

import com.itextpdf.signatures.cms.CMSContainer;
import com.itextpdf.signatures.validation.report.xml.AdESReportAggregator;
import com.itextpdf.signatures.validation.report.xml.POEValidationReport;
import com.itextpdf.signatures.validation.report.xml.PadesValidationReport;
import com.itextpdf.signatures.validation.report.xml.SignatureValidationReport;
import com.itextpdf.signatures.validation.report.xml.SignatureValidationStatus;
import com.itextpdf.signatures.validation.report.xml.SubValidationReport;
import com.itextpdf.signatures.validation.report.xml.ValidationObjects;
import java.util.Date;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAdESReportAggregator
implements AdESReportAggregator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAdESReportAggregator.class);
    private final ValidationObjects validationObjects = new ValidationObjects();
    private final PadesValidationReport report = new PadesValidationReport(this.validationObjects);
    private final Stack<SubValidationReport> validationReportStack = new Stack();

    @Override
    public void startSignatureValidation(byte[] signature, String name, Date signingDate) {
        try {
            SignatureValidationReport currentSignatureValidationReport = new SignatureValidationReport(this.validationObjects, new CMSContainer(signature), name, signingDate);
            this.validationReportStack.push(currentSignatureValidationReport);
            this.report.addSignatureValidationReport(currentSignatureValidationReport);
        }
        catch (Exception e) {
            LOGGER.error("Unable to parse signature container.", e);
            throw new IllegalArgumentException("Signature is not parsable", e);
        }
    }

    @Override
    public void proofOfExistenceFound(byte[] timeStampSignature, boolean document) {
        try {
            POEValidationReport currentValidationReport = new POEValidationReport(this.validationObjects, new CMSContainer(timeStampSignature), document);
            this.validationReportStack.push(currentValidationReport);
            this.validationObjects.addObject(currentValidationReport);
        }
        catch (Exception e) {
            LOGGER.error("Unable to parse timestamp signature container.", e);
            throw new IllegalArgumentException("Timestamp signature is not parsable", e);
        }
    }

    @Override
    public void reportSignatureValidationSuccess() {
        SignatureValidationStatus status = new SignatureValidationStatus();
        status.setMainIndication(SignatureValidationStatus.MainIndication.TOTAL_PASSED);
        SubValidationReport currentValidationReport = this.validationReportStack.pop();
        currentValidationReport.setSignatureValidationStatus(status);
    }

    @Override
    public void reportSignatureValidationFailure(boolean isInconclusive, String reason) {
        SignatureValidationStatus status = new SignatureValidationStatus();
        if (isInconclusive) {
            status.setMainIndication(SignatureValidationStatus.MainIndication.INDETERMINATE);
        } else {
            status.setMainIndication(SignatureValidationStatus.MainIndication.TOTAL_FAILED);
        }
        status.addMessage(reason, SignatureValidationStatus.MessageType.ERROR);
        SubValidationReport currentValidationReport = this.validationReportStack.pop();
        currentValidationReport.setSignatureValidationStatus(status);
    }

    @Override
    public PadesValidationReport getReport() {
        return this.report;
    }
}

