/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IBasicOCSPResp;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ICertificateStatus;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IRevokedStatus;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ISingleResp;
import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.IssuingCertificateRetriever;
import com.itextpdf.signatures.TimestampConstants;
import com.itextpdf.signatures.validation.SafeCalling;
import com.itextpdf.signatures.validation.SignatureValidationProperties;
import com.itextpdf.signatures.validation.ValidatorChainBuilder;
import com.itextpdf.signatures.validation.context.CertificateSource;
import com.itextpdf.signatures.validation.context.ValidationContext;
import com.itextpdf.signatures.validation.context.ValidatorContext;
import com.itextpdf.signatures.validation.report.CertificateReportItem;
import com.itextpdf.signatures.validation.report.ReportItem;
import com.itextpdf.signatures.validation.report.ValidationReport;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class OCSPValidator {
    static final String CERT_IS_EXPIRED = "Certificate is expired on {0}. Its revocation status could have been removed from the database, so the OCSP response status could be falsely valid.";
    static final String CERT_IS_REVOKED = "Certificate status is revoked.";
    static final String CERT_STATUS_IS_UNKNOWN = "Certificate status is unknown.";
    static final String INVALID_OCSP = "OCSP response is invalid.";
    static final String ISSUERS_DO_NOT_MATCH = "OCSP: Issuers don't match.";
    static final String ISSUER_MISSING = "Issuer certificate wasn't found.";
    static final String FRESHNESS_CHECK = "OCSP response is not fresh enough: this update: {0}, validation date: {1}, freshness: {2}.";
    static final String OCSP_COULD_NOT_BE_VERIFIED = "OCSP response could not be verified: it does not contain responder in the certificate chain and response is not signed by issuer certificate or any from the trusted store.";
    static final String OCSP_RESPONDER_NOT_RETRIEVED = "OCSP response could not be verified: \" +\n            \"Unexpected exception occurred retrieving responder.";
    static final String OCSP_RESPONDER_NOT_VERIFIED = "OCSP response could not be verified: \" +\n            \" Unexpected exception occurred while validating responder certificate.";
    static final String OCSP_RESPONDER_DID_NOT_SIGN = "OCSP response could not be verified against this responder.";
    static final String OCSP_RESPONDER_TRUST_NOT_RETRIEVED = "OCSP response could not be verified: \" +\n            \"responder trust state could not be retrieved.";
    static final String OCSP_RESPONDER_TRUSTED = "Responder certificate is a trusted certificate.";
    static final String OCSP_RESPONDER_IS_CA = "Responder certificate is the CA certificate.";
    static final String OCSP_IS_NO_LONGER_VALID = "OCSP is no longer valid: {0} after {1}";
    static final String SERIAL_NUMBERS_DO_NOT_MATCH = "OCSP: Serial numbers don't match.";
    static final String UNABLE_TO_CHECK_IF_ISSUERS_MATCH = "OCSP response could not be verified: Unexpected exception occurred checking if issuers match.";
    static final String UNABLE_TO_RETRIEVE_ISSUER = "OCSP response could not be verified: Unexpected exception occurred while retrieving issuer";
    static final String OCSP_CHECK = "OCSP response check.";
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private final IssuingCertificateRetriever certificateRetriever;
    private final SignatureValidationProperties properties;
    private final ValidatorChainBuilder builder;

    protected OCSPValidator(ValidatorChainBuilder builder) {
        this.certificateRetriever = builder.getCertificateRetriever();
        this.properties = builder.getProperties();
        this.builder = builder;
    }

    public void validate(ValidationReport report, ValidationContext context, X509Certificate certificate, ISingleResp singleResp, IBasicOCSPResp ocspResp, Date validationDate, Date responseGenerationDate) {
        List<X509Certificate> issuerCerts;
        ValidationContext localContext = context.setValidatorContext(ValidatorContext.OCSP_VALIDATOR);
        if (CertificateUtil.isSelfSigned(certificate)) {
            report.addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, "Certificate is self-signed. Revocation data check will be skipped.", ReportItem.ReportItemStatus.INFO));
            return;
        }
        if (!certificate.getSerialNumber().equals(singleResp.getCertID().getSerialNumber())) {
            report.addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, SERIAL_NUMBERS_DO_NOT_MATCH, ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        try {
            issuerCerts = this.certificateRetriever.retrieveIssuerCertificate(certificate);
        }
        catch (RuntimeException e) {
            report.addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, UNABLE_TO_RETRIEVE_ISSUER, e, ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        if (issuerCerts.isEmpty()) {
            report.addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, MessageFormatUtil.format(ISSUER_MISSING, certificate.getSubjectX500Principal()), ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        ValidationReport[] candidateReports = new ValidationReport[issuerCerts.size()];
        for (int i = 0; i < issuerCerts.size(); ++i) {
            Date startExpirationDate;
            block18: {
                candidateReports[i] = new ValidationReport();
                try {
                    if (!CertificateUtil.checkIfIssuersMatch(singleResp.getCertID(), issuerCerts.get(i))) {
                        candidateReports[i].addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, ISSUERS_DO_NOT_MATCH, ReportItem.ReportItemStatus.INDETERMINATE));
                    }
                    break block18;
                }
                catch (Exception e) {
                    candidateReports[i].addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, UNABLE_TO_CHECK_IF_ISSUERS_MATCH, e, ReportItem.ReportItemStatus.INDETERMINATE));
                }
                continue;
            }
            Duration freshness = this.properties.getFreshness(localContext);
            if (DateTimeUtil.addMillisToDate(singleResp.getThisUpdate(), freshness.toMillis()).before(validationDate)) {
                candidateReports[i].addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, MessageFormatUtil.format(FRESHNESS_CHECK, singleResp.getThisUpdate(), validationDate, freshness), ReportItem.ReportItemStatus.INDETERMINATE));
                continue;
            }
            if (singleResp.getNextUpdate() != TimestampConstants.UNDEFINED_TIMESTAMP_DATE && validationDate.after(singleResp.getNextUpdate())) {
                candidateReports[i].addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, MessageFormatUtil.format(OCSP_IS_NO_LONGER_VALID, validationDate, singleResp.getNextUpdate()), ReportItem.ReportItemStatus.INDETERMINATE));
                continue;
            }
            ICertificateStatus status = singleResp.getCertStatus();
            IRevokedStatus revokedStatus = BOUNCY_CASTLE_FACTORY.createRevokedStatus(status);
            boolean isStatusGood = BOUNCY_CASTLE_FACTORY.createCertificateStatus().getGood().equals(status);
            if (isStatusGood && certificate.getNotAfter().before(ocspResp.getProducedAt()) && (TimestampConstants.UNDEFINED_TIMESTAMP_DATE == (startExpirationDate = this.getArchiveCutoffExtension(ocspResp)) || certificate.getNotAfter().before(startExpirationDate))) {
                candidateReports[i].addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, MessageFormatUtil.format(CERT_IS_EXPIRED, certificate.getNotAfter()), ReportItem.ReportItemStatus.INDETERMINATE));
                continue;
            }
            if (isStatusGood || revokedStatus != null && validationDate.before(revokedStatus.getRevocationTime())) {
                this.verifyOcspResponder(candidateReports[i], localContext, ocspResp, issuerCerts.get(i), responseGenerationDate);
                if (!isStatusGood) {
                    candidateReports[i].addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, MessageFormatUtil.format("The certificate was valid on the verification date, but has been revoked since {0}.", revokedStatus.getRevocationTime()), ReportItem.ReportItemStatus.INFO));
                }
            } else if (revokedStatus != null) {
                candidateReports[i].addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, CERT_IS_REVOKED, ReportItem.ReportItemStatus.INVALID));
            } else {
                candidateReports[i].addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, CERT_STATUS_IS_UNKNOWN, ReportItem.ReportItemStatus.INDETERMINATE));
            }
            if (candidateReports[i].getValidationResult() != ValidationReport.ValidationResult.VALID) continue;
            report.merge(candidateReports[i]);
            return;
        }
        for (ValidationReport candidateReport : candidateReports) {
            report.merge(candidateReport);
        }
    }

    private void verifyOcspResponder(ValidationReport report, ValidationContext context, IBasicOCSPResp ocspResp, X509Certificate issuerCert, Date responseGenerationDate) {
        ValidationContext localContext = context.setCertificateSource(CertificateSource.OCSP_ISSUER);
        if (CertificateUtil.isSignatureValid(ocspResp, issuerCert)) {
            report.addReportItem(new CertificateReportItem(issuerCert, OCSP_CHECK, OCSP_RESPONDER_IS_CA, ReportItem.ReportItemStatus.INFO));
            return;
        }
        Set<Certificate> candidates = SafeCalling.onRuntimeExceptionLog(() -> this.certificateRetriever.retrieveOCSPResponderByNameCertificate(ocspResp), Collections.emptySet(), report, e -> new CertificateReportItem(issuerCert, OCSP_CHECK, OCSP_RESPONDER_NOT_RETRIEVED, (Exception)e, ReportItem.ReportItemStatus.INDETERMINATE));
        if (candidates.isEmpty()) {
            report.addReportItem(new CertificateReportItem(issuerCert, OCSP_CHECK, OCSP_COULD_NOT_BE_VERIFIED, ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        ValidationReport[] candidateReports = new ValidationReport[candidates.size()];
        int reportIndex = 0;
        for (Certificate cert : candidates) {
            X509Certificate responderCert = (X509Certificate)cert;
            ValidationReport candidateReport = new ValidationReport();
            candidateReports[reportIndex++] = candidateReport;
            if (!CertificateUtil.isSignatureValid(ocspResp, responderCert)) {
                candidateReport.addReportItem(new CertificateReportItem(responderCert, OCSP_CHECK, OCSP_RESPONDER_DID_NOT_SIGN, ReportItem.ReportItemStatus.INDETERMINATE));
                continue;
            }
            try {
                if (this.certificateRetriever.getTrustedCertificatesStore().isCertificateTrustedForOcsp(responderCert) || this.certificateRetriever.getTrustedCertificatesStore().isCertificateGenerallyTrusted(responderCert)) {
                    candidateReport.addReportItem(new CertificateReportItem(responderCert, OCSP_CHECK, OCSP_RESPONDER_TRUSTED, ReportItem.ReportItemStatus.INFO));
                    report.merge(candidateReport);
                    return;
                }
            }
            catch (RuntimeException e2) {
                report.addReportItem(new CertificateReportItem(responderCert, OCSP_CHECK, OCSP_RESPONDER_TRUST_NOT_RETRIEVED, e2, ReportItem.ReportItemStatus.INDETERMINATE));
                continue;
            }
            try {
                responderCert.verify(issuerCert.getPublicKey());
            }
            catch (Exception e3) {
                candidateReport.addReportItem(new CertificateReportItem(responderCert, OCSP_CHECK, INVALID_OCSP, e3, ReportItem.ReportItemStatus.INVALID));
                continue;
            }
            ValidationReport responderReport = new ValidationReport();
            try {
                this.builder.getCertificateChainValidator().validate(responderReport, localContext, responderCert, responseGenerationDate);
            }
            catch (RuntimeException e4) {
                candidateReport.addReportItem(new CertificateReportItem(responderCert, OCSP_CHECK, OCSP_RESPONDER_NOT_VERIFIED, e4, ReportItem.ReportItemStatus.INDETERMINATE));
                continue;
            }
            OCSPValidator.addResponderValidationReport(candidateReport, responderReport);
            if (candidateReport.getValidationResult() != ValidationReport.ValidationResult.VALID) continue;
            OCSPValidator.addResponderValidationReport(report, candidateReport);
            return;
        }
        for (ValidationReport subReport : candidateReports) {
            report.merge(subReport);
        }
    }

    private static void addResponderValidationReport(ValidationReport report, ValidationReport responderReport) {
        for (ReportItem reportItem : responderReport.getLogs()) {
            report.addReportItem(ReportItem.ReportItemStatus.INVALID == reportItem.getStatus() ? reportItem.setStatus(ReportItem.ReportItemStatus.INDETERMINATE) : reportItem);
        }
    }

    private Date getArchiveCutoffExtension(IBasicOCSPResp ocspResp) {
        IASN1Encodable archiveCutoff = ocspResp.getExtensionParsedValue(BOUNCY_CASTLE_FACTORY.createOCSPObjectIdentifiers().getIdPkixOcspArchiveCutoff());
        if (!archiveCutoff.isNull()) {
            try {
                return BOUNCY_CASTLE_FACTORY.createASN1GeneralizedTime(archiveCutoff).getDate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (Date)TimestampConstants.UNDEFINED_TIMESTAMP_DATE;
    }
}

