/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation;

import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.commons.datastructures.Tuple2;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfFormAnnotationUtil;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.io.source.RASInputStream;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.io.source.WindowRandomAccessSource;
import com.itextpdf.kernel.pdf.DocumentRevision;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfRevisionsReader;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.signatures.AccessPermissions;
import com.itextpdf.signatures.PdfSignature;
import com.itextpdf.signatures.SignatureUtil;
import com.itextpdf.signatures.validation.SignatureValidationProperties;
import com.itextpdf.signatures.validation.ValidationMetaInfo;
import com.itextpdf.signatures.validation.ValidatorChainBuilder;
import com.itextpdf.signatures.validation.context.ValidationContext;
import com.itextpdf.signatures.validation.context.ValidatorContext;
import com.itextpdf.signatures.validation.report.ReportItem;
import com.itextpdf.signatures.validation.report.ValidationReport;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DocumentRevisionsValidator {
    static final String DOC_MDP_CHECK = "DocMDP check.";
    static final String FIELD_MDP_CHECK = "FieldMDP check.";
    static final String ACCESS_PERMISSIONS_ADDED = "Access permissions level specified for \"{0}\" approval signature is higher than previous one specified. These access permissions will be ignored.";
    static final String ACROFORM_REMOVED = "AcroForm dictionary was removed from catalog.";
    static final String ANNOTATIONS_MODIFIED = "Field annotations were removed, added or unexpectedly modified.";
    static final String BASE_VERSION_DECREASED = "Base version number in developer extension \"{0}\" dictionary was decreased.";
    static final String BASE_VERSION_EXTENSION_NOT_PARSABLE = "Base version number in developer extension \"{0}\" dictionary is not parsable.";
    static final String DEVELOPER_EXTENSION_REMOVED = "Developer extension \"{0}\" dictionary was removed or unexpectedly modified.";
    static final String DIRECT_OBJECT = "{0} must be an indirect reference.";
    static final String DOCUMENT_WITHOUT_SIGNATURES = "Document doesn't contain any signatures.";
    static final String DSS_REMOVED = "DSS dictionary was removed from catalog.";
    static final String EXTENSIONS_REMOVED = "Extensions dictionary was removed from the catalog.";
    static final String EXTENSIONS_TYPE = "Developer extensions must be a dictionary.";
    static final String EXTENSION_LEVEL_DECREASED = "Extension level number in developer extension \"{0}\" dictionary was decreased.";
    static final String FIELD_NOT_DICTIONARY = "Form field \"{0}\" or one of its widgets is not a dictionary. It will not be validated.";
    static final String FIELD_REMOVED = "Form field {0} was removed or unexpectedly modified.";
    static final String LOCKED_FIELD_KIDS_ADDED = "Kids were added to locked form field \"{0}\".";
    static final String LOCKED_FIELD_KIDS_REMOVED = "Kids were removed from locked form field \"{0}\" .";
    static final String LOCKED_FIELD_MODIFIED = "Locked form field \"{0}\" or one of its widgets was modified.";
    static final String LOCKED_FIELD_REMOVED = "Locked form field \"{0}\" was removed from the document.";
    static final String NOT_ALLOWED_ACROFORM_CHANGES = "PDF document AcroForm contains changes other than document timestamp (docMDP level >= 1), form fill-in and digital signatures (docMDP level >= 2), adding or editing annotations (docMDP level 3), which are not allowed.";
    static final String NOT_ALLOWED_CATALOG_CHANGES = "PDF document catalog contains changes other than DSS dictionary and DTS addition (docMDP level >= 1), form fill-in and digital signatures (docMDP level >= 2), adding or editing annotations (docMDP level 3).";
    static final String NOT_ALLOWED_CERTIFICATION_SIGNATURE = "Certification signature is applied after the approval signature which is not allowed.";
    static final String OBJECT_REMOVED = "Object \"{0}\", which is not allowed to be removed, was removed from the document through XREF table.";
    static final String PAGES_MODIFIED = "Pages structure was unexpectedly modified.";
    static final String PAGE_ANNOTATIONS_MODIFIED = "Page annotations were unexpectedly modified.";
    static final String PAGE_MODIFIED = "Page was unexpectedly modified.";
    static final String TABS_MODIFIED = "Tabs entry in a page dictionary was unexpectedly modified.";
    static final String PERMISSIONS_REMOVED = "Permissions dictionary was removed from the catalog.";
    static final String PERMISSIONS_TYPE = "Permissions must be a dictionary.";
    static final String PERMISSION_REMOVED = "Permission \"{0}\" dictionary was removed or unexpectedly modified.";
    static final String REFERENCE_REMOVED = "Signature reference dictionary was removed or unexpectedly modified.";
    static final String REVISIONS_READING_EXCEPTION = "IOException occurred during document revisions reading.";
    static final String REVISIONS_RETRIEVAL_FAILED = "Wasn't possible to retrieve document revisions.";
    static final String REVISIONS_RETRIEVAL_FAILED_UNEXPECTEDLY = "Unexpected exception while retrieving document revisions.";
    static final String SIGNATURE_MODIFIED = "Signature {0} was unexpectedly modified.";
    static final String SIGNATURE_REVISION_NOT_FOUND = "Not possible to identify document revision corresponding to the first signature in the document.";
    static final String STRUCT_TREE_CONTENT_MODIFIED = "Struct tree content element is unexpectedly modified.";
    static final String STRUCT_TREE_ELEMENT_MODIFIED = "Struct tree element is unexpectedly modified.";
    static final String STRUCT_TREE_ROOT_ADDED = "StructTreeRoot which contains not allowed entries was added to the catalog.";
    static final String STRUCT_TREE_ROOT_MODIFIED = "StructTreeRoot was unexpectedly modified.";
    static final String STRUCT_TREE_ROOT_NOT_DICT = "StructTreeRoot, which is not a dictionary, was modified.";
    static final String STRUCT_TREE_ROOT_REMOVED = "StructTreeRoot was removed from the catalog.";
    static final String TOO_MANY_CERTIFICATION_SIGNATURES = "Document contains more than one certification signature.";
    static final String UNEXPECTED_ENTRY_IN_XREF = "New PDF document revision contains unexpected entry \"{0}\" in XREF table.";
    static final String UNEXPECTED_FORM_FIELD = "New PDF document revision contains unexpected form field \"{0}\".";
    static final String UNKNOWN_ACCESS_PERMISSIONS = "Access permissions level number specified for \"{0}\" signature is undefined. Default level 2 will be used instead.";
    static final String UNRECOGNIZED_ACTION = "Signature field lock dictionary contains unrecognized \"Action\" value \"{0}\". \"All\" will be used instead.";
    private static final float EPS = 1.0E-5f;
    private static final PdfDictionary DUMMY_STRUCT_TREE_ELEMENT = new PdfDictionary(Collections.singletonMap(PdfName.K, new PdfArray()));
    private final Set<String> lockedFields = new HashSet<String>();
    private final SignatureValidationProperties properties;
    private IMetaInfo metaInfo = new ValidationMetaInfo();
    private AccessPermissions accessPermissions = AccessPermissions.ANNOTATION_MODIFICATION;
    private AccessPermissions requestedAccessPermissions = AccessPermissions.UNSPECIFIED;
    private ReportItem.ReportItemStatus unexpectedXrefChangesStatus = ReportItem.ReportItemStatus.INFO;
    private Set<PdfObject> checkedAnnots;
    private Set<PdfDictionary> newlyAddedFields;
    private Set<PdfDictionary> removedTaggedObjects;
    private Set<PdfDictionary> addedTaggedObjects;
    private Tuple2<Set<PdfIndirectReference>, Set<PdfIndirectReference>> usuallyModifiedObjects;

    protected DocumentRevisionsValidator(ValidatorChainBuilder chainBuilder) {
        this.properties = chainBuilder.getProperties();
    }

    public DocumentRevisionsValidator setEventCountingMetaInfo(IMetaInfo metaInfo) {
        this.metaInfo = metaInfo;
        return this;
    }

    public DocumentRevisionsValidator setAccessPermissions(AccessPermissions accessPermissions) {
        this.requestedAccessPermissions = accessPermissions;
        return this;
    }

    public DocumentRevisionsValidator setUnexpectedXrefChangesStatus(ReportItem.ReportItemStatus status) {
        this.unexpectedXrefChangesStatus = status;
        return this;
    }

    public ValidationReport validateAllDocumentRevisions(ValidationContext context, PdfDocument document) {
        return this.validateAllDocumentRevisions(context, document, null);
    }

    ValidationReport validateAllDocumentRevisions(ValidationContext context, PdfDocument document, String signatureName) {
        List<DocumentRevision> documentRevisions;
        this.resetClassFields();
        ValidationContext localContext = context.setValidatorContext(ValidatorContext.DOCUMENT_REVISIONS_VALIDATOR);
        ValidationReport report = new ValidationReport();
        PdfRevisionsReader revisionsReader = new PdfRevisionsReader(document.getReader());
        revisionsReader.setEventCountingMetaInfo(this.metaInfo);
        try {
            documentRevisions = revisionsReader.getAllRevisions();
        }
        catch (IOException e) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, REVISIONS_RETRIEVAL_FAILED, ReportItem.ReportItemStatus.INDETERMINATE));
            return report;
        }
        catch (RuntimeException e) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, REVISIONS_RETRIEVAL_FAILED_UNEXPECTEDLY, e, ReportItem.ReportItemStatus.INDETERMINATE));
            return report;
        }
        this.mergeRevisionsInLinearizedDocument(document, documentRevisions);
        SignatureUtil signatureUtil = new SignatureUtil(document);
        ArrayList<String> signatures = new ArrayList<String>(signatureUtil.getSignatureNames());
        if (signatures.isEmpty()) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, DOCUMENT_WITHOUT_SIGNATURES, ReportItem.ReportItemStatus.INFO));
            return report;
        }
        boolean updateAccessPermissions = true;
        boolean documentSigned = false;
        boolean certificationSignatureFound = false;
        boolean collectRevisionsValidationReport = signatureName == null;
        String currentSignatureName = (String)signatures.get(0);
        PdfSignature currentSignature = signatureUtil.getSignature(currentSignatureName);
        for (int i = 0; i < documentRevisions.size(); ++i) {
            if (currentSignature != null && this.revisionContainsSignature(documentRevisions.get(i), currentSignatureName, document, report)) {
                if (this.isCertificationSignature(currentSignature)) {
                    if (certificationSignatureFound) {
                        report.addReportItem(new ReportItem(DOC_MDP_CHECK, TOO_MANY_CERTIFICATION_SIGNATURES, ReportItem.ReportItemStatus.INDETERMINATE));
                    } else if (documentSigned) {
                        report.addReportItem(new ReportItem(DOC_MDP_CHECK, NOT_ALLOWED_CERTIFICATION_SIGNATURE, ReportItem.ReportItemStatus.INDETERMINATE));
                    } else {
                        certificationSignatureFound = true;
                        if (updateAccessPermissions) {
                            this.updateCertificationSignatureAccessPermissions(currentSignature, report);
                        }
                    }
                }
                documentSigned = true;
                if (updateAccessPermissions) {
                    this.updateApprovalSignatureAccessPermissions(signatureUtil.getSignatureFormFieldDictionary(currentSignatureName), report);
                    this.updateApprovalSignatureFieldLock(documentRevisions.get(i), signatureUtil.getSignatureFormFieldDictionary(currentSignatureName), document, report);
                }
                if (signatureName != null && signatureName.equals(currentSignatureName)) {
                    updateAccessPermissions = false;
                    collectRevisionsValidationReport = true;
                }
                signatures.remove(0);
                if (signatures.isEmpty()) {
                    currentSignature = null;
                } else {
                    currentSignatureName = (String)signatures.get(0);
                    currentSignature = signatureUtil.getSignature(currentSignatureName);
                }
            }
            if (documentSigned && i < documentRevisions.size() - 1) {
                ValidationReport validationReport = new ValidationReport();
                this.validateRevision(documentRevisions.get(i), documentRevisions.get(i + 1), document, validationReport, localContext);
                if (collectRevisionsValidationReport) {
                    report.merge(validationReport);
                }
            }
            if (this.stopValidation(report, localContext)) break;
        }
        if (!documentSigned) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, SIGNATURE_REVISION_NOT_FOUND, ReportItem.ReportItemStatus.INVALID));
        }
        return report;
    }

    void validateRevision(DocumentRevision previousRevision, DocumentRevision currentRevision, PdfDocument originalDocument, ValidationReport validationReport, ValidationContext context) {
        this.createDocumentAndPerformOperation(previousRevision, originalDocument, validationReport, documentWithoutRevision -> this.createDocumentAndPerformOperation(currentRevision, originalDocument, validationReport, documentWithRevision -> this.validateRevision(validationReport, context, (PdfDocument)documentWithoutRevision, (PdfDocument)documentWithRevision, currentRevision)));
    }

    private void mergeRevisionsInLinearizedDocument(PdfDocument document, List<DocumentRevision> documentRevisions) {
        if (documentRevisions.size() > 1) {
            this.createDocumentAndPerformOperation(documentRevisions.get(0), document, new ValidationReport(), firstRevisionDocument -> {
                if (DocumentRevisionsValidator.isLinearizedPdf(document)) {
                    HashSet<PdfIndirectReference> mergedModifiedReferences = new HashSet<PdfIndirectReference>(((DocumentRevision)documentRevisions.get(0)).getModifiedObjects());
                    mergedModifiedReferences.addAll(((DocumentRevision)documentRevisions.get(1)).getModifiedObjects());
                    DocumentRevision mergedRevision = new DocumentRevision(((DocumentRevision)documentRevisions.get(0)).getEofOffset(), mergedModifiedReferences);
                    documentRevisions.add(0, mergedRevision);
                    documentRevisions.remove(1);
                    documentRevisions.remove(1);
                }
                return true;
            });
        }
    }

    private boolean validateRevision(ValidationReport validationReport, ValidationContext context, PdfDocument documentWithoutRevision, PdfDocument documentWithRevision, DocumentRevision currentRevision) {
        this.usuallyModifiedObjects = new Tuple2<Set<PdfIndirectReference>, Set<PdfIndirectReference>>(this.createUsuallyModifiedObjectsSet(documentWithoutRevision), this.createUsuallyModifiedObjectsSet(documentWithRevision));
        if (!this.compareCatalogs(documentWithoutRevision, documentWithRevision, validationReport, context)) {
            return false;
        }
        Set<PdfIndirectReference> currentAllowedReferences = this.createAllowedReferences(documentWithRevision);
        Set<PdfIndirectReference> previousAllowedReferences = this.createAllowedReferences(documentWithoutRevision);
        for (PdfIndirectReference indirectReference : currentRevision.getModifiedObjects()) {
            if (indirectReference.isFree()) {
                boolean referenceWasInPrevDocument;
                boolean referenceAllowedToBeRemoved = previousAllowedReferences.stream().anyMatch(reference -> reference != null && reference.getObjNumber() == indirectReference.getObjNumber()) && !currentAllowedReferences.stream().anyMatch(reference -> reference != null && reference.getObjNumber() == indirectReference.getObjNumber());
                boolean bl = referenceWasInPrevDocument = documentWithoutRevision.getPdfObject(indirectReference.getObjNumber()) != null;
                if (DocumentRevisionsValidator.isMaxGenerationObject(indirectReference) || !referenceWasInPrevDocument || referenceAllowedToBeRemoved) continue;
                validationReport.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format(OBJECT_REMOVED, indirectReference.getObjNumber()), this.unexpectedXrefChangesStatus));
                continue;
            }
            if (this.checkAllowedReferences(currentAllowedReferences, previousAllowedReferences, indirectReference, documentWithoutRevision) || this.isAllowedStreamObj(indirectReference, documentWithRevision)) continue;
            validationReport.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format(UNEXPECTED_ENTRY_IN_XREF, indirectReference.getObjNumber()), this.unexpectedXrefChangesStatus));
        }
        return validationReport.getValidationResult() == ValidationReport.ValidationResult.VALID;
    }

    AccessPermissions getAccessPermissions() {
        return this.requestedAccessPermissions == AccessPermissions.UNSPECIFIED ? this.accessPermissions : this.requestedAccessPermissions;
    }

    private static InputStream createInputStreamFromRevision(PdfDocument originalDocument, DocumentRevision revision) {
        RandomAccessFileOrArray raf = originalDocument.getReader().getSafeFile();
        WindowRandomAccessSource source = new WindowRandomAccessSource(raf.createSourceView(), 0L, revision.getEofOffset());
        return new RASInputStream(source);
    }

    private static boolean isLinearizedPdf(PdfDocument originalDocument) {
        for (int i = 0; i < originalDocument.getNumberOfPdfObjects(); ++i) {
            PdfDictionary dictionary;
            PdfObject object = originalDocument.getPdfObject(i);
            if (!(object instanceof PdfDictionary) || !(dictionary = (PdfDictionary)object).containsKey(new PdfName("Linearized"))) continue;
            return true;
        }
        return false;
    }

    private static boolean isStructTreeElement(PdfObject object) {
        if (object instanceof PdfDictionary) {
            PdfDictionary objectDictionary = (PdfDictionary)object;
            PdfName type = objectDictionary.getAsName(PdfName.Type);
            return type == null || PdfName.StructElem.equals(type);
        }
        return false;
    }

    private static PdfObject getObjectFromStructTreeContent(PdfObject structTreeContent) {
        return structTreeContent instanceof PdfDictionary ? ((PdfDictionary)structTreeContent).get(PdfName.Obj) : null;
    }

    private boolean stopValidation(ValidationReport result, ValidationContext validationContext) {
        return !this.properties.getContinueAfterFailure(validationContext) && result.getValidationResult() == ValidationReport.ValidationResult.INVALID;
    }

    private void updateApprovalSignatureAccessPermissions(PdfDictionary signatureField, ValidationReport report) {
        AccessPermissions newAccessPermissions;
        PdfDictionary fieldLock = signatureField.getAsDictionary(PdfName.Lock);
        if (fieldLock == null || fieldLock.getAsNumber(PdfName.P) == null) {
            return;
        }
        PdfNumber p = fieldLock.getAsNumber(PdfName.P);
        switch (p.intValue()) {
            case 1: {
                newAccessPermissions = AccessPermissions.NO_CHANGES_PERMITTED;
                break;
            }
            case 2: {
                newAccessPermissions = AccessPermissions.FORM_FIELDS_MODIFICATION;
                break;
            }
            case 3: {
                newAccessPermissions = AccessPermissions.ANNOTATION_MODIFICATION;
                break;
            }
            default: {
                return;
            }
        }
        if (this.accessPermissions.compareTo(newAccessPermissions) < 0) {
            PdfString fieldName = signatureField.getAsString(PdfName.T);
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format(ACCESS_PERMISSIONS_ADDED, fieldName == null ? "" : fieldName.getValue()), ReportItem.ReportItemStatus.INDETERMINATE));
        } else {
            this.accessPermissions = newAccessPermissions;
        }
    }

    private void updateApprovalSignatureFieldLock(DocumentRevision revision, PdfDictionary signatureField, PdfDocument document, ValidationReport report) {
        PdfDictionary fieldLock = signatureField.getAsDictionary(PdfName.Lock);
        if (fieldLock == null || fieldLock.getAsName(PdfName.Action) == null) {
            return;
        }
        PdfName action = fieldLock.getAsName(PdfName.Action);
        if (PdfName.Include.equals(action)) {
            PdfArray fields = fieldLock.getAsArray(PdfName.Fields);
            if (fields != null) {
                for (PdfObject fieldName : fields) {
                    if (!(fieldName instanceof PdfString)) continue;
                    this.lockedFields.add(((PdfString)fieldName).toUnicodeString());
                }
            }
        } else if (PdfName.Exclude.equals(action)) {
            PdfArray fields = fieldLock.getAsArray(PdfName.Fields);
            List<String> excludedFields = Collections.emptyList();
            if (fields != null) {
                excludedFields = fields.toList().stream().map(field -> field instanceof PdfString ? ((PdfString)field).toUnicodeString() : null).collect(Collectors.toList());
            }
            this.lockAllFormFields(revision, excludedFields, document, report);
        } else {
            if (!PdfName.All.equals(action)) {
                report.addReportItem(new ReportItem(FIELD_MDP_CHECK, MessageFormatUtil.format(UNRECOGNIZED_ACTION, action.getValue()), ReportItem.ReportItemStatus.INVALID));
            }
            this.lockAllFormFields(revision, Collections.emptyList(), document, report);
        }
    }

    private void lockAllFormFields(DocumentRevision revision, List<String> excludedFields, PdfDocument originalDocument, ValidationReport report) {
        this.createDocumentAndPerformOperation(revision, originalDocument, report, document -> {
            PdfAcroForm acroForm = PdfFormCreator.getAcroForm(document, false);
            if (acroForm != null) {
                for (String fieldName : acroForm.getAllFormFields().keySet()) {
                    if (excludedFields.contains(fieldName)) continue;
                    this.lockedFields.add(fieldName);
                }
            }
            return true;
        });
    }

    private void updateCertificationSignatureAccessPermissions(PdfSignature signature, ValidationReport report) {
        PdfArray references = ((PdfDictionary)signature.getPdfObject()).getAsArray(PdfName.Reference);
        for (PdfObject reference : references) {
            PdfDictionary referenceDict = (PdfDictionary)reference;
            PdfName transformMethod = referenceDict.getAsName(PdfName.TransformMethod);
            if (!PdfName.DocMDP.equals(transformMethod)) continue;
            PdfDictionary transformParameters = referenceDict.getAsDictionary(PdfName.TransformParams);
            if (transformParameters == null || transformParameters.getAsNumber(PdfName.P) == null) {
                this.accessPermissions = AccessPermissions.FORM_FIELDS_MODIFICATION;
                return;
            }
            PdfNumber p = transformParameters.getAsNumber(PdfName.P);
            switch (p.intValue()) {
                case 1: {
                    this.accessPermissions = AccessPermissions.NO_CHANGES_PERMITTED;
                    break;
                }
                case 2: {
                    this.accessPermissions = AccessPermissions.FORM_FIELDS_MODIFICATION;
                    break;
                }
                case 3: {
                    this.accessPermissions = AccessPermissions.ANNOTATION_MODIFICATION;
                    break;
                }
                default: {
                    report.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format(UNKNOWN_ACCESS_PERMISSIONS, signature.getName()), ReportItem.ReportItemStatus.INDETERMINATE));
                    this.accessPermissions = AccessPermissions.FORM_FIELDS_MODIFICATION;
                }
            }
            return;
        }
    }

    private boolean isCertificationSignature(PdfSignature signature) {
        if (PdfName.DocTimeStamp.equals(signature.getType()) || PdfName.ETSI_RFC3161.equals(signature.getSubFilter())) {
            return false;
        }
        PdfArray references = ((PdfDictionary)signature.getPdfObject()).getAsArray(PdfName.Reference);
        if (references != null) {
            for (PdfObject reference : references) {
                if (!(reference instanceof PdfDictionary)) continue;
                PdfDictionary referenceDict = (PdfDictionary)reference;
                PdfName transformMethod = referenceDict.getAsName(PdfName.TransformMethod);
                return PdfName.DocMDP.equals(transformMethod);
            }
        }
        return false;
    }

    private boolean revisionContainsSignature(DocumentRevision revision, String signature, PdfDocument originalDocument, ValidationReport report) {
        return this.createDocumentAndPerformOperation(revision, originalDocument, report, document -> {
            SignatureUtil signatureUtil = new SignatureUtil((PdfDocument)document);
            return signatureUtil.signatureCoversWholeDocument(signature);
        });
    }

    /*
     * Exception decompiling
     */
    private boolean createDocumentAndPerformOperation(DocumentRevision revision, PdfDocument originalDocument, ValidationReport report, Function<PdfDocument, Boolean> operation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void resetClassFields() {
        this.lockedFields.clear();
        this.accessPermissions = AccessPermissions.ANNOTATION_MODIFICATION;
    }

    private boolean compareCatalogs(PdfDocument documentWithoutRevision, PdfDocument documentWithRevision, ValidationReport report, ValidationContext context) {
        PdfDictionary previousCatalog = (PdfDictionary)documentWithoutRevision.getCatalog().getPdfObject();
        PdfDictionary currentCatalog = (PdfDictionary)documentWithRevision.getCatalog().getPdfObject();
        PdfDictionary previousCatalogCopy = this.copyCatalogEntriesToCompare(previousCatalog);
        PdfDictionary currentCatalogCopy = this.copyCatalogEntriesToCompare(currentCatalog);
        this.removedTaggedObjects = new HashSet<PdfDictionary>();
        this.addedTaggedObjects = new HashSet<PdfDictionary>();
        if (!DocumentRevisionsValidator.comparePdfObjects(previousCatalogCopy, currentCatalogCopy, this.usuallyModifiedObjects)) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, NOT_ALLOWED_CATALOG_CHANGES, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        boolean result = this.compareExtensions(previousCatalog.get(PdfName.Extensions), currentCatalog.get(PdfName.Extensions), report);
        if (this.stopValidation(report, context)) {
            return result;
        }
        boolean bl = result = result && this.comparePermissions(previousCatalog.get(PdfName.Perms), currentCatalog.get(PdfName.Perms), report);
        if (this.stopValidation(report, context)) {
            return result;
        }
        boolean bl2 = result = result && this.compareDss(previousCatalog.get(PdfName.DSS), currentCatalog.get(PdfName.DSS), report);
        if (this.stopValidation(report, context)) {
            return result;
        }
        boolean bl3 = result = result && this.compareAcroFormsWithFieldMDP(documentWithoutRevision, documentWithRevision, report);
        if (this.stopValidation(report, context)) {
            return result;
        }
        boolean bl4 = result = result && this.compareAcroForms(previousCatalog.getAsDictionary(PdfName.AcroForm), currentCatalog.getAsDictionary(PdfName.AcroForm), report);
        if (this.stopValidation(report, context)) {
            return result;
        }
        boolean bl5 = result = result && this.comparePages(previousCatalog.getAsDictionary(PdfName.Pages), currentCatalog.getAsDictionary(PdfName.Pages), report);
        if (this.stopValidation(report, context)) {
            return result;
        }
        return result && this.compareStructTreeRoot(previousCatalog.get(PdfName.StructTreeRoot), currentCatalog.get(PdfName.StructTreeRoot), report);
    }

    private boolean compareStructTreeRoot(PdfObject previousStructTreeRoot, PdfObject currentStructTreeRoot, ValidationReport report) {
        if (previousStructTreeRoot == currentStructTreeRoot) {
            return true;
        }
        if (!(previousStructTreeRoot instanceof PdfDictionary) && currentStructTreeRoot instanceof PdfDictionary) {
            this.compareStructTreeElementKids(DUMMY_STRUCT_TREE_ELEMENT, (PdfDictionary)currentStructTreeRoot, report);
            if (this.addedTaggedObjects.contains(currentStructTreeRoot)) {
                return true;
            }
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, STRUCT_TREE_ROOT_ADDED, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        if (!(currentStructTreeRoot instanceof PdfDictionary) && previousStructTreeRoot instanceof PdfDictionary) {
            this.compareStructTreeElementKids((PdfDictionary)previousStructTreeRoot, DUMMY_STRUCT_TREE_ELEMENT, report);
            if (this.removedTaggedObjects.contains(previousStructTreeRoot)) {
                return true;
            }
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, STRUCT_TREE_ROOT_REMOVED, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        if (!(previousStructTreeRoot instanceof PdfDictionary)) {
            if (DocumentRevisionsValidator.comparePdfObjects(previousStructTreeRoot, currentStructTreeRoot, this.usuallyModifiedObjects)) {
                return true;
            }
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, STRUCT_TREE_ROOT_NOT_DICT, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        PdfDictionary previousStructTreeRootDict = new PdfDictionary((PdfDictionary)previousStructTreeRoot);
        PdfDictionary currentStructTreeRootDict = new PdfDictionary((PdfDictionary)currentStructTreeRoot);
        previousStructTreeRootDict.remove(PdfName.IDTree);
        currentStructTreeRootDict.remove(PdfName.IDTree);
        previousStructTreeRootDict.remove(PdfName.ParentTree);
        currentStructTreeRootDict.remove(PdfName.ParentTree);
        previousStructTreeRootDict.remove(PdfName.ParentTreeNextKey);
        currentStructTreeRootDict.remove(PdfName.ParentTreeNextKey);
        previousStructTreeRootDict.remove(PdfName.K);
        currentStructTreeRootDict.remove(PdfName.K);
        if (!DocumentRevisionsValidator.comparePdfObjects(previousStructTreeRootDict, currentStructTreeRootDict, this.usuallyModifiedObjects)) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, STRUCT_TREE_ROOT_MODIFIED, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        if (this.compareStructTreeElementKids((PdfDictionary)previousStructTreeRoot, (PdfDictionary)currentStructTreeRoot, report)) {
            return true;
        }
        report.addReportItem(new ReportItem(DOC_MDP_CHECK, STRUCT_TREE_ROOT_MODIFIED, ReportItem.ReportItemStatus.INVALID));
        return false;
    }

    private boolean compareStructTreeElementKids(PdfDictionary previousStructElement, PdfDictionary currentStructElement, ValidationReport report) {
        PdfArray previousKids = previousStructElement.get(PdfName.K) instanceof PdfArray ? previousStructElement.getAsArray(PdfName.K) : new PdfArray(previousStructElement.get(PdfName.K));
        PdfArray currentKids = currentStructElement.get(PdfName.K) instanceof PdfArray ? currentStructElement.getAsArray(PdfName.K) : new PdfArray(currentStructElement.get(PdfName.K));
        int i = 0;
        int j = 0;
        boolean comparisonHappened = false;
        while (i < previousKids.size() || j < currentKids.size()) {
            PdfObject currentContentObject;
            PdfObject previousContentObject;
            PdfDictionary currentKid;
            PdfDictionary previousKid = i < previousKids.size() ? previousKids.get(i) : DUMMY_STRUCT_TREE_ELEMENT;
            PdfObject pdfObject = currentKid = j < currentKids.size() ? currentKids.get(j) : DUMMY_STRUCT_TREE_ELEMENT;
            if (!DocumentRevisionsValidator.isStructTreeElement(previousKid) && (previousContentObject = DocumentRevisionsValidator.getObjectFromStructTreeContent(previousKid)) != null && this.removedTaggedObjects.contains(previousContentObject)) {
                ++i;
                continue;
            }
            if (!DocumentRevisionsValidator.isStructTreeElement(currentKid) && (currentContentObject = DocumentRevisionsValidator.getObjectFromStructTreeContent(currentKid)) != null && this.addedTaggedObjects.contains(currentContentObject)) {
                ++j;
                continue;
            }
            if (DocumentRevisionsValidator.isStructTreeElement(previousKid) && DocumentRevisionsValidator.isStructTreeElement(currentKid)) {
                boolean kidsComparisonResult = this.compareStructTreeElementKids(previousKid, currentKid, report);
                if (this.removedTaggedObjects.contains(previousKid)) {
                    ++i;
                    continue;
                }
                if (this.addedTaggedObjects.contains(currentKid)) {
                    ++j;
                    continue;
                }
                comparisonHappened = true;
                if (!kidsComparisonResult || !this.compareStructTreeElements(previousKid, currentKid, report)) {
                    return false;
                }
            } else if (!DocumentRevisionsValidator.isStructTreeElement(previousKid) && !DocumentRevisionsValidator.isStructTreeElement(currentKid)) {
                comparisonHappened = true;
                if (!this.compareStructTreeContents(previousKid, currentKid, report)) {
                    return false;
                }
            } else {
                if (DocumentRevisionsValidator.isStructTreeElement(previousKid)) {
                    this.compareStructTreeElementKids(previousKid, DUMMY_STRUCT_TREE_ELEMENT, report);
                    if (this.removedTaggedObjects.contains(previousKid)) {
                        ++i;
                        continue;
                    }
                    return false;
                }
                this.compareStructTreeElementKids(DUMMY_STRUCT_TREE_ELEMENT, currentKid, report);
                if (this.addedTaggedObjects.contains(currentKid)) {
                    ++j;
                    continue;
                }
                return false;
            }
            ++i;
            ++j;
        }
        if (!comparisonHappened && previousStructElement != DUMMY_STRUCT_TREE_ELEMENT) {
            this.removedTaggedObjects.add(previousStructElement);
        }
        if (!comparisonHappened && currentStructElement != DUMMY_STRUCT_TREE_ELEMENT) {
            this.addedTaggedObjects.add(currentStructElement);
        }
        return true;
    }

    private boolean compareStructTreeElements(PdfDictionary previousStructElement, PdfDictionary currentStructElement, ValidationReport report) {
        PdfDictionary previousStructElementCopy = new PdfDictionary(previousStructElement);
        previousStructElementCopy.remove(PdfName.K);
        previousStructElementCopy.remove(PdfName.P);
        previousStructElementCopy.remove(PdfName.Ref);
        previousStructElementCopy.remove(PdfName.Pg);
        PdfDictionary currentStructElementCopy = new PdfDictionary(currentStructElement);
        currentStructElementCopy.remove(PdfName.K);
        currentStructElementCopy.remove(PdfName.P);
        currentStructElementCopy.remove(PdfName.Ref);
        currentStructElementCopy.remove(PdfName.Pg);
        if (!DocumentRevisionsValidator.comparePdfObjects(previousStructElementCopy, currentStructElementCopy, this.usuallyModifiedObjects)) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, STRUCT_TREE_ELEMENT_MODIFIED, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        return this.compareIndirectReferencesObjNums(previousStructElement.get(PdfName.P), currentStructElement.get(PdfName.P), report, "Struct tree element parent entry") && this.compareIndirectReferencesObjNums(previousStructElement.get(PdfName.Ref), currentStructElement.get(PdfName.Ref), report, "Struct tree element ref entry") && this.compareIndirectReferencesObjNums(previousStructElement.get(PdfName.Pg), currentStructElement.get(PdfName.Pg), report, "Struct tree element page entry");
    }

    private boolean compareStructTreeContents(PdfObject previousStructTreeContent, PdfObject currentStructTreeContent, ValidationReport report) {
        if (previousStructTreeContent instanceof PdfDictionary && currentStructTreeContent instanceof PdfDictionary) {
            PdfDictionary previousContentDictionary = (PdfDictionary)previousStructTreeContent;
            PdfDictionary currentContentDictionary = (PdfDictionary)currentStructTreeContent;
            PdfDictionary previousContentDictionaryCopy = new PdfDictionary(previousContentDictionary);
            previousContentDictionaryCopy.remove(PdfName.Pg);
            previousContentDictionaryCopy.remove(PdfName.Obj);
            PdfDictionary currentContentDictionaryCopy = new PdfDictionary(currentContentDictionary);
            currentContentDictionaryCopy.remove(PdfName.Pg);
            currentContentDictionaryCopy.remove(PdfName.Obj);
            if (!DocumentRevisionsValidator.comparePdfObjects(previousContentDictionaryCopy, currentContentDictionaryCopy, this.usuallyModifiedObjects)) {
                report.addReportItem(new ReportItem(DOC_MDP_CHECK, STRUCT_TREE_CONTENT_MODIFIED, ReportItem.ReportItemStatus.INVALID));
                return false;
            }
            return this.compareIndirectReferencesObjNums(previousContentDictionary.get(PdfName.Pg), currentContentDictionary.get(PdfName.Pg), report, "Object reference dictionary page entry") && this.compareIndirectReferencesObjNums(previousContentDictionary.get(PdfName.Obj), currentContentDictionary.get(PdfName.Obj), report, "Object reference dictionary obj entry");
        }
        return DocumentRevisionsValidator.comparePdfObjects(previousStructTreeContent, currentStructTreeContent, this.usuallyModifiedObjects);
    }

    private boolean compareExtensions(PdfObject previousExtensions, PdfObject currentExtensions, ValidationReport report) {
        if (previousExtensions == null || DocumentRevisionsValidator.comparePdfObjects(previousExtensions, currentExtensions, this.usuallyModifiedObjects)) {
            return true;
        }
        if (currentExtensions == null) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, EXTENSIONS_REMOVED, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        if (!(previousExtensions instanceof PdfDictionary) || !(currentExtensions instanceof PdfDictionary)) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, EXTENSIONS_TYPE, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        PdfDictionary previousExtensionsDictionary = (PdfDictionary)previousExtensions;
        PdfDictionary currentExtensionsDictionary = (PdfDictionary)currentExtensions;
        boolean result = true;
        for (Map.Entry<PdfName, PdfObject> previousExtension : previousExtensionsDictionary.entrySet()) {
            PdfDictionary currentExtension = currentExtensionsDictionary.getAsDictionary(previousExtension.getKey());
            if (currentExtension == null) {
                report.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format(DEVELOPER_EXTENSION_REMOVED, previousExtension.getKey()), ReportItem.ReportItemStatus.INVALID));
                result = false;
                continue;
            }
            PdfDictionary currentExtensionCopy = new PdfDictionary(currentExtension);
            currentExtensionCopy.remove(PdfName.ExtensionLevel);
            currentExtensionCopy.remove(PdfName.BaseVersion);
            PdfDictionary previousExtensionCopy = new PdfDictionary((PdfDictionary)previousExtension.getValue());
            previousExtensionCopy.remove(PdfName.ExtensionLevel);
            previousExtensionCopy.remove(PdfName.BaseVersion);
            if (!DocumentRevisionsValidator.comparePdfObjects(previousExtensionCopy, currentExtensionCopy, this.usuallyModifiedObjects)) {
                report.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format(DEVELOPER_EXTENSION_REMOVED, previousExtension.getKey()), ReportItem.ReportItemStatus.INVALID));
                result = false;
                continue;
            }
            PdfNumber previousExtensionLevel = ((PdfDictionary)previousExtension.getValue()).getAsNumber(PdfName.ExtensionLevel);
            PdfNumber currentExtensionLevel = currentExtension.getAsNumber(PdfName.ExtensionLevel);
            if (previousExtensionLevel != null && (currentExtensionLevel == null || previousExtensionLevel.intValue() > currentExtensionLevel.intValue())) {
                report.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format(EXTENSION_LEVEL_DECREASED, previousExtension.getKey()), ReportItem.ReportItemStatus.INVALID));
                result = false;
            }
            PdfName previousBaseVersion = ((PdfDictionary)previousExtension.getValue()).getAsName(PdfName.BaseVersion);
            PdfName currentBaseVersion = currentExtension.getAsName(PdfName.BaseVersion);
            if (previousBaseVersion == null) continue;
            try {
                if (currentBaseVersion != null && !(Double.parseDouble(previousBaseVersion.getValue()) > Double.parseDouble(currentBaseVersion.getValue()) + (double)1.0E-5f)) continue;
                report.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format(BASE_VERSION_DECREASED, previousExtension.getKey()), ReportItem.ReportItemStatus.INVALID));
                result = false;
            }
            catch (NumberFormatException e) {
                report.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format(BASE_VERSION_EXTENSION_NOT_PARSABLE, previousExtension.getKey()), ReportItem.ReportItemStatus.INVALID));
            }
        }
        return result;
    }

    private boolean comparePermissions(PdfObject previousPerms, PdfObject currentPerms, ValidationReport report) {
        if (previousPerms == null || DocumentRevisionsValidator.comparePdfObjects(previousPerms, currentPerms, this.usuallyModifiedObjects)) {
            return true;
        }
        if (currentPerms == null) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, PERMISSIONS_REMOVED, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        if (!(previousPerms instanceof PdfDictionary) || !(currentPerms instanceof PdfDictionary)) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, PERMISSIONS_TYPE, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        PdfDictionary previousPermsDictionary = (PdfDictionary)previousPerms;
        PdfDictionary currentPermsDictionary = (PdfDictionary)currentPerms;
        boolean result = true;
        for (Map.Entry<PdfName, PdfObject> previousPermission : previousPermsDictionary.entrySet()) {
            PdfDictionary currentPermission = currentPermsDictionary.getAsDictionary(previousPermission.getKey());
            if (currentPermission == null) {
                report.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format(PERMISSION_REMOVED, previousPermission.getKey()), ReportItem.ReportItemStatus.INVALID));
                result = false;
                continue;
            }
            if (this.compareSignatureDictionaries(previousPermission.getValue(), currentPermission, report)) continue;
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format(PERMISSION_REMOVED, previousPermission.getKey()), ReportItem.ReportItemStatus.INVALID));
            result = false;
        }
        return result;
    }

    private boolean compareDss(PdfObject previousDss, PdfObject currentDss, ValidationReport report) {
        if (previousDss == null) {
            return true;
        }
        if (currentDss == null) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, DSS_REMOVED, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        return true;
    }

    private boolean compareAcroFormsWithFieldMDP(PdfDocument documentWithoutRevision, PdfDocument documentWithRevision, ValidationReport report) {
        PdfAcroForm currentAcroForm = PdfFormCreator.getAcroForm(documentWithRevision, false);
        PdfAcroForm previousAcroForm = PdfFormCreator.getAcroForm(documentWithoutRevision, false);
        if (currentAcroForm == null || previousAcroForm == null) {
            return true;
        }
        if (this.accessPermissions == AccessPermissions.NO_CHANGES_PERMITTED) {
            return true;
        }
        boolean result = true;
        for (Map.Entry<String, PdfFormField> previousField : previousAcroForm.getAllFormFields().entrySet()) {
            if (!this.lockedFields.contains(previousField.getKey())) continue;
            PdfFormField currentFormField = currentAcroForm.getField(previousField.getKey());
            if (currentFormField == null) {
                report.addReportItem(new ReportItem(FIELD_MDP_CHECK, MessageFormatUtil.format(LOCKED_FIELD_REMOVED, previousField.getKey()), ReportItem.ReportItemStatus.INVALID));
                result = false;
                continue;
            }
            if (this.compareFormFieldWithFieldMDP(previousField.getValue().getPdfObject(), currentFormField.getPdfObject(), previousField.getKey(), report)) continue;
            result = false;
        }
        return result;
    }

    private boolean compareFormFieldWithFieldMDP(PdfDictionary previousField, PdfDictionary currentField, String fieldName, ValidationReport report) {
        PdfDictionary previousFieldCopy = new PdfDictionary(previousField);
        previousFieldCopy.remove(PdfName.Kids);
        previousFieldCopy.remove(PdfName.P);
        previousFieldCopy.remove(PdfName.Parent);
        previousFieldCopy.remove(PdfName.V);
        PdfDictionary currentFieldCopy = new PdfDictionary(currentField);
        currentFieldCopy.remove(PdfName.Kids);
        currentFieldCopy.remove(PdfName.P);
        currentFieldCopy.remove(PdfName.Parent);
        currentFieldCopy.remove(PdfName.V);
        if (!DocumentRevisionsValidator.comparePdfObjects(previousFieldCopy, currentFieldCopy, this.usuallyModifiedObjects)) {
            report.addReportItem(new ReportItem(FIELD_MDP_CHECK, MessageFormatUtil.format(LOCKED_FIELD_MODIFIED, fieldName), ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        PdfObject prevValue = previousField.get(PdfName.V);
        PdfObject currValue = currentField.get(PdfName.V);
        if (PdfName.Sig.equals(currentField.getAsName(PdfName.FT))) {
            if (!this.compareSignatureDictionaries(prevValue, currValue, report)) {
                report.addReportItem(new ReportItem(FIELD_MDP_CHECK, MessageFormatUtil.format(LOCKED_FIELD_MODIFIED, fieldName), ReportItem.ReportItemStatus.INVALID));
                return false;
            }
        } else if (!DocumentRevisionsValidator.comparePdfObjects(prevValue, currValue, this.usuallyModifiedObjects)) {
            report.addReportItem(new ReportItem(FIELD_MDP_CHECK, MessageFormatUtil.format(LOCKED_FIELD_MODIFIED, fieldName), ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        if (!this.compareIndirectReferencesObjNums(previousField.get(PdfName.P), currentField.get(PdfName.P), report, "Page object with which field annotation is associated") || !this.compareIndirectReferencesObjNums(previousField.get(PdfName.Parent), currentField.get(PdfName.Parent), report, "Form field parent")) {
            report.addReportItem(new ReportItem(FIELD_MDP_CHECK, MessageFormatUtil.format(LOCKED_FIELD_MODIFIED, fieldName), ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        PdfArray previousKids = previousField.getAsArray(PdfName.Kids);
        PdfArray currentKids = currentField.getAsArray(PdfName.Kids);
        if (previousKids == null && currentKids != null) {
            report.addReportItem(new ReportItem(FIELD_MDP_CHECK, MessageFormatUtil.format(LOCKED_FIELD_KIDS_ADDED, fieldName), ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        if (previousKids != null && currentKids == null) {
            report.addReportItem(new ReportItem(FIELD_MDP_CHECK, MessageFormatUtil.format(LOCKED_FIELD_KIDS_REMOVED, fieldName), ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        if (previousKids == currentKids) {
            return true;
        }
        if (previousKids.size() < currentKids.size()) {
            report.addReportItem(new ReportItem(FIELD_MDP_CHECK, MessageFormatUtil.format(LOCKED_FIELD_KIDS_ADDED, fieldName), ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        if (previousKids.size() > currentKids.size()) {
            report.addReportItem(new ReportItem(FIELD_MDP_CHECK, MessageFormatUtil.format(LOCKED_FIELD_KIDS_REMOVED, fieldName), ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        for (int i = 0; i < previousKids.size(); ++i) {
            PdfDictionary previousKid = previousKids.getAsDictionary(i);
            PdfDictionary currentKid = currentKids.getAsDictionary(i);
            if (previousKid == null || currentKid == null) {
                report.addReportItem(new ReportItem(FIELD_MDP_CHECK, MessageFormatUtil.format(FIELD_NOT_DICTIONARY, fieldName), ReportItem.ReportItemStatus.INDETERMINATE));
                continue;
            }
            if (!PdfFormAnnotationUtil.isPureWidget(previousKid) || this.compareFormFieldWithFieldMDP(previousKid, currentKid, fieldName, report)) continue;
            return false;
        }
        return true;
    }

    private boolean compareAcroForms(PdfDictionary prevAcroForm, PdfDictionary currAcroForm, ValidationReport report) {
        this.checkedAnnots = new HashSet<PdfObject>();
        this.newlyAddedFields = new HashSet<PdfDictionary>();
        if (prevAcroForm == null) {
            if (currAcroForm == null) {
                return true;
            }
            PdfArray fields = currAcroForm.getAsArray(PdfName.Fields);
            for (PdfObject field : fields) {
                PdfDictionary fieldDict = (PdfDictionary)field;
                if (this.isAllowedSignatureField(fieldDict, report)) continue;
                report.addReportItem(new ReportItem(DOC_MDP_CHECK, NOT_ALLOWED_ACROFORM_CHANGES, ReportItem.ReportItemStatus.INVALID));
                return false;
            }
            return true;
        }
        if (currAcroForm == null) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, ACROFORM_REMOVED, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        PdfDictionary previousAcroFormCopy = this.copyAcroformDictionary(prevAcroForm);
        PdfDictionary currentAcroFormCopy = this.copyAcroformDictionary(currAcroForm);
        PdfArray prevFields = prevAcroForm.getAsArray(PdfName.Fields);
        PdfArray currFields = currAcroForm.getAsArray(PdfName.Fields);
        if (!DocumentRevisionsValidator.comparePdfObjects(previousAcroFormCopy, currentAcroFormCopy, this.usuallyModifiedObjects) || prevFields.size() > currFields.size() || !this.compareFormFields(prevFields, currFields, report)) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, NOT_ALLOWED_ACROFORM_CHANGES, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        return true;
    }

    private boolean compareFormFields(PdfArray prevFields, PdfArray currFields, ValidationReport report) {
        Set<PdfDictionary> prevFieldsSet = this.populateFormFields(prevFields);
        Set<PdfDictionary> currFieldsSet = this.populateFormFields(currFields);
        for (PdfDictionary previousField : prevFieldsSet) {
            PdfDictionary currentField = this.retrieveTheSameField(currFieldsSet, previousField);
            if (currentField == null || !this.compareFields(previousField, currentField, report)) {
                PdfString fieldName = previousField.getAsString(PdfName.T);
                report.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format(FIELD_REMOVED, fieldName == null ? "" : fieldName.getValue()), ReportItem.ReportItemStatus.INVALID));
                return false;
            }
            if (PdfFormAnnotationUtil.isPureWidgetOrMergedField(previousField)) {
                this.checkedAnnots.add(previousField);
            }
            if (PdfFormAnnotationUtil.isPureWidgetOrMergedField(currentField)) {
                this.checkedAnnots.add(currentField);
            }
            currFieldsSet.remove(currentField);
        }
        for (PdfDictionary field : currFieldsSet) {
            if (this.isAllowedSignatureField(field, report)) continue;
            return false;
        }
        return this.compareWidgets(prevFields, currFields, report);
    }

    private PdfDictionary retrieveTheSameField(Set<PdfDictionary> currFields, PdfDictionary previousField) {
        for (PdfDictionary currentField : currFields) {
            PdfDictionary currFormDict;
            PdfDictionary prevFormDict = this.copyFieldDictionary(previousField);
            if (!DocumentRevisionsValidator.comparePdfObjects(prevFormDict, currFormDict = this.copyFieldDictionary(currentField), this.usuallyModifiedObjects) || !this.compareIndirectReferencesObjNums(prevFormDict.get(PdfName.Parent), currFormDict.get(PdfName.Parent), new ValidationReport(), "Form field parent") || !this.compareIndirectReferencesObjNums(prevFormDict.get(PdfName.P), currFormDict.get(PdfName.P), new ValidationReport(), "Page object with which field annotation is associated")) continue;
            return currentField;
        }
        return null;
    }

    private boolean compareFields(PdfDictionary previousField, PdfDictionary currentField, ValidationReport report) {
        PdfObject prevValue = previousField.get(PdfName.V);
        PdfObject currValue = currentField.get(PdfName.V);
        if (prevValue == null && currValue == null && PdfName.Ch.equals(currentField.getAsName(PdfName.FT))) {
            prevValue = previousField.get(PdfName.I);
            currValue = currentField.get(PdfName.I);
        }
        if (PdfName.Sig.equals(currentField.getAsName(PdfName.FT))) {
            if (!this.compareSignatureDictionaries(prevValue, currValue, report)) {
                PdfString fieldName = currentField.getAsString(PdfName.T);
                report.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format(SIGNATURE_MODIFIED, fieldName == null ? "" : fieldName.getValue()), ReportItem.ReportItemStatus.INVALID));
                return false;
            }
        } else if (this.getAccessPermissions() == AccessPermissions.NO_CHANGES_PERMITTED && !DocumentRevisionsValidator.comparePdfObjects(prevValue, currValue, this.usuallyModifiedObjects)) {
            return false;
        }
        return this.compareFormFields(previousField.getAsArray(PdfName.Kids), currentField.getAsArray(PdfName.Kids), report);
    }

    private boolean compareSignatureDictionaries(PdfObject prevSigDict, PdfObject curSigDict, ValidationReport report) {
        if (prevSigDict == null) {
            return true;
        }
        if (curSigDict == null) {
            return false;
        }
        if (!(prevSigDict instanceof PdfDictionary) || !(curSigDict instanceof PdfDictionary)) {
            return false;
        }
        PdfDictionary currentSigDictCopy = new PdfDictionary((PdfDictionary)curSigDict);
        currentSigDictCopy.remove(PdfName.Reference);
        PdfDictionary previousSigDictCopy = new PdfDictionary((PdfDictionary)prevSigDict);
        previousSigDictCopy.remove(PdfName.Reference);
        if (!DocumentRevisionsValidator.comparePdfObjects(previousSigDictCopy, currentSigDictCopy, this.usuallyModifiedObjects)) {
            return false;
        }
        PdfArray previousReference = ((PdfDictionary)prevSigDict).getAsArray(PdfName.Reference);
        PdfArray currentReference = ((PdfDictionary)curSigDict).getAsArray(PdfName.Reference);
        return this.compareSignatureReferenceDictionaries(previousReference, currentReference, report);
    }

    private boolean compareSignatureReferenceDictionaries(PdfArray previousReferences, PdfArray currentReferences, ValidationReport report) {
        if (previousReferences == null || DocumentRevisionsValidator.comparePdfObjects(previousReferences, currentReferences, this.usuallyModifiedObjects)) {
            return true;
        }
        if (currentReferences == null || previousReferences.size() != currentReferences.size()) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, REFERENCE_REMOVED, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        for (int i = 0; i < previousReferences.size(); ++i) {
            PdfDictionary currentReferenceCopy = new PdfDictionary(currentReferences.getAsDictionary(i));
            currentReferenceCopy.remove(PdfName.Data);
            PdfDictionary previousReferenceCopy = new PdfDictionary(previousReferences.getAsDictionary(i));
            previousReferenceCopy.remove(PdfName.Data);
            if (DocumentRevisionsValidator.comparePdfObjects(previousReferenceCopy, currentReferenceCopy, this.usuallyModifiedObjects) && this.compareIndirectReferencesObjNums(previousReferences.getAsDictionary(i).get(PdfName.Data), currentReferences.getAsDictionary(i).get(PdfName.Data), report, "Data entry in the signature reference dictionary")) continue;
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, REFERENCE_REMOVED, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        return true;
    }

    private boolean compareWidgets(PdfArray prevFields, PdfArray currFields, ValidationReport report) {
        if (this.getAccessPermissions() == AccessPermissions.ANNOTATION_MODIFICATION) {
            return true;
        }
        List<PdfDictionary> prevAnnots = this.populateWidgetAnnotations(prevFields);
        List<PdfDictionary> currAnnots = this.populateWidgetAnnotations(currFields);
        if (prevAnnots.size() != currAnnots.size()) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, ANNOTATIONS_MODIFIED, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        for (int i = 0; i < prevAnnots.size(); ++i) {
            PdfDictionary prevAnnot = new PdfDictionary(prevAnnots.get(i));
            this.removeAppearanceRelatedProperties(prevAnnot);
            PdfDictionary currAnnot = new PdfDictionary(currAnnots.get(i));
            this.removeAppearanceRelatedProperties(currAnnot);
            if (!(DocumentRevisionsValidator.comparePdfObjects(prevAnnot, currAnnot, this.usuallyModifiedObjects) && this.compareIndirectReferencesObjNums(prevAnnots.get(i).get(PdfName.P), currAnnots.get(i).get(PdfName.P), report, "Page object with which annotation is associated") && this.compareIndirectReferencesObjNums(prevAnnots.get(i).get(PdfName.Parent), currAnnots.get(i).get(PdfName.Parent), report, "Annotation parent"))) {
                report.addReportItem(new ReportItem(DOC_MDP_CHECK, ANNOTATIONS_MODIFIED, ReportItem.ReportItemStatus.INVALID));
                return false;
            }
            this.checkedAnnots.add(prevAnnots.get(i));
            this.checkedAnnots.add(currAnnots.get(i));
        }
        return true;
    }

    private boolean comparePages(PdfDictionary prevPages, PdfDictionary currPages, ValidationReport report) {
        if (prevPages == null ^ currPages == null) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, PAGES_MODIFIED, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        if (prevPages == null) {
            return true;
        }
        PdfDictionary previousPagesCopy = new PdfDictionary(prevPages);
        previousPagesCopy.remove(PdfName.Kids);
        previousPagesCopy.remove(PdfName.Parent);
        PdfDictionary currentPagesCopy = new PdfDictionary(currPages);
        currentPagesCopy.remove(PdfName.Kids);
        currentPagesCopy.remove(PdfName.Parent);
        if (!DocumentRevisionsValidator.comparePdfObjects(previousPagesCopy, currentPagesCopy, this.usuallyModifiedObjects) || !this.compareIndirectReferencesObjNums(prevPages.get(PdfName.Parent), currPages.get(PdfName.Parent), report, "Page tree node parent")) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, PAGES_MODIFIED, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        PdfArray prevKids = prevPages.getAsArray(PdfName.Kids);
        PdfArray currKids = currPages.getAsArray(PdfName.Kids);
        if (prevKids.size() != currKids.size()) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, PAGES_MODIFIED, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        for (int i = 0; i < currKids.size(); ++i) {
            PdfArray currNotModifiableAnnots;
            PdfDictionary previousKid = prevKids.getAsDictionary(i);
            PdfDictionary currentKid = currKids.getAsDictionary(i);
            if (PdfName.Pages.equals(previousKid.getAsName(PdfName.Type))) {
                if (this.comparePages(previousKid, currentKid, report)) continue;
                return false;
            }
            PdfDictionary previousPageCopy = new PdfDictionary(previousKid);
            previousPageCopy.remove(PdfName.Annots);
            previousPageCopy.remove(PdfName.Parent);
            previousPageCopy.remove(PdfName.StructParents);
            previousPageCopy.remove(PdfName.Tabs);
            PdfDictionary currentPageCopy = new PdfDictionary(currentKid);
            currentPageCopy.remove(PdfName.Annots);
            currentPageCopy.remove(PdfName.Parent);
            currentPageCopy.remove(PdfName.StructParents);
            currentPageCopy.remove(PdfName.Tabs);
            if (!DocumentRevisionsValidator.comparePdfObjects(previousPageCopy, currentPageCopy, this.usuallyModifiedObjects) || !this.compareIndirectReferencesObjNums(previousKid.get(PdfName.Parent), currentKid.get(PdfName.Parent), report, "Page parent")) {
                report.addReportItem(new ReportItem(DOC_MDP_CHECK, PAGE_MODIFIED, ReportItem.ReportItemStatus.INVALID));
                return false;
            }
            if (!this.compareTabs(previousKid.getAsName(PdfName.Tabs), currentKid.getAsName(PdfName.Tabs))) {
                report.addReportItem(new ReportItem(DOC_MDP_CHECK, TABS_MODIFIED, ReportItem.ReportItemStatus.INVALID));
                return false;
            }
            PdfArray prevNotModifiableAnnots = this.getAnnotsNotAllowedToBeModified(previousKid);
            if (!this.comparePageAnnotations(prevNotModifiableAnnots, currNotModifiableAnnots = this.getAnnotsNotAllowedToBeModified(currentKid), report)) {
                report.addReportItem(new ReportItem(DOC_MDP_CHECK, PAGE_ANNOTATIONS_MODIFIED, ReportItem.ReportItemStatus.INVALID));
                return false;
            }
            this.collectRemovedAndAddedAnnotations(previousKid.getAsArray(PdfName.Annots), currentKid.getAsArray(PdfName.Annots));
        }
        return true;
    }

    private boolean compareTabs(PdfName previousTabs, PdfName currentTabs) {
        if (this.getAccessPermissions() == AccessPermissions.ANNOTATION_MODIFICATION) {
            return true;
        }
        return Objects.equals(previousTabs, currentTabs) || previousTabs == null && currentTabs.equals(PdfName.S);
    }

    private void collectRemovedAndAddedAnnotations(PdfArray previousAnnotations, PdfArray currentAnnotations) {
        ValidationReport dummyReport = new ValidationReport();
        ArrayList<PdfDictionary> prevAnnots = new ArrayList<PdfDictionary>();
        if (previousAnnotations != null) {
            for (PdfObject annot : previousAnnotations) {
                if (!(annot instanceof PdfDictionary)) continue;
                prevAnnots.add((PdfDictionary)annot);
            }
        }
        ArrayList<PdfDictionary> currAnnots = new ArrayList<PdfDictionary>();
        if (currentAnnotations != null) {
            for (PdfObject annot : currentAnnotations) {
                if (!(annot instanceof PdfDictionary)) continue;
                currAnnots.add((PdfDictionary)annot);
            }
        }
        this.removedTaggedObjects.addAll(prevAnnots.stream().filter(prevAnnot -> !currAnnots.stream().anyMatch(currAnnot -> this.comparePageAnnotations((PdfDictionary)prevAnnot, (PdfDictionary)currAnnot, dummyReport))).collect(Collectors.toList()));
        this.addedTaggedObjects.addAll(currAnnots.stream().filter(currAnnot -> !prevAnnots.stream().anyMatch(prevAnnot -> this.comparePageAnnotations((PdfDictionary)prevAnnot, (PdfDictionary)currAnnot, dummyReport))).collect(Collectors.toList()));
    }

    private boolean comparePageAnnotations(PdfArray prevAnnots, PdfArray currAnnots, ValidationReport report) {
        if (prevAnnots == null && currAnnots == null) {
            return true;
        }
        if (prevAnnots == null || currAnnots == null || prevAnnots.size() != currAnnots.size()) {
            return false;
        }
        for (int i = 0; i < prevAnnots.size(); ++i) {
            PdfDictionary currAnnot;
            PdfDictionary prevAnnot = prevAnnots.getAsDictionary(i);
            if (this.comparePageAnnotations(prevAnnot, currAnnot = currAnnots.getAsDictionary(i), report)) continue;
            return false;
        }
        return true;
    }

    private boolean comparePageAnnotations(PdfDictionary prevAnnot, PdfDictionary currAnnot, ValidationReport report) {
        PdfDictionary prevAnnotCopy = new PdfDictionary(prevAnnot);
        prevAnnotCopy.remove(PdfName.P);
        prevAnnotCopy.remove(PdfName.Parent);
        PdfDictionary currAnnotCopy = new PdfDictionary(currAnnot);
        currAnnotCopy.remove(PdfName.P);
        currAnnotCopy.remove(PdfName.Parent);
        if (PdfName.Sig.equals(currAnnot.getAsName(PdfName.FT))) {
            if (!this.compareSignatureDictionaries(prevAnnot.get(PdfName.V), currAnnot.get(PdfName.V), report)) {
                return false;
            }
            prevAnnotCopy.remove(PdfName.V);
            currAnnotCopy.remove(PdfName.V);
        }
        return DocumentRevisionsValidator.comparePdfObjects(prevAnnotCopy, currAnnotCopy, this.usuallyModifiedObjects) && this.compareIndirectReferencesObjNums(prevAnnot.get(PdfName.P), currAnnot.get(PdfName.P), report, "Page object with which annotation is associated") && this.compareIndirectReferencesObjNums(prevAnnot.get(PdfName.Parent), currAnnot.get(PdfName.Parent), report, "Annotation parent");
    }

    private boolean compareIndirectReferencesObjNums(PdfObject prevObj, PdfObject currObj, ValidationReport report, String type) {
        if (prevObj == null ^ currObj == null) {
            return false;
        }
        if (prevObj == null) {
            return true;
        }
        PdfIndirectReference prevObjRef = prevObj.getIndirectReference();
        PdfIndirectReference currObjRef = currObj.getIndirectReference();
        if (prevObjRef == null || currObjRef == null) {
            if (report != null) {
                report.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format(DIRECT_OBJECT, type), ReportItem.ReportItemStatus.INVALID));
            }
            return false;
        }
        return DocumentRevisionsValidator.isSameReference(prevObjRef, currObjRef);
    }

    private boolean isAllowedSignatureField(PdfDictionary field, ValidationReport report) {
        PdfDictionary value = field.getAsDictionary(PdfName.V);
        if (!PdfName.Sig.equals(field.getAsName(PdfName.FT)) || value == null || this.getAccessPermissions() == AccessPermissions.NO_CHANGES_PERMITTED && !PdfName.DocTimeStamp.equals(value.getAsName(PdfName.Type))) {
            PdfString fieldName = field.getAsString(PdfName.T);
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format(UNEXPECTED_FORM_FIELD, fieldName == null ? "" : fieldName.getValue()), ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        if (PdfFormAnnotationUtil.isPureWidgetOrMergedField(field)) {
            this.checkedAnnots.add(field);
        } else {
            PdfArray kids = field.getAsArray(PdfName.Kids);
            this.checkedAnnots.addAll(this.populateWidgetAnnotations(kids));
        }
        this.newlyAddedFields.add(field);
        return true;
    }

    private Set<PdfDictionary> populateFormFields(PdfArray fieldsArray) {
        HashSet<PdfDictionary> fields = new HashSet<PdfDictionary>();
        if (fieldsArray != null) {
            for (int i = 0; i < fieldsArray.size(); ++i) {
                PdfDictionary fieldDict = (PdfDictionary)fieldsArray.get(i);
                if (!PdfFormField.isFormField(fieldDict)) continue;
                fields.add(fieldDict);
            }
        }
        return fields;
    }

    private List<PdfDictionary> populateWidgetAnnotations(PdfArray fieldsArray) {
        ArrayList<PdfDictionary> annotations = new ArrayList<PdfDictionary>();
        if (fieldsArray != null) {
            for (int i = 0; i < fieldsArray.size(); ++i) {
                PdfDictionary annotDict = (PdfDictionary)fieldsArray.get(i);
                if (!PdfFormAnnotationUtil.isPureWidget(annotDict)) continue;
                annotations.add(annotDict);
            }
        }
        return annotations;
    }

    private PdfArray getAnnotsNotAllowedToBeModified(PdfDictionary page) {
        PdfArray annots = page.getAsArray(PdfName.Annots);
        if (annots == null || this.getAccessPermissions() == AccessPermissions.ANNOTATION_MODIFICATION) {
            return null;
        }
        PdfArray annotsCopy = new PdfArray(annots);
        for (PdfObject annot : annots) {
            if (!this.checkedAnnots.contains(annot)) continue;
            annotsCopy.remove(annot);
        }
        return annotsCopy;
    }

    private PdfDictionary copyCatalogEntriesToCompare(PdfDictionary catalog) {
        PdfDictionary catalogCopy = new PdfDictionary(catalog);
        catalogCopy.remove(PdfName.Metadata);
        catalogCopy.remove(PdfName.Extensions);
        catalogCopy.remove(PdfName.Perms);
        catalogCopy.remove(PdfName.DSS);
        catalogCopy.remove(PdfName.AcroForm);
        catalogCopy.remove(PdfName.Pages);
        catalogCopy.remove(PdfName.StructTreeRoot);
        catalogCopy.remove(PdfName.Version);
        return catalogCopy;
    }

    private PdfDictionary copyAcroformDictionary(PdfDictionary acroForm) {
        PdfDictionary acroFormCopy = new PdfDictionary(acroForm);
        acroFormCopy.remove(PdfName.Fields);
        acroFormCopy.remove(PdfName.DR);
        acroFormCopy.remove(PdfName.DA);
        return acroFormCopy;
    }

    private PdfDictionary copyFieldDictionary(PdfDictionary field) {
        PdfDictionary formDict = new PdfDictionary(field);
        formDict.remove(PdfName.V);
        formDict.remove(PdfName.I);
        formDict.remove(PdfName.Parent);
        formDict.remove(PdfName.Kids);
        this.removeAppearanceRelatedProperties(formDict);
        return formDict;
    }

    private void removeAppearanceRelatedProperties(PdfDictionary annotDict) {
        annotDict.remove(PdfName.P);
        annotDict.remove(PdfName.Parent);
        if (this.getAccessPermissions() == AccessPermissions.FORM_FIELDS_MODIFICATION) {
            annotDict.remove(PdfName.AP);
            annotDict.remove(PdfName.AS);
            annotDict.remove(PdfName.M);
            annotDict.remove(PdfName.F);
        }
        if (this.getAccessPermissions() == AccessPermissions.ANNOTATION_MODIFICATION) {
            for (PdfName key : new PdfDictionary(annotDict).keySet()) {
                if (PdfFormField.getFormFieldKeys().contains(key)) continue;
                annotDict.remove(key);
            }
        }
    }

    private static boolean comparePdfObjects(PdfObject pdfObject1, PdfObject pdfObject2, Tuple2<Set<PdfIndirectReference>, Set<PdfIndirectReference>> usuallyModifiedObjects) {
        return DocumentRevisionsValidator.comparePdfObjects(pdfObject1, pdfObject2, new ArrayList<Tuple2<PdfObject, PdfObject>>(), usuallyModifiedObjects);
    }

    private static boolean comparePdfObjects(PdfObject pdfObject1, PdfObject pdfObject2, List<Tuple2<PdfObject, PdfObject>> visitedObjects, Tuple2<Set<PdfIndirectReference>, Set<PdfIndirectReference>> usuallyModifiedObjects) {
        for (Tuple2<PdfObject, PdfObject> pair : visitedObjects) {
            if (pair.getFirst() != pdfObject1) continue;
            return pair.getSecond() == pdfObject2;
        }
        visitedObjects.add(new Tuple2<PdfObject, PdfObject>(pdfObject1, pdfObject2));
        if (Objects.equals(pdfObject1, pdfObject2)) {
            return true;
        }
        if (pdfObject1 == null || pdfObject2 == null) {
            return false;
        }
        if (pdfObject1.getClass() != pdfObject2.getClass()) {
            return false;
        }
        if (pdfObject1.getIndirectReference() != null && usuallyModifiedObjects.getFirst().stream().anyMatch(reference -> DocumentRevisionsValidator.isSameReference(reference, pdfObject1.getIndirectReference())) && pdfObject2.getIndirectReference() != null && usuallyModifiedObjects.getSecond().stream().anyMatch(reference -> DocumentRevisionsValidator.isSameReference(reference, pdfObject2.getIndirectReference()))) {
            return DocumentRevisionsValidator.isSameReference(pdfObject1.getIndirectReference(), pdfObject2.getIndirectReference());
        }
        if (pdfObject1.getIndirectReference() == null ^ pdfObject2.getIndirectReference() == null) {
            return false;
        }
        switch (pdfObject1.getType()) {
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                return pdfObject1.equals(pdfObject2);
            }
            case 5: {
                return DocumentRevisionsValidator.comparePdfObjects(((PdfIndirectReference)pdfObject1).getRefersTo(), ((PdfIndirectReference)pdfObject2).getRefersTo(), visitedObjects, usuallyModifiedObjects);
            }
            case 1: {
                return DocumentRevisionsValidator.comparePdfArrays((PdfArray)pdfObject1, (PdfArray)pdfObject2, visitedObjects, usuallyModifiedObjects);
            }
            case 3: {
                return DocumentRevisionsValidator.comparePdfDictionaries((PdfDictionary)pdfObject1, (PdfDictionary)pdfObject2, visitedObjects, usuallyModifiedObjects);
            }
            case 9: {
                return DocumentRevisionsValidator.comparePdfStreams((PdfStream)pdfObject1, (PdfStream)pdfObject2, visitedObjects, usuallyModifiedObjects);
            }
        }
        return false;
    }

    private static boolean comparePdfArrays(PdfArray array1, PdfArray array2, List<Tuple2<PdfObject, PdfObject>> visitedObjects, Tuple2<Set<PdfIndirectReference>, Set<PdfIndirectReference>> usuallyModifiedObjects) {
        if (array1.size() != array2.size()) {
            return false;
        }
        for (int i = 0; i < array1.size(); ++i) {
            if (DocumentRevisionsValidator.comparePdfObjects(array1.get(i), array2.get(i), visitedObjects, usuallyModifiedObjects)) continue;
            return false;
        }
        return true;
    }

    private static boolean comparePdfDictionaries(PdfDictionary dictionary1, PdfDictionary dictionary2, List<Tuple2<PdfObject, PdfObject>> visitedObjects, Tuple2<Set<PdfIndirectReference>, Set<PdfIndirectReference>> usuallyModifiedObjects) {
        Set<Map.Entry<PdfName, PdfObject>> entrySet1 = dictionary1.entrySet();
        Set<Map.Entry<PdfName, PdfObject>> entrySet2 = dictionary2.entrySet();
        if (entrySet1.size() != entrySet2.size()) {
            return false;
        }
        for (Map.Entry<PdfName, PdfObject> entry1 : entrySet1) {
            if (entrySet2.stream().anyMatch(entry2 -> ((PdfName)entry2.getKey()).equals(entry1.getKey()) && DocumentRevisionsValidator.comparePdfObjects((PdfObject)entry2.getValue(), (PdfObject)entry1.getValue(), visitedObjects, usuallyModifiedObjects))) continue;
            return false;
        }
        return true;
    }

    private static boolean comparePdfStreams(PdfStream stream1, PdfStream stream2, List<Tuple2<PdfObject, PdfObject>> visitedObjects, Tuple2<Set<PdfIndirectReference>, Set<PdfIndirectReference>> usuallyModifiedObjects) {
        return Arrays.equals(stream1.getBytes(), stream2.getBytes()) && DocumentRevisionsValidator.comparePdfDictionaries(stream1, stream2, visitedObjects, usuallyModifiedObjects);
    }

    private static boolean isSameReference(PdfIndirectReference indirectReference1, PdfIndirectReference indirectReference2) {
        if (indirectReference1 == indirectReference2) {
            return true;
        }
        if (indirectReference1 == null || indirectReference2 == null) {
            return false;
        }
        return indirectReference1.getObjNumber() == indirectReference2.getObjNumber() && indirectReference1.getGenNumber() == indirectReference2.getGenNumber();
    }

    private static boolean isMaxGenerationObject(PdfIndirectReference indirectReference) {
        return indirectReference.getObjNumber() == 0 && indirectReference.getGenNumber() == 65535;
    }

    private Set<PdfIndirectReference> createUsuallyModifiedObjectsSet(PdfDocument document) {
        HashSet<PdfIndirectReference> usuallyModifiedObjectsSet = new HashSet<PdfIndirectReference>();
        usuallyModifiedObjectsSet.add(((PdfDictionary)document.getCatalog().getPdfObject()).getIndirectReference());
        PdfDictionary catalog = (PdfDictionary)document.getCatalog().getPdfObject();
        if (catalog.get(PdfName.Pages) != null) {
            usuallyModifiedObjectsSet.add(catalog.get(PdfName.Pages).getIndirectReference());
            if (catalog.getAsDictionary(PdfName.Pages) != null) {
                this.addPageEntriesToSet(catalog.getAsDictionary(PdfName.Pages), usuallyModifiedObjectsSet);
            }
        }
        if (catalog.get(PdfName.StructTreeRoot) != null) {
            usuallyModifiedObjectsSet.add(catalog.get(PdfName.StructTreeRoot).getIndirectReference());
            if (catalog.getAsDictionary(PdfName.StructTreeRoot) != null && catalog.getAsDictionary(PdfName.StructTreeRoot).get(PdfName.K) != null) {
                this.addStructTreeElementsToSet(catalog.getAsDictionary(PdfName.StructTreeRoot).get(PdfName.K), usuallyModifiedObjectsSet);
            }
        }
        return usuallyModifiedObjectsSet;
    }

    private void addStructTreeElementsToSet(PdfObject structTreeRootKids, Set<PdfIndirectReference> set) {
        if (structTreeRootKids instanceof PdfArray) {
            set.add(structTreeRootKids.getIndirectReference());
            this.addStructTreeElementsToSet((PdfArray)structTreeRootKids, set);
        } else {
            this.addStructTreeElementsToSet(new PdfArray(structTreeRootKids), set);
        }
    }

    private void addStructTreeElementsToSet(PdfArray structTreeRootKids, Set<PdfIndirectReference> set) {
        for (PdfObject kid : structTreeRootKids) {
            if (kid == null) continue;
            set.add(kid.getIndirectReference());
            if (!DocumentRevisionsValidator.isStructTreeElement(kid) || ((PdfDictionary)kid).get(PdfName.K) == null) continue;
            this.addStructTreeElementsToSet(((PdfDictionary)kid).get(PdfName.K), set);
        }
    }

    private void addPageEntriesToSet(PdfDictionary page, Set<PdfIndirectReference> set) {
        PdfArray kids = page.getAsArray(PdfName.Kids);
        if (kids != null) {
            set.add(kids.getIndirectReference());
            for (int i = 0; i < kids.size(); ++i) {
                set.add(kids.get(i).getIndirectReference());
                PdfDictionary pageNode = kids.getAsDictionary(i);
                if (pageNode == null || !PdfName.Pages.equals(pageNode.getAsName(PdfName.Type))) continue;
                this.addPageEntriesToSet(pageNode, set);
            }
        }
    }

    private Set<PdfIndirectReference> createAllowedReferences(PdfDocument document) {
        PdfDictionary structTreeRoot;
        PdfDictionary pagesDictionary;
        PdfDictionary acroForm;
        PdfDictionary dssDictionary;
        HashSet<PdfIndirectReference> allowedReferences = new HashSet<PdfIndirectReference>();
        if (document.getTrailer().get(PdfName.Info) != null) {
            allowedReferences.add(document.getTrailer().get(PdfName.Info).getIndirectReference());
        }
        if (document.getCatalog().getPdfObject() == null) {
            return allowedReferences;
        }
        allowedReferences.add(((PdfDictionary)document.getCatalog().getPdfObject()).getIndirectReference());
        if (((PdfDictionary)document.getCatalog().getPdfObject()).get(PdfName.Metadata) != null) {
            allowedReferences.add(((PdfDictionary)document.getCatalog().getPdfObject()).get(PdfName.Metadata).getIndirectReference());
        }
        if ((dssDictionary = ((PdfDictionary)document.getCatalog().getPdfObject()).getAsDictionary(PdfName.DSS)) != null) {
            allowedReferences.add(dssDictionary.getIndirectReference());
            allowedReferences.addAll(this.createAllowedDssEntries(document));
        }
        if ((acroForm = ((PdfDictionary)document.getCatalog().getPdfObject()).getAsDictionary(PdfName.AcroForm)) != null) {
            allowedReferences.add(acroForm.getIndirectReference());
            PdfArray fields = acroForm.getAsArray(PdfName.Fields);
            this.createAllowedFormFieldEntries(fields, allowedReferences);
            PdfDictionary resources = acroForm.getAsDictionary(PdfName.DR);
            if (resources != null) {
                allowedReferences.add(resources.getIndirectReference());
                this.addAllNestedDictionaryEntries(allowedReferences, resources);
            }
        }
        if ((pagesDictionary = ((PdfDictionary)document.getCatalog().getPdfObject()).getAsDictionary(PdfName.Pages)) != null) {
            allowedReferences.add(pagesDictionary.getIndirectReference());
            allowedReferences.addAll(this.createAllowedPagesEntries(pagesDictionary));
        }
        if ((structTreeRoot = ((PdfDictionary)document.getCatalog().getPdfObject()).getAsDictionary(PdfName.StructTreeRoot)) != null) {
            allowedReferences.add(structTreeRoot.getIndirectReference());
            allowedReferences.addAll(this.createAllowedStructTreeRootEntries(structTreeRoot));
        }
        return allowedReferences;
    }

    private boolean checkAllowedReferences(Set<PdfIndirectReference> currentAllowedReferences, Set<PdfIndirectReference> previousAllowedReferences, PdfIndirectReference indirectReference, PdfDocument documentWithoutRevision) {
        for (PdfIndirectReference currentAllowedReference : currentAllowedReferences) {
            if (!DocumentRevisionsValidator.isSameReference(currentAllowedReference, indirectReference)) continue;
            return documentWithoutRevision.getPdfObject(indirectReference.getObjNumber()) == null || previousAllowedReferences.stream().anyMatch(reference -> DocumentRevisionsValidator.isSameReference(reference, indirectReference));
        }
        return false;
    }

    private boolean isAllowedStreamObj(PdfIndirectReference indirectReference, PdfDocument document) {
        PdfObject pdfObject = document.getPdfObject(indirectReference.getObjNumber());
        if (pdfObject instanceof PdfStream) {
            PdfName type = ((PdfStream)pdfObject).getAsName(PdfName.Type);
            return PdfName.XRef.equals(type) || PdfName.ObjStm.equals(type);
        }
        return false;
    }

    private Set<PdfIndirectReference> createAllowedDssEntries(PdfDocument document) {
        PdfDictionary vris;
        PdfArray crls;
        PdfArray ocsps;
        HashSet<PdfIndirectReference> allowedReferences = new HashSet<PdfIndirectReference>();
        PdfDictionary dssDictionary = ((PdfDictionary)document.getCatalog().getPdfObject()).getAsDictionary(PdfName.DSS);
        PdfArray certs = dssDictionary.getAsArray(PdfName.Certs);
        if (certs != null) {
            allowedReferences.add(certs.getIndirectReference());
            for (int i = 0; i < certs.size(); ++i) {
                allowedReferences.add(certs.get(i).getIndirectReference());
            }
        }
        if ((ocsps = dssDictionary.getAsArray(PdfName.OCSPs)) != null) {
            allowedReferences.add(ocsps.getIndirectReference());
            for (int i = 0; i < ocsps.size(); ++i) {
                allowedReferences.add(ocsps.get(i).getIndirectReference());
            }
        }
        if ((crls = dssDictionary.getAsArray(PdfName.CRLs)) != null) {
            allowedReferences.add(crls.getIndirectReference());
            for (int i = 0; i < crls.size(); ++i) {
                allowedReferences.add(crls.get(i).getIndirectReference());
            }
        }
        if ((vris = dssDictionary.getAsDictionary(PdfName.VRI)) != null) {
            allowedReferences.add(vris.getIndirectReference());
            for (Map.Entry<PdfName, PdfObject> vri : vris.entrySet()) {
                PdfArray vriCrls;
                PdfArray vriOcsps;
                allowedReferences.add(vri.getValue().getIndirectReference());
                if (!(vri.getValue() instanceof PdfDictionary)) continue;
                PdfDictionary vriDictionary = (PdfDictionary)vri.getValue();
                PdfArray vriCerts = vriDictionary.getAsArray(PdfName.Cert);
                if (vriCerts != null) {
                    allowedReferences.add(vriCerts.getIndirectReference());
                    for (int i = 0; i < vriCerts.size(); ++i) {
                        allowedReferences.add(vriCerts.get(i).getIndirectReference());
                    }
                }
                if ((vriOcsps = vriDictionary.getAsArray(PdfName.OCSP)) != null) {
                    allowedReferences.add(vriOcsps.getIndirectReference());
                    for (int i = 0; i < vriOcsps.size(); ++i) {
                        allowedReferences.add(vriOcsps.get(i).getIndirectReference());
                    }
                }
                if ((vriCrls = vriDictionary.getAsArray(PdfName.CRL)) != null) {
                    allowedReferences.add(vriCrls.getIndirectReference());
                    for (int i = 0; i < vriCrls.size(); ++i) {
                        allowedReferences.add(vriCrls.get(i).getIndirectReference());
                    }
                }
                if (vriDictionary.get(new PdfName("TS")) == null) continue;
                allowedReferences.add(vriDictionary.get(new PdfName("TS")).getIndirectReference());
            }
        }
        return allowedReferences;
    }

    private Set<PdfIndirectReference> createAllowedStructTreeRootEntries(PdfDictionary structTreeRoot) {
        PdfDictionary parentTree;
        HashSet<PdfIndirectReference> allowedReferences = new HashSet<PdfIndirectReference>();
        PdfDictionary idTree = structTreeRoot.getAsDictionary(PdfName.IDTree);
        if (idTree != null) {
            this.createAllowedTreeEntries(idTree, allowedReferences, PdfName.Names);
        }
        if ((parentTree = structTreeRoot.getAsDictionary(PdfName.ParentTree)) != null) {
            this.createAllowedTreeEntries(parentTree, allowedReferences, PdfName.Nums);
        }
        if (structTreeRoot.get(PdfName.K) != null) {
            allowedReferences.add(structTreeRoot.get(PdfName.K).getIndirectReference());
            this.createAllowedStructTreeRootKidsEntries(structTreeRoot.get(PdfName.K), allowedReferences);
        }
        return allowedReferences;
    }

    private void createAllowedTreeEntries(PdfObject treeNode, Set<PdfIndirectReference> allowedReferences, PdfName contentName) {
        PdfArray kids;
        if (!(treeNode instanceof PdfDictionary)) {
            return;
        }
        PdfDictionary treeNodeDictionary = (PdfDictionary)treeNode;
        allowedReferences.add(treeNodeDictionary.getIndirectReference());
        PdfArray content = treeNodeDictionary.getAsArray(contentName);
        if (content != null) {
            allowedReferences.add(content.getIndirectReference());
            for (int i = 1; i < content.size(); i += 2) {
                PdfArray contentArray = content.getAsArray(i);
                if (contentArray == null) continue;
                allowedReferences.add(contentArray.getIndirectReference());
            }
        }
        if ((kids = treeNodeDictionary.getAsArray(PdfName.Kids)) != null) {
            allowedReferences.add(kids.getIndirectReference());
            for (PdfObject kid : kids) {
                this.createAllowedTreeEntries(kid, allowedReferences, contentName);
            }
        }
    }

    private void createAllowedStructTreeRootKidsEntries(PdfObject structTreeRootKids, Set<PdfIndirectReference> allowedReferences) {
        if (structTreeRootKids instanceof PdfArray) {
            allowedReferences.add(structTreeRootKids.getIndirectReference());
            this.createAllowedStructTreeRootKidsEntries((PdfArray)structTreeRootKids, allowedReferences);
        } else {
            this.createAllowedStructTreeRootKidsEntries(new PdfArray(structTreeRootKids), allowedReferences);
        }
    }

    private void createAllowedStructTreeRootKidsEntries(PdfArray structTreeRootKids, Set<PdfIndirectReference> allowedReferences) {
        for (PdfObject kid : structTreeRootKids) {
            if (kid == null) continue;
            allowedReferences.add(kid.getIndirectReference());
            if (!DocumentRevisionsValidator.isStructTreeElement(kid)) continue;
            PdfDictionary structTreeElementCopy = new PdfDictionary((PdfDictionary)kid);
            PdfObject kids = structTreeElementCopy.remove(PdfName.K);
            structTreeElementCopy.remove(PdfName.P);
            structTreeElementCopy.remove(PdfName.Ref);
            structTreeElementCopy.remove(PdfName.Pg);
            this.addAllNestedDictionaryEntries(allowedReferences, structTreeElementCopy);
            if (kids == null) continue;
            this.createAllowedStructTreeRootKidsEntries(kids, allowedReferences);
        }
    }

    private Collection<PdfIndirectReference> createAllowedPagesEntries(PdfDictionary pagesDictionary) {
        HashSet<PdfIndirectReference> allowedReferences = new HashSet<PdfIndirectReference>();
        PdfArray kids = pagesDictionary.getAsArray(PdfName.Kids);
        if (kids != null) {
            allowedReferences.add(kids.getIndirectReference());
            for (int i = 0; i < kids.size(); ++i) {
                PdfDictionary pageNode = kids.getAsDictionary(i);
                allowedReferences.add(kids.get(i).getIndirectReference());
                if (pageNode == null) continue;
                if (PdfName.Pages.equals(pageNode.getAsName(PdfName.Type))) {
                    allowedReferences.addAll(this.createAllowedPagesEntries(pageNode));
                    continue;
                }
                PdfObject annots = pageNode.get(PdfName.Annots);
                if (annots == null) continue;
                allowedReferences.add(annots.getIndirectReference());
                if (this.getAccessPermissions() != AccessPermissions.ANNOTATION_MODIFICATION) continue;
                this.addAllNestedArrayEntries(allowedReferences, (PdfArray)annots);
            }
        }
        return allowedReferences;
    }

    private void createAllowedFormFieldEntries(PdfArray fields, Set<PdfIndirectReference> allowedReferences) {
        if (fields == null) {
            return;
        }
        for (PdfObject field : fields) {
            PdfDictionary fieldDict = (PdfDictionary)field;
            if (PdfFormField.isFormField(fieldDict)) {
                PdfObject value = fieldDict.get(PdfName.V);
                if (this.getAccessPermissions() == AccessPermissions.NO_CHANGES_PERMITTED && (!(value instanceof PdfDictionary) || !PdfName.DocTimeStamp.equals(((PdfDictionary)value).getAsName(PdfName.Type)))) continue;
                allowedReferences.add(fieldDict.getIndirectReference());
                PdfString fieldName = PdfFormCreator.createFormField(fieldDict).getFieldName();
                if (this.newlyAddedFields.contains(fieldDict)) {
                    this.addAllNestedDictionaryEntries(allowedReferences, fieldDict);
                    continue;
                }
                if (fieldName != null && this.lockedFields.contains(fieldName.getValue())) continue;
                if (value != null) {
                    allowedReferences.add(value.getIndirectReference());
                }
                if (PdfFormAnnotationUtil.isPureWidgetOrMergedField(fieldDict)) {
                    this.addWidgetAnnotation(allowedReferences, fieldDict);
                    continue;
                }
                PdfArray kids = fieldDict.getAsArray(PdfName.Kids);
                this.createAllowedFormFieldEntries(kids, allowedReferences);
                continue;
            }
            this.addWidgetAnnotation(allowedReferences, fieldDict);
        }
    }

    private void addWidgetAnnotation(Set<PdfIndirectReference> allowedReferences, PdfDictionary annotDict) {
        allowedReferences.add(annotDict.getIndirectReference());
        if (this.getAccessPermissions() == AccessPermissions.ANNOTATION_MODIFICATION) {
            PdfDictionary pureAnnotDict = new PdfDictionary(annotDict);
            for (PdfName key : annotDict.keySet()) {
                if (!PdfFormField.getFormFieldKeys().contains(key)) continue;
                pureAnnotDict.remove(key);
            }
            this.addAllNestedDictionaryEntries(allowedReferences, pureAnnotDict);
        } else {
            PdfObject timeStamp;
            PdfObject appearanceState;
            PdfObject appearance = annotDict.get(PdfName.AP);
            if (appearance != null) {
                allowedReferences.add(appearance.getIndirectReference());
                if (appearance instanceof PdfDictionary) {
                    this.addAllNestedDictionaryEntries(allowedReferences, (PdfDictionary)appearance);
                }
            }
            if ((appearanceState = annotDict.get(PdfName.AS)) != null) {
                allowedReferences.add(appearanceState.getIndirectReference());
            }
            if ((timeStamp = annotDict.get(PdfName.M)) != null) {
                allowedReferences.add(timeStamp.getIndirectReference());
            }
        }
    }

    private void addAllNestedDictionaryEntries(Set<PdfIndirectReference> allowedReferences, PdfDictionary dictionary) {
        for (Map.Entry<PdfName, PdfObject> entry : dictionary.entrySet()) {
            PdfObject value = entry.getValue();
            if (value.getIndirectReference() != null && allowedReferences.stream().anyMatch(reference -> DocumentRevisionsValidator.isSameReference(reference, value.getIndirectReference()))) continue;
            allowedReferences.add(value.getIndirectReference());
            if (value instanceof PdfDictionary) {
                this.addAllNestedDictionaryEntries(allowedReferences, (PdfDictionary)value);
            }
            if (!(value instanceof PdfArray)) continue;
            this.addAllNestedArrayEntries(allowedReferences, (PdfArray)value);
        }
    }

    private void addAllNestedArrayEntries(Set<PdfIndirectReference> allowedReferences, PdfArray pdfArray) {
        for (int i = 0; i < pdfArray.size(); ++i) {
            PdfObject arrayEntry = pdfArray.get(i);
            if (arrayEntry.getIndirectReference() != null && allowedReferences.stream().anyMatch(reference -> DocumentRevisionsValidator.isSameReference(reference, arrayEntry.getIndirectReference()))) continue;
            allowedReferences.add(arrayEntry.getIndirectReference());
            if (arrayEntry instanceof PdfDictionary) {
                this.addAllNestedDictionaryEntries(allowedReferences, (PdfDictionary)arrayEntry);
            }
            if (!(arrayEntry instanceof PdfArray)) continue;
            this.addAllNestedArrayEntries(allowedReferences, (PdfArray)arrayEntry);
        }
    }
}

