/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.kernel.crypto.DigestAlgorithms;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.signatures.BouncyCastleDigest;
import com.itextpdf.signatures.ICrlClient;
import com.itextpdf.signatures.IExternalSignatureContainer;
import com.itextpdf.signatures.IOcspClient;
import com.itextpdf.signatures.ITSAClient;
import com.itextpdf.signatures.OcspClientBouncyCastle;
import com.itextpdf.signatures.PdfPKCS7;
import com.itextpdf.signatures.PdfSigner;
import com.itextpdf.signatures.PrivateKeySignature;
import com.itextpdf.signatures.SignUtils;
import com.itextpdf.signatures.SignaturePolicyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;

public class PKCS7ExternalSignatureContainer
implements IExternalSignatureContainer {
    private final Certificate[] chain;
    private final PrivateKey privateKey;
    private final String hashAlgorithm;
    private IOcspClient ocspClient;
    private ICrlClient crlClient;
    private ITSAClient tsaClient;
    private PdfSigner.CryptoStandard sigType = PdfSigner.CryptoStandard.CMS;
    private SignaturePolicyInfo signaturePolicy;

    public PKCS7ExternalSignatureContainer(PrivateKey privateKey, Certificate[] chain, String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
        this.chain = chain;
        this.privateKey = privateKey;
    }

    @Override
    public byte[] sign(InputStream data) throws GeneralSecurityException {
        byte[] hash;
        PdfPKCS7 sgn = new PdfPKCS7(null, this.chain, this.hashAlgorithm, null, new BouncyCastleDigest(), false);
        if (this.signaturePolicy != null) {
            sgn.setSignaturePolicy(this.signaturePolicy);
        }
        try {
            hash = DigestAlgorithms.digest(data, SignUtils.getMessageDigest(this.hashAlgorithm));
        }
        catch (IOException e) {
            throw new PdfException(e);
        }
        Collection<byte[]> crlBytes = null;
        int i = 0;
        while (this.crlClient != null && crlBytes == null && i < this.chain.length) {
            crlBytes = this.crlClient.getEncoded((X509Certificate)this.chain[i++], null);
        }
        ArrayList<byte[]> ocspList = new ArrayList<byte[]>();
        if (this.chain.length > 1 && this.ocspClient != null) {
            for (int j = 0; j < this.chain.length - 1; ++j) {
                byte[] ocsp = this.ocspClient.getEncoded((X509Certificate)this.chain[j], (X509Certificate)this.chain[j + 1], null);
                if (ocsp == null || !BouncyCastleFactoryCreator.getFactory().createCertificateStatus().getGood().equals(OcspClientBouncyCastle.getCertificateStatus(ocsp))) continue;
                ocspList.add(ocsp);
            }
        }
        byte[] sh = sgn.getAuthenticatedAttributeBytes(hash, this.sigType, ocspList, crlBytes);
        PrivateKeySignature pkSign = new PrivateKeySignature(this.privateKey, this.hashAlgorithm, BouncyCastleFactoryCreator.getFactory().getProviderName());
        byte[] signData = pkSign.sign(sh);
        sgn.setExternalSignatureValue(signData, null, pkSign.getSignatureAlgorithmName(), pkSign.getSignatureMechanismParameters());
        return sgn.getEncodedPKCS7(hash, this.sigType, this.tsaClient, ocspList, crlBytes);
    }

    @Override
    public void modifySigningDictionary(PdfDictionary signDic) {
        signDic.put(PdfName.Filter, PdfName.Adobe_PPKLite);
        signDic.put(PdfName.SubFilter, this.sigType == PdfSigner.CryptoStandard.CADES ? PdfName.ETSI_CAdES_DETACHED : PdfName.Adbe_pkcs7_detached);
    }

    public void setOcspClient(IOcspClient ocspClient) {
        this.ocspClient = ocspClient;
    }

    public void setCrlClient(ICrlClient crlClient) {
        this.crlClient = crlClient;
    }

    public void setTsaClient(ITSAClient tsaClient) {
        this.tsaClient = tsaClient;
    }

    public void setSignaturePolicy(SignaturePolicyInfo signaturePolicy) {
        this.signaturePolicy = signaturePolicy;
    }

    public void setSignatureType(PdfSigner.CryptoStandard sigType) {
        this.sigType = sigType;
    }
}

