/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.ua2;

import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.pdfua.checkers.utils.ContextAwareTagTreeIteratorHandler;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;

public final class PdfUA2TableOfContentsChecker {
    private final PdfUAValidationContext context;

    public PdfUA2TableOfContentsChecker(PdfUAValidationContext context) {
        this.context = context;
    }

    public void checkRefInTociStructElement(IStructureNode structNode) {
        PdfStructElem toci = this.context.getElementIfRoleMatches(PdfName.TOCI, structNode);
        if (toci == null) {
            return;
        }
        if (!PdfUA2TableOfContentsChecker.isRefPresent(toci)) {
            throw new PdfUAConformanceException("Each TOCI structure element shall contain the Ref entry, either directly on the TOCI structure element itself or on at least one of its descendant structure elements.");
        }
    }

    private static boolean isRefPresent(PdfStructElem toci) {
        if (!toci.getRefsList().isEmpty()) {
            return true;
        }
        for (IStructureNode kid : toci.getKids()) {
            if (!(kid instanceof PdfStructElem) || !PdfUA2TableOfContentsChecker.isRefPresent((PdfStructElem)kid)) continue;
            return true;
        }
        return false;
    }

    public static class PdfUA2TableOfContentsHandler
    extends ContextAwareTagTreeIteratorHandler {
        private final PdfUA2TableOfContentsChecker checker;

        public PdfUA2TableOfContentsHandler(PdfUAValidationContext context) {
            super(context);
            this.checker = new PdfUA2TableOfContentsChecker(context);
        }

        @Override
        public boolean accept(IStructureNode node) {
            return node != null;
        }

        @Override
        public void processElement(IStructureNode elem) {
            this.checker.checkRefInTociStructElement(elem);
        }
    }
}

