/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.ua2;

import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfStructureAttributes;
import com.itextpdf.pdfua.checkers.utils.ContextAwareTagTreeIteratorHandler;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;

public final class PdfUA2ListChecker {
    private final PdfUAValidationContext context;

    public PdfUA2ListChecker(PdfUAValidationContext context) {
        this.context = context;
    }

    public void checkStructElement(IStructureNode structNode) {
        PdfStructElem list = this.context.getElementIfRoleMatches(PdfName.L, structNode);
        if (list == null) {
            return;
        }
        boolean isLblPresent = false;
        for (IStructureNode listItem : list.getKids()) {
            String listItemRole = this.context.resolveToStandardRole(listItem);
            if (!"LI".equals(listItemRole)) continue;
            for (IStructureNode kid : listItem.getKids()) {
                String kidRole = this.context.resolveToStandardRole(kid);
                if ("Lbl".equals(kidRole)) {
                    isLblPresent = true;
                    continue;
                }
                if ("LBody".equals(kidRole) || "Artifact".equals(kidRole)) continue;
                throw new PdfUAConformanceException("Any real content within an LI structure element that is not enclosed in a Lbl structure element shall be enclosed in an LBody structure element.");
            }
        }
        if (isLblPresent) {
            boolean isValidListNumbering = false;
            for (PdfStructureAttributes attribute : list.getAttributesList()) {
                String listNumValue = attribute.getAttributeAsEnum(PdfName.ListNumbering.getValue());
                if (listNumValue == null) continue;
                if (PdfName.None.getValue().equals(listNumValue)) break;
                isValidListNumbering = true;
                break;
            }
            if (!isValidListNumbering) {
                throw new PdfUAConformanceException("If Lbl structure elements are present, the ListNumbering attribute shall be specified for the respective L structure element; the value None shall not be used.");
            }
        }
    }

    public static class PdfUA2ListHandler
    extends ContextAwareTagTreeIteratorHandler {
        private final PdfUA2ListChecker checker;

        public PdfUA2ListHandler(PdfUAValidationContext context) {
            super(context);
            this.checker = new PdfUA2ListChecker(context);
        }

        @Override
        public boolean accept(IStructureNode node) {
            return node != null;
        }

        @Override
        public void processElement(IStructureNode elem) {
            this.checker.checkStructElement(elem);
        }
    }
}

