/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.PdfConformance;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfDocumentInfo;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfUAConformance;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.PdfViewerPreferences;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.StampingProperties;
import com.itextpdf.kernel.validation.IValidationChecker;
import com.itextpdf.kernel.validation.Pdf20Checker;
import com.itextpdf.kernel.validation.ValidationContainer;
import com.itextpdf.layout.tagging.ProhibitedTagRelationsResolver;
import com.itextpdf.pdfua.PdfUAConfig;
import com.itextpdf.pdfua.PdfUAPageFactory;
import com.itextpdf.pdfua.checkers.PdfUA1Checker;
import com.itextpdf.pdfua.checkers.PdfUA2Checker;
import com.itextpdf.pdfua.checkers.PdfUAChecker;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfUADocument
extends PdfDocument {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfUADocument.class);

    public PdfUADocument(PdfWriter writer, PdfUAConfig config) {
        this(writer, new DocumentProperties(), config);
    }

    public PdfUADocument(PdfWriter writer, DocumentProperties properties, PdfUAConfig config) {
        super(PdfUADocument.configureWriterProperties(writer, config.getConformance()), properties);
        this.pdfConformance = new PdfConformance(config.getConformance());
        this.setupUAConfiguration(config);
        ValidationContainer validationContainer = new ValidationContainer();
        List<IValidationChecker> checkers = this.getCorrectCheckerFromConformance(config.getConformance());
        for (IValidationChecker checker : checkers) {
            validationContainer.addChecker(checker);
        }
        this.getDiContainer().register(ValidationContainer.class, validationContainer);
        this.pdfPageFactory = new PdfUAPageFactory(PdfUADocument.getUaChecker(checkers));
        this.getDiContainer().register(ProhibitedTagRelationsResolver.class, new ProhibitedTagRelationsResolver(this));
    }

    public PdfUADocument(PdfReader reader, PdfWriter writer, PdfUAConfig config) {
        this(reader, writer, new StampingProperties(), config);
    }

    public PdfUADocument(PdfReader reader, PdfWriter writer, StampingProperties properties, PdfUAConfig config) {
        super(reader, writer, properties);
        if (!this.getConformance().isPdfUA()) {
            LOGGER.warn("PDF to PDF/UA conversion is not supported.");
        }
        this.setupUAConfiguration(config);
        ValidationContainer validationContainer = new ValidationContainer();
        List<IValidationChecker> checkers = this.getCorrectCheckerFromConformance(config.getConformance());
        for (IValidationChecker checker : checkers) {
            validationContainer.addChecker(checker);
        }
        this.getDiContainer().register(ValidationContainer.class, validationContainer);
        this.pdfPageFactory = new PdfUAPageFactory(PdfUADocument.getUaChecker(checkers));
    }

    private static PdfWriter configureWriterProperties(PdfWriter writer, PdfUAConformance uaConformance) {
        writer.getProperties().addPdfUaXmpMetadata(uaConformance);
        if (writer.getPdfVersion() != null) {
            if (uaConformance == PdfUAConformance.PDF_UA_1 && !writer.getPdfVersion().equals(PdfVersion.PDF_1_7)) {
                LOGGER.warn(MessageFormatUtil.format("Pdf version from writer properties isn't compatible with specified PDF/UA conformance, it was overridden to {0} version.", PdfVersion.PDF_1_7));
                writer.getProperties().setPdfVersion(PdfVersion.PDF_1_7);
            }
            if (uaConformance == PdfUAConformance.PDF_UA_2 && !writer.getPdfVersion().equals(PdfVersion.PDF_2_0)) {
                LOGGER.warn(MessageFormatUtil.format("Pdf version from writer properties isn't compatible with specified PDF/UA conformance, it was overridden to {0} version.", PdfVersion.PDF_2_0));
                writer.getProperties().setPdfVersion(PdfVersion.PDF_2_0);
            }
        }
        return writer;
    }

    private static PdfUAChecker getUaChecker(List<IValidationChecker> checkers) {
        for (IValidationChecker checker : checkers) {
            if (!(checker instanceof PdfUAChecker)) continue;
            return (PdfUAChecker)checker;
        }
        return null;
    }

    private void setupUAConfiguration(PdfUAConfig config) {
        this.setTagged();
        this.getCatalog().setViewerPreferences(new PdfViewerPreferences().setDisplayDocTitle(true));
        this.getCatalog().setLang(new PdfString(config.getLanguage()));
        PdfDocumentInfo info = this.getDocumentInfo();
        info.setTitle(config.getTitle());
    }

    private List<IValidationChecker> getCorrectCheckerFromConformance(PdfUAConformance uaConformance) {
        ArrayList<IValidationChecker> checkers = new ArrayList<IValidationChecker>();
        switch (uaConformance.getPart()) {
            case "1": {
                checkers.add(new PdfUA1Checker(this));
                break;
            }
            case "2": {
                checkers.add(new PdfUA2Checker(this));
                checkers.add(new Pdf20Checker(this));
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot find an appropriate PDF/UA checker for the specified conformance.");
            }
        }
        return checkers;
    }
}

