/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.commons.actions.sequence.SequenceId;
import com.itextpdf.commons.datastructures.Tuple2;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.font.FontMetrics;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.util.EnumUtil;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfType0Font;
import com.itextpdf.kernel.font.PdfType1Font;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.font.FontCharacteristics;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.font.FontSet;
import com.itextpdf.layout.font.selectorstrategy.IFontSelectorStrategy;
import com.itextpdf.layout.hyphenation.Hyphenation;
import com.itextpdf.layout.hyphenation.HyphenationConfig;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.TextLayoutResult;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.properties.BaseDirection;
import com.itextpdf.layout.properties.FloatPropertyValue;
import com.itextpdf.layout.properties.FontKerning;
import com.itextpdf.layout.properties.IBeforeTextRestoreExecutor;
import com.itextpdf.layout.properties.OverflowPropertyValue;
import com.itextpdf.layout.properties.OverflowWrapPropertyValue;
import com.itextpdf.layout.properties.RenderingMode;
import com.itextpdf.layout.properties.TransparentColor;
import com.itextpdf.layout.properties.Underline;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AbstractWidthHandler;
import com.itextpdf.layout.renderer.AccessibleAttributesApplier;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.FloatingHelper;
import com.itextpdf.layout.renderer.ILeafElementRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.MaxSumWidthHandler;
import com.itextpdf.layout.renderer.MetaInfoContainer;
import com.itextpdf.layout.renderer.SumSumWidthHandler;
import com.itextpdf.layout.renderer.TargetCounterHandler;
import com.itextpdf.layout.renderer.TextPreprocessingUtil;
import com.itextpdf.layout.renderer.TypographyUtils;
import com.itextpdf.layout.splitting.BreakAllSplitCharacters;
import com.itextpdf.layout.splitting.ISplitCharacters;
import com.itextpdf.layout.tagging.LayoutTaggingHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextRenderer
extends AbstractRenderer
implements ILeafElementRenderer {
    protected static final float TEXT_SPACE_COEFF = 1000.0f;
    static final float TYPO_ASCENDER_SCALE_COEFF = 1.2f;
    static final int UNDEFINED_FIRST_CHAR_TO_FORCE_OVERFLOW = Integer.MAX_VALUE;
    private static final float ITALIC_ANGLE = 0.21256f;
    private static final float BOLD_SIMULATION_STROKE_COEFF = 0.033333335f;
    private static final float HEIGHT_EPS = 0.051f;
    protected float yLineOffset;
    private PdfFont font;
    protected GlyphLine text;
    protected GlyphLine line;
    protected String strToBeConverted;
    protected boolean otfFeaturesApplied = false;
    protected float tabAnchorCharacterPosition = -1.0f;
    protected List<int[]> reversedRanges;
    protected GlyphLine savedWordBreakAtLineEnding;
    private List<Integer> specialScriptsWordBreakPoints;
    private int specialScriptFirstNotFittingIndex = -1;
    private int indexOfFirstCharacterToBeForcedToOverflow = Integer.MAX_VALUE;

    public TextRenderer(Text textElement) {
        this(textElement, textElement.getText());
    }

    public TextRenderer(Text textElement, String text) {
        super(textElement);
        this.strToBeConverted = text;
    }

    protected TextRenderer(TextRenderer other) {
        super(other);
        this.text = other.text;
        this.line = other.line;
        this.font = other.font;
        this.yLineOffset = other.yLineOffset;
        this.strToBeConverted = other.strToBeConverted;
        this.otfFeaturesApplied = other.otfFeaturesApplied;
        this.tabAnchorCharacterPosition = other.tabAnchorCharacterPosition;
        this.reversedRanges = other.reversedRanges;
        this.specialScriptsWordBreakPoints = other.specialScriptsWordBreakPoints;
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        int firstPrintPos;
        boolean overflowWrapNotNormal;
        this.updateFontAndText();
        LayoutArea area = layoutContext.getArea();
        Rectangle layoutBox = area.getBBox().clone();
        boolean noSoftWrap = Boolean.TRUE.equals(this.parent.getOwnProperty(118));
        OverflowPropertyValue overflowX = (OverflowPropertyValue)((Object)this.parent.getProperty(103));
        OverflowWrapPropertyValue overflowWrap = (OverflowWrapPropertyValue)((Object)this.getProperty(102));
        boolean bl = overflowWrapNotNormal = overflowWrap == OverflowWrapPropertyValue.ANYWHERE || overflowWrap == OverflowWrapPropertyValue.BREAK_WORD;
        if (overflowWrapNotNormal) {
            overflowX = OverflowPropertyValue.FIT;
        }
        List<Rectangle> floatRendererAreas = layoutContext.getFloatRendererAreas();
        FloatPropertyValue floatPropertyValue = (FloatPropertyValue)((Object)this.getProperty(99));
        if (FloatingHelper.isRendererFloating(this, floatPropertyValue)) {
            FloatingHelper.adjustFloatedBlockLayoutBox(this, layoutBox, null, floatRendererAreas, floatPropertyValue, overflowX);
        }
        float preMarginBorderPaddingWidth = layoutBox.getWidth();
        UnitValue[] margins = this.getMargins();
        this.applyMargins(layoutBox, margins, false);
        Border[] borders = this.getBorders();
        this.applyBorderBox(layoutBox, borders, false);
        UnitValue[] paddings = this.getPaddings();
        this.applyPaddings(layoutBox, paddings, false);
        MinMaxWidth countedMinMaxWidth = new MinMaxWidth(preMarginBorderPaddingWidth - layoutBox.getWidth());
        AbstractWidthHandler widthHandler = noSoftWrap ? new SumSumWidthHandler(countedMinMaxWidth) : new MaxSumWidthHandler(countedMinMaxWidth);
        float leftMinWidth = -1.0f;
        float[] leftMarginBorderPadding = new float[]{margins[3].getValue(), borders[3] == null ? 0.0f : borders[3].getWidth(), paddings[3].getValue()};
        float rightMinWidth = -1.0f;
        float[] rightMarginBorderPadding = new float[]{margins[1].getValue(), borders[1] == null ? 0.0f : borders[1].getWidth(), paddings[1].getValue()};
        this.occupiedArea = new LayoutArea(area.getPageNumber(), new Rectangle(layoutBox.getX(), layoutBox.getY() + layoutBox.getHeight(), 0.0f, 0.0f));
        TargetCounterHandler.addPageByID(this);
        boolean anythingPlaced = false;
        int currentTextPos = this.text.getStart();
        UnitValue fontSize = this.getPropertyAsUnitValue(24);
        if (!fontSize.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(TextRenderer.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 24));
        }
        float textRise = this.getPropertyAsFloat(72).floatValue();
        Float characterSpacing = this.getPropertyAsFloat(15);
        Float wordSpacing = this.getPropertyAsFloat(78);
        float hScale = this.getProperty(29, Float.valueOf(1.0f)).floatValue();
        ISplitCharacters splitCharacters = (ISplitCharacters)this.getProperty(62);
        float italicSkewAddition = Boolean.TRUE.equals(this.getPropertyAsBoolean(31)) ? 0.21256f * fontSize.getValue() : 0.0f;
        float boldSimulationAddition = Boolean.TRUE.equals(this.getPropertyAsBoolean(8)) ? 0.033333335f * fontSize.getValue() : 0.0f;
        this.line = new GlyphLine(this.text);
        this.line.setStart(-1);
        this.line.setEnd(-1);
        float ascender = 0.0f;
        float descender = 0.0f;
        float currentLineAscender = 0.0f;
        float currentLineDescender = 0.0f;
        float currentLineHeight = 0.0f;
        int initialLineTextPos = currentTextPos;
        float currentLineWidth = 0.0f;
        int previousCharPos = -1;
        RenderingMode mode = (RenderingMode)((Object)this.getProperty(123));
        float[] ascenderDescender = TextRenderer.calculateAscenderDescender(this.font, mode);
        ascender = ascenderDescender[0];
        descender = ascenderDescender[1];
        if (RenderingMode.HTML_MODE.equals((Object)mode)) {
            currentLineAscender = ascenderDescender[0];
            currentLineDescender = ascenderDescender[1];
            currentLineHeight = (currentLineAscender - currentLineDescender) * FontProgram.convertTextSpaceToGlyphSpace(fontSize.getValue()) + textRise;
        }
        this.savedWordBreakAtLineEnding = null;
        Glyph wordBreakGlyphAtLineEnding = null;
        Character tabAnchorCharacter = (Character)this.getProperty(66);
        TextLayoutResult result = null;
        OverflowPropertyValue overflowY = !layoutContext.isClippedHeight() ? OverflowPropertyValue.FIT : (OverflowPropertyValue)((Object)this.parent.getProperty(104));
        boolean isSplitForcedByNewLine = false;
        boolean forcePartialSplitOnFirstChar = false;
        boolean ignoreNewLineSymbol = false;
        boolean crlf = false;
        boolean containsPossibleBreak = false;
        HyphenationConfig hyphenationConfig = (HyphenationConfig)this.getProperty(30);
        for (firstPrintPos = currentTextPos; firstPrintPos < this.text.getEnd() && TextRenderer.noPrint(this.text.get(firstPrintPos)); ++firstPrintPos) {
        }
        while (currentTextPos < this.text.getEnd()) {
            boolean specialScriptWordSplit;
            if (TextRenderer.noPrint(this.text.get(currentTextPos))) {
                if (this.line.getStart() == -1) {
                    this.line.setStart(currentTextPos);
                }
                this.line.setEnd(Math.max(this.line.getEnd(), currentTextPos + 1));
                ++currentTextPos;
                continue;
            }
            int nonBreakablePartEnd = this.text.getEnd() - 1;
            float nonBreakablePartFullWidth = 0.0f;
            float nonBreakablePartWidthWhichDoesNotExceedAllowedWidth = 0.0f;
            float nonBreakablePartMaxAscender = 0.0f;
            float nonBreakablePartMaxDescender = 0.0f;
            float nonBreakablePartMaxHeight = 0.0f;
            int firstCharacterWhichExceedsAllowedWidth = -1;
            float nonBreakingHyphenRelatedChunkWidth = 0.0f;
            int nonBreakingHyphenRelatedChunkStart = -1;
            float beforeNonBreakingHyphenRelatedChunkMaxAscender = 0.0f;
            float beforeNonBreakingHyphenRelatedChunkMaxDescender = 0.0f;
            for (int ind = currentTextPos; ind < this.text.getEnd(); ++ind) {
                boolean endOfNonBreakablePartCausedBySplitCharacter;
                float potentialWidth;
                boolean symbolNotFitOnLine;
                float xAdvance;
                if (TextUtil.isNewLine(this.text.get(ind))) {
                    containsPossibleBreak = true;
                    wordBreakGlyphAtLineEnding = this.text.get(ind);
                    isSplitForcedByNewLine = true;
                    firstCharacterWhichExceedsAllowedWidth = ind + 1;
                    if (ind != firstPrintPos) {
                        ignoreNewLineSymbol = true;
                    } else {
                        forcePartialSplitOnFirstChar = true;
                    }
                    if (this.line.getStart() == -1) {
                        this.line.setStart(currentTextPos);
                    }
                    if (crlf = TextUtil.isCarriageReturnFollowedByLineFeed(this.text, currentTextPos)) {
                        ++currentTextPos;
                    }
                    this.line.setEnd(Math.max(this.line.getEnd(), firstCharacterWhichExceedsAllowedWidth - 1));
                    break;
                }
                Glyph currentGlyph = this.text.get(ind);
                if (TextRenderer.noPrint(currentGlyph)) {
                    boolean nextGlyphIsSpaceOrWhiteSpace;
                    boolean bl2 = nextGlyphIsSpaceOrWhiteSpace = ind + 1 < this.text.getEnd() && splitCharacters.isSplitCharacter(this.text, ind + 1) && TextUtil.isSpaceOrWhitespace(this.text.get(ind + 1));
                    if (nextGlyphIsSpaceOrWhiteSpace && firstCharacterWhichExceedsAllowedWidth == -1) {
                        containsPossibleBreak = true;
                    }
                    if (ind + 1 != this.text.getEnd() && !nextGlyphIsSpaceOrWhiteSpace && ind + 1 < this.indexOfFirstCharacterToBeForcedToOverflow) continue;
                    if (ind + 1 >= this.indexOfFirstCharacterToBeForcedToOverflow) {
                        firstCharacterWhichExceedsAllowedWidth = currentTextPos;
                        break;
                    }
                    nonBreakablePartEnd = ind;
                    break;
                }
                if (tabAnchorCharacter != null && tabAnchorCharacter.charValue() == this.text.get(ind).getUnicode()) {
                    this.tabAnchorCharacterPosition = currentLineWidth + nonBreakablePartFullWidth;
                    tabAnchorCharacter = null;
                }
                float glyphWidth = FontProgram.convertTextSpaceToGlyphSpace(this.getCharWidth(currentGlyph, fontSize.getValue(), Float.valueOf(hScale), characterSpacing, wordSpacing));
                float f = xAdvance = previousCharPos != -1 ? (float)this.text.get(previousCharPos).getXAdvance() : 0.0f;
                if (xAdvance != 0.0f) {
                    xAdvance = FontProgram.convertTextSpaceToGlyphSpace(this.scaleXAdvance(xAdvance, fontSize.getValue(), Float.valueOf(hScale)));
                }
                boolean bl3 = symbolNotFitOnLine = (potentialWidth = nonBreakablePartFullWidth + glyphWidth + xAdvance + italicSkewAddition + boldSimulationAddition) > layoutBox.getWidth() - currentLineWidth + 1.0E-4f;
                if (!noSoftWrap && symbolNotFitOnLine && firstCharacterWhichExceedsAllowedWidth == -1 || ind == this.specialScriptFirstNotFittingIndex) {
                    firstCharacterWhichExceedsAllowedWidth = ind;
                    boolean spaceOrWhitespace = TextUtil.isSpaceOrWhitespace(this.text.get(ind));
                    OverflowPropertyValue parentOverflowX = (OverflowPropertyValue)((Object)this.parent.getProperty(103));
                    if (spaceOrWhitespace || overflowWrapNotNormal && !TextRenderer.isOverflowFit(parentOverflowX)) {
                        if (spaceOrWhitespace) {
                            wordBreakGlyphAtLineEnding = currentGlyph;
                        }
                        if (ind == firstPrintPos) {
                            containsPossibleBreak = true;
                            forcePartialSplitOnFirstChar = true;
                            firstCharacterWhichExceedsAllowedWidth = ind + 1;
                            break;
                        }
                    }
                }
                if (null != hyphenationConfig) {
                    if (TextRenderer.glyphBelongsToNonBreakingHyphenRelatedChunk(this.text, ind)) {
                        if (-1 == nonBreakingHyphenRelatedChunkStart) {
                            beforeNonBreakingHyphenRelatedChunkMaxAscender = nonBreakablePartMaxAscender;
                            beforeNonBreakingHyphenRelatedChunkMaxDescender = nonBreakablePartMaxDescender;
                            nonBreakingHyphenRelatedChunkStart = ind;
                        }
                        nonBreakingHyphenRelatedChunkWidth += glyphWidth + xAdvance;
                    } else {
                        nonBreakingHyphenRelatedChunkStart = -1;
                        nonBreakingHyphenRelatedChunkWidth = 0.0f;
                    }
                }
                if (firstCharacterWhichExceedsAllowedWidth == -1 || !TextRenderer.isOverflowFit(overflowX)) {
                    nonBreakablePartWidthWhichDoesNotExceedAllowedWidth += glyphWidth + xAdvance;
                }
                nonBreakablePartFullWidth += glyphWidth + xAdvance;
                nonBreakablePartMaxAscender = Math.max(nonBreakablePartMaxAscender, ascender);
                nonBreakablePartMaxDescender = Math.min(nonBreakablePartMaxDescender, descender);
                nonBreakablePartMaxHeight = FontProgram.convertTextSpaceToGlyphSpace((nonBreakablePartMaxAscender - nonBreakablePartMaxDescender) * fontSize.getValue()) + textRise;
                previousCharPos = ind;
                if (!noSoftWrap && symbolNotFitOnLine && (0.0f == nonBreakingHyphenRelatedChunkWidth || ind + 1 == this.text.getEnd() || !TextRenderer.glyphBelongsToNonBreakingHyphenRelatedChunk(this.text, ind + 1)) && TextRenderer.isOverflowFit(overflowX)) break;
                if (OverflowWrapPropertyValue.ANYWHERE == overflowWrap) {
                    float childMinWidth = (float)((double)glyphWidth + (double)xAdvance + (double)italicSkewAddition + (double)boldSimulationAddition);
                    if (leftMinWidth == -1.0f) {
                        leftMinWidth = childMinWidth;
                    } else {
                        rightMinWidth = childMinWidth;
                    }
                    widthHandler.updateMinChildWidth(childMinWidth);
                    widthHandler.updateMaxChildWidth((float)((double)glyphWidth + (double)xAdvance));
                }
                boolean endOfWordBelongingToSpecialScripts = this.textContainsSpecialScriptGlyphs(true) && TextRenderer.findPossibleBreaksSplitPosition(this.specialScriptsWordBreakPoints, ind + 1, true) >= 0;
                boolean bl4 = endOfNonBreakablePartCausedBySplitCharacter = splitCharacters.isSplitCharacter(this.text, ind) || ind + 1 < this.text.getEnd() && splitCharacters.isSplitCharacter(this.text, ind + 1) && TextUtil.isSpaceOrWhitespace(this.text.get(ind + 1));
                if (endOfNonBreakablePartCausedBySplitCharacter && firstCharacterWhichExceedsAllowedWidth == -1) {
                    containsPossibleBreak = true;
                }
                if (ind + 1 != this.text.getEnd() && !endOfNonBreakablePartCausedBySplitCharacter && !endOfWordBelongingToSpecialScripts && ind + 1 < this.indexOfFirstCharacterToBeForcedToOverflow) continue;
                if (ind + 1 >= this.indexOfFirstCharacterToBeForcedToOverflow && !endOfNonBreakablePartCausedBySplitCharacter) {
                    firstCharacterWhichExceedsAllowedWidth = currentTextPos;
                }
                nonBreakablePartEnd = ind;
                break;
            }
            if (firstCharacterWhichExceedsAllowedWidth == -1) {
                if (this.line.getStart() == -1) {
                    this.line.setStart(currentTextPos);
                }
                this.line.setEnd(Math.max(this.line.getEnd(), nonBreakablePartEnd + 1));
                currentLineAscender = Math.max(currentLineAscender, nonBreakablePartMaxAscender);
                currentLineDescender = Math.min(currentLineDescender, nonBreakablePartMaxDescender);
                currentLineHeight = Math.max(currentLineHeight, nonBreakablePartMaxHeight);
                currentTextPos = nonBreakablePartEnd + 1;
                currentLineWidth += nonBreakablePartFullWidth;
                if (OverflowWrapPropertyValue.ANYWHERE == overflowWrap) {
                    widthHandler.updateMaxChildWidth((float)((double)italicSkewAddition + (double)boldSimulationAddition));
                } else {
                    float childMinWidth = (float)((double)nonBreakablePartWidthWhichDoesNotExceedAllowedWidth + (double)italicSkewAddition + (double)boldSimulationAddition);
                    if (leftMinWidth == -1.0f) {
                        leftMinWidth = childMinWidth;
                    } else {
                        rightMinWidth = childMinWidth;
                    }
                    widthHandler.updateMinChildWidth(childMinWidth);
                    widthHandler.updateMaxChildWidth(childMinWidth);
                }
                anythingPlaced = true;
                continue;
            }
            if (Math.max(currentLineHeight, nonBreakablePartMaxHeight) > layoutBox.getHeight() && TextRenderer.isOverflowFit(overflowY)) {
                this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
                this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
                this.applyMargins(this.occupiedArea.getBBox(), margins, true);
                if (this.line.getStart() == -1) {
                    this.line.setStart(currentTextPos);
                }
                this.line.setEnd(Math.max(this.line.getEnd(), firstCharacterWhichExceedsAllowedWidth));
                TextRenderer[] splitResult = this.split(initialLineTextPos);
                boolean[] startsEnds = this.isStartsWithSplitCharWhiteSpaceAndEndsWithSplitChar(splitCharacters);
                return new TextLayoutResult(3, this.occupiedArea, splitResult[0], splitResult[1], this).setContainsPossibleBreak(containsPossibleBreak).setStartsWithSplitCharacterWhiteSpace(startsEnds[0]).setEndsWithSplitCharacter(startsEnds[1]);
            }
            boolean wordSplit = false;
            boolean hyphenationApplied = false;
            if (hyphenationConfig != null && this.indexOfFirstCharacterToBeForcedToOverflow == Integer.MAX_VALUE) {
                if (-1 == nonBreakingHyphenRelatedChunkStart) {
                    String word;
                    Hyphenation hyph;
                    int[] wordBounds = this.getWordBoundsForHyphenation(this.text, currentTextPos, this.text.getEnd(), Math.max(currentTextPos, firstCharacterWhichExceedsAllowedWidth - 1));
                    if (wordBounds != null && (hyph = hyphenationConfig.hyphenate(word = this.text.toUnicodeString(wordBounds[0], wordBounds[1]))) != null) {
                        for (int i = hyph.length() - 1; i >= 0; --i) {
                            float currentHyphenationChoicePreTextWidth;
                            String pre = hyph.getPreHyphenText(i);
                            String pos = hyph.getPostHyphenText(i);
                            char hyphen = hyphenationConfig.getHyphenSymbol();
                            String glyphLine = this.text.toUnicodeString(currentTextPos, wordBounds[0]) + pre;
                            if (this.font.containsGlyph(hyphen)) {
                                glyphLine = glyphLine + hyphen;
                            }
                            if (!(currentLineWidth + (currentHyphenationChoicePreTextWidth = this.getGlyphLineWidth(this.convertToGlyphLine(glyphLine), fontSize.getValue(), hScale, characterSpacing, wordSpacing)) + italicSkewAddition + boldSimulationAddition <= layoutBox.getWidth())) continue;
                            hyphenationApplied = true;
                            if (this.line.getStart() == -1) {
                                this.line.setStart(currentTextPos);
                            }
                            this.line.setEnd(Math.max(this.line.getEnd(), wordBounds[0] + pre.length()));
                            if (this.font.containsGlyph(hyphen)) {
                                GlyphLine lineCopy = this.line.copy(this.line.getStart(), this.line.getEnd());
                                lineCopy.add(this.font.getGlyph(hyphen));
                                lineCopy.setEnd(lineCopy.getEnd() + 1);
                                this.line = lineCopy;
                            }
                            currentLineAscender = Math.max(currentLineAscender, nonBreakablePartMaxAscender);
                            currentLineDescender = Math.min(currentLineDescender, nonBreakablePartMaxDescender);
                            currentLineHeight = Math.max(currentLineHeight, nonBreakablePartMaxHeight);
                            currentLineWidth += currentHyphenationChoicePreTextWidth;
                            if (OverflowWrapPropertyValue.ANYWHERE == overflowWrap) {
                                widthHandler.updateMaxChildWidth((float)((double)italicSkewAddition + (double)boldSimulationAddition));
                            } else {
                                widthHandler.updateMinChildWidth((float)((double)currentHyphenationChoicePreTextWidth + (double)italicSkewAddition + (double)boldSimulationAddition));
                                widthHandler.updateMaxChildWidth((float)((double)currentHyphenationChoicePreTextWidth + (double)italicSkewAddition + (double)boldSimulationAddition));
                            }
                            currentTextPos = wordBounds[0] + pre.length();
                            break;
                        }
                    }
                } else if (this.text.getStart() == nonBreakingHyphenRelatedChunkStart) {
                    nonBreakingHyphenRelatedChunkWidth = 0.0f;
                    firstCharacterWhichExceedsAllowedWidth = previousCharPos + 1;
                } else {
                    firstCharacterWhichExceedsAllowedWidth = nonBreakingHyphenRelatedChunkStart;
                    nonBreakablePartFullWidth -= nonBreakingHyphenRelatedChunkWidth;
                    nonBreakablePartMaxAscender = beforeNonBreakingHyphenRelatedChunkMaxAscender;
                    nonBreakablePartMaxDescender = beforeNonBreakingHyphenRelatedChunkMaxDescender;
                }
            }
            boolean bl5 = specialScriptWordSplit = this.textContainsSpecialScriptGlyphs(true) && !isSplitForcedByNewLine && TextRenderer.isOverflowFit(overflowX);
            if (nonBreakablePartFullWidth + italicSkewAddition + boldSimulationAddition > layoutBox.getWidth() && !anythingPlaced && !hyphenationApplied || forcePartialSplitOnFirstChar || -1 != nonBreakingHyphenRelatedChunkStart || specialScriptWordSplit) {
                if (this.line.getStart() == -1) {
                    this.line.setStart(currentTextPos);
                }
                if (!crlf) {
                    currentTextPos = forcePartialSplitOnFirstChar || TextRenderer.isOverflowFit(overflowX) || specialScriptWordSplit ? firstCharacterWhichExceedsAllowedWidth : nonBreakablePartEnd + 1;
                }
                this.line.setEnd(Math.max(this.line.getEnd(), currentTextPos));
                boolean bl6 = wordSplit = !forcePartialSplitOnFirstChar && this.text.getEnd() != currentTextPos;
                if (wordSplit || !forcePartialSplitOnFirstChar && !TextRenderer.isOverflowFit(overflowX)) {
                    currentLineAscender = Math.max(currentLineAscender, nonBreakablePartMaxAscender);
                    currentLineDescender = Math.min(currentLineDescender, nonBreakablePartMaxDescender);
                    currentLineHeight = Math.max(currentLineHeight, nonBreakablePartMaxHeight);
                    currentLineWidth += nonBreakablePartWidthWhichDoesNotExceedAllowedWidth;
                    if (OverflowWrapPropertyValue.ANYWHERE == overflowWrap) {
                        widthHandler.updateMaxChildWidth((float)((double)italicSkewAddition + (double)boldSimulationAddition));
                    } else {
                        float childMinWidth = (float)((double)nonBreakablePartWidthWhichDoesNotExceedAllowedWidth + (double)italicSkewAddition + (double)boldSimulationAddition);
                        if (leftMinWidth == -1.0f) {
                            leftMinWidth = childMinWidth;
                        } else {
                            rightMinWidth = childMinWidth;
                        }
                        widthHandler.updateMinChildWidth(childMinWidth);
                        widthHandler.updateMaxChildWidth(childMinWidth);
                    }
                } else {
                    currentLineAscender = ascender;
                    currentLineDescender = descender;
                    currentLineHeight = FontProgram.convertTextSpaceToGlyphSpace((currentLineAscender - currentLineDescender) * fontSize.getValue()) + textRise;
                    currentLineWidth += FontProgram.convertTextSpaceToGlyphSpace(this.getCharWidth(this.line.get(this.line.getStart()), fontSize.getValue(), Float.valueOf(hScale), characterSpacing, wordSpacing));
                }
            }
            if (this.line.getEnd() <= this.line.getStart()) {
                boolean[] startsEnds = this.isStartsWithSplitCharWhiteSpaceAndEndsWithSplitChar(splitCharacters);
                return new TextLayoutResult(3, this.occupiedArea, null, this, this).setContainsPossibleBreak(containsPossibleBreak).setStartsWithSplitCharacterWhiteSpace(startsEnds[0]).setEndsWithSplitCharacter(startsEnds[1]);
            }
            result = new TextLayoutResult(2, this.occupiedArea, null, null).setWordHasBeenSplit(wordSplit).setContainsPossibleBreak(containsPossibleBreak);
            break;
        }
        boolean isPlacingForcedWhileNothing = false;
        if (currentLineHeight > layoutBox.getHeight() + 0.051f) {
            if (!Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) && TextRenderer.isOverflowFit(overflowY)) {
                this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
                this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
                this.applyMargins(this.occupiedArea.getBBox(), margins, true);
                boolean[] startsEnds = this.isStartsWithSplitCharWhiteSpaceAndEndsWithSplitChar(splitCharacters);
                return new TextLayoutResult(3, this.occupiedArea, null, this, this).setContainsPossibleBreak(containsPossibleBreak).setStartsWithSplitCharacterWhiteSpace(startsEnds[0]).setEndsWithSplitCharacter(startsEnds[1]);
            }
            isPlacingForcedWhileNothing = true;
        }
        this.yLineOffset = RenderingMode.SVG_MODE == mode ? 0.0f : FontProgram.convertTextSpaceToGlyphSpace(currentLineAscender * fontSize.getValue());
        this.occupiedArea.getBBox().moveDown(currentLineHeight);
        this.occupiedArea.getBBox().setHeight(this.occupiedArea.getBBox().getHeight() + currentLineHeight);
        this.occupiedArea.getBBox().setWidth(Math.max(this.occupiedArea.getBBox().getWidth(), currentLineWidth));
        layoutBox.setHeight(area.getBBox().getHeight() - currentLineHeight);
        this.occupiedArea.getBBox().setWidth(this.occupiedArea.getBBox().getWidth() + italicSkewAddition + boldSimulationAddition);
        this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
        this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
        this.applyMargins(this.occupiedArea.getBBox(), margins, true);
        this.increaseYLineOffset(paddings, borders, margins);
        if (result == null) {
            result = new TextLayoutResult(1, this.occupiedArea, null, null, isPlacingForcedWhileNothing ? this : null).setContainsPossibleBreak(containsPossibleBreak);
        } else {
            TextRenderer[] split = ignoreNewLineSymbol || crlf ? this.splitIgnoreFirstNewLine(currentTextPos) : this.split(currentTextPos);
            result.setSplitForcedByNewline(isSplitForcedByNewLine);
            result.setSplitRenderer(split[0]);
            if (wordBreakGlyphAtLineEnding != null) {
                split[0].saveWordBreakIfNotYetSaved(wordBreakGlyphAtLineEnding);
            }
            if (split[1].text.getStart() != split[1].text.getEnd()) {
                result.setOverflowRenderer(split[1]);
            } else {
                result.setStatus(1);
            }
        }
        if (FloatingHelper.isRendererFloating(this, floatPropertyValue)) {
            if (result.getStatus() == 1) {
                if (this.occupiedArea.getBBox().getWidth() > 0.0f) {
                    floatRendererAreas.add(this.occupiedArea.getBBox());
                }
            } else if (result.getStatus() == 2) {
                floatRendererAreas.add(result.getSplitRenderer().getOccupiedArea().getBBox());
            }
        }
        result.setMinMaxWidth(countedMinMaxWidth);
        if (!noSoftWrap) {
            for (float dimension : leftMarginBorderPadding) {
                leftMinWidth += dimension;
            }
            for (float dimension : rightMarginBorderPadding) {
                if (rightMinWidth < 0.0f) {
                    leftMinWidth += dimension;
                    continue;
                }
                rightMinWidth += dimension;
            }
            result.setLeftMinWidth(leftMinWidth);
            result.setRightMinWidth(rightMinWidth);
        } else {
            result.setLeftMinWidth(countedMinMaxWidth.getMinWidth());
            result.setRightMinWidth(-1.0f);
        }
        boolean[] startsEnds = this.isStartsWithSplitCharWhiteSpaceAndEndsWithSplitChar(splitCharacters);
        result.setStartsWithSplitCharacterWhiteSpace(startsEnds[0]).setEndsWithSplitCharacter(startsEnds[1]);
        return result;
    }

    private void increaseYLineOffset(UnitValue[] paddings, Border[] borders, UnitValue[] margins) {
        this.yLineOffset += paddings[0] != null ? paddings[0].getValue() : 0.0f;
        this.yLineOffset += borders[0] != null ? borders[0].getWidth() : 0.0f;
        this.yLineOffset += margins[0] != null ? margins[0].getValue() : 0.0f;
    }

    public void applyOtf() {
        this.updateFontAndText();
        Character.UnicodeScript script = (Character.UnicodeScript)((Object)this.getProperty(23));
        if (!this.otfFeaturesApplied && TypographyUtils.isPdfCalligraphAvailable() && this.text.getStart() < this.text.getEnd()) {
            FontKerning fontKerning;
            IMetaInfo metaInfo;
            PdfDocument pdfDocument = this.getPdfDocument();
            SequenceId sequenceId = pdfDocument == null ? null : pdfDocument.getDocumentIdWrapper();
            MetaInfoContainer metaInfoContainer = (MetaInfoContainer)this.getProperty(135);
            IMetaInfo iMetaInfo = metaInfo = metaInfoContainer == null ? null : metaInfoContainer.getMetaInfo();
            if (this.hasOtfFont()) {
                Object typographyConfig = this.getProperty(117);
                Collection<Character.UnicodeScript> supportedScripts = null;
                if (typographyConfig != null) {
                    supportedScripts = TypographyUtils.getSupportedScripts(typographyConfig);
                }
                if (supportedScripts == null) {
                    supportedScripts = TypographyUtils.getSupportedScripts();
                }
                ArrayList<ScriptRange> scriptsRanges = new ArrayList<ScriptRange>();
                if (script != null) {
                    scriptsRanges.add(new ScriptRange(script, this.text.getEnd()));
                } else {
                    ScriptRange currRange = new ScriptRange(null, this.text.getEnd());
                    scriptsRanges.add(currRange);
                    for (int i = this.text.getStart(); i < this.text.getEnd(); ++i) {
                        Character.UnicodeScript glyphScript;
                        int unicode = this.text.get(i).getUnicode();
                        if (unicode <= -1 || Character.UnicodeScript.COMMON.equals((Object)(glyphScript = Character.UnicodeScript.of(unicode))) || Character.UnicodeScript.UNKNOWN.equals((Object)glyphScript) || Character.UnicodeScript.INHERITED.equals((Object)glyphScript) || glyphScript == currRange.script) continue;
                        if (currRange.script == null) {
                            currRange.script = glyphScript;
                            continue;
                        }
                        currRange.rangeEnd = i;
                        currRange = new ScriptRange(glyphScript, this.text.getEnd());
                        scriptsRanges.add(currRange);
                    }
                }
                int delta = 0;
                int origTextStart = this.text.getStart();
                int origTextEnd = this.text.getEnd();
                int shapingRangeStart = this.text.getStart();
                for (ScriptRange scriptsRange : scriptsRanges) {
                    if (scriptsRange.script == null || !supportedScripts.contains((Object)EnumUtil.throwIfNull(scriptsRange.script))) continue;
                    scriptsRange.rangeEnd += delta;
                    this.text.setStart(shapingRangeStart);
                    this.text.setEnd(scriptsRange.rangeEnd);
                    if ((scriptsRange.script == Character.UnicodeScript.ARABIC || scriptsRange.script == Character.UnicodeScript.HEBREW) && this.parent instanceof LineRenderer) {
                        this.setProperty(7, (Object)BaseDirection.DEFAULT_BIDI);
                    }
                    TypographyUtils.applyOtfScript(this.font.getFontProgram(), this.text, scriptsRange.script, typographyConfig, sequenceId, metaInfo);
                    delta += this.text.getEnd() - scriptsRange.rangeEnd;
                    scriptsRange.rangeEnd = shapingRangeStart = this.text.getEnd();
                }
                this.text.setStart(origTextStart);
                this.text.setEnd(origTextEnd + delta);
            }
            if ((fontKerning = this.getProperty(22, FontKerning.NO)) == FontKerning.YES) {
                TypographyUtils.applyKerning(this.font.getFontProgram(), this.text, sequenceId, metaInfo);
            }
            this.otfFeaturesApplied = true;
        }
    }

    @Override
    public void draw(DrawContext drawContext) {
        if (this.occupiedArea == null) {
            Logger logger = LoggerFactory.getLogger(TextRenderer.class);
            logger.error(MessageFormatUtil.format("Occupied area has not been initialized. {0}", "Drawing won't be performed."));
            return;
        }
        boolean isTagged = drawContext.isTaggingEnabled();
        LayoutTaggingHelper taggingHelper = null;
        boolean isArtifact = false;
        TagTreePointer tagPointer = null;
        if (isTagged) {
            taggingHelper = (LayoutTaggingHelper)this.getProperty(108);
            if (taggingHelper == null) {
                isArtifact = true;
            } else {
                isArtifact = taggingHelper.isArtifact(this);
                if (!isArtifact && taggingHelper.createTag(this, tagPointer = taggingHelper.useAutoTaggingPointerAndRememberItsPosition(this))) {
                    tagPointer.getProperties().addAttributes(0, AccessibleAttributesApplier.getLayoutAttributes(this, tagPointer));
                }
            }
        }
        super.draw(drawContext);
        boolean isRelativePosition = this.isRelativePosition();
        if (isRelativePosition) {
            this.applyRelativePositioningTranslation(false);
        }
        if (this.line.getEnd() > this.line.getStart() || this.savedWordBreakAtLineEnding != null) {
            Object underlines;
            boolean isStrokeTransparent;
            UnitValue fontSize = this.getPropertyAsUnitValue(24);
            if (!fontSize.isPointValue()) {
                Logger logger = LoggerFactory.getLogger(TextRenderer.class);
                logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 24));
            }
            TransparentColor fontColor = this.getPropertyAsTransparentColor(21);
            Integer textRenderingMode = (Integer)this.getProperty(71);
            boolean italicSimulation = Boolean.TRUE.equals(this.getPropertyAsBoolean(31));
            boolean boldSimulation = Boolean.TRUE.equals(this.getPropertyAsBoolean(8));
            Float strokeWidth = null;
            if (boldSimulation) {
                textRenderingMode = 2;
                strokeWidth = Float.valueOf(fontSize.getValue() / 30.0f);
            }
            PdfCanvas canvas = drawContext.getCanvas();
            if (isTagged) {
                if (isArtifact) {
                    canvas.openTag(new CanvasArtifact());
                } else {
                    canvas.openTag(tagPointer.getTagReference());
                }
            }
            this.beginElementOpacityApplying(drawContext);
            canvas.saveState();
            TransparentColor strokeColor = null;
            Object color = this.getProperty(63);
            if (color instanceof TransparentColor) {
                strokeColor = (TransparentColor)color;
            } else if (color instanceof Color) {
                strokeColor = new TransparentColor((Color)color, 1.0f);
            } else if (fontColor != null) {
                strokeColor = fontColor;
            }
            boolean bl = isStrokeTransparent = textRenderingMode == 2 && strokeColor != null && strokeColor.getOpacity() < 1.0f;
            if (isStrokeTransparent) {
                this.drawText(canvas, fontSize, italicSimulation, 0, strokeWidth, fontColor, strokeColor);
                this.drawText(canvas, fontSize, italicSimulation, 1, strokeWidth, fontColor, strokeColor);
            } else {
                this.drawText(canvas, fontSize, italicSimulation, textRenderingMode, strokeWidth, fontColor, strokeColor);
            }
            IBeforeTextRestoreExecutor beforeTextRestoreExecutor = (IBeforeTextRestoreExecutor)this.getProperty(157);
            if (beforeTextRestoreExecutor != null) {
                beforeTextRestoreExecutor.execute();
            }
            canvas.restoreState();
            this.endElementOpacityApplying(drawContext);
            if (isTagged) {
                canvas.closeTag();
            }
            if ((underlines = this.getProperty(74)) instanceof List) {
                for (Object underline : (List)underlines) {
                    if (!(underline instanceof Underline)) continue;
                    this.drawAndTagSingleUnderline(drawContext.isTaggingEnabled(), (Underline)underline, fontColor, canvas, fontSize.getValue(), italicSimulation ? 0.21256f : 0.0f);
                }
            } else if (underlines instanceof Underline) {
                this.drawAndTagSingleUnderline(drawContext.isTaggingEnabled(), (Underline)underlines, fontColor, canvas, fontSize.getValue(), italicSimulation ? 0.21256f : 0.0f);
            }
        }
        if (isRelativePosition) {
            this.applyRelativePositioningTranslation(false);
        }
        if (isTagged && !isArtifact) {
            if (this.isLastRendererForModelElement) {
                taggingHelper.finishTaggingHint(this);
            }
            taggingHelper.restoreAutoTaggingPointerPosition(this);
        }
    }

    public void trimFirst() {
        this.updateFontAndText();
        if (this.text != null) {
            Glyph glyph;
            while (this.text.getStart() < this.text.getEnd() && TextUtil.isWhitespace(glyph = this.text.get(this.text.getStart())) && !TextUtil.isNewLine(glyph)) {
                this.text.setStart(this.text.getStart() + 1);
            }
        }
        if (this.textContainsSpecialScriptGlyphs(true) && this.specialScriptsWordBreakPoints.get(0).intValue() == this.text.getStart()) {
            if (this.specialScriptsWordBreakPoints.size() == 1) {
                this.specialScriptsWordBreakPoints.set(0, -1);
            } else {
                this.specialScriptsWordBreakPoints.remove(0);
            }
        }
    }

    float trimLast() {
        Glyph currentGlyph;
        int firstNonSpaceCharIndex;
        float trimmedSpace = 0.0f;
        if (this.line.getEnd() <= 0) {
            return trimmedSpace;
        }
        UnitValue fontSize = this.getPropertyAsUnitValue(24);
        if (!fontSize.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(TextRenderer.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 24));
        }
        Float characterSpacing = this.getPropertyAsFloat(15);
        Float wordSpacing = this.getPropertyAsFloat(78);
        float hScale = this.getPropertyAsFloat(29, Float.valueOf(1.0f)).floatValue();
        for (firstNonSpaceCharIndex = this.line.getEnd() - 1; firstNonSpaceCharIndex >= this.line.getStart() && TextUtil.isWhitespace(currentGlyph = this.line.get(firstNonSpaceCharIndex)); --firstNonSpaceCharIndex) {
            this.saveWordBreakIfNotYetSaved(currentGlyph);
            float currentCharWidth = FontProgram.convertTextSpaceToGlyphSpace(this.getCharWidth(currentGlyph, fontSize.getValue(), Float.valueOf(hScale), characterSpacing, wordSpacing));
            float xAdvance = firstNonSpaceCharIndex > this.line.getStart() ? FontProgram.convertTextSpaceToGlyphSpace(this.scaleXAdvance(this.line.get(firstNonSpaceCharIndex - 1).getXAdvance(), fontSize.getValue(), Float.valueOf(hScale))) : 0.0f;
            trimmedSpace += currentCharWidth - xAdvance;
            this.occupiedArea.getBBox().setWidth(this.occupiedArea.getBBox().getWidth() - currentCharWidth);
        }
        this.line.setEnd(firstNonSpaceCharIndex + 1);
        return trimmedSpace;
    }

    @Override
    public float getAscent() {
        return this.yLineOffset;
    }

    @Override
    public float getDescent() {
        return -(this.getOccupiedAreaBBox().getHeight() - this.yLineOffset - this.getPropertyAsFloat(72).floatValue());
    }

    public float getYLine() {
        return this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight() - this.yLineOffset - this.getPropertyAsFloat(72).floatValue();
    }

    public void moveYLineTo(float y) {
        float curYLine = this.getYLine();
        float delta = y - curYLine;
        this.occupiedArea.getBBox().setY(this.occupiedArea.getBBox().getY() + delta);
    }

    public void setText(String text) {
        this.strToBeConverted = text;
        this.updateFontAndText();
    }

    public void setText(GlyphLine text, PdfFont font) {
        GlyphLine newText = new GlyphLine(text);
        newText = TextPreprocessingUtil.replaceSpecialWhitespaceGlyphs(newText, font);
        this.setProcessedGlyphLineAndFont(newText, font);
    }

    public GlyphLine getText() {
        this.updateFontAndText();
        return this.text;
    }

    public int length() {
        return this.text == null ? 0 : this.text.getEnd() - this.text.getStart();
    }

    @Override
    public String toString() {
        return this.line != null ? this.line.toString() : null;
    }

    public int charAt(int pos) {
        return this.text.get(pos + this.text.getStart()).getUnicode();
    }

    public float getTabAnchorCharacterPosition() {
        return this.tabAnchorCharacterPosition;
    }

    @Override
    public IRenderer getNextRenderer() {
        this.logWarningIfGetNextRendererNotOverridden(TextRenderer.class, this.getClass());
        return new TextRenderer((Text)this.modelElement);
    }

    public static float[] calculateAscenderDescender(PdfFont font) {
        return TextRenderer.calculateAscenderDescender(font, RenderingMode.DEFAULT_LAYOUT_MODE);
    }

    public static float[] calculateAscenderDescender(PdfFont font, RenderingMode mode) {
        float descender;
        float ascender;
        FontMetrics fontMetrics = font.getFontProgram().getFontMetrics();
        float usedTypoAscenderScaleCoeff = 1.2f;
        if (RenderingMode.HTML_MODE.equals((Object)mode) && !(font instanceof PdfType1Font)) {
            usedTypoAscenderScaleCoeff = 1.0f;
        }
        if (fontMetrics.getWinAscender() == 0 || fontMetrics.getWinDescender() == 0 || fontMetrics.getTypoAscender() == fontMetrics.getWinAscender() && fontMetrics.getTypoDescender() == fontMetrics.getWinDescender()) {
            ascender = (float)fontMetrics.getTypoAscender() * usedTypoAscenderScaleCoeff;
            descender = (float)fontMetrics.getTypoDescender() * usedTypoAscenderScaleCoeff;
        } else {
            ascender = fontMetrics.getWinAscender();
            descender = fontMetrics.getWinDescender();
        }
        return new float[]{ascender, descender};
    }

    List<int[]> getReversedRanges() {
        return this.reversedRanges;
    }

    List<int[]> initReversedRanges() {
        if (this.reversedRanges == null) {
            this.reversedRanges = new ArrayList<int[]>();
        }
        return this.reversedRanges;
    }

    TextRenderer removeReversedRanges() {
        this.reversedRanges = null;
        return this;
    }

    private TextRenderer[] splitIgnoreFirstNewLine(int currentTextPos) {
        if (TextUtil.isCarriageReturnFollowedByLineFeed(this.text, currentTextPos)) {
            return this.split(currentTextPos + 2);
        }
        return this.split(currentTextPos + 1);
    }

    private GlyphLine convertToGlyphLine(String text) {
        return this.font.createGlyphLine(text);
    }

    private boolean hasOtfFont() {
        return this.font instanceof PdfType0Font && this.font.getFontProgram() instanceof TrueTypeFont;
    }

    boolean textContainsSpecialScriptGlyphs(boolean analyzeSpecialScriptsWordBreakPointsOnly) {
        if (this.specialScriptsWordBreakPoints != null) {
            return !this.specialScriptsWordBreakPoints.isEmpty();
        }
        if (analyzeSpecialScriptsWordBreakPointsOnly) {
            return false;
        }
        ISplitCharacters splitCharacters = (ISplitCharacters)this.getProperty(62);
        if (splitCharacters instanceof BreakAllSplitCharacters) {
            this.specialScriptsWordBreakPoints = new ArrayList<Integer>();
        }
        for (int i = this.text.getStart(); i < this.text.getEnd(); ++i) {
            int unicode = this.text.get(i).getUnicode();
            if (unicode > -1) {
                if (!TextRenderer.codePointIsOfSpecialScript(unicode)) continue;
                return true;
            }
            char[] chars = this.text.get(i).getChars();
            if (chars == null) continue;
            for (char ch : chars) {
                if (!TextRenderer.codePointIsOfSpecialScript(ch)) continue;
                return true;
            }
        }
        this.specialScriptsWordBreakPoints = new ArrayList<Integer>();
        return false;
    }

    void setSpecialScriptsWordBreakPoints(List<Integer> specialScriptsWordBreakPoints) {
        this.specialScriptsWordBreakPoints = specialScriptsWordBreakPoints;
    }

    List<Integer> getSpecialScriptsWordBreakPoints() {
        return this.specialScriptsWordBreakPoints;
    }

    void setSpecialScriptFirstNotFittingIndex(int lastFittingIndex) {
        this.specialScriptFirstNotFittingIndex = lastFittingIndex;
    }

    int getSpecialScriptFirstNotFittingIndex() {
        return this.specialScriptFirstNotFittingIndex;
    }

    void setIndexOfFirstCharacterToBeForcedToOverflow(int indexOfFirstCharacterToBeForcedToOverflow) {
        this.indexOfFirstCharacterToBeForcedToOverflow = indexOfFirstCharacterToBeForcedToOverflow;
    }

    @Override
    protected Rectangle getBackgroundArea(Rectangle occupiedAreaWithMargins) {
        float textRise = this.getPropertyAsFloat(72).floatValue();
        return occupiedAreaWithMargins.moveUp(textRise).decreaseHeight(textRise);
    }

    @Override
    protected Float getFirstYLineRecursively() {
        return Float.valueOf(this.getYLine());
    }

    @Override
    protected Float getLastYLineRecursively() {
        return Float.valueOf(this.getYLine());
    }

    protected int lineLength() {
        return this.line.getEnd() > 0 ? this.line.getEnd() - this.line.getStart() : 0;
    }

    protected int baseCharactersCount() {
        int count = 0;
        for (int i = this.line.getStart(); i < this.line.getEnd(); ++i) {
            Glyph glyph = this.line.get(i);
            if (glyph.hasPlacement()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public MinMaxWidth getMinMaxWidth() {
        TextLayoutResult result = (TextLayoutResult)this.layout(new LayoutContext(new LayoutArea(1, new Rectangle(MinMaxWidthUtils.getInfWidth(), 1000000.0f))));
        return result.getMinMaxWidth();
    }

    protected int getNumberOfSpaces() {
        if (this.line.getEnd() <= 0) {
            return 0;
        }
        int spaces = 0;
        for (int i = this.line.getStart(); i < this.line.getEnd(); ++i) {
            Glyph currentGlyph = this.line.get(i);
            if (currentGlyph.getUnicode() != 32) continue;
            ++spaces;
        }
        return spaces;
    }

    protected TextRenderer createSplitRenderer() {
        return (TextRenderer)this.getNextRenderer();
    }

    protected TextRenderer createOverflowRenderer() {
        return (TextRenderer)this.getNextRenderer();
    }

    protected TextRenderer[] split(int initialOverflowTextPos) {
        TextRenderer splitRenderer = this.createSplitRenderer();
        GlyphLine newText = new GlyphLine(this.text);
        newText.setStart(this.text.getStart());
        newText.setEnd(initialOverflowTextPos);
        splitRenderer.setProcessedGlyphLineAndFont(newText, this.font);
        splitRenderer.line = this.line;
        splitRenderer.occupiedArea = this.occupiedArea.clone();
        splitRenderer.parent = this.parent;
        splitRenderer.yLineOffset = this.yLineOffset;
        splitRenderer.otfFeaturesApplied = this.otfFeaturesApplied;
        splitRenderer.isLastRendererForModelElement = false;
        splitRenderer.addAllProperties(this.getOwnProperties());
        TextRenderer overflowRenderer = this.createOverflowRenderer();
        newText = new GlyphLine(this.text);
        newText.setStart(initialOverflowTextPos);
        newText.setEnd(this.text.getEnd());
        overflowRenderer.setProcessedGlyphLineAndFont(newText, this.font);
        overflowRenderer.otfFeaturesApplied = this.otfFeaturesApplied;
        overflowRenderer.parent = this.parent;
        overflowRenderer.addAllProperties(this.getOwnProperties());
        if (this.specialScriptsWordBreakPoints != null) {
            if (this.specialScriptsWordBreakPoints.isEmpty()) {
                splitRenderer.setSpecialScriptsWordBreakPoints(new ArrayList<Integer>());
                overflowRenderer.setSpecialScriptsWordBreakPoints(new ArrayList<Integer>());
            } else if (this.specialScriptsWordBreakPoints.get(0) == -1) {
                ArrayList<Integer> split = new ArrayList<Integer>(1);
                split.add(-1);
                splitRenderer.setSpecialScriptsWordBreakPoints(split);
                ArrayList<Integer> overflow = new ArrayList<Integer>(1);
                overflow.add(-1);
                overflowRenderer.setSpecialScriptsWordBreakPoints(overflow);
            } else {
                ArrayList<Integer> split;
                int splitIndex = TextRenderer.findPossibleBreaksSplitPosition(this.specialScriptsWordBreakPoints, initialOverflowTextPos, false);
                if (splitIndex > -1) {
                    splitRenderer.setSpecialScriptsWordBreakPoints(this.specialScriptsWordBreakPoints.subList(0, splitIndex + 1));
                } else {
                    split = new ArrayList<Integer>(1);
                    split.add(-1);
                    splitRenderer.setSpecialScriptsWordBreakPoints(split);
                }
                if (splitIndex + 1 < this.specialScriptsWordBreakPoints.size()) {
                    overflowRenderer.setSpecialScriptsWordBreakPoints(this.specialScriptsWordBreakPoints.subList(splitIndex + 1, this.specialScriptsWordBreakPoints.size()));
                } else {
                    split = new ArrayList(1);
                    split.add(-1);
                    overflowRenderer.setSpecialScriptsWordBreakPoints(split);
                }
            }
        }
        return new TextRenderer[]{splitRenderer, overflowRenderer};
    }

    protected void drawSingleUnderline(Underline underline, TransparentColor fontColor, PdfCanvas canvas, float fontSize, float italicAngleTan) {
        IBeforeTextRestoreExecutor beforeTextRestoreExecutor;
        TransparentColor underlineFillColor = underline.getColor() != null ? new TransparentColor(underline.getColor(), underline.getOpacity()) : null;
        TransparentColor underlineStrokeColor = underline.getStrokeColor();
        boolean doStroke = underlineStrokeColor != null;
        boolean isClippingMode = (Integer)this.getProperty(71) > 3;
        RenderingMode renderingMode = (RenderingMode)((Object)this.getProperty(123));
        if (underlineFillColor == null && !doStroke) {
            if (RenderingMode.SVG_MODE == renderingMode && !isClippingMode) {
                return;
            }
            underlineFillColor = fontColor;
        }
        boolean doFill = underlineFillColor != null;
        canvas.saveState();
        if (doFill) {
            canvas.setFillColor(underlineFillColor.getColor());
            underlineFillColor.applyFillTransparency(canvas);
        }
        boolean isStrokeTransparent = false;
        if (doStroke) {
            canvas.setStrokeColor(underlineStrokeColor.getColor());
            underlineStrokeColor.applyStrokeTransparency(canvas);
            isStrokeTransparent = underlineStrokeColor.getOpacity() < 1.0f;
            float[] strokeDashArray = underline.getDashArray();
            if (strokeDashArray != null) {
                canvas.setLineDash(strokeDashArray, underline.getDashPhase());
            }
        }
        canvas.setLineCapStyle(underline.getLineCapStyle());
        float underlineThickness = underline.getThickness(fontSize);
        if (underlineThickness != 0.0f) {
            if (doStroke) {
                canvas.setLineWidth(underline.getStrokeWidth());
            }
            float yLine = this.getYLine();
            float underlineYPosition = underline.getYPosition(fontSize) + yLine;
            float italicWidthSubstraction = 0.5f * fontSize * italicAngleTan;
            Rectangle innerAreaBbox = this.getInnerAreaBBox();
            Rectangle underlineBBox = new Rectangle(innerAreaBbox.getX(), underlineYPosition - underlineThickness / 2.0f, innerAreaBbox.getWidth() - italicWidthSubstraction, underlineThickness);
            canvas.rectangle(underlineBBox);
            if (isClippingMode) {
                canvas.clip().endPath();
            } else if (doFill && doStroke) {
                if (isStrokeTransparent) {
                    canvas.fill();
                    canvas.rectangle(underlineBBox).stroke();
                } else {
                    canvas.fillStroke();
                }
            } else if (doStroke) {
                canvas.stroke();
            } else {
                canvas.fill();
            }
        }
        if ((beforeTextRestoreExecutor = (IBeforeTextRestoreExecutor)this.getProperty(157)) != null) {
            beforeTextRestoreExecutor.execute();
        }
        canvas.restoreState();
    }

    protected float calculateLineWidth() {
        UnitValue fontSize = this.getPropertyAsUnitValue(24);
        if (!fontSize.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(TextRenderer.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 24));
        }
        return this.getGlyphLineWidth(this.line, fontSize.getValue(), this.getPropertyAsFloat(29, Float.valueOf(1.0f)).floatValue(), this.getPropertyAsFloat(15), this.getPropertyAsFloat(78));
    }

    protected boolean resolveFonts(List<IRenderer> addTo) {
        Object font = this.getProperty(20);
        if (font instanceof PdfFont) {
            addTo.add(this);
            return false;
        }
        if (font instanceof String[]) {
            FontProvider provider = (FontProvider)this.getProperty(91);
            FontSet fontSet = (FontSet)this.getProperty(98);
            if (provider.getFontSet().isEmpty() && (fontSet == null || fontSet.isEmpty())) {
                throw new IllegalStateException("FontProvider and FontSet are empty. Cannot resolve font family name (see ElementPropertyContainer#setFontFamily) without initialized FontProvider (see RootElement#setFontProvider).");
            }
            if (null == this.strToBeConverted || this.strToBeConverted.isEmpty()) {
                addTo.add(this);
            } else {
                FontCharacteristics fc = this.createFontCharacteristics();
                IFontSelectorStrategy strategy = provider.createFontSelectorStrategy(Arrays.asList((String[])font), fc, fontSet);
                List<Tuple2<GlyphLine, PdfFont>> subTextWithFont = strategy.getGlyphLines(this.strToBeConverted);
                for (Tuple2<GlyphLine, PdfFont> subText : subTextWithFont) {
                    TextRenderer textRenderer = this.createCopy(subText.getFirst(), subText.getSecond());
                    addTo.add(textRenderer);
                }
            }
            return true;
        }
        throw new IllegalStateException("Invalid FONT property value type.");
    }

    protected void setProcessedGlyphLineAndFont(GlyphLine gl, PdfFont font) {
        this.text = gl;
        this.font = font;
        this.otfFeaturesApplied = false;
        this.strToBeConverted = null;
        this.specialScriptsWordBreakPoints = null;
        this.setProperty(20, font);
    }

    protected TextRenderer createCopy(GlyphLine gl, PdfFont font) {
        if (TextRenderer.class != this.getClass()) {
            Logger logger = LoggerFactory.getLogger(TextRenderer.class);
            logger.error(MessageFormatUtil.format("While processing an instance of TextRenderer, iText uses createCopy() to create glyph lines of specific fonts, which represent its parts. So if one extends TextRenderer, one should override createCopy, otherwise if FontSelector related logic is triggered, copies of this TextRenderer will have the default behavior rather than the custom one.", new Object[0]));
        }
        TextRenderer copy = new TextRenderer(this);
        copy.setProcessedGlyphLineAndFont(gl, font);
        return copy;
    }

    static void updateRangeBasedOnRemovedCharacters(ArrayList<Integer> removedIds, int[] range) {
        int shift = TextRenderer.numberOfElementsLessThan(removedIds, range[0]);
        range[0] = range[0] - shift;
        shift = TextRenderer.numberOfElementsLessThanOrEqual(removedIds, range[1]);
        range[1] = range[1] - shift;
    }

    static int findPossibleBreaksSplitPosition(List<Integer> list, int textStartBasedInitialOverflowTextPos, boolean amongPresentOnly) {
        int low = 0;
        int high = list.size() - 1;
        while (low <= high) {
            int middle = low + high >>> 1;
            if (list.get(middle).compareTo(textStartBasedInitialOverflowTextPos) < 0) {
                low = middle + 1;
                continue;
            }
            if (list.get(middle).compareTo(textStartBasedInitialOverflowTextPos) > 0) {
                high = middle - 1;
                continue;
            }
            return middle;
        }
        if (!amongPresentOnly && low > 0) {
            return low - 1;
        }
        return -1;
    }

    static boolean codePointIsOfSpecialScript(int codePoint) {
        Character.UnicodeScript glyphScript = Character.UnicodeScript.of(codePoint);
        return Character.UnicodeScript.THAI == glyphScript || Character.UnicodeScript.KHMER == glyphScript || Character.UnicodeScript.LAO == glyphScript || Character.UnicodeScript.MYANMAR == glyphScript;
    }

    @Override
    PdfFont resolveFirstPdfFont(String[] font, FontProvider provider, FontCharacteristics fc, FontSet additionalFonts) {
        IFontSelectorStrategy strategy = provider.createFontSelectorStrategy(Arrays.asList(font), fc, additionalFonts);
        List<Tuple2<GlyphLine, PdfFont>> glyphLines = strategy.getGlyphLines(this.strToBeConverted);
        if (!glyphLines.isEmpty()) {
            return glyphLines.get(0).getSecond();
        }
        return super.resolveFirstPdfFont(font, provider, fc, additionalFonts);
    }

    boolean[] isStartsWithSplitCharWhiteSpaceAndEndsWithSplitChar(ISplitCharacters splitCharacters) {
        boolean endsWithBreak;
        boolean startsWithBreak = this.line.getStart() < this.line.getEnd() && splitCharacters.isSplitCharacter(this.text, this.line.getStart()) && TextUtil.isSpaceOrWhitespace(this.text.get(this.line.getStart()));
        boolean bl = endsWithBreak = this.line.getStart() < this.line.getEnd() && splitCharacters.isSplitCharacter(this.text, this.line.getEnd() - 1);
        if (this.specialScriptsWordBreakPoints == null || this.specialScriptsWordBreakPoints.isEmpty()) {
            return new boolean[]{startsWithBreak, endsWithBreak};
        }
        if (!endsWithBreak) {
            endsWithBreak = this.specialScriptsWordBreakPoints.contains(this.line.getEnd());
        }
        return new boolean[]{startsWithBreak, endsWithBreak};
    }

    private void drawText(PdfCanvas canvas, UnitValue fontSize, boolean italicSimulation, Integer textRenderingMode, Float strokeWidth, TransparentColor fontColor, TransparentColor strokeColor) {
        Float horizontalScaling;
        Float wordSpacing;
        Float characterSpacing;
        Float textRise;
        canvas.beginText().setFontAndSize(this.font, fontSize.getValue());
        float leftBBoxX = this.getInnerAreaBBox().getX();
        float[] skew = (float[])this.getProperty(65);
        float verticalScale = this.getPropertyAsFloat(76, Float.valueOf(1.0f)).floatValue();
        if (skew != null && skew.length == 2) {
            canvas.setTextMatrix(1.0f, skew[0], skew[1], verticalScale, leftBBoxX, this.getYLine());
        } else if (italicSimulation) {
            canvas.setTextMatrix(1.0f, 0.0f, 0.21256f, verticalScale, leftBBoxX, this.getYLine());
        } else if (Math.abs(verticalScale - 1.0f) < 1.0E-4f) {
            canvas.moveText(leftBBoxX, this.getYLine());
        } else {
            canvas.setTextMatrix(1.0f, 0.0f, 0.0f, verticalScale, leftBBoxX, this.getYLine());
        }
        if (textRenderingMode != 0) {
            canvas.setTextRenderingMode(textRenderingMode);
        }
        if (textRenderingMode == 1 || textRenderingMode == 2) {
            List strokeDashPattern = (List)this.getProperty(156);
            if (strokeDashPattern != null && !strokeDashPattern.isEmpty()) {
                float[] dashArray = new float[strokeDashPattern.size() - 1];
                for (int i = 0; i < strokeDashPattern.size() - 1; ++i) {
                    dashArray[i] = ((Float)strokeDashPattern.get(i)).floatValue();
                }
                float dashPhase = ((Float)strokeDashPattern.get(strokeDashPattern.size() - 1)).floatValue();
                canvas.setLineDash(dashArray, dashPhase);
            }
            if (strokeWidth == null) {
                strokeWidth = this.getPropertyAsFloat(64);
            }
            if (strokeWidth != null && strokeWidth.floatValue() != 1.0f) {
                canvas.setLineWidth(strokeWidth.floatValue());
            }
            if (strokeColor != null) {
                canvas.setStrokeColor(strokeColor.getColor());
                strokeColor.applyStrokeTransparency(canvas);
            }
        }
        if (fontColor != null) {
            canvas.setFillColor(fontColor.getColor());
            fontColor.applyFillTransparency(canvas);
        }
        if ((textRise = this.getPropertyAsFloat(72)) != null && textRise.floatValue() != 0.0f) {
            canvas.setTextRise(textRise.floatValue());
        }
        if ((characterSpacing = this.getPropertyAsFloat(15)) != null && characterSpacing.floatValue() != 0.0f) {
            canvas.setCharacterSpacing(characterSpacing.floatValue());
        }
        if ((wordSpacing = this.getPropertyAsFloat(78)) != null && wordSpacing.floatValue() != 0.0f) {
            if (this.font instanceof PdfType0Font) {
                for (int gInd = this.line.getStart(); gInd < this.line.getEnd(); ++gInd) {
                    if (!TextUtil.isUni0020(this.line.get(gInd))) continue;
                    short advance = (short)(FontProgram.convertGlyphSpaceToTextSpace(wordSpacing.floatValue()) / fontSize.getValue());
                    Glyph copy = new Glyph(this.line.get(gInd));
                    copy.setXAdvance(advance);
                    this.line.set(gInd, copy);
                }
            } else {
                canvas.setWordSpacing(wordSpacing.floatValue());
            }
        }
        if ((horizontalScaling = (Float)this.getProperty(29)) != null && horizontalScaling.floatValue() != 1.0f) {
            canvas.setHorizontalScaling(horizontalScaling.floatValue() * 100.0f);
        }
        CustomGlyphLineFilter filter = new CustomGlyphLineFilter();
        boolean appearanceStreamLayout = Boolean.TRUE.equals(this.getPropertyAsBoolean(82));
        if (this.getReversedRanges() != null) {
            boolean writeReversedChars = !appearanceStreamLayout;
            ArrayList<Integer> removedIds = new ArrayList<Integer>();
            for (int i = this.line.getStart(); i < this.line.getEnd(); ++i) {
                if (filter.accept(this.line.get(i))) continue;
                removedIds.add(i);
            }
            for (int[] range : this.getReversedRanges()) {
                TextRenderer.updateRangeBasedOnRemovedCharacters(removedIds, range);
            }
            this.line = this.line.filter(filter);
            if (writeReversedChars) {
                canvas.showText(this.line, new ReversedCharsIterator(this.reversedRanges, this.line).setUseReversed(true));
            } else {
                canvas.showText(this.line);
            }
        } else {
            if (appearanceStreamLayout) {
                this.line.setActualText(this.line.getStart(), this.line.getEnd(), null);
            }
            canvas.showText(this.line.filter(filter));
        }
        if (this.savedWordBreakAtLineEnding != null) {
            canvas.showText(this.savedWordBreakAtLineEnding);
        }
        canvas.endText();
    }

    private void drawAndTagSingleUnderline(boolean isTagged, Underline underline, TransparentColor fontStrokeColor, PdfCanvas canvas, float fontSize, float italicAngleTan) {
        if (isTagged) {
            canvas.openTag(new CanvasArtifact());
        }
        this.drawSingleUnderline(underline, fontStrokeColor, canvas, fontSize, italicAngleTan);
        if (isTagged) {
            canvas.closeTag();
        }
    }

    private float getCharWidth(Glyph g, float fontSize, Float hScale, Float characterSpacing, Float wordSpacing) {
        if (hScale == null) {
            hScale = Float.valueOf(1.0f);
        }
        float resultWidth = (float)g.getWidth() * fontSize * hScale.floatValue();
        if (characterSpacing != null) {
            resultWidth += FontProgram.convertGlyphSpaceToTextSpace(characterSpacing.floatValue() * hScale.floatValue());
        }
        if (wordSpacing != null && g.getUnicode() == 32) {
            resultWidth += FontProgram.convertGlyphSpaceToTextSpace(wordSpacing.floatValue() * hScale.floatValue());
        }
        return resultWidth;
    }

    private float scaleXAdvance(float xAdvance, float fontSize, Float hScale) {
        return xAdvance * fontSize * hScale.floatValue();
    }

    private float getGlyphLineWidth(GlyphLine glyphLine, float fontSize, float hScale, Float characterSpacing, Float wordSpacing) {
        float width = 0.0f;
        for (int i = glyphLine.getStart(); i < glyphLine.getEnd(); ++i) {
            if (TextRenderer.noPrint(glyphLine.get(i))) continue;
            float charWidth = this.getCharWidth(glyphLine.get(i), fontSize, Float.valueOf(hScale), characterSpacing, wordSpacing);
            width += charWidth;
            float xAdvance = i != glyphLine.getStart() ? this.scaleXAdvance(glyphLine.get(i - 1).getXAdvance(), fontSize, Float.valueOf(hScale)) : 0.0f;
            width += xAdvance;
        }
        return FontProgram.convertTextSpaceToGlyphSpace(width);
    }

    private int[] getWordBoundsForHyphenation(GlyphLine text, int leftTextPos, int rightTextPos, int wordMiddleCharPos) {
        while (wordMiddleCharPos >= leftTextPos && !this.isGlyphPartOfWordForHyphenation(text.get(wordMiddleCharPos)) && !TextUtil.isUni0020(text.get(wordMiddleCharPos))) {
            --wordMiddleCharPos;
        }
        if (wordMiddleCharPos >= leftTextPos) {
            int right;
            int left;
            for (left = wordMiddleCharPos; left >= leftTextPos && this.isGlyphPartOfWordForHyphenation(text.get(left)); --left) {
            }
            for (right = wordMiddleCharPos; right < rightTextPos && this.isGlyphPartOfWordForHyphenation(text.get(right)); ++right) {
            }
            return new int[]{left + 1, right};
        }
        return null;
    }

    private boolean isGlyphPartOfWordForHyphenation(Glyph g) {
        return Character.isLetter((char)g.getUnicode()) || 173 == g.getUnicode();
    }

    private void updateFontAndText() {
        if (this.strToBeConverted != null) {
            PdfFont newFont;
            block3: {
                try {
                    newFont = this.getPropertyAsFont(20);
                }
                catch (ClassCastException cce) {
                    newFont = this.resolveFirstPdfFont();
                    if (this.strToBeConverted.isEmpty()) break block3;
                    Logger logger = LoggerFactory.getLogger(TextRenderer.class);
                    logger.error("The \"Property.FONT\" property must be a PdfFont object in this context.");
                }
            }
            GlyphLine newText = newFont.createGlyphLine(this.strToBeConverted);
            newText = TextPreprocessingUtil.replaceSpecialWhitespaceGlyphs(newText, newFont);
            this.setProcessedGlyphLineAndFont(newText, newFont);
        }
    }

    private void saveWordBreakIfNotYetSaved(Glyph wordBreak) {
        if (this.savedWordBreakAtLineEnding == null) {
            if (TextUtil.isNewLine(wordBreak)) {
                wordBreak = this.font.getGlyph(32);
            }
            this.savedWordBreakAtLineEnding = new GlyphLine(Collections.singletonList(wordBreak));
        }
    }

    private static int numberOfElementsLessThan(ArrayList<Integer> numbers, int n) {
        int x = Collections.binarySearch(numbers, n);
        if (x >= 0) {
            return x;
        }
        return -x - 1;
    }

    private static int numberOfElementsLessThanOrEqual(ArrayList<Integer> numbers, int n) {
        int x = Collections.binarySearch(numbers, n);
        if (x >= 0) {
            return x + 1;
        }
        return -x - 1;
    }

    private static boolean noPrint(Glyph g) {
        if (!g.hasValidUnicode()) {
            return false;
        }
        int c = g.getUnicode();
        return TextUtil.isNonPrintable(c);
    }

    private static boolean glyphBelongsToNonBreakingHyphenRelatedChunk(GlyphLine text, int ind) {
        return TextUtil.isNonBreakingHyphen(text.get(ind)) || ind + 1 < text.getEnd() && TextUtil.isNonBreakingHyphen(text.get(ind + 1)) || ind - 1 >= text.getStart() && TextUtil.isNonBreakingHyphen(text.get(ind - 1));
    }

    private static final class CustomGlyphLineFilter
    implements GlyphLine.IGlyphLineFilter {
        private CustomGlyphLineFilter() {
        }

        @Override
        public boolean accept(Glyph glyph) {
            return !TextRenderer.noPrint(glyph);
        }
    }

    private static class ScriptRange {
        Character.UnicodeScript script;
        int rangeEnd;

        ScriptRange(Character.UnicodeScript script, int rangeEnd) {
            this.script = script;
            this.rangeEnd = rangeEnd;
        }
    }

    private static class ReversedCharsIterator
    implements Iterator<GlyphLine.GlyphLinePart> {
        private List<Integer> outStart = new ArrayList<Integer>();
        private List<Integer> outEnd = new ArrayList<Integer>();
        private List<Boolean> reversed = new ArrayList<Boolean>();
        private int currentInd = 0;
        private boolean useReversed;

        public ReversedCharsIterator(List<int[]> reversedRange, GlyphLine line) {
            if (reversedRange != null) {
                if (reversedRange.get(0)[0] > 0) {
                    this.outStart.add(0);
                    this.outEnd.add(reversedRange.get(0)[0]);
                    this.reversed.add(false);
                }
                for (int i = 0; i < reversedRange.size(); ++i) {
                    int[] range = reversedRange.get(i);
                    this.outStart.add(range[0]);
                    this.outEnd.add(range[1] + 1);
                    this.reversed.add(true);
                    if (i == reversedRange.size() - 1) continue;
                    this.outStart.add(range[1] + 1);
                    this.outEnd.add(reversedRange.get(i + 1)[0]);
                    this.reversed.add(false);
                }
                int lastIndex = reversedRange.get(reversedRange.size() - 1)[1];
                if (lastIndex < line.size() - 1) {
                    this.outStart.add(lastIndex + 1);
                    this.outEnd.add(line.size());
                    this.reversed.add(false);
                }
            } else {
                this.outStart.add(line.getStart());
                this.outEnd.add(line.getEnd());
                this.reversed.add(false);
            }
        }

        public ReversedCharsIterator setUseReversed(boolean useReversed) {
            this.useReversed = useReversed;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.currentInd < this.outStart.size();
        }

        @Override
        public GlyphLine.GlyphLinePart next() {
            GlyphLine.GlyphLinePart part = new GlyphLine.GlyphLinePart(this.outStart.get(this.currentInd), this.outEnd.get(this.currentInd)).setReversed(this.useReversed && this.reversed.get(this.currentInd) != false);
            ++this.currentInd;
            return part;
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Operation not supported");
        }
    }
}

