/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.commons.utils.StringNormalizer;
import com.itextpdf.io.util.ArrayUtil;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.properties.BorderCollapsePropertyValue;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.CellRenderer;
import com.itextpdf.layout.renderer.SeparatedTableBorders;
import com.itextpdf.layout.renderer.TableRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TableWidths {
    private final TableRenderer tableRenderer;
    private final int numberOfColumns;
    private final float rightBorderMaxWidth;
    private final float leftBorderMaxWidth;
    private final ColumnWidthData[] widths;
    private final float horizontalBorderSpacing;
    private List<CellInfo> cells;
    private float tableWidth;
    private boolean fixedTableWidth;
    private boolean fixedTableLayout = false;
    private float layoutMinWidth;
    private float tableMinWidth;
    private float tableMaxWidth;
    private static final UnitValue ZeroWidth = UnitValue.createPointValue(0.0f);

    TableWidths(TableRenderer tableRenderer, float availableWidth, boolean calculateTableMaxWidth, float rightBorderMaxWidth, float leftBorderMaxWidth) {
        Float horizontalSpacing;
        this.tableRenderer = tableRenderer;
        this.numberOfColumns = ((Table)tableRenderer.getModelElement()).getNumberOfColumns();
        this.widths = new ColumnWidthData[this.numberOfColumns];
        this.rightBorderMaxWidth = rightBorderMaxWidth;
        this.leftBorderMaxWidth = leftBorderMaxWidth;
        this.horizontalBorderSpacing = tableRenderer.bordersHandler instanceof SeparatedTableBorders ? (null == (horizontalSpacing = tableRenderer.getPropertyAsFloat(115)) ? 0.0f : horizontalSpacing.floatValue()) : 0.0f;
        this.calculateTableWidth(availableWidth, calculateTableMaxWidth);
    }

    boolean hasFixedLayout() {
        return this.fixedTableLayout;
    }

    float[] layout() {
        if (this.hasFixedLayout()) {
            return this.fixedLayout();
        }
        return this.autoLayout();
    }

    float getMinWidth() {
        return this.layoutMinWidth;
    }

    float[] autoLayout() {
        assert (this.tableRenderer.getTable().isComplete());
        this.fillAndSortCells();
        this.calculateMinMaxWidths();
        float minSum = 0.0f;
        for (ColumnWidthData width : this.widths) {
            minSum += width.min;
        }
        for (CellInfo cell : this.cells) {
            this.processCell(cell);
        }
        this.processColumns();
        this.recalculate(minSum);
        return this.extractWidths();
    }

    List<CellInfo> autoLayoutCustom() {
        assert (this.tableRenderer.getTable().isComplete());
        this.fillAndSortCells();
        this.calculateMinMaxWidths();
        return this.cells;
    }

    void processCell(CellInfo cell) {
        block16: {
            block13: {
                UnitValue cellWidth;
                block17: {
                    block14: {
                        block15: {
                            cellWidth = this.getCellWidth(cell.getCell(), false);
                            if (cellWidth == null) break block13;
                            assert (cellWidth.getValue() > 0.0f);
                            if (!cellWidth.isPercentValue()) break block14;
                            if (cell.getColspan() != 1) break block15;
                            this.widths[cell.getCol()].setPercents(cellWidth.getValue());
                            break block16;
                        }
                        int pointColumns = 0;
                        float percentSum = 0.0f;
                        for (int i = cell.getCol(); i < cell.getCol() + cell.getColspan(); ++i) {
                            if (!this.widths[i].isPercent) {
                                ++pointColumns;
                                continue;
                            }
                            percentSum += this.widths[i].width;
                        }
                        float percentAddition = cellWidth.getValue() - percentSum;
                        if (!(percentAddition > 0.0f)) break block16;
                        if (pointColumns == 0) {
                            for (int i = cell.getCol(); i < cell.getCol() + cell.getColspan(); ++i) {
                                this.widths[i].addPercents(percentAddition / (float)cell.getColspan());
                            }
                        } else {
                            for (int i = cell.getCol(); i < cell.getCol() + cell.getColspan(); ++i) {
                                if (this.widths[i].isPercent) continue;
                                this.widths[i].setPercents(percentAddition / (float)pointColumns);
                            }
                        }
                        break block16;
                    }
                    if (cell.getColspan() != 1) break block17;
                    if (this.widths[cell.getCol()].isPercent) break block16;
                    if (this.widths[cell.getCol()].min <= cellWidth.getValue()) {
                        this.widths[cell.getCol()].setPoints(cellWidth.getValue()).setFixed(true);
                    } else {
                        this.widths[cell.getCol()].setPoints(this.widths[cell.getCol()].min);
                    }
                    break block16;
                }
                this.processCellsRemainWidth(cell, cellWidth);
                break block16;
            }
            if (this.widths[cell.getCol()].isFlexible()) {
                int i;
                int flexibleCols = 0;
                float remainWidth = 0.0f;
                for (i = cell.getCol(); i < cell.getCol() + cell.getColspan(); ++i) {
                    if (!this.widths[i].isFlexible()) continue;
                    remainWidth += this.widths[i].max - this.widths[i].width;
                    ++flexibleCols;
                }
                if (remainWidth > 0.0f) {
                    for (i = cell.getCol(); i < cell.getCol() + cell.getColspan(); ++i) {
                        if (!this.widths[i].isFlexible()) continue;
                        this.widths[i].addPoints(remainWidth / (float)flexibleCols);
                    }
                }
            }
        }
    }

    void processColumns() {
        for (int i = 0; i < this.numberOfColumns; ++i) {
            UnitValue colWidth = this.getTable().getColumnWidth(i);
            if (colWidth == null || !(colWidth.getValue() > 0.0f)) continue;
            if (colWidth.isPercentValue()) {
                if (this.widths[i].isPercent) continue;
                if (this.widths[i].isFixed && this.widths[i].width > this.widths[i].min) {
                    this.widths[i].max = this.widths[i].width;
                }
                this.widths[i].setPercents(colWidth.getValue());
                continue;
            }
            if (this.widths[i].isPercent || !(colWidth.getValue() >= this.widths[i].min)) continue;
            if (this.widths[i].isFixed) {
                this.widths[i].setPoints(colWidth.getValue());
                continue;
            }
            this.widths[i].resetPoints(colWidth.getValue()).setFixed(true);
        }
    }

    void recalculate(float minSum) {
        block35: {
            boolean hasFlexibleCell;
            float flexibleAddition;
            float fixedAddition;
            float minTotalNonPercent;
            float totalPercent;
            block38: {
                float sumOfPercents;
                block37: {
                    int i;
                    float minTableWidth;
                    block36: {
                        block34: {
                            if (!(this.tableWidth - minSum < 0.0f)) break block34;
                            for (int i2 = 0; i2 < this.numberOfColumns; ++i2) {
                                this.widths[i2].finalWidth = this.widths[i2].min;
                            }
                            break block35;
                        }
                        sumOfPercents = 0.0f;
                        minTableWidth = 0.0f;
                        float totalNonPercent = 0.0f;
                        for (int i3 = 0; i3 < this.widths.length; ++i3) {
                            if (this.widths[i3].isPercent) {
                                if (sumOfPercents < 100.0f && sumOfPercents + this.widths[i3].width > 100.0f) {
                                    this.widths[i3].width = 100.0f - sumOfPercents;
                                    sumOfPercents += this.widths[i3].width;
                                    this.warn100percent();
                                    continue;
                                }
                                if (sumOfPercents >= 100.0f) {
                                    this.widths[i3].resetPoints(this.widths[i3].min);
                                    minTableWidth += this.widths[i3].min;
                                    this.warn100percent();
                                    continue;
                                }
                                sumOfPercents += this.widths[i3].width;
                                continue;
                            }
                            minTableWidth += this.widths[i3].min;
                            totalNonPercent += this.widths[i3].width;
                        }
                        assert (sumOfPercents <= 100.0f);
                        boolean toBalance = true;
                        if (!this.fixedTableWidth) {
                            float tableWidthBasedOnPercents = sumOfPercents < 100.0f ? totalNonPercent * 100.0f / (100.0f - sumOfPercents) : 0.0f;
                            for (int i4 = 0; i4 < this.numberOfColumns; ++i4) {
                                if (!this.widths[i4].isPercent || !(this.widths[i4].width > 0.0f)) continue;
                                tableWidthBasedOnPercents = Math.max(this.widths[i4].max * 100.0f / this.widths[i4].width, tableWidthBasedOnPercents);
                            }
                            if (tableWidthBasedOnPercents <= this.tableWidth) {
                                if (tableWidthBasedOnPercents >= minTableWidth) {
                                    this.tableWidth = tableWidthBasedOnPercents;
                                    toBalance = false;
                                } else {
                                    this.tableWidth = minTableWidth;
                                }
                            }
                        }
                        if (sumOfPercents > 0.0f && sumOfPercents < 100.0f && totalNonPercent == 0.0f) {
                            for (int i5 = 0; i5 < this.widths.length; ++i5) {
                                this.widths[i5].width = 100.0f * this.widths[i5].width / sumOfPercents;
                            }
                            sumOfPercents = 100.0f;
                        }
                        if (toBalance) break block36;
                        for (int i6 = 0; i6 < this.numberOfColumns; ++i6) {
                            this.widths[i6].finalWidth = this.widths[i6].isPercent ? this.tableWidth * this.widths[i6].width / 100.0f : this.widths[i6].width;
                        }
                        break block35;
                    }
                    if (!(sumOfPercents >= 100.0f)) break block37;
                    sumOfPercents = 100.0f;
                    boolean recalculatePercents = false;
                    float remainWidth = this.tableWidth - minTableWidth;
                    for (i = 0; i < this.numberOfColumns; ++i) {
                        if (this.widths[i].isPercent) {
                            if (remainWidth * this.widths[i].width / 100.0f >= this.widths[i].min) {
                                this.widths[i].finalWidth = remainWidth * this.widths[i].width / 100.0f;
                                continue;
                            }
                            this.widths[i].finalWidth = this.widths[i].min;
                            this.widths[i].isPercent = false;
                            remainWidth -= this.widths[i].min;
                            sumOfPercents -= this.widths[i].width;
                            recalculatePercents = true;
                            continue;
                        }
                        this.widths[i].finalWidth = this.widths[i].min;
                    }
                    if (!recalculatePercents) break block35;
                    for (i = 0; i < this.numberOfColumns; ++i) {
                        if (!this.widths[i].isPercent) continue;
                        this.widths[i].finalWidth = remainWidth * this.widths[i].width / sumOfPercents;
                    }
                    break block35;
                }
                totalPercent = 0.0f;
                minTotalNonPercent = 0.0f;
                fixedAddition = 0.0f;
                flexibleAddition = 0.0f;
                hasFlexibleCell = false;
                for (int i = 0; i < this.numberOfColumns; ++i) {
                    if (this.widths[i].isPercent) {
                        if (this.tableWidth * this.widths[i].width / 100.0f >= this.widths[i].min) {
                            this.widths[i].finalWidth = this.tableWidth * this.widths[i].width / 100.0f;
                            totalPercent += this.widths[i].finalWidth;
                            continue;
                        }
                        sumOfPercents -= this.widths[i].width;
                        this.widths[i].resetPoints(this.widths[i].min);
                        this.widths[i].finalWidth = this.widths[i].min;
                        minTotalNonPercent += this.widths[i].min;
                        continue;
                    }
                    this.widths[i].finalWidth = this.widths[i].min;
                    minTotalNonPercent += this.widths[i].min;
                    float addition = this.widths[i].width - this.widths[i].min;
                    if (this.widths[i].isFixed) {
                        fixedAddition += addition;
                        continue;
                    }
                    flexibleAddition += addition;
                    hasFlexibleCell = true;
                }
                if (!(totalPercent + minTotalNonPercent > this.tableWidth)) break block38;
                float extraWidth = this.tableWidth - minTotalNonPercent;
                if (!(sumOfPercents > 0.0f)) break block35;
                for (int i = 0; i < this.numberOfColumns; ++i) {
                    if (!this.widths[i].isPercent) continue;
                    this.widths[i].finalWidth = extraWidth * this.widths[i].width / sumOfPercents;
                }
                break block35;
            }
            float extraWidth = this.tableWidth - totalPercent - minTotalNonPercent;
            if (fixedAddition > 0.0f && (extraWidth < fixedAddition || !hasFlexibleCell)) {
                for (int i = 0; i < this.numberOfColumns; ++i) {
                    if (!this.widths[i].isFixed) continue;
                    this.widths[i].finalWidth += (this.widths[i].width - this.widths[i].min) * extraWidth / fixedAddition;
                }
            } else if ((extraWidth -= fixedAddition) < flexibleAddition) {
                for (int i = 0; i < this.numberOfColumns; ++i) {
                    if (this.widths[i].isFixed) {
                        this.widths[i].finalWidth = this.widths[i].width;
                        continue;
                    }
                    if (this.widths[i].isPercent) continue;
                    this.widths[i].finalWidth += (this.widths[i].width - this.widths[i].min) * extraWidth / flexibleAddition;
                }
            } else {
                int i;
                float totalFixed = 0.0f;
                float totalFlexible = 0.0f;
                float flexibleCount = 0.0f;
                for (i = 0; i < this.numberOfColumns; ++i) {
                    if (this.widths[i].isFixed) {
                        this.widths[i].finalWidth = this.widths[i].width;
                        totalFixed += this.widths[i].width;
                        continue;
                    }
                    if (this.widths[i].isPercent) continue;
                    totalFlexible += this.widths[i].width;
                    flexibleCount += 1.0f;
                }
                assert (totalFlexible > 0.0f || flexibleCount > 0.0f);
                extraWidth = this.tableWidth - totalPercent - totalFixed;
                for (i = 0; i < this.numberOfColumns; ++i) {
                    if (this.widths[i].isPercent || this.widths[i].isFixed) continue;
                    this.widths[i].finalWidth = totalFlexible > 0.0f ? this.widths[i].width * extraWidth / totalFlexible : extraWidth / flexibleCount;
                }
            }
        }
    }

    void processCellsRemainWidth(CellInfo cell, UnitValue cellWidth) {
        block6: {
            float remainWidth;
            block7: {
                int i;
                int flexibleCols = 0;
                remainWidth = cellWidth.getValue();
                for (int i2 = cell.getCol(); i2 < cell.getCol() + cell.getColspan(); ++i2) {
                    if (!this.widths[i2].isPercent) {
                        remainWidth -= this.widths[i2].width;
                        if (this.widths[i2].isFixed) continue;
                        ++flexibleCols;
                        continue;
                    }
                    remainWidth = 0.0f;
                    break;
                }
                if (!(remainWidth > 0.0f)) break block6;
                int[] flexibleColIndexes = ArrayUtil.fillWithValue(new int[cell.getColspan()], -1);
                if (flexibleCols <= 0) break block7;
                for (i = cell.getCol(); i < cell.getCol() + cell.getColspan(); ++i) {
                    if (!this.widths[i].isFlexible()) continue;
                    if (this.widths[i].min > this.widths[i].width + remainWidth / (float)flexibleCols) {
                        this.widths[i].resetPoints(this.widths[i].min);
                        remainWidth -= this.widths[i].min - this.widths[i].width;
                        if (--flexibleCols != 0 && !(remainWidth <= 0.0f)) continue;
                        break;
                    }
                    flexibleColIndexes[i - cell.getCol()] = i;
                }
                if (flexibleCols <= 0 || !(remainWidth > 0.0f)) break block6;
                for (i = 0; i < flexibleColIndexes.length; ++i) {
                    if (flexibleColIndexes[i] < 0) continue;
                    this.widths[flexibleColIndexes[i]].addPoints(remainWidth / (float)flexibleCols).setFixed(true);
                }
                break block6;
            }
            for (int i = cell.getCol(); i < cell.getCol() + cell.getColspan(); ++i) {
                this.widths[i].addPoints(remainWidth / (float)cell.getColspan());
            }
        }
    }

    float[] fixedLayout() {
        int i;
        float[] columnWidths = new float[this.numberOfColumns];
        for (int i2 = 0; i2 < this.numberOfColumns; ++i2) {
            UnitValue colWidth = this.getTable().getColumnWidth(i2);
            columnWidths[i2] = colWidth == null || colWidth.getValue() < 0.0f ? -1.0f : (colWidth.isPercentValue() ? colWidth.getValue() * this.tableWidth / 100.0f : colWidth.getValue());
        }
        int processedColumns = 0;
        float remainWidth = this.tableWidth;
        CellRenderer[] firtsRow = this.tableRenderer.headerRenderer != null && this.tableRenderer.headerRenderer.rows.size() > 0 ? this.tableRenderer.headerRenderer.rows.get(0) : (this.tableRenderer.rows.size() > 0 && this.getTable().isComplete() && 0 == this.getTable().getLastRowBottomBorder().size() ? this.tableRenderer.rows.get(0) : null);
        float[] columnWidthIfPercent = new float[columnWidths.length];
        for (int i3 = 0; i3 < columnWidthIfPercent.length; ++i3) {
            columnWidthIfPercent[i3] = -1.0f;
        }
        float sumOfPercents = 0.0f;
        if (firtsRow != null && this.getTable().isComplete() && this.getTable().getLastRowBottomBorder().isEmpty()) {
            for (i = 0; i < this.numberOfColumns; ++i) {
                if (columnWidths[i] == -1.0f) {
                    UnitValue cellWidth;
                    CellRenderer cell = firtsRow[i];
                    if (cell == null || (cellWidth = this.getCellWidth(cell, true)) == null) continue;
                    assert (cellWidth.getValue() >= 0.0f);
                    float width = 0.0f;
                    if (cellWidth.isPercentValue()) {
                        width = this.tableWidth * cellWidth.getValue() / 100.0f;
                        columnWidthIfPercent[i] = cellWidth.getValue();
                        sumOfPercents += columnWidthIfPercent[i];
                    } else {
                        width = cellWidth.getValue();
                    }
                    int colspan = ((Cell)cell.getModelElement()).getColspan();
                    for (int j = 0; j < colspan; ++j) {
                        columnWidths[i + j] = width / (float)colspan;
                    }
                    remainWidth -= columnWidths[i];
                    ++processedColumns;
                    continue;
                }
                remainWidth -= columnWidths[i];
                ++processedColumns;
            }
        } else {
            for (i = 0; i < this.numberOfColumns; ++i) {
                if (columnWidths[i] == -1.0f) continue;
                ++processedColumns;
                remainWidth -= columnWidths[i];
            }
        }
        if (sumOfPercents > 100.0f) {
            this.warn100percent();
        }
        if (remainWidth > 0.0f) {
            if (this.numberOfColumns == processedColumns) {
                for (i = 0; i < this.numberOfColumns; ++i) {
                    columnWidths[i] = this.tableWidth * columnWidths[i] / (this.tableWidth - remainWidth);
                }
            }
        } else if (remainWidth < 0.0f) {
            for (i = 0; i < this.numberOfColumns; ++i) {
                int n = i;
                columnWidths[n] = columnWidths[n] + (-1.0f != columnWidthIfPercent[i] ? remainWidth * columnWidthIfPercent[i] / sumOfPercents : 0.0f);
            }
        }
        for (i = 0; i < this.numberOfColumns; ++i) {
            if (columnWidths[i] != -1.0f) continue;
            columnWidths[i] = Math.max(0.0f, remainWidth / (float)(this.numberOfColumns - processedColumns));
        }
        if (this.tableRenderer.bordersHandler instanceof SeparatedTableBorders) {
            i = 0;
            while (i < this.numberOfColumns) {
                int n = i++;
                columnWidths[n] = columnWidths[n] + this.horizontalBorderSpacing;
            }
        }
        return columnWidths;
    }

    private void calculateTableWidth(float availableWidth, boolean calculateTableMaxWidth) {
        this.fixedTableLayout = "fixed".equals(StringNormalizer.toLowerCase(this.tableRenderer.getProperty(93, "auto")));
        UnitValue width = (UnitValue)this.tableRenderer.getProperty(77);
        if (this.fixedTableLayout && width != null && width.getValue() >= 0.0f) {
            if (0 != this.getTable().getLastRowBottomBorder().size()) {
                width = this.getTable().getWidth();
            } else if (!this.getTable().isComplete() && null != this.getTable().getWidth() && this.getTable().getWidth().isPercentValue()) {
                this.getTable().setWidth(this.tableRenderer.retrieveUnitValue(availableWidth, 77).floatValue());
            }
            this.fixedTableWidth = true;
            this.tableWidth = this.retrieveTableWidth(width, availableWidth).floatValue();
            this.layoutMinWidth = width.isPercentValue() ? 0.0f : this.tableWidth;
        } else {
            this.fixedTableLayout = false;
            this.layoutMinWidth = -1.0f;
            if (calculateTableMaxWidth) {
                this.fixedTableWidth = false;
                this.tableWidth = this.retrieveTableWidth(availableWidth);
            } else if (width != null && width.getValue() >= 0.0f) {
                this.fixedTableWidth = true;
                this.tableWidth = this.retrieveTableWidth(width, availableWidth).floatValue();
            } else {
                this.fixedTableWidth = false;
                this.tableWidth = this.retrieveTableWidth(availableWidth);
            }
        }
        Float min = this.retrieveTableWidth((UnitValue)this.tableRenderer.getProperty(80), availableWidth);
        Float max = this.retrieveTableWidth((UnitValue)this.tableRenderer.getProperty(79), availableWidth);
        this.tableMinWidth = min != null ? min.floatValue() : this.layoutMinWidth;
        float f = this.tableMaxWidth = max != null ? max.floatValue() : this.tableWidth;
        if (this.tableMinWidth > this.tableMaxWidth) {
            this.tableMaxWidth = this.tableMinWidth;
        }
        if (this.tableMinWidth > this.tableWidth) {
            this.tableWidth = this.tableMinWidth;
        }
        if (this.tableMaxWidth < this.tableWidth) {
            this.tableWidth = this.tableMaxWidth;
        }
    }

    private Float retrieveTableWidth(UnitValue width, float availableWidth) {
        if (width == null) {
            return null;
        }
        return Float.valueOf(this.retrieveTableWidth(width.isPercentValue() ? width.getValue() * availableWidth / 100.0f : width.getValue()));
    }

    private float retrieveTableWidth(float width) {
        if (BorderCollapsePropertyValue.SEPARATE.equals(this.tableRenderer.getProperty(114))) {
            width -= this.rightBorderMaxWidth + this.leftBorderMaxWidth;
            width -= (float)(this.numberOfColumns + 1) * this.horizontalBorderSpacing;
        } else {
            width -= (this.rightBorderMaxWidth + this.leftBorderMaxWidth) / 2.0f;
        }
        return Math.max(width, 0.0f);
    }

    private Table getTable() {
        return (Table)this.tableRenderer.getModelElement();
    }

    private void calculateMinMaxWidths() {
        float[] minWidths = new float[this.numberOfColumns];
        float[] maxWidths = new float[this.numberOfColumns];
        for (CellInfo cell : this.cells) {
            int i;
            cell.setParent(this.tableRenderer);
            MinMaxWidth minMax = cell.getCell().getMinMaxWidth();
            if (BorderCollapsePropertyValue.SEPARATE.equals(this.tableRenderer.getProperty(114))) {
                minMax.setAdditionalWidth(minMax.getAdditionalWidth() - this.horizontalBorderSpacing);
            } else {
                float[] indents = this.getCellBorderIndents(cell);
                minMax.setAdditionalWidth(minMax.getAdditionalWidth() + indents[1] / 2.0f + indents[3] / 2.0f);
            }
            if (cell.getColspan() == 1) {
                minWidths[cell.getCol()] = Math.max(minMax.getMinWidth(), minWidths[cell.getCol()]);
                maxWidths[cell.getCol()] = Math.max(minMax.getMaxWidth(), maxWidths[cell.getCol()]);
                continue;
            }
            float remainMin = minMax.getMinWidth();
            float remainMax = minMax.getMaxWidth();
            for (i = cell.getCol(); i < cell.getCol() + cell.getColspan(); ++i) {
                remainMin -= minWidths[i];
                remainMax -= maxWidths[i];
            }
            if (remainMin > 0.0f) {
                i = cell.getCol();
                while (i < cell.getCol() + cell.getColspan()) {
                    int n = i++;
                    minWidths[n] = minWidths[n] + remainMin / (float)cell.getColspan();
                }
            }
            if (!(remainMax > 0.0f)) continue;
            i = cell.getCol();
            while (i < cell.getCol() + cell.getColspan()) {
                int n = i++;
                maxWidths[n] = maxWidths[n] + remainMax / (float)cell.getColspan();
            }
        }
        for (int i = 0; i < this.widths.length; ++i) {
            this.widths[i] = new ColumnWidthData(minWidths[i], maxWidths[i]);
        }
    }

    private float[] getCellBorderIndents(CellInfo cell) {
        TableRenderer renderer = cell.region == 1 ? this.tableRenderer.headerRenderer : (cell.region == 3 ? this.tableRenderer.footerRenderer : this.tableRenderer);
        return renderer.bordersHandler.getCellBorderIndents(cell.getRow(), cell.getCol(), cell.getRowspan(), cell.getColspan());
    }

    private void fillAndSortCells() {
        this.cells = new ArrayList<CellInfo>();
        if (this.tableRenderer.headerRenderer != null) {
            this.fillRendererCells(this.tableRenderer.headerRenderer, (byte)1);
        }
        this.fillRendererCells(this.tableRenderer, (byte)2);
        if (this.tableRenderer.footerRenderer != null) {
            this.fillRendererCells(this.tableRenderer.footerRenderer, (byte)3);
        }
        Collections.sort(this.cells);
    }

    private void fillRendererCells(TableRenderer renderer, byte region) {
        for (int row = 0; row < renderer.rows.size(); ++row) {
            for (int col = 0; col < this.numberOfColumns; ++col) {
                CellRenderer cell = renderer.rows.get(row)[col];
                if (cell == null) continue;
                this.cells.add(new CellInfo(cell, row, col, region));
            }
        }
    }

    private void warn100percent() {
        Logger logger = LoggerFactory.getLogger(TableWidths.class);
        logger.warn("Sum of table columns is greater than 100%.");
    }

    private float[] extractWidths() {
        float actualWidth = 0.0f;
        this.layoutMinWidth = 0.0f;
        float[] columnWidths = new float[this.widths.length];
        for (int i = 0; i < this.widths.length; ++i) {
            assert (this.widths[i].finalWidth >= 0.0f);
            columnWidths[i] = this.widths[i].finalWidth + this.horizontalBorderSpacing;
            actualWidth += this.widths[i].finalWidth;
            this.layoutMinWidth += this.widths[i].min + this.horizontalBorderSpacing;
        }
        if (actualWidth > this.tableWidth + MinMaxWidthUtils.getEps() * (float)this.widths.length) {
            Logger logger = LoggerFactory.getLogger(TableWidths.class);
            logger.warn("Table width is more than expected due to min width of cell(s).");
        }
        return columnWidths;
    }

    public String toString() {
        return "width=" + this.tableWidth + (this.fixedTableWidth ? "!!" : "");
    }

    private UnitValue getCellWidth(CellRenderer cell, boolean zeroIsValid) {
        UnitValue widthValue = new UnitValue(cell.getProperty(77, UnitValue.createPointValue(-1.0f)));
        if (widthValue.getValue() < -1.0E-4f) {
            return null;
        }
        if (widthValue.getValue() < 1.0E-4f) {
            return zeroIsValid ? ZeroWidth : null;
        }
        if (widthValue.isPercentValue()) {
            return widthValue;
        }
        widthValue = this.resolveMinMaxCollision(cell, widthValue);
        if (!AbstractRenderer.isBorderBoxSizing(cell)) {
            Logger logger;
            UnitValue[] paddings;
            Border[] borders = cell.getBorders();
            if (borders[1] != null) {
                widthValue.setValue(widthValue.getValue() + (this.tableRenderer.bordersHandler instanceof SeparatedTableBorders ? borders[1].getWidth() : borders[1].getWidth() / 2.0f));
            }
            if (borders[3] != null) {
                widthValue.setValue(widthValue.getValue() + (this.tableRenderer.bordersHandler instanceof SeparatedTableBorders ? borders[3].getWidth() : borders[3].getWidth() / 2.0f));
            }
            if (!(paddings = cell.getPaddings())[1].isPointValue()) {
                logger = LoggerFactory.getLogger(TableWidths.class);
                logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 48));
            }
            if (!paddings[3].isPointValue()) {
                logger = LoggerFactory.getLogger(TableWidths.class);
                logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 49));
            }
            widthValue.setValue(widthValue.getValue() + paddings[1].getValue() + paddings[3].getValue());
        }
        return widthValue;
    }

    private UnitValue resolveMinMaxCollision(CellRenderer cell, UnitValue widthValue) {
        assert (widthValue.isPointValue());
        UnitValue minWidthValue = (UnitValue)cell.getProperty(80);
        if (minWidthValue != null && minWidthValue.isPointValue() && minWidthValue.getValue() > widthValue.getValue()) {
            return minWidthValue;
        }
        UnitValue maxWidthValue = (UnitValue)cell.getProperty(79);
        if (maxWidthValue != null && maxWidthValue.isPointValue() && maxWidthValue.getValue() < widthValue.getValue()) {
            return maxWidthValue;
        }
        return widthValue;
    }

    static class CellInfo
    implements Comparable<CellInfo> {
        static final byte HEADER = 1;
        static final byte BODY = 2;
        static final byte FOOTER = 3;
        private final CellRenderer cell;
        private final int row;
        private final int col;
        final byte region;

        CellInfo(CellRenderer cell, int row, int col, byte region) {
            this.cell = cell;
            this.region = region;
            this.row = row;
            this.col = col;
        }

        CellRenderer getCell() {
            return this.cell;
        }

        int getCol() {
            return this.col;
        }

        int getColspan() {
            return this.cell.getPropertyAsInteger(16);
        }

        int getRow() {
            return this.row;
        }

        int getRowspan() {
            return this.cell.getPropertyAsInteger(60);
        }

        @Override
        public int compareTo(CellInfo o) {
            if (this.getColspan() == 1 ^ o.getColspan() == 1) {
                return this.getColspan() - o.getColspan();
            }
            if (this.region == o.region && this.getRow() == o.getRow()) {
                return this.getCol() + this.getColspan() - o.getCol() - o.getColspan();
            }
            return this.region == o.region ? this.getRow() - o.getRow() : this.region - o.region;
        }

        public String toString() {
            String str = MessageFormatUtil.format("row={0}, col={1}, rowspan={2}, colspan={3}, ", this.getRow(), this.getCol(), this.getRowspan(), this.getColspan());
            if (this.region == 1) {
                str = str + "header";
            } else if (this.region == 2) {
                str = str + "body";
            } else if (this.region == 3) {
                str = str + "footer";
            }
            return str;
        }

        public void setParent(TableRenderer tableRenderer) {
            if (this.region == 1) {
                this.cell.setParent(tableRenderer.headerRenderer);
            } else if (this.region == 3) {
                this.cell.setParent(tableRenderer.footerRenderer);
            } else {
                this.cell.setParent(tableRenderer);
            }
        }
    }

    private static class ColumnWidthData {
        final float min;
        float max;
        float width = 0.0f;
        float finalWidth = -1.0f;
        boolean isPercent = false;
        boolean isFixed = false;

        ColumnWidthData(float min, float max) {
            assert (min >= 0.0f);
            assert (max >= 0.0f);
            this.min = min > 0.0f ? min + MinMaxWidthUtils.getEps() : 0.0f;
            this.max = max > 0.0f ? Math.min(max + MinMaxWidthUtils.getEps(), 32760.0f) : 0.0f;
        }

        ColumnWidthData setPoints(float width) {
            assert (!this.isPercent);
            assert (this.min <= width);
            this.width = Math.max(this.width, width);
            return this;
        }

        ColumnWidthData resetPoints(float width) {
            assert (this.min <= width);
            this.width = width;
            this.isPercent = false;
            return this;
        }

        ColumnWidthData addPoints(float width) {
            assert (!this.isPercent);
            this.width += width;
            return this;
        }

        ColumnWidthData setPercents(float percent) {
            if (this.isPercent) {
                this.width = Math.max(this.width, percent);
            } else {
                this.isPercent = true;
                this.width = percent;
            }
            this.isFixed = false;
            return this;
        }

        ColumnWidthData addPercents(float width) {
            assert (this.isPercent);
            this.width += width;
            return this;
        }

        ColumnWidthData setFixed(boolean fixed) {
            this.isFixed = fixed;
            return this;
        }

        boolean isFlexible() {
            return !this.isFixed && !this.isPercent;
        }

        public String toString() {
            return "w=" + this.width + (this.isPercent ? "%" : "pt") + (this.isFixed ? " !!" : "") + ", min=" + this.min + ", max=" + this.max + ", finalWidth=" + this.finalWidth;
        }
    }
}

