/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.MulticolContainer;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.properties.ContinuousContainer;
import com.itextpdf.layout.properties.OverflowPropertyValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AreaBreakRenderer;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.GridMulticolUtil;
import com.itextpdf.layout.renderer.IRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class MulticolRenderer
extends AbstractRenderer {
    private static final float ZERO_DELTA = 1.0E-4f;
    private ColumnHeightCalculator heightCalculator;
    private BlockRenderer elementRenderer;
    private int columnCount;
    private float columnWidth;
    private float approximateHeight;
    private Float heightFromProperties;
    private float columnGap;
    private float containerWidth;
    private boolean isFirstLayout = true;

    public MulticolRenderer(MulticolContainer modelElement) {
        super(modelElement);
        this.setHeightCalculator(new LayoutInInfiniteHeightCalculator());
    }

    public final void setHeightCalculator(ColumnHeightCalculator heightCalculator) {
        this.heightCalculator = heightCalculator;
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        this.setProperty(140, Boolean.TRUE);
        this.setOverflowForAllChildren(this);
        Rectangle actualBBox = layoutContext.getArea().getBBox().clone();
        float originalWidth = actualBBox.getWidth();
        ContinuousContainer.setupContinuousContainerIfNeeded(this);
        this.applyPaddings(actualBBox, false);
        this.applyBorderBox(actualBBox, false);
        this.applyMargins(actualBBox, false);
        this.applyWidth(actualBBox, originalWidth);
        this.containerWidth = actualBBox.getWidth();
        this.calculateColumnCountAndWidth(this.containerWidth);
        this.heightFromProperties = this.determineHeight(actualBBox);
        if (this.elementRenderer == null) {
            this.elementRenderer = this.getElementsRenderer();
        }
        this.elementRenderer.setParent(this);
        MulticolLayoutResult layoutResult = this.layoutInColumns(layoutContext, actualBBox);
        if (layoutResult.getSplitRenderers().isEmpty()) {
            for (IRenderer child : this.elementRenderer.getChildRenderers()) {
                child.setParent(this.elementRenderer);
            }
            return new LayoutResult(3, null, null, this, layoutResult.getCauseOfNothing());
        }
        if (layoutResult.getOverflowRenderer() == null) {
            ContinuousContainer continuousContainer = (ContinuousContainer)this.getProperty(141);
            if (continuousContainer != null) {
                continuousContainer.reApplyProperties(this);
            }
            this.childRenderers.clear();
            this.addAllChildRenderers(layoutResult.getSplitRenderers());
            this.occupiedArea = this.calculateContainerOccupiedArea(layoutContext, true);
            return new LayoutResult(1, this.occupiedArea, this, null);
        }
        this.occupiedArea = this.calculateContainerOccupiedArea(layoutContext, false);
        return new LayoutResult(2, this.occupiedArea, GridMulticolUtil.createSplitRenderer(layoutResult.getSplitRenderers(), this), this.createOverflowRenderer(layoutResult.getOverflowRenderer()));
    }

    @Override
    public IRenderer getNextRenderer() {
        this.logWarningIfGetNextRendererNotOverridden(MulticolRenderer.class, this.getClass());
        return new MulticolRenderer((MulticolContainer)this.modelElement);
    }

    @Override
    public void drawBorder(DrawContext drawContext) {
        super.drawBorder(drawContext);
        Rectangle borderRect = this.applyMargins(this.occupiedArea.getBBox().clone(), this.getMargins(), false);
        boolean isAreaClipped = this.clipBorderArea(drawContext, borderRect);
        Border gap = (Border)this.getProperty(144);
        if (this.getChildRenderers().isEmpty() || gap == null || gap.getWidth() <= 1.0E-4f) {
            return;
        }
        this.drawTaggedWhenNeeded(drawContext, canvas -> {
            for (int i = 0; i < this.getChildRenderers().size() - 1; ++i) {
                Rectangle columnBBox = this.getChildRenderers().get(i).getOccupiedArea().getBBox();
                Rectangle columnSpaceBBox = new Rectangle(columnBBox.getX() + columnBBox.getWidth(), columnBBox.getY(), this.columnGap, columnBBox.getHeight());
                float x1 = columnSpaceBBox.getX() + columnSpaceBBox.getWidth() / 2.0f + gap.getWidth() / 2.0f;
                float y1 = columnSpaceBBox.getY();
                float y2 = columnSpaceBBox.getY() + columnSpaceBBox.getHeight();
                gap.draw((PdfCanvas)canvas, x1, y1, x1, y2, Border.Side.RIGHT, 0.0f, 0.0f);
            }
            if (isAreaClipped) {
                drawContext.getCanvas().restoreState();
            }
        });
    }

    protected MulticolLayoutResult layoutInColumns(LayoutContext layoutContext, Rectangle actualBBox) {
        LayoutResult inifiniteHeighOneColumnLayoutResult = this.elementRenderer.layout(new LayoutContext(new LayoutArea(1, new Rectangle(this.columnWidth, 1000000.0f))));
        if (inifiniteHeighOneColumnLayoutResult.getStatus() != 1) {
            MulticolLayoutResult result = new MulticolLayoutResult();
            result.setCauseOfNothing(inifiniteHeighOneColumnLayoutResult.getCauseOfNothing());
            return result;
        }
        this.approximateHeight = inifiniteHeighOneColumnLayoutResult.getOccupiedArea().getBBox().getHeight() / (float)this.columnCount;
        return this.balanceContentAndLayoutColumns(layoutContext, actualBBox);
    }

    protected AbstractRenderer createOverflowRenderer(IRenderer overflowedContentRenderer) {
        MulticolRenderer overflowRenderer = (MulticolRenderer)this.getNextRenderer();
        overflowRenderer.isFirstLayout = false;
        overflowRenderer.parent = this.parent;
        overflowRenderer.modelElement = this.modelElement;
        overflowRenderer.addAllProperties(this.getOwnProperties());
        ArrayList<IRenderer> children = new ArrayList<IRenderer>(1);
        children.add(overflowedContentRenderer);
        overflowRenderer.setChildRenderers(children);
        ContinuousContainer.clearPropertiesFromOverFlowRenderer(overflowRenderer);
        return overflowRenderer;
    }

    private void setOverflowForAllChildren(IRenderer renderer) {
        if (renderer == null || renderer instanceof AreaBreakRenderer) {
            return;
        }
        renderer.setProperty(103, (Object)OverflowPropertyValue.VISIBLE);
        for (IRenderer child : renderer.getChildRenderers()) {
            this.setOverflowForAllChildren(child);
        }
    }

    private void drawTaggedWhenNeeded(DrawContext drawContext, Consumer<PdfCanvas> action) {
        PdfCanvas canvas = drawContext.getCanvas();
        if (drawContext.isTaggingEnabled()) {
            canvas.openTag(new CanvasArtifact());
        }
        action.accept(canvas);
        if (drawContext.isTaggingEnabled()) {
            canvas.closeTag();
        }
    }

    private void applyWidth(Rectangle parentBbox, float originalWidth) {
        Float blockWidth = this.retrieveWidth(originalWidth);
        if (blockWidth != null) {
            parentBbox.setWidth(blockWidth.floatValue());
        } else {
            Float minWidth = this.retrieveMinWidth(parentBbox.getWidth());
            if (minWidth != null && minWidth.floatValue() > parentBbox.getWidth()) {
                parentBbox.setWidth(minWidth.floatValue());
            }
        }
    }

    private Float determineHeight(Rectangle parentBBox) {
        Float height = this.retrieveHeight();
        Float minHeight = this.retrieveMinHeight();
        Float maxHeight = this.retrieveMaxHeight();
        if ((height == null || minHeight != null && height.floatValue() < minHeight.floatValue()) && minHeight != null && parentBBox.getHeight() < minHeight.floatValue()) {
            height = minHeight;
        }
        if (height != null && maxHeight != null && height.floatValue() > maxHeight.floatValue()) {
            height = maxHeight;
        }
        return height;
    }

    private MulticolLayoutResult balanceContentAndLayoutColumns(LayoutContext prelayoutContext, Rectangle actualBbox) {
        MulticolLayoutResult result = new MulticolLayoutResult();
        int counter = this.heightCalculator.maxAmountOfRelayouts() + 1;
        float maxHeight = actualBbox.getHeight();
        boolean isLastLayout = false;
        while (counter-- > 0) {
            if (this.approximateHeight > maxHeight) {
                isLastLayout = true;
                this.approximateHeight = maxHeight;
            }
            float workingHeight = this.approximateHeight;
            if (this.heightFromProperties != null) {
                workingHeight = Math.min(this.heightFromProperties.floatValue(), this.approximateHeight);
            }
            if ((result = this.layoutColumnsAndReturnOverflowRenderer(prelayoutContext, actualBbox, workingHeight)).getOverflowRenderer() == null || isLastLayout) {
                this.clearOverFlowRendererIfNeeded(result);
                return result;
            }
            float additionalHeightPerIteration = this.heightCalculator.getAdditionalHeightOfEachColumn(this, result).floatValue();
            if (Math.abs(additionalHeightPerIteration) <= 1.0E-4f) {
                this.clearOverFlowRendererIfNeeded(result);
                return result;
            }
            this.approximateHeight += additionalHeightPerIteration;
            this.clearOverFlowRendererIfNeeded(result);
        }
        return result;
    }

    private void calculateColumnCountAndWidth(float initialWidth) {
        float columnWidthPlusGap;
        Integer columnCountTemp = (Integer)this.getProperty(138);
        Float columnWidthTemp = (Float)this.getProperty(142);
        Float columnGapTemp = (Float)this.getProperty(143);
        float f = this.columnGap = columnGapTemp == null ? 0.0f : columnGapTemp.floatValue();
        if (columnCountTemp == null && columnWidthTemp == null || columnCountTemp != null && columnCountTemp < 0 || columnWidthTemp != null && columnWidthTemp.floatValue() < 0.0f || this.columnGap < 0.0f) {
            throw new IllegalStateException("Invalid column-count/column-width/column-gap properties, they're absent or have negative value");
        }
        this.columnCount = columnWidthTemp == null ? columnCountTemp : (columnCountTemp == null ? ((columnWidthPlusGap = columnWidthTemp.floatValue() + this.columnGap) > 1.0E-4f ? Math.max(1, (int)Math.floor((initialWidth + this.columnGap) / columnWidthPlusGap)) : 1) : ((columnWidthPlusGap = columnWidthTemp.floatValue() + this.columnGap) > 1.0E-4f ? Math.min(columnCountTemp, Math.max(1, (int)Math.floor((initialWidth + this.columnGap) / columnWidthPlusGap))) : 1));
        this.columnWidth = Math.max(0.0f, (initialWidth + this.columnGap) / (float)this.columnCount - this.columnGap);
    }

    private void clearOverFlowRendererIfNeeded(MulticolLayoutResult result) {
        if (this.heightFromProperties != null && this.heightFromProperties.floatValue() < this.approximateHeight) {
            result.setOverflowRenderer(null);
        }
    }

    private LayoutArea calculateContainerOccupiedArea(LayoutContext layoutContext, boolean isFull) {
        LayoutArea area = layoutContext.getArea().clone();
        Rectangle areaBBox = area.getBBox();
        float totalContainerHeight = GridMulticolUtil.updateOccupiedHeight(this.approximateHeight, isFull, this);
        if (totalContainerHeight < areaBBox.getHeight() || isFull) {
            areaBBox.setHeight(totalContainerHeight);
            Float height = this.determineHeight(areaBBox);
            if (height != null) {
                height = Float.valueOf(GridMulticolUtil.updateOccupiedHeight(height.floatValue(), isFull, this));
                areaBBox.setHeight(height.floatValue());
            }
        }
        Rectangle initialBBox = layoutContext.getArea().getBBox();
        areaBBox.setY(initialBBox.getY() + initialBBox.getHeight() - areaBBox.getHeight());
        float totalContainerWidth = GridMulticolUtil.updateOccupiedWidth(this.containerWidth, this);
        areaBBox.setWidth(totalContainerWidth);
        return area;
    }

    private BlockRenderer getElementsRenderer() {
        if (this.getChildRenderers().size() != 1 || !(this.getChildRenderers().get(0) instanceof BlockRenderer)) {
            throw new IllegalStateException("Invalid child renderers, it should be one and be a block element");
        }
        return (BlockRenderer)this.getChildRenderers().get(0);
    }

    private MulticolLayoutResult layoutColumnsAndReturnOverflowRenderer(LayoutContext preLayoutContext, Rectangle actualBBox, float workingHeight) {
        MulticolLayoutResult result = new MulticolLayoutResult();
        IRenderer renderer = this.elementRenderer;
        for (int i = 0; i < this.columnCount && renderer != null; ++i) {
            LayoutArea tempArea = preLayoutContext.getArea().clone();
            tempArea.getBBox().setWidth(this.columnWidth);
            tempArea.getBBox().setHeight(workingHeight);
            tempArea.getBBox().setX(actualBBox.getX() + (this.columnWidth + this.columnGap) * (float)i);
            tempArea.getBBox().setY(actualBBox.getY() + actualBBox.getHeight() - tempArea.getBBox().getHeight());
            LayoutContext columnContext = new LayoutContext(tempArea, preLayoutContext.getMarginsCollapseInfo(), preLayoutContext.getFloatRendererAreas(), preLayoutContext.isClippedHeight());
            renderer.setProperty(89, false);
            LayoutResult tempResultColumn = renderer.layout(columnContext);
            if (tempResultColumn.getStatus() == 3) {
                result.setOverflowRenderer((AbstractRenderer)renderer);
                result.setCauseOfNothing(tempResultColumn.getCauseOfNothing());
                return result;
            }
            if (tempResultColumn.getSplitRenderer() == null) {
                result.getSplitRenderers().add(renderer);
            } else {
                result.getSplitRenderers().add(tempResultColumn.getSplitRenderer());
            }
            renderer = tempResultColumn.getOverflowRenderer();
        }
        result.setOverflowRenderer((AbstractRenderer)renderer);
        return result;
    }

    public static class LayoutInInfiniteHeightCalculator
    implements ColumnHeightCalculator {
        protected int maxRelayoutCount = 4;
        private Float height = null;

        @Override
        public Float getAdditionalHeightOfEachColumn(MulticolRenderer renderer, MulticolLayoutResult result) {
            if (this.height != null) {
                return this.height;
            }
            if (result.getOverflowRenderer() == null) {
                return Float.valueOf(0.0f);
            }
            LayoutResult overflowResult = result.getOverflowRenderer().layout(new LayoutContext(new LayoutArea(1, new Rectangle(renderer.columnWidth, 1000000.0f))));
            float overflowHeight = overflowResult.getOccupiedArea().getBBox().getHeight();
            if (result.getSplitRenderers().isEmpty()) {
                overflowHeight -= renderer.approximateHeight;
            }
            this.height = Float.valueOf(overflowHeight / (float)this.maxRelayoutCount);
            return this.height;
        }

        @Override
        public int maxAmountOfRelayouts() {
            return this.maxRelayoutCount;
        }
    }

    public static class MulticolLayoutResult {
        private List<IRenderer> splitRenderers = new ArrayList<IRenderer>();
        private AbstractRenderer overflowRenderer;
        private IRenderer causeOfNothing;

        public List<IRenderer> getSplitRenderers() {
            return this.splitRenderers;
        }

        public AbstractRenderer getOverflowRenderer() {
            return this.overflowRenderer;
        }

        public void setOverflowRenderer(AbstractRenderer overflowRenderer) {
            this.overflowRenderer = overflowRenderer;
        }

        public IRenderer getCauseOfNothing() {
            return this.causeOfNothing;
        }

        public void setCauseOfNothing(IRenderer causeOfNothing) {
            this.causeOfNothing = causeOfNothing;
        }
    }

    public static interface ColumnHeightCalculator {
        public Float getAdditionalHeightOfEachColumn(MulticolRenderer var1, MulticolLayoutResult var2);

        public int maxAmountOfRelayouts();
    }
}

