/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.utils.annotationsflattening;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.utils.annotationsflattening.IAnnotationFlattener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAnnotationFlattener
implements IAnnotationFlattener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAnnotationFlattener.class);

    @Override
    public boolean flatten(PdfAnnotation annotation, PdfPage page) {
        if (annotation == null) {
            throw new PdfException(MessageFormatUtil.format("{0} should not be null.", "annotation"));
        }
        if (page == null) {
            throw new PdfException(MessageFormatUtil.format("{0} should not be null.", "page"));
        }
        PdfArray pdfArrayRectangle = annotation.getRectangle();
        if (pdfArrayRectangle == null) {
            return false;
        }
        PdfDictionary normalAppearance = annotation.getNormalAppearanceObject();
        if (normalAppearance instanceof PdfStream) {
            Rectangle area = annotation.getRectangle().toRectangle();
            PdfCanvas under = this.createCanvas(page);
            PdfStream annotationNormalAppearanceStream = (PdfStream)normalAppearance;
            under.addXObjectFittedIntoRectangle(new PdfFormXObject(annotationNormalAppearanceStream), area);
            page.removeAnnotation(annotation);
            return true;
        }
        boolean drawn = this.draw(annotation, page);
        if (drawn) {
            page.removeAnnotation(annotation);
            return true;
        }
        String message = MessageFormatUtil.format("Flattening annotation type {0} is not yet supported, it will not be removed from the page", annotation.getSubtype());
        LOGGER.warn(message);
        return false;
    }

    protected PdfCanvas createCanvas(PdfPage page) {
        return new PdfCanvas(page.newContentStreamAfter(), page.getResources(), page.getDocument());
    }

    protected boolean draw(PdfAnnotation annotation, PdfPage page) {
        return false;
    }
}

