/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.function;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.function.IPdfFunction;
import com.itextpdf.kernel.pdf.function.PdfType0Function;
import com.itextpdf.kernel.pdf.function.PdfType2Function;
import com.itextpdf.kernel.pdf.function.PdfType3Function;
import com.itextpdf.kernel.pdf.function.PdfType4Function;

public final class PdfFunctionFactory {
    public static final int FUNCTION_TYPE_0 = 0;
    public static final int FUNCTION_TYPE_2 = 2;
    public static final int FUNCTION_TYPE_3 = 3;
    public static final int FUNCTION_TYPE_4 = 4;

    private PdfFunctionFactory() {
    }

    public static IPdfFunction create(PdfObject pdfObject) {
        if (pdfObject.isDictionary() || pdfObject.isStream()) {
            PdfDictionary dict = (PdfDictionary)pdfObject;
            switch (dict.getAsNumber(PdfName.FunctionType).intValue()) {
                case 0: {
                    if (pdfObject.getType() != 9) {
                        throw new PdfException("Invalid object type, a function type 0 requires a stream object");
                    }
                    return new PdfType0Function((PdfStream)pdfObject);
                }
                case 2: {
                    return new PdfType2Function(dict);
                }
                case 3: {
                    return new PdfType3Function(dict);
                }
                case 4: {
                    if (pdfObject.getType() != 9) {
                        throw new PdfException("Invalid object type, a function type 4 requires a stream object");
                    }
                    return new PdfType4Function((PdfStream)pdfObject);
                }
            }
            throw new PdfException(MessageFormatUtil.format("Invalid function type {0}", dict.getAsNumber(PdfName.FunctionType).intValue()));
        }
        throw new PdfException("Invalid object type, a function must be either a Dictionary or a Stream");
    }
}

