/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.io.source.ByteArrayOutputStream;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfStream;
import java.io.OutputStream;

class PdfObjectStream
extends PdfStream {
    public static final int MAX_OBJ_STREAM_SIZE = 200;
    protected PdfNumber size = new PdfNumber(0);
    protected PdfOutputStream indexStream;

    public PdfObjectStream(PdfDocument doc) {
        this(doc, new ByteArrayOutputStream());
        this.indexStream = new PdfOutputStream(new ByteArrayOutputStream());
    }

    PdfObjectStream(PdfObjectStream prev) {
        this(prev.getIndirectReference().getDocument(), prev.getOutputStream().getOutputStream());
        this.indexStream = new PdfOutputStream(prev.indexStream.getOutputStream());
        ((ByteArrayOutputStream)this.outputStream.getOutputStream()).reset();
        ((ByteArrayOutputStream)this.indexStream.getOutputStream()).reset();
        prev.releaseContent(true);
    }

    private PdfObjectStream(PdfDocument doc, OutputStream outputStream) {
        super(outputStream);
        this.makeIndirect(doc, doc.getXref().createNewIndirectReference(doc));
        this.getOutputStream().document = doc;
        this.put(PdfName.Type, PdfName.ObjStm);
        this.put(PdfName.N, this.size);
        this.put(PdfName.First, new PdfNumber(0));
    }

    public void addObject(PdfObject object) {
        if (this.size.intValue() == 200) {
            throw new PdfException("PdfObjectStream reach max size.");
        }
        PdfOutputStream outputStream = this.getOutputStream();
        ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)this.indexStream.writeInteger(object.getIndirectReference().getObjNumber())).writeSpace()).writeLong(outputStream.getCurrentPos())).writeSpace();
        outputStream.write(object);
        object.getIndirectReference().setObjStreamNumber(this.getIndirectReference().getObjNumber());
        object.getIndirectReference().setIndex(this.size.intValue());
        outputStream.writeSpace();
        this.size.increment();
        this.getAsNumber(PdfName.First).setValue(this.indexStream.getCurrentPos());
    }

    public int getSize() {
        return this.size.intValue();
    }

    public PdfOutputStream getIndexStream() {
        return this.indexStream;
    }

    @Override
    protected void releaseContent() {
        this.releaseContent(false);
    }

    private void releaseContent(boolean close) {
        if (close) {
            this.outputStream = null;
            this.indexStream = null;
            super.releaseContent();
        }
    }
}

