/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.commons.utils.StringNormalizer;
import com.itextpdf.kernel.pdf.PdfAConformance;
import com.itextpdf.kernel.pdf.PdfUAConformance;
import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import com.itextpdf.kernel.xmp.XMPMetaFactory;
import com.itextpdf.kernel.xmp.XMPUtils;
import com.itextpdf.kernel.xmp.options.PropertyOptions;
import com.itextpdf.kernel.xmp.properties.XMPProperty;

public class PdfConformance {
    public static final String PDF_A_4_REVISION = "2020";
    public static final PdfConformance PDF_A_1A = new PdfConformance(PdfAConformance.PDF_A_1A);
    public static final PdfConformance PDF_A_1B = new PdfConformance(PdfAConformance.PDF_A_1B);
    public static final PdfConformance PDF_A_2A = new PdfConformance(PdfAConformance.PDF_A_2A);
    public static final PdfConformance PDF_A_2B = new PdfConformance(PdfAConformance.PDF_A_2B);
    public static final PdfConformance PDF_A_2U = new PdfConformance(PdfAConformance.PDF_A_2U);
    public static final PdfConformance PDF_A_3A = new PdfConformance(PdfAConformance.PDF_A_3A);
    public static final PdfConformance PDF_A_3B = new PdfConformance(PdfAConformance.PDF_A_3B);
    public static final PdfConformance PDF_A_3U = new PdfConformance(PdfAConformance.PDF_A_3U);
    public static final PdfConformance PDF_A_4 = new PdfConformance(PdfAConformance.PDF_A_4);
    public static final PdfConformance PDF_A_4E = new PdfConformance(PdfAConformance.PDF_A_4E);
    public static final PdfConformance PDF_A_4F = new PdfConformance(PdfAConformance.PDF_A_4F);
    public static final PdfConformance PDF_UA_1 = new PdfConformance(PdfUAConformance.PDF_UA_1);
    public static final PdfConformance PDF_UA_2 = new PdfConformance(PdfUAConformance.PDF_UA_2);
    public static final PdfConformance PDF_NONE_CONFORMANCE = new PdfConformance();
    private final PdfAConformance aConformance;
    private final PdfUAConformance uaConformance;
    private static final String PDF_UA_EXTENSION = "    <x:xmpmeta xmlns:x=\"adobe:ns:meta/\">\n      <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n        <rdf:Description rdf:about=\"\" xmlns:pdfaExtension=\"http://www.aiim.org/pdfa/ns/extension/\" xmlns:pdfaSchema=\"http://www.aiim.org/pdfa/ns/schema#\" xmlns:pdfaProperty=\"http://www.aiim.org/pdfa/ns/property#\">\n          <pdfaExtension:schemas>\n            <rdf:Bag>\n              <rdf:li rdf:parseType=\"Resource\">\n                <pdfaSchema:namespaceURI rdf:resource=\"http://www.aiim.org/pdfua/ns/id/\"/>\n                <pdfaSchema:prefix>pdfuaid</pdfaSchema:prefix>\n                <pdfaSchema:schema>PDF/UA identification schema</pdfaSchema:schema>\n                <pdfaSchema:property>\n                  <rdf:Seq>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:category>internal</pdfaProperty:category>\n                      <pdfaProperty:description>PDF/UA version identifier</pdfaProperty:description>\n                      <pdfaProperty:name>part</pdfaProperty:name>\n                      <pdfaProperty:valueType>Integer</pdfaProperty:valueType>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:category>internal</pdfaProperty:category>\n                      <pdfaProperty:description>PDF/UA amendment identifier</pdfaProperty:description>\n                      <pdfaProperty:name>amd</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:category>internal</pdfaProperty:category>\n                      <pdfaProperty:description>PDF/UA corrigenda identifier</pdfaProperty:description>\n                      <pdfaProperty:name>corr</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                    </rdf:li>\n                  </rdf:Seq>\n                </pdfaSchema:property>\n              </rdf:li>\n            </rdf:Bag>\n          </pdfaExtension:schemas>\n        </rdf:Description>\n      </rdf:RDF>\n    </x:xmpmeta>";

    public PdfConformance(PdfAConformance aConformance, PdfUAConformance uaConformance) {
        this.aConformance = aConformance;
        this.uaConformance = uaConformance;
    }

    public PdfConformance(PdfAConformance aConformance) {
        this.aConformance = aConformance;
        this.uaConformance = null;
    }

    public PdfConformance(PdfUAConformance uaConformance) {
        this.uaConformance = uaConformance;
        this.aConformance = null;
    }

    public PdfConformance() {
        this.aConformance = null;
        this.uaConformance = null;
    }

    public boolean isPdfA() {
        return this.aConformance != null;
    }

    public boolean isPdfUA() {
        return this.uaConformance != null;
    }

    public boolean isPdfAOrUa() {
        return this.isPdfA() || this.isPdfUA();
    }

    public PdfAConformance getAConformance() {
        return this.aConformance;
    }

    public PdfUAConformance getUAConformance() {
        return this.uaConformance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfConformance that = (PdfConformance)o;
        return this.aConformance == that.aConformance && this.uaConformance == that.uaConformance;
    }

    public int hashCode() {
        int result = this.aConformance == null ? 0 : this.aConformance.hashCode();
        result = 31 * result + (this.uaConformance == null ? 0 : this.uaConformance.hashCode());
        return result;
    }

    public static PdfConformance getConformance(XMPMeta meta) {
        if (meta == null) {
            return PDF_NONE_CONFORMANCE;
        }
        XMPProperty conformanceAXmpProperty = null;
        XMPProperty partAXmpProperty = null;
        PdfAConformance aLevel = null;
        try {
            conformanceAXmpProperty = meta.getProperty("http://www.aiim.org/pdfa/ns/id/", "conformance");
            partAXmpProperty = meta.getProperty("http://www.aiim.org/pdfa/ns/id/", "part");
        }
        catch (XMPException xMPException) {
            // empty catch block
        }
        if (partAXmpProperty != null && (conformanceAXmpProperty != null || "4".equals(partAXmpProperty.getValue()))) {
            aLevel = PdfConformance.getAConformance(partAXmpProperty.getValue(), conformanceAXmpProperty == null ? null : conformanceAXmpProperty.getValue());
        }
        XMPProperty partUAXmpProperty = null;
        PdfUAConformance uaLevel = null;
        try {
            partUAXmpProperty = meta.getProperty("http://www.aiim.org/pdfua/ns/id/", "part");
        }
        catch (XMPException xMPException) {
            // empty catch block
        }
        if (partUAXmpProperty != null) {
            uaLevel = PdfConformance.getUAConformance(partUAXmpProperty.getValue());
        }
        return new PdfConformance(aLevel, uaLevel);
    }

    public static void setConformanceToXmp(XMPMeta xmpMeta, PdfConformance conformance) throws XMPException {
        if (conformance == null) {
            return;
        }
        if (conformance.isPdfUA()) {
            if (xmpMeta.getProperty("http://www.aiim.org/pdfua/ns/id/", "part") == null) {
                xmpMeta.setPropertyInteger("http://www.aiim.org/pdfua/ns/id/", "part", Integer.parseInt(conformance.getUAConformance().getPart()), new PropertyOptions(0x40000000));
            }
            if (conformance.getUAConformance() == PdfUAConformance.PDF_UA_2 && xmpMeta.getProperty("http://www.aiim.org/pdfua/ns/id/", "rev") == null) {
                xmpMeta.setPropertyInteger("http://www.aiim.org/pdfua/ns/id/", "rev", 2024);
            }
        }
        if (conformance.isPdfA()) {
            PdfAConformance aLevel = conformance.getAConformance();
            if (xmpMeta.getProperty("http://www.aiim.org/pdfa/ns/id/", "part") == null) {
                xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", aLevel.getPart());
            }
            if (aLevel.getLevel() != null && xmpMeta.getProperty("http://www.aiim.org/pdfa/ns/id/", "conformance") == null) {
                xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", aLevel.getLevel());
            }
            if ("4".equals(aLevel.getPart()) && xmpMeta.getProperty("http://www.aiim.org/pdfa/ns/id/", "rev") == null) {
                xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "rev", PDF_A_4_REVISION);
            }
            if (xmpMeta.getPropertyInteger("http://www.aiim.org/pdfua/ns/id/", "part") != null) {
                XMPMeta taggedExtensionMeta = XMPMetaFactory.parseFromString(PDF_UA_EXTENSION);
                XMPUtils.appendProperties(taggedExtensionMeta, xmpMeta, true, false);
            }
        }
    }

    public static PdfAConformance getAConformance(String part, String level) {
        String lowLetter = StringNormalizer.toUpperCase(level);
        boolean aLevel = "A".equals(lowLetter);
        boolean bLevel = "B".equals(lowLetter);
        boolean uLevel = "U".equals(lowLetter);
        boolean eLevel = "E".equals(lowLetter);
        boolean fLevel = "F".equals(lowLetter);
        switch (part) {
            case "1": {
                if (aLevel) {
                    return PdfAConformance.PDF_A_1A;
                }
                if (!bLevel) break;
                return PdfAConformance.PDF_A_1B;
            }
            case "2": {
                if (aLevel) {
                    return PdfAConformance.PDF_A_2A;
                }
                if (bLevel) {
                    return PdfAConformance.PDF_A_2B;
                }
                if (!uLevel) break;
                return PdfAConformance.PDF_A_2U;
            }
            case "3": {
                if (aLevel) {
                    return PdfAConformance.PDF_A_3A;
                }
                if (bLevel) {
                    return PdfAConformance.PDF_A_3B;
                }
                if (!uLevel) break;
                return PdfAConformance.PDF_A_3U;
            }
            case "4": {
                if (eLevel) {
                    return PdfAConformance.PDF_A_4E;
                }
                if (fLevel) {
                    return PdfAConformance.PDF_A_4F;
                }
                return PdfAConformance.PDF_A_4;
            }
        }
        return null;
    }

    private static PdfUAConformance getUAConformance(String part) {
        if ("1".equals(part)) {
            return PdfUAConformance.PDF_UA_1;
        }
        if ("2".equals(part)) {
            return PdfUAConformance.PDF_UA_2;
        }
        return null;
    }
}

