/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.mac;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1EncodableVector;
import com.itextpdf.commons.bouncycastle.asn1.IDERSequence;
import com.itextpdf.commons.bouncycastle.asn1.IDERSet;
import com.itextpdf.io.source.IRandomAccessSource;
import com.itextpdf.io.source.RASInputStream;
import com.itextpdf.io.source.RandomAccessSourceFactory;
import com.itextpdf.kernel.crypto.DigestAlgorithms;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.mac.MacContainerReader;
import com.itextpdf.kernel.mac.MacProperties;
import com.itextpdf.kernel.mac.MacValidationException;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;

public abstract class AbstractMacIntegrityProtector {
    private static final IBouncyCastleFactory BC_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private static final String PDF_MAC = "PDFMAC";
    protected final PdfDocument document;
    protected final MacProperties macProperties;
    protected byte[] kdfSalt = null;
    protected byte[] fileEncryptionKey = new byte[0];
    private final MacContainerReader macContainerReader;

    protected AbstractMacIntegrityProtector(PdfDocument document, MacProperties macProperties) {
        this.document = document;
        this.macContainerReader = null;
        this.macProperties = macProperties;
    }

    protected AbstractMacIntegrityProtector(PdfDocument document, PdfDictionary authDictionary) {
        this.document = document;
        this.macContainerReader = MacContainerReader.getInstance(authDictionary);
        this.macProperties = new MacProperties(AbstractMacIntegrityProtector.getMacDigestAlgorithm(this.macContainerReader.parseDigestAlgorithm()));
    }

    public void setFileEncryptionKey(byte[] fileEncryptionKey) {
        this.fileEncryptionKey = fileEncryptionKey;
    }

    public byte[] getKdfSalt() {
        if (this.kdfSalt == null) {
            this.kdfSalt = AbstractMacIntegrityProtector.generateRandomBytes(32);
        }
        return Arrays.copyOf(this.kdfSalt, this.kdfSalt.length);
    }

    public void setKdfSalt(byte[] kdfSalt) {
        this.kdfSalt = Arrays.copyOf(kdfSalt, kdfSalt.length);
    }

    public void validateMacToken() {
        if (this.kdfSalt == null) {
            throw new MacValidationException("MAC token validation failed. Salt is not found.");
        }
        try {
            byte[] dataDigest;
            byte[] macKey = this.generateDecryptedKey(this.macContainerReader.parseMacKey());
            long[] byteRange = this.macContainerReader.getByteRange();
            IRandomAccessSource randomAccessSource = this.document.getReader().getSafeFile().createSourceView();
            try (RASInputStream rg = new RASInputStream(new RandomAccessSourceFactory().createRanged(randomAccessSource, byteRange));){
                dataDigest = this.digestBytes(rg);
            }
            byte[] expectedData = this.macContainerReader.parseAuthAttributes().getEncoded();
            byte[] expectedMac = this.generateMac(macKey, expectedData);
            byte[] signatureDigest = this.digestBytes(this.macContainerReader.getSignature());
            byte[] expectedMessageDigest = this.createMessageDigestSequence(AbstractMacIntegrityProtector.createPdfMacIntegrityInfo(dataDigest, signatureDigest)).getEncoded();
            byte[] actualMessageDigest = this.macContainerReader.parseMessageDigest().getEncoded();
            byte[] actualMac = this.macContainerReader.parseMac();
            if (!Arrays.equals(expectedMac, actualMac) || !Arrays.equals(expectedMessageDigest, actualMessageDigest)) {
                throw new MacValidationException("MAC integrity protection was compromised. Document content was modified.");
            }
        }
        catch (PdfException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MacValidationException("Unexpected exception occurred during MAC token validation.", e);
        }
    }

    protected byte[] digestBytes(byte[] bytes) throws NoSuchAlgorithmException, IOException, NoSuchProviderException {
        return bytes == null ? null : this.digestBytes(new ByteArrayInputStream(bytes));
    }

    protected byte[] digestBytes(InputStream inputStream) throws NoSuchAlgorithmException, IOException, NoSuchProviderException {
        int rd;
        if (inputStream == null) {
            return null;
        }
        String algorithm = MacProperties.macDigestAlgorithmToString(this.macProperties.getMacDigestAlgorithm());
        MessageDigest digest = DigestAlgorithms.getMessageDigest(algorithm, BC_FACTORY.getProviderName());
        byte[] buf = new byte[8192];
        while ((rd = inputStream.read(buf, 0, buf.length)) > 0) {
            digest.update(buf, 0, rd);
        }
        return digest.digest();
    }

    protected IDERSequence createMacContainer(byte[] dataDigest, byte[] macKey, byte[] signature) throws GeneralSecurityException, IOException {
        IASN1EncodableVector contentInfoV = BC_FACTORY.createASN1EncodableVector();
        contentInfoV.add(BC_FACTORY.createASN1ObjectIdentifier("1.2.840.113549.1.9.16.1.2"));
        IASN1EncodableVector recInfoV = BC_FACTORY.createASN1EncodableVector();
        recInfoV.add(BC_FACTORY.createASN1Integer(0));
        recInfoV.add(BC_FACTORY.createDERTaggedObject(0, BC_FACTORY.createASN1ObjectIdentifier("1.0.32004.1.1")));
        recInfoV.add(BC_FACTORY.createDERSequence(BC_FACTORY.createASN1ObjectIdentifier(this.getKeyWrappingAlgorithmOid())));
        byte[] macKek = BC_FACTORY.generateHKDF(this.fileEncryptionKey, this.kdfSalt, PDF_MAC.getBytes(StandardCharsets.UTF_8));
        byte[] encryptedKey = this.generateEncryptedKey(macKey, macKek);
        recInfoV.add(BC_FACTORY.createDEROctetString(encryptedKey));
        byte[] messageBytes = AbstractMacIntegrityProtector.createPdfMacIntegrityInfo(dataDigest, signature == null ? null : this.digestBytes(signature));
        IASN1EncodableVector encapContentInfoV = BC_FACTORY.createASN1EncodableVector();
        encapContentInfoV.add(BC_FACTORY.createASN1ObjectIdentifier("1.0.32004.1.0"));
        encapContentInfoV.add(BC_FACTORY.createDERTaggedObject(0, BC_FACTORY.createDEROctetString(messageBytes)));
        IDERSet authAttrs = this.createAuthAttributes(messageBytes);
        byte[] data = authAttrs.getEncoded();
        byte[] mac = this.generateMac(macKey, data);
        IASN1EncodableVector authDataV = BC_FACTORY.createASN1EncodableVector();
        authDataV.add(BC_FACTORY.createASN1Integer(0));
        authDataV.add(BC_FACTORY.createDERSet(BC_FACTORY.createDERTaggedObject(false, 3, BC_FACTORY.createDERSequence(recInfoV))));
        authDataV.add(BC_FACTORY.createDERSequence(BC_FACTORY.createASN1ObjectIdentifier(this.getMacAlgorithmOid())));
        String algorithm = MacProperties.macDigestAlgorithmToString(this.macProperties.getMacDigestAlgorithm());
        String macDigestOid = DigestAlgorithms.getAllowedDigest(algorithm);
        authDataV.add(BC_FACTORY.createDERTaggedObject(false, 1, BC_FACTORY.createDERSequence(BC_FACTORY.createASN1ObjectIdentifier(macDigestOid))));
        authDataV.add(BC_FACTORY.createDERSequence(encapContentInfoV));
        authDataV.add(BC_FACTORY.createDERTaggedObject(false, 2, authAttrs));
        authDataV.add(BC_FACTORY.createDEROctetString(mac));
        contentInfoV.add(BC_FACTORY.createDERTaggedObject(0, BC_FACTORY.createDERSequence(authDataV)));
        return BC_FACTORY.createDERSequence(contentInfoV);
    }

    private byte[] generateMac(byte[] macKey, byte[] data) throws NoSuchAlgorithmException, InvalidKeyException {
        switch (this.macProperties.getMacAlgorithm()) {
            case HMAC_WITH_SHA_256: {
                return BC_FACTORY.generateHMACSHA256Token(macKey, data);
            }
        }
        throw new PdfException("This MAC algorithm is not supported.");
    }

    private byte[] generateEncryptedKey(byte[] macKey, byte[] macKek) throws GeneralSecurityException {
        switch (this.macProperties.getKeyWrappingAlgorithm()) {
            case AES_256_NO_PADD: {
                return BC_FACTORY.generateEncryptedKeyWithAES256NoPad(macKey, macKek);
            }
        }
        throw new PdfException("This wrapping algorithm is not supported.");
    }

    private byte[] generateDecryptedKey(byte[] encryptedMacKey) throws GeneralSecurityException {
        byte[] macKek = BC_FACTORY.generateHKDF(this.fileEncryptionKey, this.kdfSalt, PDF_MAC.getBytes(StandardCharsets.UTF_8));
        switch (this.macProperties.getKeyWrappingAlgorithm()) {
            case AES_256_NO_PADD: {
                return BC_FACTORY.generateDecryptedKeyWithAES256NoPad(encryptedMacKey, macKek);
            }
        }
        throw new PdfException("This wrapping algorithm is not supported.");
    }

    private String getMacAlgorithmOid() {
        switch (this.macProperties.getMacAlgorithm()) {
            case HMAC_WITH_SHA_256: {
                return "1.2.840.113549.2.9";
            }
        }
        throw new PdfException("This MAC algorithm is not supported.");
    }

    private String getKeyWrappingAlgorithmOid() {
        switch (this.macProperties.getKeyWrappingAlgorithm()) {
            case AES_256_NO_PADD: {
                return "2.16.840.1.101.3.4.1.45";
            }
        }
        throw new PdfException("This wrapping algorithm is not supported.");
    }

    private IDERSequence createMessageDigestSequence(byte[] messageBytes) throws NoSuchAlgorithmException, IOException, NoSuchProviderException {
        String algorithm = MacProperties.macDigestAlgorithmToString(this.macProperties.getMacDigestAlgorithm());
        MessageDigest digest = DigestAlgorithms.getMessageDigest(algorithm, BC_FACTORY.getProviderName());
        digest.update(messageBytes);
        byte[] messageDigest = this.digestBytes(messageBytes);
        IASN1EncodableVector messageDigestV = BC_FACTORY.createASN1EncodableVector();
        messageDigestV.add(BC_FACTORY.createASN1ObjectIdentifier("1.2.840.113549.1.9.4"));
        messageDigestV.add(BC_FACTORY.createDERSet(BC_FACTORY.createDEROctetString(messageDigest)));
        return BC_FACTORY.createDERSequence(messageDigestV);
    }

    private IDERSet createAuthAttributes(byte[] messageBytes) throws NoSuchAlgorithmException, IOException, NoSuchProviderException {
        IASN1EncodableVector contentTypeInfoV = BC_FACTORY.createASN1EncodableVector();
        contentTypeInfoV.add(BC_FACTORY.createASN1ObjectIdentifier("1.2.840.113549.1.9.3"));
        contentTypeInfoV.add(BC_FACTORY.createDERSet(BC_FACTORY.createASN1ObjectIdentifier("1.0.32004.1.0")));
        IASN1EncodableVector algorithmsInfoV = BC_FACTORY.createASN1EncodableVector();
        String algorithm = MacProperties.macDigestAlgorithmToString(this.macProperties.getMacDigestAlgorithm());
        String macDigestOid = DigestAlgorithms.getAllowedDigest(algorithm);
        algorithmsInfoV.add(BC_FACTORY.createDERSequence(BC_FACTORY.createASN1ObjectIdentifier(macDigestOid)));
        algorithmsInfoV.add(BC_FACTORY.createDERTaggedObject(2, BC_FACTORY.createASN1ObjectIdentifier(this.getMacAlgorithmOid())));
        IASN1EncodableVector algoProtectionInfoV = BC_FACTORY.createASN1EncodableVector();
        algoProtectionInfoV.add(BC_FACTORY.createASN1ObjectIdentifier("1.2.840.113549.1.9.52"));
        algoProtectionInfoV.add(BC_FACTORY.createDERSet(BC_FACTORY.createDERSequence(algorithmsInfoV)));
        IASN1EncodableVector authAttrsV = BC_FACTORY.createASN1EncodableVector();
        authAttrsV.add(BC_FACTORY.createDERSequence(contentTypeInfoV));
        authAttrsV.add(BC_FACTORY.createDERSequence(algoProtectionInfoV));
        authAttrsV.add(this.createMessageDigestSequence(messageBytes));
        return BC_FACTORY.createDERSet(authAttrsV);
    }

    private static byte[] createPdfMacIntegrityInfo(byte[] dataDigest, byte[] signatureDigest) throws IOException {
        IASN1EncodableVector digestInfoV = BC_FACTORY.createASN1EncodableVector();
        digestInfoV.add(BC_FACTORY.createASN1Integer(0));
        digestInfoV.add(BC_FACTORY.createDEROctetString(dataDigest));
        if (signatureDigest != null) {
            digestInfoV.add(BC_FACTORY.createDERTaggedObject(false, 0, BC_FACTORY.createDEROctetString(signatureDigest)));
        }
        return BC_FACTORY.createDERSequence(digestInfoV).getEncoded();
    }

    protected static byte[] generateRandomBytes(int length) {
        byte[] randomBytes = new byte[length];
        BC_FACTORY.getSecureRandom().nextBytes(randomBytes);
        return randomBytes;
    }

    private static MacProperties.MacDigestAlgorithm getMacDigestAlgorithm(String oid) {
        switch (oid) {
            case "2.16.840.1.101.3.4.2.1": {
                return MacProperties.MacDigestAlgorithm.SHA_256;
            }
            case "2.16.840.1.101.3.4.2.2": {
                return MacProperties.MacDigestAlgorithm.SHA_384;
            }
            case "2.16.840.1.101.3.4.2.3": {
                return MacProperties.MacDigestAlgorithm.SHA_512;
            }
            case "2.16.840.1.101.3.4.2.8": {
                return MacProperties.MacDigestAlgorithm.SHA3_256;
            }
            case "2.16.840.1.101.3.4.2.9": {
                return MacProperties.MacDigestAlgorithm.SHA3_384;
            }
            case "2.16.840.1.101.3.4.2.10": {
                return MacProperties.MacDigestAlgorithm.SHA3_512;
            }
        }
        throw new PdfException("This digest algorithm is not supported for MAC integrity protection.");
    }
}

