/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.impl;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.css.apply.impl.BlockCssApplier;
import com.itextpdf.html2pdf.css.apply.util.BorderStyleApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.VerticalAlignmentApplierUtil;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.node.IStylesContainer;
import java.util.Map;

public class TdTagCssApplier
extends BlockCssApplier {
    @Override
    public void apply(ProcessorContext context, IStylesContainer stylesContainer, ITagWorker worker) {
        super.apply(context, stylesContainer, worker);
        IPropertyContainer cell = worker.getElementResult();
        if (cell != null) {
            Map<String, String> cssProps = stylesContainer.getStyles();
            VerticalAlignmentApplierUtil.applyVerticalAlignmentForCells(cssProps, context, cell);
            float em = CssDimensionParsingUtils.parseAbsoluteLength(cssProps.get("font-size"));
            float rem = context.getCssContext().getRootFontSize();
            Border[] bordersArray = BorderStyleApplierUtil.getBordersArray(cssProps, em, rem);
            if (bordersArray[0] == null) {
                cell.setProperty(13, Border.NO_BORDER);
            }
            if (bordersArray[1] == null) {
                cell.setProperty(12, Border.NO_BORDER);
            }
            if (bordersArray[2] == null) {
                cell.setProperty(10, Border.NO_BORDER);
            }
            if (bordersArray[3] == null) {
                cell.setProperty(11, Border.NO_BORDER);
            }
        }
    }
}

