/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.commons.utils.FileUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.util.AccessiblePropHelper;
import com.itextpdf.html2pdf.attach.util.ContextMappingHelper;
import com.itextpdf.html2pdf.util.SvgProcessingUtil;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.tagging.IAccessibleElement;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import com.itextpdf.svg.converter.SvgConverter;
import com.itextpdf.svg.element.SvgImage;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.processors.ISvgProcessorResult;
import com.itextpdf.svg.processors.impl.SvgConverterProperties;
import com.itextpdf.svg.xobject.SvgImageXObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectTagWorker
implements ITagWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectTagWorker.class);
    private final SvgProcessingUtil processUtil;
    private Image image;
    private ISvgProcessorResult res;

    public ObjectTagWorker(IElementNode element, ProcessorContext context) {
        this.processUtil = new SvgProcessingUtil(context.getResourceResolver());
        String type = element.getAttribute("type");
        if (this.isSvgImage(type)) {
            String dataValue = element.getAttribute("data");
            try (InputStream svgStream = context.getResourceResolver().retrieveResourceAsInputStream(dataValue);){
                if (svgStream != null) {
                    SvgConverterProperties props = ContextMappingHelper.mapToSvgConverterProperties(context);
                    if (!ResourceResolver.isDataSrc(dataValue)) {
                        URL fullURL = context.getResourceResolver().resolveAgainstBaseUri(dataValue);
                        String dir = FileUtil.parentDirectory(fullURL);
                        props.setBaseUri(dir);
                    }
                    this.res = SvgConverter.parseAndProcess(svgStream, props);
                }
            }
            catch (SvgProcessingException spe) {
                LOGGER.error(spe.getMessage());
            }
            catch (IOException | URISyntaxException ie) {
                LOGGER.error(MessageFormatUtil.format("Unable to retrieve stream with given base URI ({0}) and source path ({1})", context.getBaseUri(), element.getAttribute("data"), ie));
            }
        }
    }

    private boolean isSvgImage(String typeAttribute) {
        return "image/svg+xml".equals(typeAttribute);
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        if (this.res != null) {
            SvgImageXObject svgImageXObject = this.processUtil.createXObjectFromProcessingResult(this.res, context, false);
            svgImageXObject.setIsCreatedByObject(true);
            this.image = new SvgImage(svgImageXObject);
            AccessiblePropHelper.trySetLangAttribute((IAccessibleElement)this.image, element);
        }
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        return false;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        return false;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.image;
    }
}

