/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.forms.form.element.IFormField;
import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.BrTagWorker;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.attach.impl.tags.ImgTagWorker;
import com.itextpdf.html2pdf.attach.impl.tags.SpanTagWorker;
import com.itextpdf.html2pdf.attach.util.AccessiblePropHelper;
import com.itextpdf.html2pdf.attach.util.WaitingInlineElementsHelper;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.AreaBreak;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.MulticolContainer;
import com.itextpdf.layout.tagging.IAccessibleElement;
import com.itextpdf.styledxmlparser.node.IElementNode;
import java.util.Map;

public class DivTagWorker
implements ITagWorker,
IDisplayAware {
    protected MulticolContainer multicolContainer;
    private Div div;
    private WaitingInlineElementsHelper inlineHelper;
    private String display;

    public DivTagWorker(IElementNode element, ProcessorContext context) {
        this(element, context, new Div());
    }

    protected DivTagWorker(IElementNode element, ProcessorContext context, Div container) {
        this.div = container;
        Map<String, String> styles = element.getStyles();
        if (styles != null && (styles.containsKey("column-count") || styles.containsKey("column-width"))) {
            this.multicolContainer = new MulticolContainer();
            this.multicolContainer.add(this.div);
        }
        this.inlineHelper = new WaitingInlineElementsHelper(styles == null ? null : styles.get("white-space"), styles == null ? null : styles.get("text-transform"));
        this.display = element.getStyles() != null ? element.getStyles().get("display") : null;
        AccessiblePropHelper.trySetLangAttribute((IAccessibleElement)this.div, element);
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        this.inlineHelper.flushHangingLeaves(this.div);
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        this.inlineHelper.add(content);
        return true;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        boolean processed = false;
        IPropertyContainer element = childTagWorker.getElementResult();
        if (childTagWorker instanceof BrTagWorker) {
            this.inlineHelper.add((ILeafElement)childTagWorker.getElementResult());
            return true;
        }
        if (childTagWorker instanceof IDisplayAware && "inline-block".equals(((IDisplayAware)((Object)childTagWorker)).getDisplay()) && childTagWorker.getElementResult() instanceof IBlockElement) {
            this.inlineHelper.add((IBlockElement)childTagWorker.getElementResult());
            return true;
        }
        if (childTagWorker instanceof SpanTagWorker) {
            boolean allChildrenProcessed = true;
            for (IPropertyContainer childElement : ((SpanTagWorker)childTagWorker).getAllElements()) {
                if (childElement instanceof ILeafElement) {
                    this.inlineHelper.add((ILeafElement)childElement);
                    continue;
                }
                if (childElement instanceof IBlockElement && "inline-block".equals(((SpanTagWorker)childTagWorker).getElementDisplay(childElement))) {
                    this.inlineHelper.add((IBlockElement)childElement);
                    continue;
                }
                if (!(childElement instanceof IElement)) continue;
                allChildrenProcessed = this.addBlockChild((IElement)childElement) && allChildrenProcessed;
            }
            processed = allChildrenProcessed;
        } else if (!(!(element instanceof IFormField) || childTagWorker instanceof IDisplayAware && "block".equals(((IDisplayAware)((Object)childTagWorker)).getDisplay()))) {
            this.inlineHelper.add((IBlockElement)element);
            processed = true;
        } else if (element instanceof AreaBreak) {
            this.postProcessInlineGroup();
            this.div.add((AreaBreak)element);
            processed = true;
        } else if (childTagWorker instanceof ImgTagWorker && element instanceof IElement && !"block".equals(((ImgTagWorker)childTagWorker).getDisplay())) {
            this.inlineHelper.add((ILeafElement)childTagWorker.getElementResult());
            processed = true;
        } else if (element instanceof IElement) {
            processed = this.addBlockChild((IElement)element);
        }
        return processed;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.multicolContainer == null ? this.div : this.multicolContainer;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    protected boolean addBlockChild(IElement element) {
        this.postProcessInlineGroup();
        boolean processed = false;
        if (element instanceof IBlockElement) {
            this.div.add((IBlockElement)element);
            processed = true;
        } else if (element instanceof Image) {
            this.div.add((Image)element);
            processed = true;
        }
        return processed;
    }

    protected void postProcessInlineGroup() {
        this.inlineHelper.flushHangingLeaves(this.div);
    }
}

