/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.html2pdf.attach.impl.layout.HtmlDocumentRenderer;
import com.itextpdf.html2pdf.attach.impl.layout.PageCountElement;
import com.itextpdf.html2pdf.attach.impl.layout.PageCountType;
import com.itextpdf.html2pdf.css.resolve.func.counter.CounterDigitsGlyphStyle;
import com.itextpdf.html2pdf.html.HtmlUtils;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.DocumentRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.TextRenderer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PageCountRenderer
extends TextRenderer {
    private final CounterDigitsGlyphStyle digitsGlyphStyle;

    PageCountRenderer(PageCountElement textElement) {
        super(textElement);
        this.digitsGlyphStyle = textElement.getDigitsGlyphStyle();
    }

    protected PageCountRenderer(TextRenderer other) {
        super(other);
        this.digitsGlyphStyle = ((PageCountRenderer)other).digitsGlyphStyle;
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        PageCountType pageCountType = (PageCountType)((Object)this.getProperty(0x100002));
        String previousText = this.getText().toString();
        boolean textHasBeenReplaced = false;
        if (pageCountType == PageCountType.CURRENT_PAGE_NUMBER) {
            this.setText(HtmlUtils.convertNumberAccordingToGlyphStyle(this.digitsGlyphStyle, layoutContext.getArea().getPageNumber()));
            textHasBeenReplaced = true;
        } else if (pageCountType == PageCountType.TOTAL_PAGE_COUNT) {
            IRenderer rootRenderer = this;
            while (rootRenderer instanceof AbstractRenderer && ((AbstractRenderer)rootRenderer).getParent() != null) {
                rootRenderer = ((AbstractRenderer)rootRenderer).getParent();
            }
            if (rootRenderer instanceof HtmlDocumentRenderer && ((HtmlDocumentRenderer)rootRenderer).getEstimatedNumberOfPages() > 0) {
                this.setText(HtmlUtils.convertNumberAccordingToGlyphStyle(this.digitsGlyphStyle, ((HtmlDocumentRenderer)rootRenderer).getEstimatedNumberOfPages()));
                textHasBeenReplaced = true;
            } else if (rootRenderer instanceof DocumentRenderer && rootRenderer.getModelElement() instanceof Document) {
                this.setText(HtmlUtils.convertNumberAccordingToGlyphStyle(this.digitsGlyphStyle, ((Document)rootRenderer.getModelElement()).getPdfDocument().getNumberOfPages()));
                textHasBeenReplaced = true;
            }
        }
        LayoutResult result = super.layout(layoutContext);
        if (textHasBeenReplaced) {
            this.setText(previousText);
        }
        return result;
    }

    @Override
    public IRenderer getNextRenderer() {
        if (PageCountRenderer.class != this.getClass()) {
            Logger logger = LoggerFactory.getLogger(PageCountRenderer.class);
            logger.error(MessageFormatUtil.format("If a renderer overflows, iText uses this method to create another renderer for the overflow part. So if one wants to extend the renderer, one should override this method: otherwise the default method will be used and thus the default rather than the custom renderer will be created.", new Object[0]));
        }
        return new PageCountRenderer((PageCountElement)this.modelElement);
    }

    @Override
    protected TextRenderer createCopy(GlyphLine gl, PdfFont font) {
        if (PageCountRenderer.class != this.getClass()) {
            Logger logger = LoggerFactory.getLogger(PageCountRenderer.class);
            logger.error(MessageFormatUtil.format("While processing an instance of TextRenderer, iText uses createCopy() to create glyph lines of specific fonts, which represent its parts. So if one extends TextRenderer, one should override createCopy, otherwise if FontSelector related logic is triggered, copies of this TextRenderer will have the default behavior rather than the custom one.", new Object[0]));
        }
        PageCountRenderer copy = new PageCountRenderer(this);
        copy.setProcessedGlyphLineAndFont(gl, font);
        return copy;
    }

    @Override
    protected boolean resolveFonts(List<IRenderer> addTo) {
        ArrayList<IRenderer> dummyList = new ArrayList<IRenderer>();
        super.resolveFonts(dummyList);
        this.setProperty(20, ((IRenderer)dummyList.get(0)).getProperty(20));
        addTo.add(this);
        return true;
    }
}

