/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout;

import com.itextpdf.html2pdf.attach.impl.layout.DimensionContainer;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.styledxmlparser.css.CssContextNode;

class HeightDimensionContainer
extends DimensionContainer {
    private static final float infHeight = 1000000.0f;

    HeightDimensionContainer(CssContextNode pmbcNode, float width, float maxHeight, IRenderer renderer, float additionalWidthFix) {
        String height = pmbcNode.getStyles().get("height");
        if (height != null && !"auto".equals(height)) {
            this.dimension = this.parseDimension(pmbcNode, height, maxHeight, additionalWidthFix);
        }
        this.minDimension = this.getMinHeight(pmbcNode, maxHeight, additionalWidthFix);
        this.maxDimension = this.getMaxHeight(pmbcNode, maxHeight, additionalWidthFix);
        if (!this.isAutoDimension()) {
            this.maxContentDimension = this.dimension;
            this.maxContentDimension = this.dimension;
        } else {
            LayoutArea layoutArea = new LayoutArea(1, new Rectangle(0.0f, 0.0f, width, 1000000.0f));
            LayoutContext minimalContext = new LayoutContext(layoutArea);
            LayoutResult quickLayout = renderer.layout(minimalContext);
            if (quickLayout.getStatus() != 3) {
                this.minContentDimension = this.maxContentDimension = quickLayout.getOccupiedArea().getBBox().getHeight();
            }
        }
    }

    private float getMinHeight(CssContextNode node, float maxAvailableHeight, float additionalWidthFix) {
        String content = node.getStyles().get("min-height");
        if (content == null) {
            return 0.0f;
        }
        return this.parseDimension(node, content, maxAvailableHeight, additionalWidthFix);
    }

    private float getMaxHeight(CssContextNode node, float maxAvailableHeight, float additionalWidthFix) {
        String content = node.getStyles().get("max-height");
        if (content == null) {
            return Float.MAX_VALUE;
        }
        float dim = this.parseDimension(node, content, maxAvailableHeight, additionalWidthFix);
        if (dim == 0.0f) {
            return Float.MAX_VALUE;
        }
        return dim;
    }
}

