/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.renderer;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.fields.ChoiceFormFieldBuilder;
import com.itextpdf.forms.fields.PdfChoiceFormField;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.form.element.AbstractSelectField;
import com.itextpdf.forms.form.element.ComboBoxField;
import com.itextpdf.forms.form.element.SelectFieldItem;
import com.itextpdf.forms.form.renderer.AbstractSelectFieldRenderer;
import com.itextpdf.forms.util.BorderStyleUtil;
import com.itextpdf.forms.util.FormFieldRendererUtil;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.properties.Background;
import com.itextpdf.layout.properties.BoxSizingPropertyValue;
import com.itextpdf.layout.properties.OverflowPropertyValue;
import com.itextpdf.layout.properties.RenderingMode;
import com.itextpdf.layout.properties.TransparentColor;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.properties.VerticalAlignment;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.tagging.IAccessibleElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectFieldComboBoxRenderer
extends AbstractSelectFieldRenderer {
    private final IRenderer minMaxWidthRenderer;

    public SelectFieldComboBoxRenderer(AbstractSelectField modelElement) {
        super(modelElement);
        this.setProperty(105, (Object)BoxSizingPropertyValue.BORDER_BOX);
        this.setProperty(75, (Object)VerticalAlignment.MIDDLE);
        this.setProperty(103, (Object)OverflowPropertyValue.HIDDEN);
        this.setProperty(104, (Object)OverflowPropertyValue.HIDDEN);
        this.minMaxWidthRenderer = this.createFlatRenderer(true);
    }

    @Override
    public IRenderer getNextRenderer() {
        return new SelectFieldComboBoxRenderer((AbstractSelectField)this.modelElement);
    }

    @Override
    public MinMaxWidth getMinMaxWidth() {
        List realChildRenderers = this.childRenderers;
        this.childRenderers = new ArrayList();
        this.childRenderers.add(this.minMaxWidthRenderer);
        MinMaxWidth minMaxWidth = super.getMinMaxWidth();
        this.childRenderers = realChildRenderers;
        return minMaxWidth;
    }

    @Override
    protected boolean allowLastYLineRecursiveExtraction() {
        return true;
    }

    @Override
    protected IRenderer createFlatRenderer() {
        return this.createFlatRenderer(false);
    }

    @Override
    protected void applyAcroField(DrawContext drawContext) {
        SelectFieldItem selectedLabel;
        ComboBoxField comboBoxFieldModelElement = (ComboBoxField)this.modelElement;
        String name = this.getModelId();
        PdfDocument doc = drawContext.getDocument();
        Rectangle area = this.getOccupiedAreaBBox();
        PdfPage page = doc.getPage(this.occupiedArea.getPageNumber());
        PdfFont font = this.getResolvedFont(doc);
        ChoiceFormFieldBuilder builder = (ChoiceFormFieldBuilder)((ChoiceFormFieldBuilder)((ChoiceFormFieldBuilder)new ChoiceFormFieldBuilder(doc, name).setWidgetRectangle(area)).setFont(font)).setConformance(this.getConformance(doc));
        this.applyMargins(area, false);
        Map<Integer, Object> properties = FormFieldRendererUtil.removeProperties(this.modelElement);
        this.modelElement.setProperty(91, this.getProperty(91));
        this.modelElement.setProperty(123, this.getProperty(123));
        this.setupBuilderValues(builder, comboBoxFieldModelElement);
        PdfChoiceFormField comboBoxField = builder.createComboBox();
        comboBoxField.disableFieldRegeneration();
        this.applyAccessibilityProperties(comboBoxField, doc);
        Background background = (Background)this.modelElement.getProperty(6);
        if (background != null) {
            comboBoxField.getFirstFormAnnotation().setBackgroundColor(background.getColor());
        }
        BorderStyleUtil.applyBorderProperty(this, comboBoxField.getFirstFormAnnotation());
        UnitValue fontSize = this.getFontSize();
        if (fontSize != null) {
            comboBoxField.setFontSize(fontSize.getValue());
        }
        if ((selectedLabel = comboBoxFieldModelElement.getSelectedOption()) != null) {
            comboBoxField.setValue(selectedLabel.getDisplayValue());
        } else {
            String exportValue = comboBoxFieldModelElement.getSelectedExportValue();
            if (exportValue == null) {
                RenderingMode renderingMode = (RenderingMode)((Object)comboBoxFieldModelElement.getProperty(123));
                if (RenderingMode.HTML_MODE == renderingMode && comboBoxFieldModelElement.hasOptions()) {
                    comboBoxFieldModelElement.setSelected(0);
                    comboBoxField.setValue(comboBoxFieldModelElement.getSelectedExportValue());
                }
            } else {
                comboBoxField.setValue(comboBoxFieldModelElement.getSelectedExportValue());
            }
        }
        comboBoxField.getFirstFormAnnotation().setFormFieldElement(comboBoxFieldModelElement);
        comboBoxField.enableFieldRegeneration();
        PdfFormCreator.getAcroForm(doc, true).addField(comboBoxField, page);
        FormFieldRendererUtil.reapplyProperties(this.modelElement, properties);
    }

    private UnitValue getFontSize() {
        if (!this.hasProperty(24)) {
            return null;
        }
        UnitValue fontSize = this.getPropertyAsUnitValue(24);
        if (!fontSize.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(SelectFieldComboBoxRenderer.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 24));
        }
        return fontSize;
    }

    private IRenderer createFlatRenderer(boolean addAllOptionsToChildren) {
        AccessibilityProperties properties;
        AbstractSelectField selectField = (AbstractSelectField)this.modelElement;
        List<SelectFieldItem> options = selectField.getOptions();
        Div pseudoContainer = new Div();
        for (SelectFieldItem option : options) {
            pseudoContainer.add(option.getElement());
        }
        IRenderer pseudoRendererSubTree = pseudoContainer.createRendererSubTree();
        List<Paragraph> allOptions = addAllOptionsToChildren ? this.getAllOptionsFlatElements(pseudoRendererSubTree) : this.getSingleSelectedOptionFlatRenderer(pseudoRendererSubTree);
        if (allOptions.isEmpty()) {
            allOptions.add(this.createComboBoxOptionFlatElement());
        }
        pseudoContainer.getChildren().clear();
        for (Paragraph option : allOptions) {
            pseudoContainer.add(option);
        }
        String lang = this.getLang();
        if (lang != null && (properties = pseudoContainer.getAccessibilityProperties()).getLanguage() == null) {
            properties.setLanguage(lang);
        }
        IRenderer rendererSubTree = pseudoContainer.createRendererSubTree();
        return rendererSubTree;
    }

    private List<Paragraph> getSingleSelectedOptionFlatRenderer(IRenderer optionsSubTree) {
        ArrayList<Paragraph> selectedOptionFlatRendererList = new ArrayList<Paragraph>();
        List<IRenderer> selectedOptions = this.getOptionsMarkedSelected(optionsSubTree);
        IRenderer selectedOption = selectedOptions.isEmpty() ? this.getFirstOption(optionsSubTree) : selectedOptions.get(selectedOptions.size() - 1);
        if (selectedOption != null) {
            String label = (String)selectedOption.getProperty(0x20000A);
            Paragraph p = this.createComboBoxOptionFlatElement(label, false);
            this.processLangAttribute(p, selectedOption);
            selectedOptionFlatRendererList.add(p);
        } else {
            ComboBoxField modelElement = (ComboBoxField)this.getModelElement();
            SelectFieldItem selectedOptionItem = modelElement.getSelectedOption();
            String label = modelElement.getSelectedExportValue();
            if (selectedOptionItem != null) {
                label = selectedOptionItem.getDisplayValue();
            }
            if (label != null) {
                Paragraph p = this.createComboBoxOptionFlatElement(label, false);
                p.setProperty(0x200009, true);
                this.processLangAttribute(p, p.getRenderer());
                selectedOptionFlatRendererList.add(p);
            }
        }
        return selectedOptionFlatRendererList;
    }

    private IRenderer getFirstOption(IRenderer renderer) {
        IRenderer firstOption = null;
        for (IRenderer child : renderer.getChildRenderers()) {
            if (SelectFieldComboBoxRenderer.isOptionRenderer(child)) {
                firstOption = child;
                break;
            }
            firstOption = this.getFirstOption(child);
            if (firstOption == null) continue;
            break;
        }
        return firstOption;
    }

    private List<Paragraph> getAllOptionsFlatElements(IRenderer renderer) {
        return this.getAllOptionsFlatElements(renderer, false);
    }

    private List<Paragraph> getAllOptionsFlatElements(IRenderer renderer, boolean isInOptGroup) {
        ArrayList<Paragraph> options = new ArrayList<Paragraph>();
        for (IRenderer child : renderer.getChildRenderers()) {
            if (SelectFieldComboBoxRenderer.isOptionRenderer(child)) {
                String label = (String)child.getProperty(0x20000A);
                options.add(this.createComboBoxOptionFlatElement(label, isInOptGroup));
                continue;
            }
            options.addAll(this.getAllOptionsFlatElements(child, isInOptGroup || SelectFieldComboBoxRenderer.isOptGroupRenderer(child)));
        }
        return options;
    }

    private void processLangAttribute(Paragraph optionFlatElement, IRenderer originalOptionRenderer) {
        IPropertyContainer propertyContainer = originalOptionRenderer.getModelElement();
        if (propertyContainer instanceof IAccessibleElement) {
            String lang = ((IAccessibleElement)((Object)propertyContainer)).getAccessibilityProperties().getLanguage();
            AccessibilityProperties properties = optionFlatElement.getAccessibilityProperties();
            if (properties.getLanguage() == null) {
                properties.setLanguage(lang);
            }
        }
    }

    private Paragraph createComboBoxOptionFlatElement() {
        return this.createComboBoxOptionFlatElement(null, false);
    }

    private Paragraph createComboBoxOptionFlatElement(String label, boolean simulateOptGroupMargin) {
        PdfFont font;
        Paragraph paragraph = (Paragraph)new Paragraph().setMargin(0.0f);
        paragraph.getAccessibilityProperties().setRole("Lbl");
        if (simulateOptGroupMargin) {
            paragraph.add("\u200d    ");
        }
        if (label == null || label.isEmpty()) {
            label = "\u00a0";
        }
        paragraph.add(label);
        paragraph.setProperty(103, (Object)OverflowPropertyValue.VISIBLE);
        paragraph.setProperty(104, (Object)OverflowPropertyValue.VISIBLE);
        paragraph.setFontColor((TransparentColor)this.modelElement.getProperty(21));
        UnitValue fontSize = (UnitValue)this.modelElement.getProperty(24);
        if (fontSize != null) {
            paragraph.setFontSize(fontSize.getValue());
        }
        if ((font = this.getResolvedFont(null)) != null) {
            paragraph.setFont(font);
        }
        float paddingTop = 0.0f;
        float paddingBottom = 0.75f;
        float paddingLeft = 1.5f;
        float paddingRight = 1.5f;
        if (!this.isFlatten()) {
            float extraPaddingChrome = 10.0f;
            paddingRight += 10.0f;
        }
        paragraph.setPaddings(0.0f, paddingRight, 0.75f, 1.5f);
        return paragraph;
    }
}

