/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.element;

import com.itextpdf.forms.FormDefaultAccessibilityProperties;
import com.itextpdf.forms.form.element.FormField;
import com.itextpdf.forms.form.element.IFormField;
import com.itextpdf.forms.form.renderer.ButtonRenderer;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.properties.BoxSizingPropertyValue;
import com.itextpdf.layout.properties.TextAlignment;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.properties.VerticalAlignment;
import com.itextpdf.layout.renderer.IRenderer;

public class Button
extends FormField<Button> {
    private static final VerticalAlignment DEFAULT_VERTICAL_ALIGNMENT = VerticalAlignment.MIDDLE;
    private static final TextAlignment DEFAULT_TEXT_ALIGNMENT = TextAlignment.CENTER;
    private static final Color DEFAULT_BACKGROUND_COLOR = ColorConstants.LIGHT_GRAY;
    private boolean singleLine = false;

    public Button(String id) {
        super(id);
        this.setTextAlignment(DEFAULT_TEXT_ALIGNMENT);
        this.setBackgroundColor(DEFAULT_BACKGROUND_COLOR);
        this.setProperty(105, (Object)BoxSizingPropertyValue.BORDER_BOX);
    }

    public Button add(IBlockElement element) {
        this.singleLine = false;
        this.childElements.add(element);
        return this;
    }

    public Button add(Image element) {
        this.singleLine = false;
        this.childElements.add(element);
        return this;
    }

    public boolean isSingleLine() {
        return this.singleLine;
    }

    public Button setSingleLineValue(String value) {
        this.setValue(value);
        this.setProperty(32, Boolean.FALSE);
        this.singleLine = true;
        return this;
    }

    @Override
    public IFormField setValue(String value) {
        this.childElements.clear();
        Paragraph paragraph = (Paragraph)((Paragraph)((Paragraph)new Paragraph(value).setMargin(0.0f)).setMultipliedLeading(1.0f).setVerticalAlignment(DEFAULT_VERTICAL_ALIGNMENT)).setTextAlignment(DEFAULT_TEXT_ALIGNMENT);
        if (this.getProperty(20) != null) {
            paragraph.setProperty(20, this.getProperty(20));
        }
        if (this.getProperty(24) != null) {
            paragraph.setFontSize(((UnitValue)this.getProperty(24)).getValue());
        }
        return this.add(paragraph);
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        if (property == 32) {
            return (T1)Boolean.valueOf(true);
        }
        return super.getDefaultProperty(property);
    }

    @Override
    public AccessibilityProperties getAccessibilityProperties() {
        if (this.tagProperties == null) {
            this.tagProperties = new FormDefaultAccessibilityProperties("pb");
        }
        return this.tagProperties;
    }

    @Override
    protected IRenderer makeNewRenderer() {
        return new ButtonRenderer(this);
    }
}

