/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields;

import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.source.PdfTokenizer;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.io.source.RandomAccessSourceFactory;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceCmyk;
import com.itextpdf.kernel.colors.DeviceGray;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.pdf.PdfConformance;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfString;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPdfFormField
extends PdfObjectWrapper<PdfDictionary> {
    public static final int DEFAULT_FONT_SIZE = 12;
    public static final int MIN_FONT_SIZE = 4;
    private static final PdfName[] TERMINAL_FIELDS = new PdfName[]{PdfName.Btn, PdfName.Tx, PdfName.Ch, PdfName.Sig};
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPdfFormField.class);
    private static final int DA_FONT = 0;
    private static final int DA_SIZE = 1;
    private static final int DA_COLOR = 2;
    protected PdfFont font;
    protected float fontSize = -1.0f;
    protected Color color;
    protected PdfConformance pdfConformance;
    protected PdfFormField parent;
    private boolean enableFieldRegeneration = true;

    protected AbstractPdfFormField(PdfDictionary pdfObject) {
        super(pdfObject);
        AbstractPdfFormField.ensureObjectIsAddedToDocument(pdfObject);
        this.setForbidRelease();
        this.retrieveStyles();
    }

    @Override
    public PdfDictionary getPdfObject() {
        return (PdfDictionary)super.getPdfObject();
    }

    public void setParent(PdfFormField parent) {
        if (!parent.getPdfObject().equals(this.getParent()) && !parent.getPdfObject().equals(this.getPdfObject())) {
            this.put(PdfName.Parent, parent.getPdfObject());
        }
        this.parent = parent;
    }

    public PdfDictionary getParent() {
        PdfDictionary parentDict = this.getPdfObject().getAsDictionary(PdfName.Parent);
        if (parentDict == null) {
            parentDict = this.parent == null ? null : this.parent.getPdfObject();
        }
        return parentDict;
    }

    public PdfFormField getParentField() {
        return this.parent;
    }

    public PdfString getFieldName() {
        return this.getFieldName(new HashSet<PdfFormField>());
    }

    public abstract PdfString getDefaultAppearance();

    public float getFontSize() {
        float fontSizeToReturn;
        float f = fontSizeToReturn = this.fontSize == -1.0f && this.parent != null ? this.parent.getFontSize() : this.fontSize;
        if (fontSizeToReturn == -1.0f) {
            fontSizeToReturn = 12.0f;
        }
        return fontSizeToReturn;
    }

    public PdfFont getFont() {
        PdfFont fontToReturn;
        PdfFont pdfFont = fontToReturn = this.font == null && this.parent != null ? this.parent.getFont() : this.font;
        if (fontToReturn == null) {
            fontToReturn = this.getDocument().getDefaultFont();
        }
        return fontToReturn;
    }

    public Color getColor() {
        return this.color == null && this.parent != null ? this.parent.getColor() : this.color;
    }

    public PdfConformance getPdfConformance() {
        return this.pdfConformance == null && this.parent != null ? this.parent.getPdfConformance() : this.pdfConformance;
    }

    public abstract boolean regenerateField();

    public void disableFieldRegeneration() {
        this.enableFieldRegeneration = false;
        if (this instanceof PdfFormField) {
            for (AbstractPdfFormField child : ((PdfFormField)this).getChildFields()) {
                child.disableFieldRegeneration();
            }
        }
    }

    public void enableFieldRegeneration() {
        this.enableFieldRegeneration = true;
        if (this instanceof PdfFormField) {
            for (AbstractPdfFormField child : ((PdfFormField)this).getAllChildFields()) {
                child.enableFieldRegeneration = true;
            }
        }
        this.regenerateField();
    }

    public void disableCurrentFieldRegeneration() {
        this.enableFieldRegeneration = false;
    }

    public void enableCurrentFieldRegeneration() {
        this.enableFieldRegeneration = true;
        this.regenerateField();
    }

    public boolean isFieldRegenerationEnabled() {
        return this.enableFieldRegeneration;
    }

    void setColorNoRegenerate(Color color) {
        this.color = color;
    }

    public abstract String[] getAppearanceStates();

    public AbstractPdfFormField put(PdfName key, PdfObject value) {
        this.getPdfObject().put(key, value);
        this.setModified();
        return this;
    }

    public AbstractPdfFormField remove(PdfName key) {
        this.getPdfObject().remove(key);
        this.setModified();
        return this;
    }

    public void release() {
        if (!this.getPdfObject().isModified()) {
            this.unsetForbidRelease();
        }
        this.getPdfObject().release();
    }

    public PdfDocument getDocument() {
        return this.getPdfObject().getIndirectReference().getDocument();
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    public AbstractPdfFormField setColor(Color color) {
        this.color = color;
        this.regenerateField();
        return this;
    }

    public AbstractPdfFormField setFont(PdfFont font) {
        this.updateFontAndFontSize(font, this.fontSize);
        this.regenerateField();
        return this;
    }

    public AbstractPdfFormField setFontSize(float fontSize) {
        this.updateFontAndFontSize(this.font, fontSize);
        this.regenerateField();
        return this;
    }

    public AbstractPdfFormField setFontSize(int fontSize) {
        this.setFontSize((float)fontSize);
        return this;
    }

    public AbstractPdfFormField setFontSizeAutoScale() {
        this.fontSize = 0.0f;
        this.regenerateField();
        return this;
    }

    public AbstractPdfFormField setFontAndSize(PdfFont font, float fontSize) {
        this.updateFontAndFontSize(font, fontSize);
        this.regenerateField();
        return this;
    }

    public boolean isTerminalFormField() {
        if (this.getPdfObject() == null || this.getPdfObject().get(PdfName.FT) == null) {
            return false;
        }
        for (PdfName terminalField : TERMINAL_FIELDS) {
            if (!terminalField.equals(this.getPdfObject().get(PdfName.FT))) continue;
            return true;
        }
        return false;
    }

    PdfString getFieldName(Set<PdfFormField> visited) {
        PdfString name;
        String parentName = "";
        PdfDictionary parentDict = this.getParent();
        if (parentDict != null) {
            PdfFormField parentField = this.getParentField();
            if (!visited.contains(parentField)) {
                if (parentField == null) {
                    parentField = PdfFormField.makeFormField(this.getParent(), this.getDocument());
                }
                visited.add(parentField);
                PdfString pName = parentField.getFieldName(visited);
                if (pName != null) {
                    parentName = pName.toUnicodeString() + ".";
                }
            } else {
                LOGGER.warn("Form field contains parent pointing to itself. This form field parent reference will be invalidated.");
                this.remove(PdfName.Parent);
                this.parent = null;
            }
        }
        if ((name = this.getPdfObject().getAsString(PdfName.T)) != null) {
            return new PdfString(parentName + name.toUnicodeString(), "UnicodeBig");
        }
        if (this.isTerminalFormField()) {
            return new PdfString(parentName, "UnicodeBig");
        }
        return null;
    }

    void updateFontAndFontSize(PdfFont font, float fontSize) {
        this.font = font;
        this.fontSize = fontSize;
    }

    void retrieveStyles() {
        Object[] fontData;
        PdfString defaultAppearance = this.getDefaultAppearance();
        if (defaultAppearance != null && (fontData = AbstractPdfFormField.splitDAelements(defaultAppearance.getValue()))[1] != null && fontData[0] != null) {
            this.color = (Color)fontData[2];
            this.fontSize = ((Float)fontData[1]).floatValue();
            this.font = this.resolveFontName((String)fontData[0]);
        }
    }

    PdfObject getAcroFormObject(PdfName key, int type) {
        PdfObject acroFormObject = null;
        PdfDictionary acroFormDictionary = ((PdfDictionary)this.getDocument().getCatalog().getPdfObject()).getAsDictionary(PdfName.AcroForm);
        if (acroFormDictionary != null) {
            acroFormObject = acroFormDictionary.get(key);
        }
        return acroFormObject != null && acroFormObject.getType() == type ? acroFormObject : null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object[] splitDAelements(String da) {
        tk = new PdfTokenizer(new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(PdfEncodings.convertToBytes(da, null))));
        stack = new ArrayList<String>();
        ret = new Object[3];
lbl4:
        // 5 sources

        try {
            block14: while (tk.nextToken()) {
                block15: {
                    if (tk.getTokenType() == PdfTokenizer.TokenType.Comment) continue;
                    if (tk.getTokenType() != PdfTokenizer.TokenType.Other) break block15;
                    var4_4 = tk.getStringValue();
                    var5_6 = -1;
                    switch (var4_4.hashCode()) {
                        case 2706: {
                            if (!var4_4.equals("Tf")) break;
                            var5_6 = 0;
                            break;
                        }
                        case 103: {
                            if (!var4_4.equals("g")) break;
                            var5_6 = 1;
                            break;
                        }
                        case 3637: {
                            if (!var4_4.equals("rg")) break;
                            var5_6 = 2;
                            break;
                        }
                        case 107: {
                            if (!var4_4.equals("k")) break;
                            var5_6 = 3;
                            break;
                        }
                    }
                    switch (var5_6) {
                        case 0: {
                            if (stack.size() < 2) continue block14;
                            ret[0] = stack.get(stack.size() - 2);
                            ret[1] = new Float((String)stack.get(stack.size() - 1));
                            ** GOTO lbl4
                        }
                        case 1: {
                            if (stack.size() < 1 || (gray = new Float((String)stack.get(stack.size() - 1)).floatValue()) == 0.0f) continue block14;
                            ret[2] = new DeviceGray(gray);
                            ** GOTO lbl4
                        }
                        case 2: {
                            if (stack.size() < 3) continue block14;
                            red = new Float((String)stack.get(stack.size() - 3)).floatValue();
                            green = new Float((String)stack.get(stack.size() - 2)).floatValue();
                            blue = new Float((String)stack.get(stack.size() - 1)).floatValue();
                            ret[2] = new DeviceRgb(red, green, blue);
                            ** GOTO lbl4
                        }
                        case 3: {
                            if (stack.size() < 4) continue block14;
                            cyan = new Float((String)stack.get(stack.size() - 4)).floatValue();
                            magenta = new Float((String)stack.get(stack.size() - 3)).floatValue();
                            yellow = new Float((String)stack.get(stack.size() - 2)).floatValue();
                            black = new Float((String)stack.get(stack.size() - 1)).floatValue();
                            ret[2] = new DeviceCmyk(cyan, magenta, yellow, black);
                            ** GOTO lbl4
                        }
                    }
                    stack.clear();
                    continue;
                }
                stack.add(tk.getStringValue());
            }
            return ret;
        }
        catch (Exception var4_5) {
            // empty catch block
        }
        return ret;
    }

    private PdfFont resolveFontName(String fontName) {
        PdfDictionary daFontDict;
        PdfDictionary defaultFontDic;
        PdfDictionary defaultResources = (PdfDictionary)this.getAcroFormObject(PdfName.DR, 3);
        PdfDictionary pdfDictionary = defaultFontDic = defaultResources != null ? defaultResources.getAsDictionary(PdfName.Font) : null;
        if (fontName != null && defaultFontDic != null && (daFontDict = defaultFontDic.getAsDictionary(new PdfName(fontName))) != null) {
            return this.getDocument().getFont(daFontDict);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.getPdfObject() == ((AbstractPdfFormField)o).getPdfObject();
    }

    public int hashCode() {
        return this.getPdfObject().hashCode();
    }
}

