/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.vue;

import com.google.common.io.ByteStreams;
import io.netty.util.AsciiString;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.io.File;
import java.io.InputStream;
import net.bluemind.webmodules.vue.VueHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LibraryHandler {
    private static final Logger logger = LoggerFactory.getLogger(LibraryHandler.class);
    private static final CharSequence JS = new AsciiString((CharSequence)"application/javascript");
    private static boolean isDevMode = new File("/root/dev-vue").exists();

    public void handle(HttpServerRequest httpServerRequest, Buffer buffer) {
        logger.debug("VueHandler {}", (Object)httpServerRequest.path());
        HttpServerResponse httpServerResponse = httpServerRequest.response();
        httpServerResponse.putHeader(HttpHeaders.CONTENT_TYPE, JS).end(buffer);
    }

    protected static byte[] loadVueFile(String string) {
        String string2 = string + ".prod.js";
        if (isDevMode) {
            string2 = string + ".js";
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = VueHandler.class.getClassLoader().getResourceAsStream("web-resources/js/" + string2);){
                logger.debug("Found file " + string2);
                return ByteStreams.toByteArray((InputStream)inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
            return new byte[0];
        }
    }
}

