/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2022
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.helper.ical4j;

import java.net.URISyntaxException;

import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.parameter.XParameter;
import net.fortuna.ical4j.model.property.Attendee;

public class PropertyConverter {

	interface IConvert {
		Property convert();
	}

	public static IConvert getConverter(Property property) {
		if (property.getName().equals(Property.ATTENDEE)) {
			return new AttendeeConverter(property);
		}
		return new DefaultConverter(property);
	}

	private static class DefaultConverter implements IConvert {
		protected final Property property;

		public DefaultConverter(Property property) {
			this.property = property;
		}

		@Override
		public Property convert() {
			return property;
		}

	}

	private static final class AttendeeConverter extends DefaultConverter implements IConvert {

		public AttendeeConverter(Property property) {
			super(property);
		}

		@Override
		public Property convert() {
			Attendee attendee = null;
			try {
				attendee = new Attendee(property.getValue());
			} catch (URISyntaxException e) {
				attendee = new Attendee();
			}
			for (Parameter param : property.getParameters()) {
				if ("TO-ALL-PROPOSED-NEW-TIME".equals(param.getName())) {
					attendee.getParameters().add(new XParameter(param.getName(), param.getValue()));
				} else {
					attendee.getParameters().add(param);
				}
			}
			return attendee;
		}

	}

}
