/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.retry.support.common;

public abstract class RetryQueue implements AutoCloseable {

	@SuppressWarnings("serial")
	public static class QueueException extends RuntimeException {

		public QueueException(Throwable e) {
			super(e);
		}

	}

	@FunctionalInterface
	public interface Appender {
		void write(String txt) throws QueueException;
	}

	public interface QueueRecord {

		String payload();

	}

	public interface Tailer {
		QueueRecord next();

		void commit();

	}

	public abstract Appender writer();

	public abstract Tailer reader();

	public void compact() {

	}

	public void close() {

	}

	/**
	 * Remove all entries in the queue, used in JUnits
	 */
	public void clear() {
	}

}
